/*
 * Decompiled with CFR 0.152.
 */
package jde.wizards;

import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Vector;
import jde.wizards.InterfaceFactory;
import jde.wizards.MethodFactory;
import jde.wizards.NameFactory;
import jde.wizards.Signature;

public class EventSourceFactory
extends InterfaceFactory {
    private static EventSourceFactory eventSourceFactory;
    private Class listenerClass;
    private String listenerClassNameFQN;
    private String listenerClassName;
    private String listenerVectorName;

    public EventSourceFactory() {
    }

    public EventSourceFactory(NameFactory factory) {
        super(factory);
    }

    public static void makeEventSourceSupportExpression(String listenerName, boolean truncate) {
        if (eventSourceFactory == null) {
            eventSourceFactory = new EventSourceFactory();
        }
        eventSourceFactory.flush();
        eventSourceFactory.makeEventSourceSupportExpressionInternal(listenerName, truncate);
    }

    private void makeEventSourceSupportExpressionInternal(String name, boolean truncate) {
        try {
            this.listenerClass = Class.forName(name);
            this.listenerClassNameFQN = this.listenerClass.getName();
            this.listenerClassName = this.listenerClass.getName().substring(this.listenerClass.getName().lastIndexOf(46) + 1);
            StringBuffer buf = new StringBuffer(this.listenerClassName);
            buf.setCharAt(0, Character.toLowerCase(this.listenerClassName.charAt(0)));
            this.listenerVectorName = buf.toString() + "s";
        }
        catch (ClassNotFoundException e) {
            MethodFactory.println("(error \"Error: could not find listenerClass named: " + name + ". " + "Note: name must be qualified.\")");
            return;
        }
        super.makeInterfaceExpressionInternal(name, truncate);
    }

    public static void getImportedClasses() {
        MethodFactory.println(eventSourceFactory.getImportsAsList());
    }

    public void dumpExpression(PrintWriter out, boolean truncate) {
        StringBuffer buf = new StringBuffer("(jde-wiz-gen-event-source (list ");
        try {
            this.registerImport(Class.forName("java.util.Vector"));
            this.registerImport(Class.forName(this.listenerClassNameFQN));
        }
        catch (Exception ex) {
            // empty catch block
        }
        buf.append("(quote (jde-wiz-gen-listener-registry");
        buf.append(" \"" + this.listenerClassNameFQN + "\"))");
        Enumeration declaring_classes = this.interfaces.keys();
        while (declaring_classes.hasMoreElements()) {
            String declaring = (String)declaring_classes.nextElement();
            Vector v = (Vector)this.interfaces.get(declaring);
            buf.append("(quote ");
            buf.append("\"Fire methods for ");
            buf.append(this.listenerClassName);
            buf.append("\")");
            Enumeration e = v.elements();
            while (e.hasMoreElements()) {
                Signature sig = (Signature)e.nextElement();
                buf.append("(quote ");
                buf.append(this.createEventSourceFireMethodExpression(sig));
                buf.append(")");
            }
        }
        buf.append("))");
        MethodFactory.println(buf.toString());
    }

    private String createEventSourceFireMethodExpression(Signature sig) {
        String methName = sig.getMethod().getName();
        StringBuffer temp = new StringBuffer(methName);
        temp.setCharAt(0, Character.toUpperCase(temp.charAt(0)));
        String methNameUpCase = temp.toString();
        StringBuffer buf = new StringBuffer();
        buf.append("(jde-wiz-gen-event-source-fire-method");
        buf.append(" \"" + this.listenerClassNameFQN + "\"");
        buf.append(" \"" + methName + "\"");
        buf.append(" \"" + sig.baseName(sig.getMethod().getReturnType()) + "\"");
        buf.append(" \"" + sig.getParameters(sig.getMethod().getParameterTypes()) + "\")");
        return buf.toString();
    }

    public static void main(String[] args) {
        EventSourceFactory.makeEventSourceSupportExpression("javax.swing.event.MouseInputListener", true);
    }
}

