
;;; d-flock-coding-preferences.el --- Uses Hungarian notation for fontification of global variables etc.

;; Copyright (C) 2014-2016 Davin Pearson

;; Emacs Lisp Archive Entry:
;; Filename: d-flock-coding-preferences.el
;; Author/Maintainer: Davin Pearson <http://davin.50webs.com>
;; Keywords: Current function method C, C++, Java, Emacs Lisp
;; Version: 1.0

;;; Commentary:

;; This file is not part of GNU Emacs.

;;; Limitation of Warranty

;; This program is free software: you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation, either version 3 of the License, or (at
;; your option) any later version.
;;
;; This program is distributed in the hope that it will be useful, but
;; WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;; General Public License for more details.
;;
;; You should have received a copy of the GNU General Public License
;; along with GNU Emacs, see the file COPYING.  If not, see:
;;
;; <http://www.gnu.org/licenses/gpl-3.0.txt>.


;;; m4_install_instructions(d-flock-coding-preferences)

;;; Known Bugs:

;; None so far!

(add-hook 'font-lock-mode-hook 'd-coding-prefs-font-lock-mode-hook)

(defun d-coding-prefs-font-lock-mode-hook ()

  (if (or (eq major-mode 'c-mode)
          (eq major-mode 'c++-mode)
          (eq major-mode 'java-mode))
      (d-font-lock-add-begin
       '(
         ("\\<global[a-zA-Z0-9_]*"  0 global-face nil)
         ("\\<GLOBAL[a-zA-Z0-9_]*"  0 global-face nil)
         ("\\<local[a-zA-Z0-9_]*"   0 local-face nil)
         ("\\<LOCAL[a-zA-Z0-9_]*"   0 local-face nil)
         ("\\<prop[a-zA-Z0-9_]*"    0 prop-face nil)
         ("\\<PROP[a-zA-Z0-9_]*"    0 prop-face nil)
         )))

  (if (eq major-mode 'emacs-lisp-mode)
      (d-font-lock-add-begin
       '(
         ("\\<global[-a-zA-Z0-9_+]*"  0 global-face nil)
         ("\\<GLOBAL[-a-zA-Z0-9_+]*"  0 global-face nil)
         ("\\<local[-a-zA-Z0-9_+]*"   0 local-face nil)
         ("\\<LOCAL[-a-zA-Z0-9_+]*"   0 local-face nil)
         ("\\<prop[-a-zA-Z0-9_+]*"    0 prop-face nil)
         ("\\<PROP[-a-zA-Z0-9_+]*"    0 prop-face nil)
         ("\\*[-+a-zA-Z0-9_<>!]+\\*"  0 global-face t)
         )
       )
    )
  )

(make-face 'global-face)
(set-face-foreground 'global-face "#008800")
(make-face-bold 'global-face)
(setq global-face 'global-face)

(make-face 'local-face)
(set-face-foreground 'local-face "#f90")
(make-face-bold 'local-face)
(setq local-face 'local-face)

(make-face 'prop-face)
(set-face-foreground 'prop-face "#f90")
(make-face-bold 'prop-face)
(setq prop-face 'prop-face)

(provide 'd-flock-coding-preferences)
;;; d-flock-coding-preferences.el ends here
