# Commands covered:  ::dom::DOMimplementation parse
#
# This file contains a collection of tests for one or more of the 
# XercesSAXcommands.  Sourcing this file into Tcl runs the tests and
# generates output for errors.  No output means no errors were found.
#
# $Id: parser.test.tcl,v 1.2 2000/03/10 21:52:40 awb Exp $
package require tcldompro 1.1

if {[catch {package require xercessax 1.0}]} {
    catch {puts stderr "Cannot load xercessax 1.0 package"}
    return
}

# set trivialXML "<?xml version='1.0' encoding='UTF-8' ?><!DOCTYPE test SYSTEM><test>xxx</test>"
set trivialXML "<?xml version='1.0' encoding='UTF-8'?><test>xxx<? \
	Target Data?></test>"
set badXML "12356<zzz?xml version='1.0' encoding='UTF-8'?><test>xxx<? \
	Target Data?></test>"
set validatingXML {<?xml version='1.0'\
	encoding='UTF-8'?>\
	<!DOCTYPE test [\
	<!ELEMENT test (#PCDATA)>\
	<!ENTITY abc SYSTEM 'abc'>\
	<!ENTITY def PUBLIC 'def' 'xyz'>\
	]><test>xxx&abc;zzz&def;<!--comment--></test>}

if {0} {
set validatingXML "<!DOCTYPE doc \[\
<!ELEMENT doc (#PCDATA)>\
\]>\
<doc>xx</doc>"
}

proc readUtfOrUnicode {name} {
    set f [open $name r]
    fconfigure $f -encoding binary
    set prefix [read $f 2]
    seek $f 0 start
    if {[string equal $prefix \u00ff\u00fe]} {
	fconfigure $f -encoding identity
    } else {
	fconfigure $f -encoding utf-8
    }
    set xml [read $f]
    close $f
    return $xml
}	

proc readBinary {name} {
    set f [open $name r]
    fconfigure $f -encoding binary
    set data [read $f]
    close $f
    return $data
}

proc makeUnicode {data} {
    return [encoding convertfrom identity [encoding convertto unicode $data]]
}
proc resetCallbacks {parser} {
	global valueList
	catch {unset valueList}
	foreach a [list \
		-elementstartcommand -elementendcommand \
		-characterdatacommand -processinginstructioncommand \
		-externalentitycommand -defaultcommand \
		-handlernamespace -commentcommand] {
		$parser configure $a {}
	}
}

proc genericCallback {args} {
	global valueList
	# puts stdout "genericCallback: $args"
	lappend valueList $args
}

proc entityResolver {name base publicId systemId} {
	return [string toupper $systemId]
}

proc nullResolver {name base publicId systemId} {
	return ""
}

#
# Returning -code continue means
# that we couldn't resolve the entity
#
proc nonResolver {name base publicId systemId} {
	return -code continue
}

#
# name and base are inherited from tclexpat and don't appear
# to me to be useful

proc cXMLResolver {name base publicId systemId} {
	set ext [file extension $systemId]
	if {$ext == ".mod" || $ext == ".dtd"} {
		set fname [file join $::tcltest::testsDirectory cXML $systemId]
		set fd [open $fname r]
		set stuff [read $fd]
		close $fd
		return $stuff
	}
	return ""
}

    set result [catch {::xercessax::createParser} parserHandle]
	list $result [string trimright $parserHandle "0123456789abcdef"]
	puts stdout 1

    set result [catch {$parserHandle configure -validate 1} err]
	list $result $err 
	puts stdout 2

    set result [catch {$parserHandle configure -validate 0} err]
	list $result $err 
	puts stdout 3

    set result [catch {$parserHandle configure -elementstartcommand \
		genericProc} err]
	list $result $err 
	puts stdout 4

    set result [catch {$parserHandle configure -elementstartcommand {}} err]
	list $result $err 
	puts stdout 5

    set result [catch {$parserHandle cget -validate} err]
	list $result $err 
	puts stdout 6

    set result [catch {$parserHandle reset} err]
	list $result $err 
	puts stdout 7


    set result [catch {$parserHandle parse $trivialXML} err]
	list $result $err 
	puts stdout 8

	resetCallbacks $parserHandle
    catch {$parserHandle configure -elementstartcommand genericCallback}
    set result [catch {$parserHandle parse $trivialXML} err]
	list $result $err $valueList
	puts stdout 9

	resetCallbacks $parserHandle
    catch {$parserHandle configure -elementendcommand genericCallback}
    set result [catch {$parserHandle parse $trivialXML} err]
	list $result $err $valueList
	puts stdout 10

	resetCallbacks $parserHandle
    catch {$parserHandle configure -characterdatacommand genericCallback}
    set result [catch {$parserHandle parse $trivialXML} err]
	list $result $err $valueList
	puts stdout 11

	resetCallbacks $parserHandle
    catch {$parserHandle configure -processinginstructioncommand genericCallback}
    set result [catch {$parserHandle parse $trivialXML} err]
	list $result $err $valueList
	puts stdout 12

	resetCallbacks $parserHandle
	$parserHandle reset
    catch {$parserHandle configure -validate 1 -externalentitycommand \
		entityResolver -characterdatacommand genericCallback}
    set result [catch {$parserHandle parse $validatingXML} err]
	list $result $err $valueList
	puts stdout 13

	resetCallbacks $parserHandle
	$parserHandle reset
    catch {$parserHandle configure -validate 1 -externalentitycommand \
		entityResolver -comment genericCallback}
    set result [catch {$parserHandle parse $validatingXML} err]
	list $result $err $valueList
	puts stdout 14

	resetCallbacks $parserHandle
	$parserHandle reset
    catch {$parserHandle configure -validate 1 -externalentitycommand \
		bogusResolver -characterdatacommand genericCallback}
    set result [catch {$parserHandle parse $validatingXML} err]
	list $result $err
	puts stdout 15

	resetCallbacks $parserHandle
	$parserHandle reset
    catch {$parserHandle configure -validate 1 -externalentitycommand \
		nullResolver -characterdatacommand genericCallback}
    set result [catch {$parserHandle parse $validatingXML} err]
	list $result $err $valueList
	puts stdout 16

	resetCallbacks $parserHandle
	$parserHandle reset
    catch {$parserHandle configure -validate 1 -externalentitycommand \
		nonResolver -characterdatacommand genericCallback}
    set result [catch {$parserHandle parse $validatingXML} err]
	list $result [string range $err 0 25]
	puts stdout 17

	$parserHandle reset
    set result [catch {$parserHandle parse $badXML} err]
	list $result $err 
	puts stdout 18

	set compositeResult {}
	foreach fname [glob $::tcltest::testsDirectory/sa/*.xml] {
		# skip external entity for now
		if {[file tail $fname] == "097.xml"} continue
	    set xml [readUtfOrUnicode $fname]
	    resetCallbacks $parserHandle
	    $parserHandle reset
        catch {$parserHandle configure -validate 0}
        set result [catch {$parserHandle parse $xml} err]
		if {$result != 0} {
			lappend compositeResult [file tail $fname] $err
		}
	}
	set compositeResult
	puts stdout 19

	set compositeResult {}
	resetCallbacks $parserHandle
    $parserHandle configure -validate 0 -externalentitycommand cXMLResolver
	foreach fname [glob $::tcltest::testsDirectory/cXML/*.xml] {
	    set xml [readUtfOrUnicode $fname]
	    $parserHandle reset
        set result [catch {$parserHandle parse $xml} err]
		if {$result != 0} {
			lappend compositeResult [file tail $fname] $err
		}
	}
	set compositeResult

$parserHandle free

::tcltest::cleanupTests
return
