/*
 * XercesSax.h --
 *
 *       This header file contains information for the internal
 *       implementation of the XercesInt extension.
 *
 * Copyright (c) 1998-2000 Ajuba Solutions.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 * $Id: XercesSax.h,v 1.26 2000/09/29 00:47:25 awb Exp $
 */

#ifndef _XERCESTCLINT
#define _XERCESTCLINT


#include <internal/XMLScanner.hpp>
#include <util/PlatformUtils.hpp>
#include <util/XMLString.hpp>
#include <framework/XMLPScanToken.hpp>
#include <sax/HandlerBase.hpp>
#include <parsers/DOMParser.hpp>
#include <parsers/SAXParser.hpp>
#include <internal/MemBufInputSource.hpp>
#include <sax/ErrorHandler.hpp>
#include <sax/SAXParseException.hpp>
#include <validators/DTD/DTDValidator.hpp>
#include <validators/DTD/ContentSpecNode.hpp>

#include <cwchar>

#include <tcl.h>
#include <tdp.h>



#define NAMESPACE "xercessax::"
#define PACKAGE_NAME "xercessax"

class XercesIntData;
class SAXTclHandler;
class SAXAdvTclHandler;
class SAXTclResolver;
class SAXTclDocTypeHandler;
class TclMemoryBuffer;
class InputSource;

#define ID_SIZE 128

/*
 * This structure contains information for a given 
 * interpreter instance.
 */
class XercesIntData {
public:
    int parserSeed;
};

/*
 * This structure contains information for a given 
 * parser instance.
 */
class XercesParserData {
public:
    Tcl_Obj *parserHandle;
    SAXParser *saxParserPtr;
    SAXTclHandler *saxHandler;
    SAXTclResolver *resolverPtr;
    SAXAdvTclHandler *saxAdvHandler;
    SAXTclDocTypeHandler *docTypeHandler;
    XMLPScanToken parseToken;
    int treatWarningsAsErrors;		/* Set this to have warnings cause a parse error */
    Tcl_DString parseErrors;		/* Accumulated parse errors or callback errors */
    Tcl_DString parseErrorsAndWarnings;	/* As above, plus warnings */
    int parseStatus;			/* Global status of parse process */
    int validate;			/* Set this to validate the XML */
    int namespaces;			/* Set this to use namespaces in the parser */
    Tcl_Obj *elementStartCommand;       /* Script for element start */
    Tcl_Obj *elementEndCommand;         /* Script for element end */
    Tcl_Obj *characterDataCommand;      /* Script for character data */
    Tcl_Obj *processingInstructionCommand; /* Script for processing instructions */
    Tcl_Obj *externalEntityCommand;     /* Script for external entity */
    Tcl_Obj *defaultCommand;            /* Script for callbacks with no defined scripts */
    Tcl_Obj *unparsedEntityCommand;     /* Script of unparsed entities */
    Tcl_Obj *notationDeclarationCommand;/* Script for notation declarations */
    Tcl_Obj *unknownEncodingCommand;    /* Script for unknown encodings */
    /* The following are not part of Steve Ball's baseline API */
    Tcl_Obj *commentCommand;           /* Script for comments */
    Tcl_Obj *notStandaloneCommand;     /* Script for "not standalone" docs */
    Tcl_Obj *startCdataSectionCommand; /* Script for CDATA section start */
    Tcl_Obj *endCdataSectionCommand;   /* Script for CDATA section end */
    Tcl_Obj *elementDeclCommand;       /* Script for <!ELEMENT decl's */
    Tcl_Obj *attlistDeclCommand;       /* Script for <!ATTLIST decl's */
    Tcl_Obj *startDoctypeDeclCommand;  /* Script for <!DOCTYPE decl's */
    Tcl_Obj *endDoctypeDeclCommand;    /* Script for <!DOCTYPE decl ends */
    Tcl_Obj *baseURL;
    Tcl_Obj *handlerNamespace;
    int final;
    int ignoreWhiteSpace;
    int useDom;             /* if true, generate a DOM tree */
    int haveDomPackage;     /* if true, package has successfully been loaded */
    unsigned int currentLine;
    unsigned int currentColumn;
    unsigned int previousLine;
    unsigned int previousColumn;
    XMLCh currentSysId[ID_SIZE];
    XMLCh currentPubId[ID_SIZE];
    Tdp_Document currentDocument; /* root of the DOM tree */
    Tdp_Node currentNode;      /* used while building the DOM tree */
    int depth;                  /* nesting depth while building the DOM tree */
};

class SAXTclHandler : public HandlerBase
{
public:
    // -----------------------------------------------------------------------
    //  Constructors
    // -----------------------------------------------------------------------
    SAXTclHandler(const bool doEscapes, Tcl_Interp *interp, XercesParserData *parserPtr);
    ~SAXTclHandler();


    // -----------------------------------------------------------------------
    //  Implementations of the SAX DocumentHandler interface
    // -----------------------------------------------------------------------
    void endDocument();

    void endElement(const XMLCh* const name);

    void characters(const XMLCh* const chars, const unsigned int length);

    void ignorableWhitespace
    (
        const   XMLCh* const    chars
        , const unsigned int    length
    );

    void processingInstruction
    (
        const   XMLCh* const    target
        , const XMLCh* const    data
    );

    void startDocument();

    void startElement(const XMLCh* const name, AttributeList& attributes);



    // -----------------------------------------------------------------------
    //  Implementations of the SAX ErrorHandler interface
    // -----------------------------------------------------------------------
    void warning(const SAXParseException& exception);
    void error(const SAXParseException& exception);
    void fatalError(const SAXParseException& exception);



    // -----------------------------------------------------------------------
    //  Implementation of the SAX DTDHandler interface
    // -----------------------------------------------------------------------
    void notationDecl
    (
        const   XMLCh* const    name
        , const XMLCh* const    publicId
        , const XMLCh* const    systemId
    );

    void unparsedEntityDecl
    (
        const   XMLCh* const    name
        , const XMLCh* const    publicId
        , const XMLCh* const    systemId
        , const XMLCh* const    notationName
    );

    void setTclNamespace(Tcl_Interp *interp, char *tclNamespace);
    void setDocumentLocator(Locator* const locator);
private:
    void SAXTclHandler::genericError(const SAXParseException& e, char *errorType);
private :
    // -----------------------------------------------------------------------
    //  Private data members
    //
    //  fDoEscapes
    //      Indicates whether characters should be escaped via char refs if
    //      they would normally be in that place in a legal XML file.
    // -----------------------------------------------------------------------
    bool    fDoEscapes;
    char *handlerNamespace;
    XercesParserData *parserPtr;
    Tcl_Interp *interp;
};

class SAXTclResolver : public EntityResolver {
public:
    SAXTclResolver(Tcl_Interp *interp, XercesParserData *parserPtr);
    ~SAXTclResolver();
    InputSource *resolveEntity(const XMLCh* const publicId,
        const XMLCh* const systemId);
private:
    Tcl_Interp *interp;
    XercesParserData *parserPtr;
};

class SAXAdvTclHandler : public XMLDocumentHandler {
public:
     SAXAdvTclHandler(Tcl_Interp *interp, XercesParserData *parserPtr);
    ~SAXAdvTclHandler();

void docCharacters(const XMLCh * const chars, const unsigned int length,
    const bool cdataSection);

void docComment(const XMLCh * const chars);

void docPI(const XMLCh * const chars, const XMLCh * const data);

void endDocument();

void endElement(const XMLElementDecl& elemDecl,
    const unsigned int uriId, const bool isRoot);

void endEntityReference(const XMLEntityDecl& entDecl);

void ignorableWhitespace(const XMLCh * const chars, const unsigned int length,
    const bool cdataSection);

void resetDocument();

void startDocument();

void startElement(const XMLElementDecl& elemDecl,
    const unsigned int uriId,
    const XMLCh* const prefixName,
    const RefVectorOf<XMLAttr>& attrList,
    const unsigned int attrCount,
    const bool isEmpty,
    const bool isRoot);

void startEntityReference(const XMLEntityDecl& entityDecl);

void XMLDecl(const XMLCh * const versionStr,
    const XMLCh * const encodingStr,
    const XMLCh * const standaloneStr,
    const XMLCh * const autoEncodingStr);
private:
    Tcl_Interp *interp;
    XercesParserData *parserPtr;
};


class SAXTclDocTypeHandler : public DocTypeHandler
{
public:
    SAXTclDocTypeHandler(Tcl_Interp *interp, XercesParserData *parserPtr);
    ~SAXTclDocTypeHandler();
void attDef(
    const DTDElementDecl& elemDecl,
    const DTDAttDef& attDef,
    const bool ignoring
);
void doctypeComment(
    const XMLCh* const comment
);
void doctypeDecl(
    const DTDElementDecl& elemeDecl,
    const XMLCh* const publicId,
    const XMLCh* const systemId,
    const bool hasIntSubset
);
void doctypePI(
    const XMLCh* const target,
    const XMLCh* const data
);
void doctypeWhitespace(
    const XMLCh* const chars,
    const unsigned int length
);
void elementDecl
(
    const   DTDElementDecl& decl, 
    const bool            isIgnored
);

void endAttList
    (
        const   DTDElementDecl& elemDecl
    );

void endIntSubset();

void endExtSubset();

void entityDecl
    (
        const   DTDEntityDecl&  entityDecl
        , const bool            isPEDecl
        , const bool            isIgnored
    );

void resetDocType();

void notationDecl
    (
        const   XMLNotationDecl&    notDecl
        , const bool                isIgnored
    );

void startAttList
    (
        const   DTDElementDecl& elemDecl
    );

void startIntSubset();

void startExtSubset();

void TextDecl
    (
        const   XMLCh* const    versionStr
        , const XMLCh* const    encodingStr
    );
void FormatNodes(Tcl_Obj *specObjPtr, const ContentSpecNode *contentSpec,
    ContentSpecNode::NodeTypes parentType);

private:
    Tcl_Interp *interp;
    XercesParserData *parserPtr;
    Tcl_Obj *attrListPtr;
};

class TclMemoryBuffer  : public InputSource {
public:
    TclMemoryBuffer(
	const   XMLByte* const  srcDocBytes,
	const unsigned int    byteCount,
	const char* const     bufId,
	const bool            adoptBuffer=false
    );
    TclMemoryBuffer (
        const   XMLByte* const  srcDocBytes,
        const unsigned int    byteCount,
        const XMLCh* const    bufId,
        const bool            adoptBuffer = false
    );
    BinInputStream* TclMemoryBuffer::makeStream() const;
    unsigned int curPos();

// -----------------------------------------------------------------------
//  Private data members
//
//  fAdopted
//      Indicates whether the buffer is adopted or not. If so, then it
//      is destroyed when the input source is destroyed.
//
//  fByteCount
//      The size of the source document.
//
//  fCopyBufToStream
//      This defaults to true (the safe option), which causes it to
//      give a copy of the buffer to any streams it creates. If you set
//      it to false, it will allow the streams to just reference the
//      buffer (in which case this input source must stay alive as long
//      as the buffer is in use by the stream.)
//
//  fSrcBytes
//      The source memory buffer that is being spooled from. Whether it
//      belongs to the this input source or not is controlled by the
//      fAdopted flag.
// -----------------------------------------------------------------------
    bool            fAdopted;
    unsigned int    fByteCount;
    bool            fCopyBufToStream;
    const XMLByte*  fSrcBytes;
    BinInputStream* fStream;
};



#endif /* _XERCESTCLINT */
