#!/smart/lbin/rtclsh
# Provide INETD service to rpcserv.tcl (RPC server capability)
# without using inetd
# Needs TCL version >= 7.5 
# Created: Tue Apr 30 14:45:49 EDT 1996
# Last Updated: Tue Apr 30 14:45:55 EDT 1996
proc rpc_service_do {args} {
	#puts "GOT $args"
	set sockfd [lindex $args 0]
	set sockhost [lindex $args 1]
	set sockport [lindex $args 2]
	#flush stdout
	#puts "Launched: exec rtclsh rpcserv.tcl <@$sockfd >@$sockfd 2>@$sockfd &"
	set pid [exec tclx.ora rpcserv.tcl\
		RPCSERVTCLAUTO <@$sockfd >@$sockfd 2>@$sockfd &]
	#puts "sockfd is $sockfd"
	#flush stdout
	close $sockfd
	global fplog
	if {$fplog != ""} {
		set day [clock format [clock seconds]]
		puts $fplog\
		"HOST $sockhost PID $pid PORT $sockport FD $sockfd DATE $day"
		flush $fplog
	}
}

proc getenv {x} {
	global env
	if {[catch {set ret $env($x)}] == 0} {
		return $ret
	} else {return ""}
}

proc main {} {
	global env mainport fplog
	set port [getenv RPCSOCKET]
	if {$port == ""} {
		set port 7098
	}
	set mainport [socket -server rpc_service_do $port]
	set fplog ""
	catch {set fplog [open rpcserv.log a]}

}

main
vwait any
