'\"
'\" Generated from ../tcllib/modules/doctools/mpexpand.man by mpexpand with fmt.nroff
'\"
.so man.macros
.TH "mpexpand" n 1.0 doctools "Documentation toolbox"
.BS
.SH NAME
mpexpand \- Markup processor
.SH "SYNOPSIS"
\fBmpexpand\fR ?-module \fImodule\fR? \fIformat\fR \fIinfile\fR|- \fIoutfile\fR|-\fR
.sp
\fBmpexpand.all\fR ?\fI-verbose\fR? ?\fImodule\fR?\fR
.sp
.BE
.SH "DESCRIPTION"
.PP
This manpage describes the processor / converter for manpages in the
format described in the manpage \fBmp_rules\fR.
.TP
\fBmpexpand\fR ?-module \fImodule\fR? \fIformat\fR \fIinfile\fR|- \fIoutfile\fR|-\fR
The processor takes three arguments, namely the code describing which
formatting to generate as the output, the file to read the markup
from, and the file to write the generated output into. If the
\fIinfile\fR is "\fB-\fR" the processor will read from
\fBstdin\fR. If \fIoutfile\fR is "\fB-\fR" the processor will
write to \fBstdout\fR.
.sp
If the option \fI-module\fR is present its value overides the internal
definition of the module name.
.sp
The currently known output formats are
.RS
.TP
\fBnroff\fR
The processor generates *roff output, the standard format for unix
manpages.
.TP
\fBhtml\fR
The processor generates HTML output, for usage in and display by web
browsers.
.TP
\fBtmml\fR
The processor generates TMML output, the Tcl Manpage Markup Language,
a derivative of XML.
.TP
\fBlatex\fR
The processor generates LaTeX output.
.RE
.TP
\fBmpexpand.all\fR ?\fI-verbose\fR? ?\fImodule\fR?\fR
This command uses \fBmpexpand\fR to generate all possible output
formats for all manpages in the current directory. The manpages are
recognized through the extension \fB.man\fR. If \fI-verbose\fR is
specified the command will list its actions before executing them.
.sp
The \fImodule\fR information is passed to \fBmpexpand\fR.
.SH "NOTES"
.PP
The interface between the manpage processor and a file specifying the
conversion to an output format is described in the manpage
\fBformatter(n)\fR.
.PP
Possible future formats are plain text, latex, pdf and postscript.
.SH "SEE ALSO"
expander(n), format(n), formatter(n)
.SH "KEYWORDS"
manpage, TMML, HTML, nroff, conversion, markup
