/* 
This software is being provided to you, the LICENSEE, by the
Massachusetts Institute of Technology (M.I.T.) under the following
license.  By obtaining, using and/or copying this software, you agree
that you have read, understood, and will comply with these terms and
conditions:

Permission to use, copy, modify and distribute, including the right to
grant others the right to distribute at any tier, this software and
its documentation for any purpose and without fee or royalty is hereby
granted, provided that you agree to comply with the following
copyright notice and statements, including the disclaimer, and that
the same appear on ALL copies of the software and documentation,
including modifications that you make for internal use or for
distribution:

Copyright 1992,1993,1994 by the Massachusetts Institute of Technology.
                    All rights reserved.

THIS SOFTWARE IS PROVIDED "AS IS", AND M.I.T. MAKES NO REPRESENTATIONS
OR WARRANTIES, EXPRESS OR IMPLIED.  By way of example, but not
limitation, M.I.T. MAKES NO REPRESENTATIONS OR WARRANTIES OF
MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE
OF THE LICENSED SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD
PARTY PATENTS, COPYRIGHTS, TRADEMARKS OR OTHER RIGHTS.

The name of the Massachusetts Institute of Technology or M.I.T. may
NOT be used in advertising or publicity pertaining to distribution of
the software.  Title to copyright in this software and any associated
documentation shall at all times remain with M.I.T., and USER agrees
to preserve same.
*/
/*
 * Gregory D. Troxel
 */

/* SEGMENT - describes group of data points */
typedef struct segment_s
{
  int clock;			/* clock number of this segment */
  int run;			/* run for points in this segment */
  dataset_t *ds;
  int first;
  int n;
  struct segment_s *samerun;		/* same run, but disjoint points */
  struct segment_s *next;		/* different run or clock */
  /* XXX include memoized sums for this segment (and samerun) */
} segment_t;

/* SUMSEG - sums of a segment (for given phases) */
typedef struct sumseg_s
{
  int n;
  int first;
  double sumweights;
  double Sx, Sxx, Sxxx, Sxxxx;
  double Sy, Sxy, Sxxy;
  ntp_t ltime, htime;
} sumseg_t;

/* SEGMENT routines */
segment_t *segment_new();
void segment_free(segment_t *sp);
void segment_print(FILE *finfo, segment_t *sp, int crossclockruns);
void segment_print_verbose(FILE *finfo, segment_t *sp, int crossclockruns);
segment_t *segment_copy(segment_t *sp);
segment_t *segment_last(segment_t *sp, int crossclockruns);

int segment_count(segment_t *sp, int crossclockruns);
int segment_count_valid(segment_t *sp, int crossclockruns);
int segment_count_clocks(segment_t *sp);
int segment_count_runs(segment_t *sp);

#ifdef __GNUC__
inline static 
#endif
int segment_begin(segment_t *sp)
#if defined(PD_UTIL) || defined(__GNUC__)
{
  return sp->first;
}
#else
;
#endif

#ifdef __GNUC__
inline static
#endif
ntp_t segment_begin_time(segment_t *sp)
#if defined(PD_UTIL) || defined(__GNUC__)
{
  return sp->ds->dptr[sp->first].time;
}
#else
;
#endif

#ifdef __GNUC__
inline static
#endif
int segment_end(segment_t *spo, int crossclockruns)
#if defined(PD_UTIL) || defined(__GNUC__)
{
  segment_t *sp;

  /* cdr to end */
  if ( crossclockruns )
    for ( sp = spo ; sp->next; sp = sp->next )
      ;
  else
    sp = spo;
  for ( ; sp->samerun; sp = sp->samerun )
    ;
  return sp->first + sp->n - 1;
}
#else
;
#endif

#ifdef __GNUC__
inline static
#endif
ntp_t segment_end_time(segment_t *sp, int crossclockruns)
#if defined(PD_UTIL) || defined(__GNUC__)
{
  return sp->ds->dptr[segment_end(sp, crossclockruns)].time;
}
#else
;
#endif

ntp_t segment_multiple_begin_time(segment_t *sp);
ntp_t segment_multiple_end_time(segment_t *sp);

segment_t *
segment_append(FILE *finfo, segment_t *sp, segment_t *spapp,
	       int take_from, int take_to);
void segment_trim(segment_t *sp, int rem_from, int rem_to);
segment_t *segment_fixup(segment_t *sp);

/* SUMSEG routines */
void sumseg_print(FILE *finfo, sumseg_t *ss);
void sumseg_init(sumseg_t *ss);
void sumseg_sum(segment_t *sp, double offset, sumseg_t *ss,
		int crossclockrun, int includeinvalid);


