/* 
This software is being provided to you, the LICENSEE, by the
Massachusetts Institute of Technology (M.I.T.) under the following
license.  By obtaining, using and/or copying this software, you agree
that you have read, understood, and will comply with these terms and
conditions:

Permission to use, copy, modify and distribute, including the right to
grant others the right to distribute at any tier, this software and
its documentation for any purpose and without fee or royalty is hereby
granted, provided that you agree to comply with the following
copyright notice and statements, including the disclaimer, and that
the same appear on ALL copies of the software and documentation,
including modifications that you make for internal use or for
distribution:

Copyright 1992,1993,1994 by the Massachusetts Institute of Technology.
                    All rights reserved.

THIS SOFTWARE IS PROVIDED "AS IS", AND M.I.T. MAKES NO REPRESENTATIONS
OR WARRANTIES, EXPRESS OR IMPLIED.  By way of example, but not
limitation, M.I.T. MAKES NO REPRESENTATIONS OR WARRANTIES OF
MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE
OF THE LICENSED SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD
PARTY PATENTS, COPYRIGHTS, TRADEMARKS OR OTHER RIGHTS.

The name of the Massachusetts Institute of Technology or M.I.T. may
NOT be used in advertising or publicity pertaining to distribution of
the software.  Title to copyright in this software and any associated
documentation shall at all times remain with M.I.T., and USER agrees
to preserve same.
*/
/*
 * Gregory D. Troxel
 * program-wide include file
 * include system headers
 * include headers for other files
 * define program-wide types
 * each file must include this to check its own header vs. func decls
 */

/* system includes might not work ok if we do them twice */
#ifndef __PD_DO_INCLUDES__
#define __PD_DO_INCLUDES__

#ifdef HAVE_CONFIG_H
#include <config.h>		/* autoconf information */
#endif

#include <stdio.h>
#include <errno.h>

#ifdef HAVE_STDLIB_H
#include <stdlib.h>
#endif

#ifdef HAVE_MATH_H
#include <math.h>
#endif

#if TIME_WITH_SYS_TIME
# include <sys/time.h>
# include <time.h>
#else
# if HAVE_SYS_TIME_H
#  include <sys/time.h>
# else
#  include <time.h>
# endif
#endif

#if HAVE_STRING_H
# include <string.h>
#else
# ifndef HAVE_STRCHR
#  define strchr index
#  define strrchr rindex
# endif
char *strchr (), *strrchr ();
#endif

#ifdef DEFINE_MISSING_FUNCS
#ifdef HAVE_SETENV
  int setenv();
#else
#ifdef HAVE_PUTENV
  int putenv();
#endif
#endif
#endif

/* #define GNU_MALLOC */

/* generic routines not pd-specific */
#include "median.h"
#include "pd_util.h"

/* program-wide defines */
#define NEW(type)	((type *) (malloc(sizeof(type))))

#define	JAN_1970	(2208988800U) /* 1970 - 1900 in seconds */

#define Tunix2ntp(t)	( (t) + JAN_1970 )
#define Tntp2unix(t)	( (t) - JAN_1970 )

#define Trun2ntp(t)	( (t) + globals.first_time )
#define Tntp2run(t)	( (t) - globals.first_time )
#define Trun2unix(t)	( (t) + globals.ufirst_time )
#define Tunix2run(t)	( (t) - globals.ufirst_time )

#define SECSPERDAY	86400
#define KK		1000000	/* a true 1 million */
#define HUGEDEV		1.0E12	/* to represent infinity */
#define HUGEDELAY	1.0E12	/* to represent infinity */

#define DIAGNOSTIC		/* extra checks */

/* program-wide arbitrary limits on imput */
#define NCLOCKS 64
#define NRUNS 128

/* type declarations */
#include "pd_types.h"

/* user defined types */
#include "pd_datapoint.h"
#include "pd_clock.h"
#include "pd_seg.h"
#include "pd_fit.h"

#include "pd_globals.h"

#include "pd_config.h"
#include "pd_io.h"

#include "pd_delay.h"
#include "pd_piecewise.h"
#include "pd_integrated.h"
#include "pd_join.h"
#include "pd_invalidate.h"
#include "pd_rsadj.h"
#include "pd_autocorr.h"

#endif /* __PD_DO_INCLUDES__ */


