/*********************************************************/
#include	<std.h>
#include	<rt11.h>
#include	<mmmhdr.h>


/*********************************************************/
/**** entry points */
FILE	getifile(),getofile();
int	inirtrav(),iniptrav(),link(),freenodes(),initnode();
TREEPTR	rtrav(),ptrav(),getnode(),fndleft();
int	info(),gactmag(),getformat();
int	quit(),illcom(),ambcom();
int	sizmap();

/*********************************************************/
/* external functions from genlib */
TEXTPTR	concat(),getstr();

/*********************************************************/
/* external functions from diolib */
FILE	dopen(),dcreate();

/*********************************************************/
struct 	tstk {
	struct segnode *ptr;
	BOOL 	flag;
	} stk[10]
	{  {0,0},{0,0},{0,0},{0,0},{0,0},
	   {0,0},{0,0},{0,0},{0,0},{0,0},};

int	stkptr = 0;
TEXTPTR	algnam[] ;
TREEPTR	top,mtop,present ;
int	lcurx,lcury,curx,cury;


/*********************************************************/
/* unlink node from tree; return unlinked node */

TREEPTR	unlink(node)
FAST	TREEPTR node;
{
FAST	TREEPTR lnode;

if ( !node) return;
if ( (lnode = fndleft(node)) == node) {
	lnode = node->upptr;		/* this is first child of father*/
	lnode->lptr = node->rptr;
	}
else	lnode->rptr = node->rptr;

if (node == top ) top = NULL;
node->rptr = NULL;
node->upptr = NULL;
return (node );
}


/*********************************************************/
/* link child as son of father */
link(father,child)
FAST	TREEPTR father,child;
{
FAST	TREEPTR node;

if ( !father ) {	/* if no father given, assume mtop to be father*/
	top = child;	/* set top as child */
	father = mtop;
	}
child->upptr=father;
if (father->lptr == NULL) father->lptr = child;	/* first son */
else {			/* find rightmost son and link */

	for(node=father->lptr; node->rptr ;node=node->rptr);
	node->rptr=child;
	}

}	/* of link */


/*********************************************************/
/* initialise stack */
intstk()
{
stkptr = 0;
}

/*********************************************************/
push(node,flg)
FAST	TREEPTR node;
BOOL flg;

{
stk[stkptr].ptr=node;
stk[stkptr++].flag=flg;

}	/* of push */


/*********************************************************/
BOOL pop(node,flg)
TREEPTR *node;
BOOL	*flg;

{
if (stkptr <= 0) return(NO);

*node=stk[--stkptr].ptr;
*flg=stk[stkptr].flag;
return(YES);

}	/* of pop */

/*********************************************************/
/* initialize reverse preorder traversal ; root is topnode */
inirtrav(topnode)
TREEPTR topnode;

{
intstk();
if (topnode ) push(topnode,NO);

} 	/* of inirtrav */

/*********************************************************/
/* return next node in reverse preorder traversal of tree */
TREEPTR rtrav()

{
TREEPTR node;
BOOL	flg;

FOREVER {

	if (pop(&node,&flg) == NO) return(NULL);
	if(flg == YES ) return (node);
	push(node,YES);

	for(node=node->lptr; node ; node=node->rptr)
	push(node,NO);
	} 	/* of outer for */
}	/* of rtrav */


/*********************************************************/
/* initialize preorder traversal of tree at topnode */
iniptrav(topnode)
TREEPTR topnode;

{
intstk();
if (topnode ) push(topnode,NO);

} 	/* of iniptrav */


/*********************************************************/
/* return next node in preorder traversal of tree */
TREEPTR ptrav()

{
TREEPTR node;
BOOL	flg;

if (pop(&node,&flg) == NO) return(NULL);
if ( (node != top) && node->rptr ) push(node->rptr,YES);
if(node->lptr )	push(node->lptr,YES);
return(node);

}	/* of ptrav */


/**************************************************************/
/* allocate new node */
TREEPTR	getnode()
{
FAST	TREEPTR	node;

if ( (node = nalloc(sizeof(*node),node) ) == NULL) 
	putstr(STDERR,"out of heap space /n",NULL);
return(node);
}

/**************************************************************/
/* free nodes in tree at root */
freenodes(root)
TREEPTR root;
{
FAST	TREEPTR node;

inirtrav(root);
for (node=rtrav(); node ; node=rtrav())
	free(node,NULL);
}

/*********************************************************/
initnode(node)
FAST	TREEPTR	node;
{
node->dataflag=0 ;
node->filptr = 0L;
node->xsiz = 1728 ;
node->ysiz = 2200 ;
node->startx=0 ;
node->starty=0 ;

node->alg=1 ;
node->white=0 ;
node->black=1 ;
node->trans=-1 ;

node->segxsiz=1728;
node->segysiz=2200;
node->segxpos=0;
node->segypos=0;
node->id=0 ;	

node->resx=DEFXRES ;	
node->resxmm=DEFXMM ;	
node->resy=DEFYRES ;	
node->resymm=DEFYMM ;	

node->magx=1 ;
node->magxbas=1 ;
node->magy=1 ;
node->magybas=1 ;

node->scrxsiz=0 ;
node->scrysiz=0 ;
node->scrxpos=0 ;
node->scrypos=0 ;

node->upptr=NULL ;
node->lptr=NULL ;
node->rptr=NULL ;
}

/*********************************************************/
/* prettyp info about node */
info()
{
FAST	TREEPTR	node,pa;
int	xpos,ypos,x,xb,y,yb;

if ( (node=present) == NULL) return;

putstr(STDOUT,"alg: ",algnam[node->alg],"\n",NULL);

if (node->dataflag ) {
	putstr(STDOUT,"from file: ",node->filnam,"\n",NULL);
	putstr(STDOUT,"window at: (",NULL);
	putdec(node->startx,",");
	putdec(node->starty,")\n");
	}

putstr(STDOUT,"segsiz: ",NULL);
putdec(node->segxsiz," by ");
putdec(node->segysiz,"    ");

putstr(STDOUT,"segpos: (",NULL);
pa=node->upptr;
if (pa==mtop) {
	xpos = 0;
	ypos = 0;
	}
else	{
	xpos = muldiv(node->scrxpos-pa->scrxpos,pa->magxbas,pa->magx);
	ypos = muldiv(node->scrypos-pa->scrypos,pa->magybas,pa->magy);
}

putdec(xpos,",");
putdec(ypos,")\n");

putstr(STDOUT,"x resolution: ",NULL);
putdec(node->resx," per ");
putdec(node->resxmm," mm    ");

putstr(STDOUT,"y resolution: ",NULL);
putdec(node->resy," per ");
putdec(node->resymm," mm\n");

gactmag(node,&x,&xb,&y,&yb);
putstr(STDOUT,"x scale factor: ",NULL);
putdec(x,":");
putdec(xb,"    ");

putstr(STDOUT,"y scale factor: ",NULL);
putdec(y,":");
putdec(yb,"\n");

putstr(STDOUT,"pos in disp: (",NULL);
putdec(node->scrxpos,",");
putdec(node->scrypos,")    ");

putstr(STDOUT,"siz in disp: ",NULL);
putdec(node->scrxsiz," by ");
putdec(node->scrysiz,"\n");

putstr(STDOUT,"virtual cursor at: (",NULL);
putdec(lcurx,",");
putdec(lcury,")    ");

putstr(STDOUT,"physical cursor at: (",NULL);
putdec(curx,",");
putdec(cury,")\n");
}

/**************************************************/
/* compute actual magnification of segment. The node
contains mag factor to map data directly to screen which
contains a factor for mapping resolutions. */

gactmag(node,x,xb,y,yb)
FAST	TREEPTR node;
int	*x,*xb,*y,*yb;
{

*x = node->resx*SCRXMM;
*xb = node->resxmm*SCRXRES;
factor(x,xb);
*x = *x * node->magx;
*xb = *xb * node->magxbas;
factor(x,xb);

*y = node->resy*SCRYMM;
*yb = node->resymm*SCRYRES;
factor(y,yb);
*y = *y * node->magy ;
*yb = *yb *node->magybas ;
factor(y,yb);
}

/************************************************/
/* return left node of node */
/* returns node if no left node */

TREEPTR fndleft(node)
FAST	TREEPTR node;
{
FAST	TREEPTR snode;

if (node ) snode = node->upptr;
else	snode = mtop;
if ( (snode = snode->lptr) == node ) return(node);
while ( snode  && (snode->rptr != node) )
	snode= snode->rptr;
return(snode);
}

/************************************************************/
/* gets file name and creates output file */
/* defext contains the default extension */

FILE	getofile(name,defext)
FAST	TEXTPTR	name,defext;
{
FILE	f;

getstr("output file:",name);
if ( !name[scnstr(name,'.')] ) concat(name,".",defext,NULL);
if ((f = dcreate(name,0,1)) < 0) putstr(STDERR,"create error-",name,
	"\n",NULL);
return(f);
}

/************************************************************/
/* gets file name and opens input file */
/* defext contains the default extension */
FILE	getifile(name,defext)
FAST	TEXTPTR	name,defext;
{
FILE	f;

getstr("input file:",name);
if ( !name[scnstr(name,'.')] ) concat(name,".",defext,NULL);
if ((f = dopen(name,2,1)) < 0) putstr(STDERR,"open error-",name,"\n",NULL);
return(f);
}

/*********************************************************/
/* maps size l from source res. (sres/sresmm) to
destination resolution (dres/dresmm) */

sizmap(l,sres,sresmm,dres,dresmm)
int	l,sres,sresmm,dres,dresmm;
{
return( muldiv( muldiv(l,dres,dresmm),sresmm,sres) );
}

/*********************************************************/
/* makes copy of tree at node and returns the copy */

makcopy(node)
FAST	TREEPTR	node;
{
FAST	TREEPTR	newnode;

if ( !node) return(NULL);
if ( !(newnode = getnode()) ) return(NULL);

cpybuf(newnode->filnam,node->filnam,20) ;
newnode->dataflag = node->dataflag ;
newnode->filptr = node->filptr ;
newnode->xsiz = node->xsiz ;
newnode->ysiz = node->ysiz ;
newnode->startx = node->startx ;
newnode->starty = node->starty ;

newnode->alg = node->alg ;
newnode->white = node->white ;
newnode->black = node->black ;
newnode->trans = node->trans ;

newnode->segxsiz = node->segxsiz ;
newnode->segysiz = node->segysiz ;
newnode->segxpos = node->segxpos ;
newnode->segypos = node->segypos ;
newnode->id = node->id ;	

newnode->resx = node->resx ;	
newnode->resxmm = node->resxmm ;	
newnode->resy = node->resy ;	
newnode->resymm = node->resymm ;	

newnode->magx = node->magx ;
newnode->magxbas = node->magxbas ;
newnode->magy = node->magy ;
newnode->magybas = node->magybas ;

newnode->scrxsiz = node->scrxsiz ;
newnode->scrysiz = node->scrysiz ;
newnode->scrxpos = node->scrxpos ;
newnode->scrypos = node->scrypos ;

newnode->upptr = NULL ;
newnode->lptr = NULL ;
newnode->rptr = NULL ;

for ( node = node->lptr ; node ; node = node->rptr )
	link(newnode,makcopy(node) );

return(newnode);

}

/****************************************************/
/* sets screen position of node to x,y. adjusts
positions of its children by the same amount.
Equiv. to translating the substruct. to (x,y) */

adjpos(node,x,y)
FAST	TREEPTR node;
int	x,y;
{
FAST	int	dx,dy;

dx = x - node->scrxpos;
dy = y - node->scrypos;
node->scrxpos = x;
node->scrypos = y;
iniptrav(node->lptr);
while (node = ptrav() ) {
	node->scrxpos += dx;
	node->scrypos += dy;
	}
}

/*********************************************************/
/* maps logical screen position x to physical screen pos. */
mapx(x)
int	x;
{
return(x-(lcurx-curx) );
}

/*********************************************************/
/* maps logical screen position y to physical screen pos. */
mapy(y)
int	y;
{
return(y-(lcury-cury) );
}
          