/*********************************************************/
#include	<std.h>
#include	<rt11.h>
#include	<mmmhdr.h>


/*********************************************************/
/****  external functions from mmmelm */
long	proplist(),list(),text(),bitstr();
int	endlist(),endplist(),index(),integer(),name(),endtext();

/*********************************************************/
/**** entry points */

/*********************************************************/
/* This file contains routines to store the MM struct.
in a RFC767 format message */
/* All routines closely follows the definition of a message */
/* Each routine constructs a specific field of the message; what
goes into this field can be a complicated structure, even a recursive
one! Routines from mmmelm.c are used to construct each field as 
a type followed by its value. Some routines also return a count of 
the number of fields it created so that the calling routine can use the count
to update the count field of a list or proplist. Fields containing
default values are not created, if permitted to do so. */


/* external globals */
FILE	fd;
TEXT	opnerr[];
TEXT	linbuf[];
TREEPTR mtop;
int	format;

int	maxalg ;
TEXTPTR	algnam[] ;


/*********************************************************/
/* stores image struct. as message body */
storimg(node)
TREEPTR node;

{
long	savadr;

savadr = proplist(fd);
ibody(node);
endplist(fd, savadr,1);
}

/*********************************************************/
/* stores body of image as body element */
ibody(node)
TREEPTR node;
{
long	savadr;

name(fd,"BODY");
savadr = proplist(fd);
imulmedia(node);
endplist(fd,savadr,1);
}

/*********************************************************/
/* stores image only as multimedia message*/
imulmedia(node)
TREEPTR node;

{
long	savadr;

name(fd,"MULTIMEDIA");
savadr = proplist(fd);
faxseg(node);
endplist(fd, savadr,1);
}

/*********************************************************/
/* stores struct. as MM message without headers*/
stormmm(node)
TREEPTR node;

{
long	savadr;

savadr = proplist(fd);
body(node);
endplist(fd, savadr,1);
}

/*********************************************************/
/* stores struct. as mm mesage with headers*/
sndmmmm(node)
TREEPTR node;

{
long	savadr;
int	count = 0;

savadr = proplist(fd);
count += date();
count += from();
count += subject();
count += to();
count += cc();
putstr(STDOUT,"inserting body ..\n",NULL);

body(node);
count += 1;

endplist(fd, savadr,count);
}


/*********************************************************/
/* inserts body of MM message */
body(node)
TREEPTR node;
{
long	savadr;

name(fd,"BODY");
savadr = proplist(fd);
mulmedia(node);
endplist(fd,savadr,1);
}

/*********************************************************/
/* forms multimedia element in body */
mulmedia(node)
TREEPTR node;

{
long	savadr;
int	count = 0;

name(fd,"MULTIMEDIA");
savadr = proplist(fd);
for (node = node ->lptr ; node ; node = node->rptr){
	count += 1;
	if (node->alg == ALGTEXT) texseg(node);
	else if ( (node->alg >= ALGBITMAP) && (node->alg <= ALGCCITT ))
		faxseg(node);
	else	{
		putstr(STDERR,"unknown alg",NULL);
		putdec(node->alg,"\n");
		}
	}
endplist(fd, savadr,count);
}

/*********************************************************/
/* gets date from user ??? and adds to message */
date()
{
getstr("date:",linbuf);
if ( *linbuf ) {
	name(fd,"DATE");
	name(fd,linbuf);
	return(1);
	}
return(0);
}


/*********************************************************/
/* gets and forms from fields */
from()
{
long	savadr;
int	count;

name(fd,"FROM");
putstr(STDOUT,"from:\n",NULL);
savadr = list(fd);
count = getmblst();
endlist(fd, savadr,count);
return(1);
}

/*********************************************************/
/* gets and forms mail box list */
getmblst()
{
long	savadr;
int	n = 0;
int	count = 0;

for (getstr("  user:",linbuf); *linbuf ; getstr("  user:",linbuf) ) {
	n =+ 1;
	savadr = proplist(fd);

	if ( *linbuf ){
		name(fd,"USER");
		name(fd,linbuf);
		count += 1;
		}

	getstr("  host:",linbuf);
	if ( *linbuf ){
		name(fd,"HOST");
		name(fd,linbuf);
		count += 1;
		}


	getstr("  person:",linbuf);
	if ( *linbuf ){
		name(fd,"PERSON");
		name(fd,linbuf);
		count += 1;
		}
	endplist(fd, savadr,count);
	}
return(n);
}
/*********************************************************/
/* constructs to field */
to()
{
long	savadr;
int	count = 0;

name(fd,"TO");
putstr(STDOUT,"to:\n",NULL);
savadr = list(fd);
count = getmblst();
endlist(fd, savadr,count);
return(1);
}

/*********************************************************/
/* constructs cc field */
cc()
{
long	savadr;
int	count;

name(fd,"CC");
putstr(STDOUT,"cc:\n",NULL);
savadr = list(fd);
count = getmblst();
endlist(fd, savadr,count);
return(1);
}

/*********************************************************/
/* constructs subject field */
subject()
{
long	savadr;

getstr("subject",linbuf);
if ( *linbuf ) {
	name(fd,"SUBJECT:");
	savadr = text(fd);
	dwrite(fd,linbuf,lenstr(linbuf));
	endtext(fd,savadr);
	}
return(1);
}


/*********************************************************/
/* constructs text segment */
texseg(node)
TREEPTR node;
{
int	count2 = 0;
int	n;
long	savadr1,savadr2,savadr3;
FILE	fdi;

name(fd,"TEXT");
savadr1 = proplist(fd);

name(fd,"PROTOCOL");
name(fd,"PARAGRAPH");

name(fd,"VERSION");
index(fd,1);

name(fd,"DATA");

savadr2 = list(fd);

for (node = node->lptr; node ; node = node->rptr){
	count2 += 1;
	savadr3 = text(fd);
	if ( (fdi = dopen(node->filnam,0,1)) < 0) {
		putstr(STDERR,opnerr,node->filnam,NULL);
		return(NULL);
		}
	dlseek(fdi,node->filptr,SEEKABS);
	for(n = node->segxsiz;n > 0; n -= 80){
		if (n >= 80) {
			dread(fdi,linbuf,80);
			dwrite(fd,linbuf,80);
			}
		else {
			dread(fdi,linbuf,n);
			dwrite(fd,linbuf,n);
			}
		}
	dclose(fdi);
	endtext(fd,savadr3);
	}
endlist(fd, savadr2,count2);
endplist(fd, savadr1,3);
}
	
/*********************************************************/
/* constructs image segment */
faxseg(node)
TREEPTR node;
{
long	savadr;

name(fd,"IMAGE");
savadr = proplist(fd);

name(fd,"PROTOCOL");
name(fd,"COMSAT");

name(fd,"VERSION");
index(fd,1);

name(fd,"DATA");
segment(node);

endplist(fd, savadr,3);
}


/*********************************************************/
/* constructs segment of image as data of faxseg ( ??) */
segment(node)
TREEPTR node;

{
long savadr ;
int	count = 0;

savadr = proplist(fd);
count += ident(node);
count += descriptor(node);
count += data(node);
count += seglist(node);
endplist(fd,savadr,count);
}

/*********************************************************/
/* contructs ident field */
ident(node)
TREEPTR node;

{
long	savadr;

if (node -> id > 0) {
	name(fd,"ID");

	savadr = proplist(fd);
	name(fd,"IDENT");
	index(fd,node->id);
	endplist(fd,savadr,1);
	return(1);
	}
return(0);
}

/*********************************************************/
/* contructs descriptor field */
descriptor(node)
TREEPTR node;

{
long	savadr;
int	count = 0;

name(fd,"DESCRIPTOR");

savadr = proplist(fd);
count += size(node);
count += resolut(node);
count += palette(node);
count += position(node);
count += algorithm(node);
count += tolerance(node);

if (format == 0) {
	count += start(node);
	count += mag(node);
	}
endplist(fd,savadr,count);
return(1);

}

/*********************************************************/
/* contructs size field */
size(node)
TREEPTR node;

{
long	savadr;
int	count = 0;

if (node->segxsiz > 0 || node ->segysiz  > 0){
	name(fd,"SIZE");

	savadr = proplist(fd);
	if (node ->segxsiz > 0){
		name(fd,"XPELS");
		integer(fd, (long) node->segxsiz);
		count += 1;
		}
	if (node ->segysiz > 0){
		name(fd,"YPELS");
		integer(fd,(long) node->segysiz);
		count += 1;
		}
	endplist(fd,savadr,count);
	return(1);
	}
return(0);
}

/*********************************************************/
resolut(node)
TREEPTR node;

{
long	savadr;
int	count = 0;

if (node->resx > 0 || node ->resy > 0){
	name(fd,"RESOLUTION");

	savadr = proplist(fd);
	if (node ->resx > 0){
		name(fd,"XPELS");
		integer(fd,(long) node->resx);
		name(fd,"XMM");
		integer(fd,(long) node->resxmm);
		count += 2;
		}
	if (node ->resy > 0){
		name(fd,"YPELS");
		integer(fd,(long) node->resy);
		name(fd,"YMM");
		integer(fd,(long) node->resymm);
		count += 2;
		}
	endplist(fd,savadr,count);
	return(1);
	}
return(0);
}

/*********************************************************/
palette(node)
TREEPTR node;

{
return(0);
}

/*********************************************************/
position(node)
TREEPTR node;

{
FAST	TREEPTR parnode;
int	x,y;
long savadr;
int	count = 0;

x = 0;
y = 0;
if ((parnode=node->upptr) != mtop ) {
	x = sizmap(node->scrxpos - parnode->scrxpos,SCRXRES,SCRXMM,
		parnode->resx,parnode->resxmm);
	y = sizmap(node->scrypos - parnode->scrypos,SCRYRES,SCRYMM,
		parnode->resy,parnode->resymm);
	}

if (x > 0 || y > 0){
	name(fd,"POSITION");

	savadr = proplist(fd);
	if (x > 0){
		name(fd,"X");
		integer(fd,(long)x);
		count += 1;
		}
	if (y > 0){
		name(fd,"Y");
		integer(fd,(long)y);
		count += 1;
		}
	endplist(fd,savadr,count);
	return(1);
	}
return(0);
}


/*********************************************************/
algorithm(node)
TREEPTR node;

{
long	savadr;

if (node->alg >= ALGBITMAP){
	name(fd,"ALGORITHM");

	savadr = proplist(fd);
	name(fd,"NAME");
	if (format == 0) name(fd,algnam[1]);
	else	name(fd,algnam[0]);
	endplist(fd,savadr,1);
	return(1);
	}
return(0);
}

/*********************************************************/
tolerance(node)
TREEPTR node;

{
return(0);
}

/*********************************************************/
start(node)
TREEPTR node;

{
long	savadr;
int 	count = 0;

if (node->startx > 0 || node ->starty > 0){
	name(fd,"START");

	savadr = proplist(fd);
	if (node ->startx > 0){
		name(fd,"X");
		index(fd,node->startx);
		count += 1;
		}
	if (node ->starty > 0){
		name(fd,"Y");
		index(fd,node->starty);
		count += 1;
		}
	endplist(fd,savadr,count);
	return(1);
	}
return(0);
}

/*********************************************************/
mag(node)
TREEPTR node;

{
long	savadr;
int	count = 0;
int	x,xb,y,yb;

gactmag(node,&x,&xb,&y,&yb);
if (x != 1 || y != 1 || xb != 1	|| yb != 1){
	name(fd,"MAG");

	savadr = proplist(fd);
	if (x != 1 ){
		name(fd,"MAGX");
		index(fd,x);
		count += 1;
		}
	if (xb != 1 ){
		name(fd,"MAGXBAS");
		index(fd,xb);
		count += 1;
		}
	if (y != 1 ){
		name(fd,"MAGY");
		index(fd,y);
		count += 1;
		}
	if (yb != 1 ){
		name(fd,"MAGYBAS");
		index(fd,yb);
		count += 1;
		}
	endplist(fd,savadr,count);
	return(1);
	}
return(0);
}



/*********************************************************/
data(node)
TREEPTR node;

{
long	savadr;

if (node->dataflag == 0) return(0);
name(fd,"DATA");
if (format == 0) name(fd,node->filnam);
else if (format == 1){
	savadr = bitstr(fd);
	intimg(fd,node->segxsiz,node->segysiz);
	dlseek(fd,savadr,SEEKABS);
	putseg(node);
	endbitstr(fd,savadr);
	}
else 	return(0);
return(1);

}

/*********************************************************/
seglist(node)
TREEPTR node;
{
long	savadr;
int	count = 0;

if (node->lptr ) {
	name(fd,"SEGLIST");

	savadr = list(fd);
	for (node=node->lptr;node; node=node->rptr){
		count += 1;
		segment(node);
		}
	endlist(fd,savadr,count);
	return(1);
	}
return(0);
}
                                                                                                                                                                                                                                                                                                                                                                                                                                              