/*********************************************************/
#include	<std.h>
#include	<rt11.h>

/*********************************************************/
typedef	TEXT	*TEXTPTR;

/*********************************************************/
/**** entry points */
int	putdec(),getdec(),putldec();
TEXTPTR	getstr(),concat(),append();
TEXTPTR	itob1(),itob2(),ltob3(),ltob4();
int	b1toi(),b2toi();
long	b3tol(),b4tol();
int	ovlap(),hcf(),xchange();
int	lsttab(),srchtab();

/*********************************************************/
/* This file contains a number of utility C programs
of general use */

/*********************************************************/
/* prints prompt on TTY and gets input string into buff. 
All characters are converted to upper case.
returns pointer to first non blank char. in buff */

TEXTPTR
getstr(prompt,buff)
TEXTPTR	prompt,buff;

{
FAST	TEXTPTR	s;

putstr(STDOUT,prompt,NULL);
buff[getlin(buff,79) - 1] = NULL;
for (s=buff; *s ; ++s ) *s = toupper(*s);
while ( *buff++ == ' ');
return(--buff);

}	/* of getstr */

/*********************************************************/
/* prints out decimal value of n; follows it by printing
the string s */

putdec(n,s)
TEXT	*s;
int	n;

{
TEXT	junk[10] ;
junk[itob(junk,n,-10)]=NULL;
putstr(STDOUT,junk,s,NULL);
}

/*********************************************************/
/* prints out decimal value of long n; follows it by printing
the string s */

putldec(n,s)
TEXT	*s;
long	n;
{
TEXT	junk[10] ;

junk[ltob(junk,n,-10)]=NULL;
putstr(STDOUT,junk,s,NULL);
}

/***********************************************************/
/* gets string from TTY and returns decimal value.
s is a prompt string */

getdec(s)
TEXT	*s;
{
int n;
TEXT	junk[10] ;

getstr(s,junk);
if ( !(*junk) ) return(0);
btoi(junk,10,&n,10);
return(n);
}

/*********************************************************/
/* The following are routines to convert integers in various sizes 
and formats ( BE - Big Endian, SE - Small Endian ) from one
format to another */

/*********************************************************/
/* converts 1 byte number(BE) pointed to by s to 2 byte integer (SE) */

b1toi(s)
FAST	TEXT	*s;
{
int	n;
FAST	TEXT	*a;

a = &n;
*a++ = *s;
*a = NULL;
return(n);
}

/*********************************************************/
/* converts 2 byte integer n(SE) to 1 byte(BE) and
stores it in buffer s */

TEXT	*itob1(n,s)
int	n;
FAST	TEXT	*s;
{
FAST	TEXT	*a;

a = &n;
*s = *a;
return(s);
}

/*********************************************************/
/* converts 3 byte number at s(BE) to long(SE) */

long	b3tol(s)
FAST	TEXT	*s;
{
FAST	TEXT	*a;
long	n;

a = &n;
*++a = NULL;
*--a = *s++;

a += 2;
*++a = *s++;
*--a = *s++;
return(n);
}

/*********************************************************/
/* long (SE) to 3 bytes (BE) */

TEXT	*ltob3(n,s)
long	n;
FAST	TEXT	*s;

{
FAST	TEXT	*a;

a = &n;
*s++ = *a;

a += 2;
*s++ = *++a;
*s = *--a;
return(s-2);
}

/*********************************************************/
/* 4 byte number (BE) to long (SE) */

long	b4tol(s)
FAST	TEXT	*s;
{
FAST	TEXT	*a;
long	n;

a = &n;
*++a = *s++;
*--a = *s++;

a += 2;
*++a = *s++;
*--a = *s++;
return(n);
}

/*********************************************************/
/* long (SE) to 4 byte number (BE) */

TEXT	*ltob4(n,s)
long	n;
FAST	TEXT	*s;

{
FAST	TEXT	*a;

a = &n;
*s++ = *++a;
*s++ = *--a;

a += 2;
*s++ = *++a;
*s = *--a;
return(s-3);
}


/*********************************************************/
/* 2 byte number (BE ) to integer (SE) */
b2toi(s)
FAST	TEXT	*s;
{
int	n;
FAST	TEXT	*a;

a = &n;
*++a = *s++;
*--a = *s;
return(n);
}

/*********************************************************/
/* integer (SE) to 2 byte number (BE)*/
TEXT	*itob2(n,s)
int	n;
FAST	TEXT	*s;

{
FAST	TEXT	*a;

a = &n;
*s++ = *++a;
*s = *--a;
return(s-1);
}

/*********************************************************/
/* finds out intersection of the two rectangles (x1,y1,dx1,dx2) 
and (x2,y2,dx2,dy2) and returns result in ( *ox, *oy, *dx, *dy ).
returns 0 if NULL intersection; 1 otherwise */

ovlap(x1,y1,dx1,dy1,x2,y2,dx2,dy2,ox,oy,dx,dy)
int	x1,y1,x2,y2,dx1,dy1,dx2,dy2;
int	*dx,*dy,*ox,*oy;
{
if (x2 > x1) {			/* make sure x1 > x2 */
	xchange(&x1,&x2);
	xchange(&dx1,&dx2);
	}
if (y2 > y1) {			/* make sure y1 > y2 */
	xchange(&y1,&y2);
	xchange(&dy1,&dy2);
	}
*ox=x1;
*oy=y1;

if ( (*dx=min(dx2-(x1-x2),dx1) ) <= 0 ) return(-1);
if ( (*dy=min(dy2-(y1-y2),dy1) ) <= 0 ) return(-1);
return(1);

}  	/* of ovlap */


/*********************************************************/
/* exchanges two integers */

xchange(a,b)
FAST	int	*a,*b;

{
FAST	int	t;
t  = *a;
*a = *b;
*b =  t;
}	/* of xchange */


/****************************************************/
/* prints table of strings */
/* prints 5 items per line, each item in a 12 char field */

lsttab(tab,maxitem)
TEXT	*tab[];
int	maxitem;

{
FAST	int	i,j;
TEXT	junk[10];

i = 0;
while ( i < maxitem) {
	for ( j = 0; ( i < maxitem ) && (j < 5) ; j++,i++) 
		putstr(STDOUT,tab[i],flblank(12-lenstr(tab[i]),junk),NULL);
	putstr(STDOUT,"\n",NULL);
	}
}

/*********************************************************/
/*  inserts n blanks in buff */
/* returns buff itself */
flblank(n,buff)
TEXT	buff[];
int	n;

{
TEXT	*s;

for ( s = buff ; n-- > 0 ; *s++ = ' ');
*s++ = NULL;
return(buff);
}


/*********************************************************/
/* searches table of strings tab having maxitem items
for string srcstr. A successful match is one when the srcstr
matches a prefix of a string in the table.
Returns index of string matched if successful, maxitem if 
non successful and maxitem+1 if > 1 matches found.
Table strings should be upper case. scrstr is converted to upper 
case before search and blanks are ignored. */

srchtab(tab,maxitem,srcstr)
TEXT	*tab[];
int	maxitem;
TEXT	*srcstr;

{
FAST	int	i,j;
FAST	TEXT	*s;
int	n;

n=squeeze(srcstr,lenstr(srcstr),' ');	/* delete blanks from scrstr */
srcstr[n]=NULL;
for (s = srcstr; *s ; ++s) *s = toupper(*s); /* convert scrstr to uppercase */

for ( i=0; (i < maxitem) && (!cmpbuf(srcstr,tab[i],n) ); i++) ;

if(i < maxitem ) {		/* found a match; look for another */
	for ( j=i+1; (j < maxitem) && (!cmpbuf(srcstr,tab[j],n) ); j++) ;
	if(j < maxitem) return(maxitem+1);	/* second match found */
	}

return(i);

} 	/* of srchtab */


/*********************************************************/
/* sorts table of strings tab1, containing maxitem items.
tab2 is also sortd correspondingly. Uses bubble sort */

sorttab(tab1,tab2,maxitem)
TEXT	*tab1[];
int	*tab2[];
int	maxitem;

{
FAST	int	i,j;

for (i=maxitem-1; i > 1 ; i--)
	for (j = 0; j < i; j++)
		if ( strcom(tab1[j],tab1[j+1]) > 0 ) {
			xchange(&tab1[j],&tab1[j+1]);
			xchange(&tab2[j],&tab2[j+1]);
			};
}
	
/*********************************************************/
/* compares two strings s1 and s2.
returns  1 if s1 > s2
        -1 if s1 < s2
	 0 if s1 = s2	*/

strcom(s1,s2)
FAST	TEXT	*s1,*s2;

{
for ( ; *s1 && *s2 ; s1++,s2++){
	if (*s1 > *s2 ) return(1);
	if (*s1 < *s2 ) return(-1);
	}
if ( !*s1 && !*s2 ) return(0);
if ( *s1 ) return (1);
return (-1);
}




/***********************************************************/
/* returns highest common factor of x and y */
hcf(x,y)
FAST	int x,y;
{
if ( (x <= 0) || (y <= 0) ) {
	putstr(STDOUT,"negative mag factors ???\n",NULL);
	return(1);
	}
while ( x != y ) {
	if (x > y) x -= y;	/* hcf(x,y) = hcf(x-y,y) */
	else y -= x;		/* hcf(x,y) = hcf(x,y-x) */
	}
return(x);			/* hcf(x,x) = x */
}

/*************************************************/
/* reduces *n1 and *n2 such that their ratio is preserved 
approximately and both numbers end up <= 100 */

factor(n1,n2)
int	*n1,*n2;

{
int	h;

FOREVER {
	*n2 /= (h = hcf(*n1,*n2) );	/* delete common factors */
	if ( ( (*n1 /= h) < 101 ) && (*n2 < 101) ) break;
	*n1 >>= 1;			/* divide by 2 */
	*n2 >>= 1;
	}
}

/******************************************************/
/* concatenates upto 4 strings onto string ds */
/* returns pointer to last NULL char of result */

TEXTPTR	concat(ds,s1,s2,s3,s4)
TEXTPTR	ds,s1,s2,s3,s4;

{
FAST	TEXTPTR	d;

for (d = ds; *d ; d++);
if ( !s1 ) return(d);
d = append(d,s1);
if ( !s2 ) return(d);
d = append(d,s2);
if ( !s3 ) return(d);
d = append(d,s3);
if ( !s4 ) return(d);
d = append(d,s4);
return(d);
}

/*****************************************************/
/* appends string s to string at d.
Returns pointer to last (NULL) char. */

TEXTPTR	append(d,s)
FAST	TEXTPTR	d,s;
{
while ( *s ) *d++ = *s++ ;
*d = NULL;
return(d);
}

/***************************************************/
/* finds length in bytes of file fd. File better
be a text file because end of file is assumed to
be a zero byte. Uses Dread (from diolib) to read file.
If Clib's I/o is used, then file should be opened using open
and define dread as read */

fndflen(fd)
FILE	fd;
{
int	n ;
int	count = 0;
TEXT	buff[81];

while( 0 < ( n = dread(fd,buff,80) ) ){
	buff[n]=NULL;
	n = scnbuf(buff,81,NULL) ;
	count += n;
	if ( n < 80 ) break;		/* NULL found within chars. read */
	}
return(count);
}
                                                                                                                                                                                                                                                     