#include <stdlib.h>
#include <desktop/tt_c.h>
#include <xview/notify.h>
#include <xview/panel.h>

#include "altfontsel_tt.h"
#include "altfontsel_ui.h"

extern altfontsel_baseframe_objects	*Altfontsel_baseframe;


static Tt_message replymsg;


static Notify_value processToolTalkMessage(Notify_client, Notify_event, Notify_arg,
					   Notify_event_type);

/* RealFontNames[] was moved outside the function ReplyToMessage so that
   it would be available from the processToolTalkMessage function. A
   NULL was also added to be able to detect the end of the list. */
static const char *RealFontNames[] = {
		"-*-courier-medium-r-*-*-12-*-*-*-*-*-*-*",
		"-*-helvetica-medium-r-*-*-12-*-*-*-*-*-*-*",
		"-*-lucida bright-medium-i-*-*-12-*-*-*-*-*-*-*",
		"-*-times-medium-r-*-*-14-*-*-*-*-*-*-*",
		"-*-zapfchancery-medium-i-*-*-18-*-*-*-*-*-*-*",
	        NULL};

void
initToolTalk(Notify_client client)
{
	Tt_status ttrc;
	int ttfd;
	int ttmark;
	char *procid;

	ttmark = tt_mark();
	procid = tt_open();
	ttfd = tt_fd();
	ttrc = tt_ptype_declare("altfontsel");
	ttrc = tt_session_join(tt_default_session());
	notify_set_input_func(client, processToolTalkMessage, ttfd);
	replymsg = 0;
	xv_set(Altfontsel_baseframe->ApplyButton, PANEL_INACTIVE, TRUE, 0);
	xv_set(Altfontsel_baseframe->CancelButton, PANEL_INACTIVE, TRUE,  0);
	tt_release(ttmark);
}
	

static Notify_value
processToolTalkMessage(Notify_client client,
		       Notify_event event,
		       Notify_arg arg,
		       Notify_event_type notifyeventtype)
{
	

	int ttmark;
	Tt_message incoming;

	ttmark = tt_mark();

	incoming = tt_message_receive();

	/*
	 * It's possible that the file descriptor may become active but
	 * there's not actually a ToolTalk message for us.
	 */
	if (incoming == 0) return NOTIFY_DONE;

	if (0==strcmp(tt_message_op(incoming),"GetFontName")) {
	        char *requested_default_name;   /* will point to the requesting default */
		const char *name_ptr = NULL;    /* used to scan RealFontNames[] */
		int index = 0;                  /* used during scan of RealFontNames[] */

		/*
		 * This is the message we expected.  If we're already 
		 * busy, reject it. Otherwise activate the "apply" button.
		 */
		if (replymsg) {
			tt_message_reject(incoming);
			tt_message_destroy(incoming);
			tt_release(ttmark);
			return NOTIFY_DONE;
		}

		/* get ptr to desired default font name */
		requested_default_name = tt_message_arg_val(incoming,0);


		if (requested_default_name != NULL) /* we actually got a name */
		   {
		    /* set the selections - scan the font name list looking for match */
		    name_ptr = RealFontNames[0];
		    while (name_ptr != NULL)
		      if (strcmp(requested_default_name, name_ptr) == 0) /* we found it */
		         {xv_set(Altfontsel_baseframe->list1,             /* turn on */
			         PANEL_LIST_SELECT, index, TRUE, NULL);
		          break;
		          }
		      else 
		         {index++;
		          name_ptr = RealFontNames[index];
		         }
	           }

		/* if we didn't get a name, or it was a name we didn't have, 
		   just select the 0th item */
		if (name_ptr == NULL) 
		  xv_set(Altfontsel_baseframe->list1, PANEL_LIST_SELECT, 0, TRUE, NULL);	  

		xv_set(Altfontsel_baseframe->ApplyButton,
		       PANEL_INACTIVE, FALSE,
		       0);
		xv_set(Altfontsel_baseframe->CancelButton,
		       PANEL_INACTIVE, FALSE,
		       0);
		replymsg = incoming;
		tt_release(ttmark);
		return NOTIFY_DONE;
	}

	/*
         * This is not a message we recognize.
	 * If it's a request, or a notice that caused us to start, fail it.
	 */

	if (tt_message_class(incoming) == TT_REQUEST ||
	    tt_message_status(incoming) == TT_WRN_START_MESSAGE) {
		tt_message_fail(incoming);
	}
	tt_message_destroy(incoming);
	tt_release(ttmark);

	return NOTIFY_DONE;

}

/*
 * Called when the Apply or Cancel  button is pressed.  Replies to the outstanding
 * message and turn off the Apply and Cancelbutton.
 */

/* ARGSUSED */
void ReplyToMessage(int cancel)
{	
	int x;

	if (cancel) {
		tt_message_fail(replymsg);
	} else {
		const char *fontname;
		x = (int)xv_get(Altfontsel_baseframe->list1,
				PANEL_LIST_FIRST_SELECTED);

		fontname = RealFontNames[x];

		tt_message_arg_val_set(replymsg, 0, fontname);
		tt_message_reply(replymsg);
	}
	tt_message_destroy(replymsg);
	replymsg = 0;
	xv_set(Altfontsel_baseframe->ApplyButton, PANEL_INACTIVE, TRUE, 0);
	xv_set(Altfontsel_baseframe->CancelButton, PANEL_INACTIVE, TRUE,  0);
}
