/* ================================================================================
   tt_error_notify.h   --  Debug support for notification of ToolTalk Errors.  

   This file defines macros TT_SERR_NOTIFY, TT_PERR_NOTIFY and TT_IERR_NOTIFY, (for 
   use with ToolTalk functions that return Tt_status, char* and int respectively).  
   These macros can be used to cause printing of ToolTalk error messages to stderr,
   including the source filename and line number where the error occurred.

   When DEBUG is #defined:
   The macros expand into calls to functions that print ToolTalk error messages 
   (per tt_status_message()) to stderr, including the source file name and line 
   number where the error occured.  These functions then return the macro's 
   argument.

   When DEBUG is not #defined:
   The Macros simply expand into their argument, so there's no runtime overhead.

   Example use:
   msg_in = TT_PERR_NOTIFY(tt_message_receive()); 

 ================================================================================ */

#ifndef _TT_ERROR_SUPPORT_
#define _TT_ERROR_SUPPORT_

#ifdef DEBUG

extern Tt_status _tt_serr_notify();
extern void*     _tt_perr_notify();
extern int       _tt_ierr_notify();

#define TT_SERR_NOTIFY(status) _tt_serr_notify(status, __FILE__, __LINE__)
#define TT_PERR_NOTIFY(ptr)    _tt_perr_notify(ptr,    __FILE__, __LINE__)
#define TT_IERR_NOTIFY(i)      _tt_ierr_notify(i,      __FILE__, __LINE__)

#else

#define TT_SERR_NOTIFY(status)  status
#define TT_PERR_NOTIFY(ptr)     ptr
#define TT_IERR_NOTIFY(i)       i

#endif

#endif
