/* ================================================================================
   tt_error_notify.c   --  Debug support for notification of ToolTalk Errors.

   When DEBUG is #defined:
   This file defines functions (used by macros TT_SERR_NOTIFY, TT_PERR_NOTIFY and 
   TT_IERR_NOTIFY) that print ToolTalk error messages (per tt_status_message()) to 
   stderr, including the source file name and line number where the error occured.  
   These functions return their first argument.

   When DEBUG is not #defined:
   No functions are defined

 ================================================================================ */

#ifdef DEBUG

#include <stdio.h>
#include <desktop/tt_c.h>


Tt_status _tt_serr_notify(status, src_file, line_no) 
          Tt_status status;  char* src_file;  int line_no;
{if (status != TT_OK)
     {fprintf(stderr, "ToolTalk Error: %s\n        Origin: Source File %s Line %d\n",
            tt_status_message(status), src_file, line_no);
     }
 return status;
}


void* _tt_perr_notify(ptr, src_file, line_no) 
      void* ptr; char* src_file;  int line_no;
{_tt_serr_notify(tt_ptr_error(ptr), src_file, line_no); 
 return ptr;
}


int _tt_ierr_notify(i, src_file, line_no) 
    int i; char* src_file;  int line_no; 
{_tt_serr_notify(tt_int_error(i), src_file, line_no); 
 return i;
}

#endif
