/* ================================================================================
   send_up_case - sends a Request message to the default session, with 
   Address = TT_PROCEDURE, op = UpperCase, Scope = TT_SESSION, 
   an 'added' argument with mode TT_INOUT, and a value being the
   argument passed on the command line.
   It then prints the result of a reply to the message and exits.
   ================================================================================ */

/* xview only used here for easy notification of incoming messages */
#include <xview/xview.h>
Xv_opaque base_frame;  /* xview handle */

/* include the tooltalk API header file */
#include <desktop/tt_c.h>

/* include Debug support for notification of ToolTalk Errors. */
#include "tt_error_notify.h"


/* ================================================================================ */
/* When a ToolTalk message is available, receive it - Note the callback does all the 
   work, but we still need to call tt_message_receive to make callback get invoked */

void receive_tt_message()
{
 Tt_message msg_in;              /* holds handle to message  */

 TT_PERR_NOTIFY(msg_in = tt_message_receive());      /* get a handle to the message */

 if (msg_in != NULL)
 { /* should never get this because the callback should have taken care of things,
    but I like to be informed if something unusual has happened. */
  fprintf(stderr, "Warning: receive_tt_message() got a message \
                   that it shouldn't have gotten!\n");
 }

 return;
}

/* ================================================================================
   This function gets called whenever our message undergoes a state change          */

Tt_callback_action ShowUpperCaseReply(msg, pat)
     Tt_message msg; Tt_pattern pat;

{char* result;

 switch(tt_message_state(msg)) 
  { case TT_CREATED:  printf("Message State = TT_CREATED\n");  break;

    case TT_QUEUED:   printf("Message State = TT_QUEUED\n");   break;

    case TT_STARTED:  printf("Message State = TT_STARTED\n");  break;

    case TT_SENT:     printf("Message State = TT_SENT\n");     break;

    case TT_HANDLED:  printf("Message State = TT_HANDLED\n");
                      printf("Reply is:\n\t%s\n", 
			    (result = tt_message_arg_val(msg, 0)) ? result : "NULL");
                      notify_post_destroy(base_frame, DESTROY_PROCESS_DEATH, NOTIFY_IMMEDIATE);
                      break;

    case TT_FAILED:   printf("Message State = TT_FAILED\n");
                      notify_post_destroy(base_frame, DESTROY_PROCESS_DEATH, NOTIFY_IMMEDIATE);
                      break;

    case TT_REJECTED: printf("Message State = TT_REJECTED\n");
                      notify_post_destroy(base_frame, DESTROY_PROCESS_DEATH, NOTIFY_IMMEDIATE);
                      break;
  };

  /* Destroy the handle */
  TT_SERR_NOTIFY(tt_message_destroy(msg));

  return TT_CALLBACK_PROCESSED;
}




/* ================================================================================ */

void main(argc, argv)
     int argc;  char **argv;

{Tt_message msg_out;
 char *my_procid;
 int my_fd;

 xv_init(XV_INIT_ARGC_PTR_ARGV, &argc, argv, 0);       /* initialize XView */

if (argc != 2)       /* check for 1 arg - the string to be upper cased */
   {printf("\nUsage: send_up_case 'string to be upper cased'\n");
    exit (-1);}

 base_frame = xv_create(NULL, FRAME, XV_SHOW, FALSE, NULL); /* base xview frame */

 TT_PERR_NOTIFY(my_procid = tt_open());  /* Initialize ToolTalk */

 TT_IERR_NOTIFY(my_fd = tt_fd());  /* set fd that activates when message arrives */

 /* Tell XView to call receive_tt_message when msg_fd becomes active */
 notify_set_input_func(base_frame, (Notify_func)receive_tt_message, my_fd);

 /* Create and send ToolTalk msg.  */
  msg_out = tt_prequest_create(TT_SESSION, "UpperCase");
  TT_SERR_NOTIFY(tt_message_arg_add(msg_out, TT_INOUT, "mystring", argv[1]));
  TT_SERR_NOTIFY(tt_message_callback_add(msg_out, ShowUpperCaseReply)); 
  TT_SERR_NOTIFY(tt_message_send(msg_out));

  xv_main_loop(base_frame);               /* enter XView notifier     */

  /* Destroy the handle */
  TT_SERR_NOTIFY(tt_message_destroy(msg_out));

}

	    
