/*
 * $Id: globals.h,v 1.37 1995/10/29 10:45:46 coleman Exp coleman $
 *
 * globals.h - global variables for zsh
 *
 * This file is part of zsh, the Z shell.
 *
 * Copyright (c) 1992-1995 Paul Falstad
 * All rights reserved.
 *
 * Permission is hereby granted, without written agreement and without
 * license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that the
 * above copyright notice and the following two paragraphs appear in
 * all copies of this software.
 *
 * In no event shall Paul Falstad or the Zsh Development Group be liable
 * to any party for direct, indirect, special, incidental, or consequential
 * damages arising out of the use of this software and its documentation,
 * even if Paul Falstad and the Zsh Development Group have been advised of
 * the possibility of such damage.
 *
 * Paul Falstad and the Zsh Development Group specifically disclaim any
 * warranties, including, but not limited to, the implied warranties of
 * merchantability and fitness for a particular purpose.  The software
 * provided hereunder is on an "as is" basis, and Paul Falstad and the
 * Zsh Development Group have no obligation to provide maintenance,
 * support, updates, enhancements, or modifications.
 *
 */


/* GLOBALS is defined is init.c, so the global variables *
 * are actually contained in init.c, and are externs in  *
 * the other source files.                               */

#ifdef GLOBALS
# define EXTERN
#else
# define EXTERN extern
#endif
 
#ifdef GLOBALS
int redirtab[TRINANG - OUTANG + 1] =
{
    WRITE,
    WRITENOW,
    APP,
    APPNOW,
    READ,
    HEREDOC,
    HEREDOCDASH,
    MERGE,
    MERGEOUT,
    MERGEOUTNOW,
    ERRAPP,
    ERRAPPNOW,
    HERESTR,
};
#else
extern int redirtab[TRINANG - OUTANG + 1];
#endif

#ifdef GLOBALS
char nulstring[] = {Nularg, '\0'};
int  nulstrlen   = sizeof(nulstring) - 1;
#else
extern char nulstring[];
extern int  nulstrlen;
#endif

/* buffered shell input for non-interactive shells */
 
EXTERN FILE *bshin;
 
/* NULL-terminated arrays containing path, cdpath, etc. */
 
EXTERN char **path, **cdpath, **fpath, **watch, **mailpath;
EXTERN char **manpath, **tildedirs, **fignore;
EXTERN char **psvar;
 
/* array of named directories, and a flag indicating *
 * whether or not it's had the usernames added to it */

EXTERN struct nameddir *namdirs;

#ifdef CACHE_USERNAMES
EXTERN int usernamescached;
#endif /* CACH_USERNAMES */
 
/* size of userdirs[], # of userdirs */
 
EXTERN int userdirsz, userdirct;
 
EXTERN char *mailfile;
 
EXTERN char *yytext;

/* used to suppress ERREXIT and  *
 * trapping of SIGZERR, SIGEXIT. */

EXTERN int noerrexit;
 
/* error/break flag */
 
EXTERN int errflag;
 
/* Status of return from a trap */
 
EXTERN int trapreturn;
 
EXTERN char *tokstr;
EXTERN int tok, tokfd;
 
/* lexical analyzer error flag */
 
EXTERN int lexstop;
 
/* suppress error messages */
 
EXTERN int noerrs;
 
/* nonzero means we are not evaluating, just parsing (in math.c) */
 
EXTERN int noeval;
 
/* current history event number */
 
EXTERN int curhist;
 
/* if != 0, we are expanding the current line */

EXTERN int expanding;

/* these are used to modify the cursor position during expansion */

EXTERN int excs, exlast, exmax;

/* if != 0, this is the first line of the command */
 
EXTERN int isfirstln;
 
/* if != 0, this is the first char of the command (not including
        white space) */
 
EXTERN int isfirstch;

/* number of history entries */
 
EXTERN int histentct;
 
/* array of history entries */
 
EXTERN Histent histentarr;
 
/* capacity of history lists */
 
EXTERN int histsiz, lithistsiz;
 
/* if = 1, we have performed history substitution on the current line
        if = 2, we have used the 'p' modifier */
 
EXTERN int histdone;
 
/* default event (usually curhist-1, that is, "!!") */
 
EXTERN int defev;
 
/* != 0 if we are about to read a command word */
 
EXTERN int incmdpos;
 
/* != 0 if we are in the middle of a [[ ... ]] */
 
EXTERN int incond;
 
/* != 0 if we are after a redirection (for ctxtlex only) */
 
EXTERN int inredir;
 
/* != 0 if we are about to read a case pattern */
 
EXTERN int incasepat;
 
/* != 0 if we just read FUNCTION */
 
EXTERN int infunc;
 
/* != 0 if we just read a newline */
 
EXTERN int isnewlin;

/* the lists of history events */
 
EXTERN LinkList histlist, lithistlist;
 
/* the directory stack */
 
EXTERN LinkList dirstack;
 
/* the zle buffer stack */
 
EXTERN LinkList bufstack;

/* total # of characters waiting to be read. */

EXTERN int inbufct;

/* != 0 if this is a subshell */
 
EXTERN int subsh;
 
/* # of break levels */
 
EXTERN int breaks;
 
/* != 0 if we have a return pending */
 
EXTERN int retflag;
 
/* how far we've hashed the PATH so far */
 
EXTERN char **pathchecked;
 
/* # of nested loops we are in */
 
EXTERN int loops;
 
/* # of continue levels */
 
EXTERN int contflag;
 
/* the job we are working on */
 
EXTERN int thisjob;

/* the current job (+) */
 
EXTERN int curjob;
 
/* the previous job (-) */
 
EXTERN int prevjob;
 
/* hash table containing the aliases */
 
EXTERN HashTable aliastab;
 
/* hash table containing the reserved words */

EXTERN HashTable reswdtab;

/* hash table containing the parameters */
 
EXTERN HashTable paramtab;
 
/* hash table containing the external/hashed commands */
 
EXTERN HashTable cmdnamtab;

/* hash table containing the shell functions */

EXTERN HashTable shfunctab;

/* hash table containing builtin commands */

EXTERN HashTable builtintab;
 
/* hash table for completion info for commands */
 
EXTERN HashTable compctltab;

/* hash table for multi-character bindings */

EXTERN HashTable keybindtab;

/* hash table for emacs multi-character bindings */

EXTERN HashTable emkeybindtab;

/* hash table for vi multi-character bindings */

EXTERN HashTable vikeybindtab;
 
/* default completion infos */
 
EXTERN struct compctl cc_compos, cc_default, cc_first, cc_dummy;
 
/* the job table */
 
EXTERN struct job jobtab[MAXJOB];
 
/* shell timings */
 
EXTERN struct tms shtms;
 
/* the list of sched jobs pending */
 
EXTERN struct schedcmd *schedcmds;
 
/* the last l for s/l/r/ history substitution */
 
EXTERN char *hsubl;

/* the last r for s/l/r/ history substitution */
 
EXTERN char *hsubr;
 
/* We cache `USERNAME' and use check cached_uid *
 * so we know when to recompute it.             */

EXTERN uid_t cached_uid;
EXTERN char *cached_username;   /* $USERNAME   */
EXTERN char *login_name;	/* $LOGNAME    */
EXTERN char *zsh_name;		/* ZSH_NAME    */

EXTERN char *underscore;	/* $_          */
EXTERN long lastval;            /* $?          */
EXTERN pid_t mypid;		/* $$          */
EXTERN pid_t lastpid;		/* $!          */
EXTERN pid_t ppid;		/* $PPID       */
EXTERN char *ifs;		/* $IFS        */
EXTERN char *pwd;		/* $PWD        */
EXTERN char *oldpwd;		/* $OLDPWD     */

EXTERN long baud;               /* $BAUD       */
EXTERN long columns;            /* $COLUMNS    */
EXTERN long lines;              /* $LINES      */
EXTERN long reporttime;         /* $REPORTTIME */
EXTERN long mailcheck;          /* $MAILCHECK  */
EXTERN long logcheck;           /* $LOGCHECK   */

EXTERN char *zoptarg;		/* $OPTARG     */
EXTERN long zoptind;		/* $OPTIND     */
EXTERN char *prompt;		/* $PROMPT     */
EXTERN char *prompt2;		/* etc.        */
EXTERN char *prompt3;
EXTERN char *prompt4;
EXTERN char *rprompt;		/* $RPROMPT    */
EXTERN char *sprompt;

EXTERN char *timefmt;		/* $TIMEFMT    */
EXTERN char *watchfmt;		/* $WATCHFMT   */
EXTERN char *wordchars;
EXTERN char *fceditparam;
EXTERN char *tmpprefix;		/* $TMPPREFIX  */
EXTERN char *rstring, *Rstring;
EXTERN char *postedit;

EXTERN char *hostnam;           /* from gethostname */
EXTERN char *hostvar;           /* $HOST */
EXTERN char *home;              /* $HOME */
EXTERN char **pparams;          /* $argv */

EXTERN pid_t mypgrp;		/* the process group of the shell */
 
EXTERN char *argzero;           /* $0 */
 
EXTERN char *hackzero;

EXTERN long keytimeout;         /* $KEYTIMEOUT   */
EXTERN long lineno;             /* $LINENO       */
EXTERN long listmax;            /* $LISTMAX      */
EXTERN long savehist;           /* $SAVEHIST     */
EXTERN long shlvl;              /* $SHLVL        */
EXTERN long tmout;              /* $TMOUT        */
EXTERN long dirstacksize;       /* $DIRSTACKSIZE */
 
EXTERN long lastval2;

/* input fd from the coprocess */
 
EXTERN int coprocin;
 
/* output fd from the coprocess */
 
EXTERN int coprocout;
 
/* the last time we checked mail */
 
EXTERN time_t lastmailcheck;
 
/* the last time we checked the people in the WATCH variable */
 
EXTERN time_t lastwatch;
 
/* the last time we did the periodic() shell function */
 
EXTERN time_t lastperiod;
 
/* $SECONDS = time(NULL) - shtimer.tv_sec */
 
EXTERN struct timeval shtimer;
 
/* the default command for null commands */
 
EXTERN char *nullcmd;
EXTERN char *readnullcmd;
 
/* the List of local variables we have to destroy */
 
EXTERN LinkList locallist;

/* what level of localness we are at */
 
EXTERN int locallevel;
 
/* what level of sourcing we are at */
 
EXTERN int sourcelevel;
 
/* the shell input fd */
 
EXTERN int SHIN;
 
/* the shell tty fd */
 
EXTERN int SHTTY;

/* the FILE attached to the shell tty */

EXTERN FILE *shout;

/* the stack of aliases we are expanding */
 
EXTERN struct alias *alstack[MAXAL];
 
/* the alias stack pointer; also, the number of aliases currently
        being expanded */
 
EXTERN int alstackind;
 
/* != 0 means we are reading input from a string */
 
EXTERN int strin;
 
/* period between periodic() commands, in seconds */
 
EXTERN long period;
 
/* != 0 means history substitution is turned off */
 
EXTERN int stophist;
 
EXTERN int lithist;
 
/* this line began with a space, so junk it if HISTIGNORESPACE is on */
 
EXTERN int spaceflag;
 
/* don't do spelling correction */
 
EXTERN int nocorrect;

/* != 0 means we have removed the current event from the history List */
 
EXTERN int histremmed;
 
/* the options; e.g. if opts['a'] == OPT_SET, -a is turned on */
 
EXTERN char opts[OPT_SIZE];
 
EXTERN int lastbase;            /* last input base we used */
 
/* the limits for child processes */
 
#ifdef HAVE_GETRLIMIT
EXTERN struct rlimit limits[RLIM_NLIMITS];
#endif
 
/* the current word in the history List */
 
EXTERN char *hlastw;
 
/* pointer into the history line */
 
EXTERN char *hptr;
 
/* the current history line */
 
EXTERN char *chline;
 
/* the termcap buffer */
 
EXTERN char termbuf[1024];

/* text attribute mask */
 
#ifdef GLOBALS
unsigned txtattrmask = 0;
#else
extern unsigned txtattrmask;
#endif

/* text change - attribute change made by prompts */

EXTERN unsigned txtchange;

EXTERN char *term;		/* $TERM */
 
/* != 0 if this $TERM setup is usable */
 
EXTERN int termok;
 
/* flag for CSHNULLGLOB */
 
EXTERN int badcshglob;
 
/* max size of histline */
 
EXTERN int hlinesz;
 
/* the alias expansion status - if == ALSTAT_MORE, we just finished
        expanding an alias ending with a space */
 
EXTERN int alstat;
 
/* we have printed a 'you have stopped (running) jobs.' message */
 
EXTERN int stopmsg;
 
/* the default tty state */
 
EXTERN struct ttyinfo shttyinfo;
 
EXTERN char *ttystrname;	/* $TTY */
 
/* 1 if ttyctl -f has been executed */
 
EXTERN int ttyfrozen;
 
/* != 0 if we are allocating in the heaplist */
 
EXTERN int useheap;
 
/* Words on the command line, for use in completion */
 
EXTERN int clwsize, clwnum, clwpos;
EXTERN char **clwords;

/* pid of process undergoing 'process substitution' */
 
EXTERN pid_t cmdoutpid;
 
/* exit status of process undergoing 'process substitution' */
 
EXTERN int cmdoutval;
 
/* 1 if aliases should not be expanded */
 
EXTERN int noaliases;

#ifdef GLOBALS
/* signal names */
char **sigptr = sigs;
/* tokens */
char *ztokens = "#$^*()$=|{}[]`<>?~`,'\"\\";
#else
extern char *ztokens, **sigptr;
#endif

/* $histchars */
 
EXTERN unsigned char bangchar, hatchar, hashchar;
 
EXTERN int eofseen;
 
/* we are parsing a line sent to use by the editor */
 
EXTERN int zleparse;
 
EXTERN int wordbeg;
 
EXTERN int parbegin;
 
/* used in arrays of lists instead of NULL pointers */
 
EXTERN struct list dummy_list;

/* lengths of each string */
 
EXTERN int tclen[TC_COUNT];
 
EXTERN char *tcstr[TC_COUNT];
 
/* names of the strings we want */
#ifdef GLOBALS
char *tccapnams[TC_COUNT] =
{
    "cl", "le", "LE", "nd", "RI", "up", "UP", "do",
    "DO", "dc", "DC", "ic", "IC", "cd", "ce", "al", "dl", "ta",
    "md", "so", "us", "me", "se", "ue"
};
#else
extern char *tccapnams[TC_COUNT];
#endif

/* the command stack for use with %_ in prompts */
 
EXTERN unsigned char *cmdstack;
EXTERN int cmdsp;

#ifdef GLOBALS
char *cmdnames[] =
{
    "for",      "while",     "repeat",    "select",
    "until",    "if",        "then",      "else",
    "elif",     "math",      "cond",      "cmdor",
    "cmdand",   "pipe",      "errpipe",   "foreach",
    "case",     "function",  "subsh",     "cursh",
    "array",    "quote",     "dquote",    "bquote",
    "cmdsubst", "mathsubst", "elif-then", "heredoc",
    "heredocd",
};
#else
extern char *cmdnames[];
#endif
 
#ifndef GLOBALS
extern struct option optns[];
#else
struct option optns[] =
{
    {"allexport", ALLEXPORT},
    {"alwayslastprompt", ALWAYSLASTPROMPT},
    {"alwaystoend", ALWAYSTOEND},
    {"appendhistory", APPENDHISTORY},
    {"autocd", AUTOCD},
    {"autolist", AUTOLIST},
    {"automenu", AUTOMENU},
    {"autonamedirs", AUTONAMEDIRS},
    {"autoparamkeys", AUTOPARAMKEYS},
    {"autoparamslash", AUTOPARAMSLASH},
    {"autopushd", AUTOPUSHD},
    {"autoremoveslash", AUTOREMOVESLASH},
    {"autoresume", AUTORESUME},
    {"bgnice", BGNICE},
    {"braceccl", BRACECCL},
    {"bsdecho", BSDECHO},
    {"cdablevars", CDABLEVARS},
    {"chaselinks", CHASELINKS},
    {"completealiases", COMPLETEALIASES},
    {"completeinword", COMPLETEINWORD},
    {"correct", CORRECT},
    {"correctall", CORRECTALL},
    {"cshjunkiehistory", CSHJUNKIEHISTORY},
    {"cshjunkieloops", CSHJUNKIELOOPS},
    {"cshjunkieparen", CSHJUNKIEPAREN},
    {"cshjunkiequotes", CSHJUNKIEQUOTES},
    {"cshnullglob", CSHNULLGLOB},
    {"errexit", ERREXIT},
    {"extendedglob", EXTENDEDGLOB},
    {"extendedhistory", EXTENDEDHISTORY},
    {"globcomplete", GLOBCOMPLETE},
    {"globdots", GLOBDOTS},
    {"globsubst", GLOBSUBST},
    {"hashcmds", HASHCMDS},
    {"hashdirs", HASHDIRS},
    {"hashlistall", HASHLISTALL},
    {"histallowclobber", HISTALLOWCLOBBER},
    {"histignoredups", HISTIGNOREDUPS},
    {"histignorespace", HISTIGNORESPACE},
    {"histlit", HISTLIT},
    {"histnostore", HISTNOSTORE},
    {"histverify", HISTVERIFY},
    {"ignorebraces", IGNOREBRACES},
    {"ignoreeof", IGNOREEOF},
    {"interactive", INTERACTIVE},
    {"interactivecomments", INTERACTIVECOMMENTS},
    {"kshoptionprint", KSHOPTIONPRINT},
    {"listambiguous", LISTAMBIGUOUS},
    {"listtypes", LISTTYPES},
    {"localoptions", LOCALOPTIONS},
    {"login", LOGINSHELL},
    {"longlistjobs", LONGLISTJOBS},
    {"magicequalsubst", MAGICEQUALSUBST},
    {"mailwarning", MAILWARNING},
    {"markdirs", MARKDIRS},
    {"menucomplete", MENUCOMPLETE},
    {"monitor", MONITOR},
    {"nobadpattern", NOBADPATTERN},
    {"nobanghist", NOBANGHIST},
    {"nobeep", NOBEEP},
    {"noclobber", NOCLOBBER},
    {"noequals", NOEQUALS},
    {"noexec", NOEXEC},
    {"noflowcontrol", NOFLOWCONTROL},
    {"noglob", NOGLOBOPT},
    {"nohistbeep", NOHISTBEEP},
    {"nohup", NOHUP},
    {"nolistbeep", NOLISTBEEP},
    {"nonomatch", NONOMATCH},
    {"nopromptcr", NOPROMPTCR},
    {"norcs", NORCS},
    {"noshortloops", NOSHORTLOOPS},
    {"notify", NOTIFY},
    {"nounset", NOUNSET},
    {"nullglob", NULLGLOB},
    {"numericglobsort", NUMERICGLOBSORT},
    {"overstrike", OVERSTRIKE},
    {"pathdirs", PATHDIRS},
    {"printexitvalue", PRINTEXITVALUE},
    {"privileged", PRIVILEGED},
    {"promptsubst", PROMPTSUBST},
    {"pushdignoredups", PUSHDIGNOREDUPS},
    {"pushdminus", PUSHDMINUS},
    {"pushdsilent", PUSHDSILENT},
    {"pushdtohome", PUSHDTOHOME},
    {"rcexpandparam", RCEXPANDPARAM},
    {"rcquotes", RCQUOTES},
    {"recexact", RECEXACT},
    {"rmstarsilent", RMSTARSILENT},
    {"shinstdin", SHINSTDIN},
    {"shwordsplit", SHWORDSPLIT},
    {"singlelinezle", SINGLELINEZLE},
    {"sunkeyboardhack", SUNKEYBOARDHACK},
    {"verbose", VERBOSE},
    {"xtrace", XTRACE},
    {"zle", USEZLE},
    {NULL, 0}
};
#endif

EXTERN short int typtab[256];

