/*

	zle_bindings.c - commands and keymaps

	This file is part of zsh, the Z shell.

	zsh is free software; no one can prevent you from reading the source
   code, or giving it to someone else.

   This file is copyrighted under the GNU General Public License, which
   can be found in the file called COPYING.

   Copyright (C) 1990, 1991 Paul Falstad

   zsh is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY.  No author or distributor accepts
   responsibility to anyone for the consequences of using it or for
   whether it serves any particular purpose or works at all, unless he
   says so in writing.  Refer to the GNU General Public License
   for full details.

   Everyone is granted permission to copy, modify and redistribute
   zsh, but only under the conditions described in the GNU General Public
   License.   A copy of this license is supposed to have been given to you
   along with zsh so you can know your rights and responsibilities.
   It should be in a file named COPYING.

   Among other things, the copyright notice and this notice must be
   preserved on all copies.

*/

#define ZLE
#include "zsh.h"


struct zlecmd zlecmds[] = {
"accept-and-hold",acceptandhold,0,
"accept-and-infer-next-history",acceptandinfernexthistory,0,
"accept-and-menu-complete", acceptandmenucomplete, ZLE_MOD|ZLE_MENUCMP,
"accept-line",acceptline,0,
"accept-line-and-down-history",acceptlineanddownhistory,ZLE_MOD,
"backward-char",backwardchar,ZLE_MOVE,
"backward-delete-char",backwarddeletechar,ZLE_INSMOD,
"backward-delete-word",backwarddeleteword,ZLE_MOD,
"backward-kill-line",backwardkillline,ZLE_MOD|ZLE_KILL,
"backward-kill-word",backwardkillword,ZLE_MOD|ZLE_KILL,
"backward-word",backwardword,ZLE_MOVE,
"beginning-of-buffer-or-history",beginningofbufferorhistory,ZLE_LINEMOVE,
"beginning-of-history",beginningofhistory,ZLE_MOD,
"beginning-of-line",beginningofline,ZLE_MOVE,
"beginning-of-line-hist",beginningoflinehist,ZLE_LINEMOVE,
"capitalize-word",capitalizeword,ZLE_MOD,
"clear-screen",clearscreen,0,
"complete-word",completeword,ZLE_MOD|ZLE_MENUCMP,
"copy-prev-word",copyprevword,ZLE_MOD,
"copy-region-as-kill",copyregionaskill,ZLE_KILL,
"delete-char",deletechar,ZLE_INSMOD,
"delete-char-or-list",deletecharorlist,ZLE_INSMOD|ZLE_MENUCMP,
"delete-word",deleteword,ZLE_MOD,
"digit-argument",digitargument,ZLE_ARG,
"down-case-word",downcaseword,ZLE_MOD,
"down-history",downhistory,ZLE_MOD,
"down-line-or-history",downlineorhistory,ZLE_LINEMOVE2,
"end-of-buffer-or-history",endofbufferorhistory,ZLE_LINEMOVE,
"end-of-history",endofhistory,ZLE_MOD,
"end-of-line",endofline,ZLE_MOVE,
"end-of-line-hist",endoflinehist,ZLE_LINEMOVE,
"exchange-point-and-mark",exchangepointandmark,ZLE_MOVE,
"execute-last-named-cmd",NULL,0,
"execute-named-cmd",NULL,0,
"expand-history",expandhistory,ZLE_MOD,
"expand-or-complete",expandorcomplete,ZLE_MOD|ZLE_MENUCMP,
"expand-word",expandword,ZLE_MOD,
"forward-char",forwardchar,ZLE_MOVE,
"forward-word",forwardword,ZLE_MOVE,
"get-line",getline,ZLE_MOD,
"gosmacs-transpose-chars",gosmacstransposechars,ZLE_MOD,
"history-incremental-search-backward",historyincrementalsearchbackward,ZLE_MOD,
"history-incremental-search-forward",historyincrementalsearchforward,ZLE_MOD,
"history-search-backward",historysearchbackward,ZLE_MOD,
"history-search-forward",historysearchforward,ZLE_MOD,
"infer-next-history",infernexthistory,ZLE_MOD,
"insert-last-word",insertlastword,ZLE_MOD,
"kill-buffer",killbuffer,ZLE_MOD|ZLE_KILL,
"kill-line",killline,ZLE_MOD|ZLE_KILL,
"kill-region",killregion,ZLE_MOD|ZLE_KILL,
"kill-whole-line",killwholeline,ZLE_MOD|ZLE_KILL,
"list-choices",listchoices,0,
"list-expand",listexpand,ZLE_MENUCMP,
"magic-space",magicspace,ZLE_MOD,
"menu-complete",menucompleteword,ZLE_MENUCMP,
"menu-expand-or-complete",menuexpandorcomplete,ZLE_MENUCMP,
"overwrite-mode",overwritemode,0,
"push-line",pushline,ZLE_MOD,
"quoted-insert",quotedinsert,ZLE_INSMOD,
"quote-line",quoteline,ZLE_MOD,
"quote-region",quoteregion,ZLE_MOD,
"redisplay",redisplay,0,
"reverse-menu-complete",reversemenucomplete,ZLE_MENUCMP,
"run-help",processcmd,0,
"self-insert",selfinsert,ZLE_INSMOD,
"self-insert-unmeta",selfinsertunmeta,ZLE_INSMOD,
"send-break",sendbreak,0,
"send-string",sendstring,0,
"",NULL,0,
"set-mark-command",setmarkcommand,0,
"spell-word",spellword,ZLE_MOD,
"toggle-literal-history",toggleliteralhistory,ZLE_MOD,
"transpose-chars",transposechars,ZLE_MOD,
"transpose-words",transposewords,ZLE_MOD,
"undefined-key",undefinedkey,0,
"undo",undo,ZLE_UNDO,
"universal-argument",universalargument,ZLE_ARG,
"up-case-word",upcaseword,ZLE_MOD,
"up-history",uphistory,ZLE_MOD,
"up-line-or-history",uplineorhistory,ZLE_LINEMOVE2,
"vi-add-eol",viaddeol,0,
"vi-add-next",viaddnext,0,
"vi-caps-lock-panic",vicapslockpanic,0,
"vi-change",vichange,ZLE_MOD,
"vi-change-eol",vichangeeol,ZLE_MOD,
"vi-change-whole-line",vichangewholeline,ZLE_MOD,
"vi-cmd-mode",vicmdmode,0,
"vi-delete",videlete,ZLE_MOD,
"vi-digit-or-beginning-of-line",NULL,0,
"vi-fetch-history",vifetchhistory,ZLE_MOD,
"vi-find-next-char",vifindnextchar,ZLE_MOVE,
"vi-find-next-char-skip",vifindnextcharskip,ZLE_MOVE,
"vi-find-prev-char",vifindprevchar,ZLE_MOVE,
"vi-find-prev-char-skip",vifindprevcharskip,ZLE_MOVE,
"vi-first-non-blank",vifirstnonblank,ZLE_MOVE,
"vi-forward-word-end",viforwardwordend,ZLE_MOVE,
"vi-goto-column",vigotocolumn,ZLE_MOVE,
"vi-history-search-backward",vihistorysearchbackward,ZLE_MOD,
"vi-history-search-forward",vihistorysearchforward,ZLE_MOD,
"vi-insert",viinsert,0,
"vi-insert-bol",viinsertbol,0,
"vi-join",vijoin,ZLE_MOD,
"vi-match-bracket",vimatchbracket,ZLE_MOVE,
"vi-open-line-above",viopenlineabove,ZLE_MOD,
"vi-open-line-below",viopenlinebelow,ZLE_MOD,
"vi-oper-swap-case",vioperswapcase,ZLE_MOD,
"vi-put-after",viputafter,ZLE_MOD,
"vi-repeat-find",virepeatfind,ZLE_MOVE,
"vi-repeat-search",virepeatsearch,ZLE_MOD,
"vi-replace",vireplace,ZLE_MOD,
"vi-replace-chars",vireplacechars,ZLE_MOD,
"vi-rev-repeat-find",virevrepeatfind,ZLE_MOVE,
"vi-rev-repeat-search",virevrepeatsearch,ZLE_MOD,
"vi-swap-case",viswapcase,ZLE_MOD,
"vi-undo",undo,ZLE_MOD,
"vi-yank",viyank,0,
"vi-yank-eol",viyankeol,0,
"which-command",processcmd,0,
"yank",yank,ZLE_MOD|ZLE_YANK,
"yank-pop",yankpop,ZLE_MOD|ZLE_YANK,
"",NULL,0
};

int emacsbind[256] = {
/* ^@ */ z_setmarkcommand,
/* ^A */ z_beginningofline,
/* ^B */ z_backwardchar,
/* ^C */ z_sendbreak,
/* ^D */ z_deletecharorlist,
/* ^E */ z_endofline,
/* ^F */ z_forwardchar,
/* ^G */ z_undefinedkey,
/* ^H */ z_backwarddeletechar,
/* ^I */ z_expandorcomplete,
/* ^J */ z_acceptline,
/* ^K */ z_killline,
/* ^L */ z_clearscreen,
/* ^M */ z_acceptline,
/* ^N */ z_downlineorhistory,
/* ^O */ z_acceptlineanddownhistory,
/* ^P */ z_uplineorhistory,
/* ^Q */ z_pushline,
/* ^R */ z_historyincrementalsearchbackward,
/* ^S */ z_historyincrementalsearchforward,
/* ^T */ z_transposechars,
/* ^U */ z_killwholeline,
/* ^V */ z_quotedinsert,
/* ^W */ z_backwardkillword,
/* ^X */ z_sequenceleadin,
/* ^Y */ z_yank,
/* ^Z */ z_undefinedkey,
/* ^[ */ z_sequenceleadin,
/* ^\ */ z_undefinedkey,
/* ^] */ z_undefinedkey,
/* ^^ */ z_undefinedkey,
/* ^_ */ z_undo,
/*   */ z_selfinsert,
/* ! */ z_selfinsert,
/* " */ z_selfinsert,
/* # */ z_selfinsert,
/* $ */ z_selfinsert,
/* % */ z_selfinsert,
/* & */ z_selfinsert,
/* ' */ z_selfinsert,
/* ( */ z_selfinsert,
/* ) */ z_selfinsert,
/* * */ z_selfinsert,
/* + */ z_selfinsert,
/* , */ z_selfinsert,
/* - */ z_selfinsert,
/* . */ z_selfinsert,
/* / */ z_selfinsert,
/* 0 */ z_selfinsert,
/* 1 */ z_selfinsert,
/* 2 */ z_selfinsert,
/* 3 */ z_selfinsert,
/* 4 */ z_selfinsert,
/* 5 */ z_selfinsert,
/* 6 */ z_selfinsert,
/* 7 */ z_selfinsert,
/* 8 */ z_selfinsert,
/* 9 */ z_selfinsert,
/* : */ z_selfinsert,
/* ; */ z_selfinsert,
/* < */ z_selfinsert,
/* = */ z_selfinsert,
/* > */ z_selfinsert,
/* ? */ z_selfinsert,
/* @ */ z_selfinsert,
/* A */ z_selfinsert,
/* B */ z_selfinsert,
/* C */ z_selfinsert,
/* D */ z_selfinsert,
/* E */ z_selfinsert,
/* F */ z_selfinsert,
/* G */ z_selfinsert,
/* H */ z_selfinsert,
/* I */ z_selfinsert,
/* J */ z_selfinsert,
/* K */ z_selfinsert,
/* L */ z_selfinsert,
/* M */ z_selfinsert,
/* N */ z_selfinsert,
/* O */ z_selfinsert,
/* P */ z_selfinsert,
/* Q */ z_selfinsert,
/* R */ z_selfinsert,
/* S */ z_selfinsert,
/* T */ z_selfinsert,
/* U */ z_selfinsert,
/* V */ z_selfinsert,
/* W */ z_selfinsert,
/* X */ z_selfinsert,
/* Y */ z_selfinsert,
/* Z */ z_selfinsert,
/* [ */ z_selfinsert,
/* \ */ z_selfinsert,
/* ] */ z_selfinsert,
/* ^ */ z_selfinsert,
/* _ */ z_selfinsert,
/* ` */ z_selfinsert,
/* a */ z_selfinsert,
/* b */ z_selfinsert,
/* c */ z_selfinsert,
/* d */ z_selfinsert,
/* e */ z_selfinsert,
/* f */ z_selfinsert,
/* g */ z_selfinsert,
/* h */ z_selfinsert,
/* i */ z_selfinsert,
/* j */ z_selfinsert,
/* k */ z_selfinsert,
/* l */ z_selfinsert,
/* m */ z_selfinsert,
/* n */ z_selfinsert,
/* o */ z_selfinsert,
/* p */ z_selfinsert,
/* q */ z_selfinsert,
/* r */ z_selfinsert,
/* s */ z_selfinsert,
/* t */ z_selfinsert,
/* u */ z_selfinsert,
/* v */ z_selfinsert,
/* w */ z_selfinsert,
/* x */ z_selfinsert,
/* y */ z_selfinsert,
/* z */ z_selfinsert,
/* { */ z_selfinsert,
/* | */ z_selfinsert,
/* } */ z_selfinsert,
/* ~ */ z_selfinsert,
/* ^? */ z_backwarddeletechar,
/* M-^@ */ z_undefinedkey,
/* M-^A */ z_undefinedkey,
/* M-^B */ z_undefinedkey,
/* M-^C */ z_undefinedkey,
/* M-^D */ z_listchoices,
/* M-^E */ z_undefinedkey,
/* M-^F */ z_undefinedkey,
/* M-^G */ z_undefinedkey,
/* M-^H */ z_backwardkillword,
/* M-^I */ z_selfinsertunmeta,
/* M-^J */ z_selfinsertunmeta,
/* M-^K */ z_undefinedkey,
/* M-^L */ z_clearscreen,
/* M-^M */ z_selfinsertunmeta,
/* M-^N */ z_undefinedkey,
/* M-^O */ z_undefinedkey,
/* M-^P */ z_undefinedkey,
/* M-^Q */ z_undefinedkey,
/* M-^R */ z_undefinedkey,
/* M-^S */ z_undefinedkey,
/* M-^T */ z_undefinedkey,
/* M-^U */ z_undefinedkey,
/* M-^V */ z_undefinedkey,
/* M-^W */ z_undefinedkey,
/* M-^X */ z_undefinedkey,
/* M-^Y */ z_undefinedkey,
/* M-^Z */ z_undefinedkey,
/* M-^[ */ z_undefinedkey,
/* M-^\ */ z_undefinedkey,
/* M-^] */ z_undefinedkey,
/* M-^^ */ z_undefinedkey,
/* M-^_ */ z_copyprevword,
/* M-  */ z_expandhistory,
/* M-! */ z_expandhistory,
/* M-" */ z_quoteregion,
/* M-# */ z_undefinedkey,
/* M-$ */ z_spellword,
/* M-% */ z_undefinedkey,
/* M-& */ z_undefinedkey,
/* M-' */ z_quoteline,
/* M-( */ z_undefinedkey,
/* M-) */ z_undefinedkey,
/* M-* */ z_undefinedkey,
/* M-+ */ z_undefinedkey,
/* M-, */ z_undefinedkey,
/* M-- */ z_undefinedkey,
/* M-. */ z_insertlastword,
/* M-/ */ z_undefinedkey,
/* M-0 */ z_digitargument,
/* M-1 */ z_digitargument,
/* M-2 */ z_digitargument,
/* M-3 */ z_digitargument,
/* M-4 */ z_digitargument,
/* M-5 */ z_digitargument,
/* M-6 */ z_digitargument,
/* M-7 */ z_digitargument,
/* M-8 */ z_digitargument,
/* M-9 */ z_digitargument,
/* M-: */ z_undefinedkey,
/* M-; */ z_undefinedkey,
/* M-< */ z_beginningofbufferorhistory,
/* M-= */ z_undefinedkey,
/* M-> */ z_endofbufferorhistory,
/* M-? */ z_whichcommand,
/* M-@ */ z_undefinedkey,
/* M-A */ z_acceptandhold,
/* M-B */ z_backwardword,
/* M-C */ z_capitalizeword,
/* M-D */ z_deleteword,
/* M-E */ z_undefinedkey,
/* M-F */ z_forwardword,
/* M-G */ z_getline,
/* M-H */ z_runhelp,
/* M-I */ z_undefinedkey,
/* M-J */ z_undefinedkey,
/* M-K */ z_undefinedkey,
/* M-L */ z_downcaseword,
/* M-M */ z_undefinedkey,
/* M-N */ z_historysearchforward,
/* M-O */ z_undefinedkey,
/* M-P */ z_historysearchbackward,
/* M-Q */ z_pushline,
/* M-R */ z_toggleliteralhistory,
/* M-S */ z_spellword,
/* M-T */ z_transposewords,
/* M-U */ z_upcaseword,
/* M-V */ z_undefinedkey,
/* M-W */ z_copyregionaskill,
/* M-X */ z_undefinedkey,
/* M-Y */ z_undefinedkey,
/* M-Z */ z_undefinedkey,
/* M-[ */ z_sequenceleadin,
/* M-\ */ z_undefinedkey,
/* M-] */ z_undefinedkey,
/* M-^ */ z_undefinedkey,
/* M-_ */ z_insertlastword,
/* M-` */ z_undefinedkey,
/* M-a */ z_acceptandhold,
/* M-b */ z_backwardword,
/* M-c */ z_capitalizeword,
/* M-d */ z_deleteword,
/* M-e */ z_undefinedkey,
/* M-f */ z_forwardword,
/* M-g */ z_getline,
/* M-h */ z_runhelp,
/* M-i */ z_undefinedkey,
/* M-j */ z_undefinedkey,
/* M-k */ z_undefinedkey,
/* M-l */ z_downcaseword,
/* M-m */ z_undefinedkey,
/* M-n */ z_historysearchforward,
/* M-o */ z_undefinedkey,
/* M-p */ z_historysearchbackward,
/* M-q */ z_pushline,
/* M-r */ z_toggleliteralhistory,
/* M-s */ z_spellword,
/* M-t */ z_transposewords,
/* M-u */ z_upcaseword,
/* M-v */ z_undefinedkey,
/* M-w */ z_copyregionaskill,
/* M-x */ z_executenamedcmd,
/* M-y */ z_yankpop,
/* M-z */ z_executelastnamedcmd,
/* M-{ */ z_undefinedkey,
/* M-| */ z_vigotocolumn,
/* M-} */ z_undefinedkey,
/* M-~ */ z_undefinedkey,
/* M-^? */ z_backwardkillword,
};

int viinsbind[32] = {
/* ^@ */ z_undefinedkey,
/* ^A */ z_selfinsert,
/* ^B */ z_selfinsert,
/* ^C */ z_sendbreak,
/* ^D */ z_listchoices,
/* ^E */ z_selfinsert,
/* ^F */ z_selfinsert,
/* ^G */ z_selfinsert,
/* ^H */ z_backwarddeletechar,
/* ^I */ z_expandorcomplete,
/* ^J */ z_acceptline,
/* ^K */ z_killline,
/* ^L */ z_clearscreen,
/* ^M */ z_acceptline,
/* ^N */ z_selfinsert,
/* ^O */ z_selfinsert,
/* ^P */ z_selfinsert,
/* ^Q */ z_selfinsert,
/* ^R */ z_redisplay,
/* ^S */ z_selfinsert,
/* ^T */ z_selfinsert,
/* ^U */ z_killwholeline,
/* ^V */ z_quotedinsert,
/* ^W */ z_backwardkillword,
/* ^X */ z_selfinsert,
/* ^Y */ z_selfinsert,
/* ^Z */ z_selfinsert,
/* ^[ */ z_vicmdmode,
/* ^\ */ z_selfinsert,
/* ^] */ z_selfinsert,
/* ^^ */ z_selfinsert,
/* ^_ */ z_selfinsert,
};

int vicmdbind[128] = {
/* ^@ */ z_undefinedkey,
/* ^A */ z_beginningofline,
/* ^B */ z_undefinedkey,
/* ^C */ z_sendbreak,
/* ^D */ z_listchoices,
/* ^E */ z_endofline,
/* ^F */ z_undefinedkey,
/* ^G */ z_listexpand,
/* ^H */ z_backwarddeletechar,
/* ^I */ z_completeword,
/* ^J */ z_acceptline,
/* ^K */ z_killline,
/* ^L */ z_clearscreen,
/* ^M */ z_acceptline,
/* ^N */ z_downhistory,
/* ^O */ z_undefinedkey,
/* ^P */ z_uphistory,
/* ^Q */ z_undefinedkey,
/* ^R */ z_redisplay,
/* ^S */ z_undefinedkey,
/* ^T */ z_undefinedkey,
/* ^U */ z_killbuffer,
/* ^V */ z_undefinedkey,
/* ^W */ z_backwardkillword,
/* ^X */ z_expandorcomplete,
/* ^Y */ z_undefinedkey,
/* ^Z */ z_undefinedkey,
/* ^[ */ z_sequenceleadin,
/* ^\ */ z_undefinedkey,
/* ^] */ z_undefinedkey,
/* ^^ */ z_undefinedkey,
/* ^_ */ z_undefinedkey,
/*   */ z_forwardchar,
/* ! */ z_undefinedkey,
/* " */ z_undefinedkey,
/* # */ z_undefinedkey,
/* $ */ z_endofline,
/* % */ z_vimatchbracket,
/* & */ z_undefinedkey,
/* ' */ z_undefinedkey,
/* ( */ z_undefinedkey,
/* ) */ z_undefinedkey,
/* * */ z_undefinedkey,
/* + */ z_downlineorhistory,
/* , */ z_virevrepeatfind,
/* - */ z_uplineorhistory,
/* . */ z_undefinedkey,
/* / */ z_vihistorysearchbackward,
/* 0 */ z_vidigitorbeginningofline,
/* 1 */ z_digitargument,
/* 2 */ z_digitargument,
/* 3 */ z_digitargument,
/* 4 */ z_digitargument,
/* 5 */ z_digitargument,
/* 6 */ z_digitargument,
/* 7 */ z_digitargument,
/* 8 */ z_digitargument,
/* 9 */ z_digitargument,
/* : */ z_undefinedkey,
/* ; */ z_virepeatfind,
/* < */ z_undefinedkey,
/* = */ z_listchoices,
/* > */ z_undefinedkey,
/* ? */ z_vihistorysearchforward,
/* @ */ z_undefinedkey,
/* A */ z_viaddeol,
/* B */ z_undefinedkey,
/* C */ z_vichangeeol,
/* D */ z_killline,
/* E */ z_undefinedkey,
/* F */ z_vifindprevchar,
/* G */ z_vifetchhistory,
/* H */ z_vicapslockpanic,
/* I */ z_viinsertbol,
/* J */ z_historysearchforward,
/* K */ z_historysearchbackward,
/* L */ z_undefinedkey,
/* M */ z_undefinedkey,
/* N */ z_virevrepeatsearch,
/* O */ z_viopenlineabove,
/* P */ z_yank,
/* Q */ z_undefinedkey,
/* R */ z_vireplace,
/* S */ z_vichangewholeline,
/* T */ z_vifindprevcharskip,
/* U */ z_undefinedkey,
/* V */ z_undefinedkey,
/* W */ z_undefinedkey,
/* X */ z_backwarddeletechar,
/* Y */ z_viyankeol,
/* Z */ z_undefinedkey,
/* [ */ z_undefinedkey,
/* \ */ z_completeword,
/* ] */ z_undefinedkey,
/* ^ */ z_vifirstnonblank,
/* _ */ z_undefinedkey,
/* ` */ z_undefinedkey,
/* a */ z_viaddnext,
/* b */ z_backwardword,
/* c */ z_vichange,
/* d */ z_videlete,
/* e */ z_viforwardwordend,
/* f */ z_vifindnextchar,
/* g */ z_undefinedkey,
/* h */ z_backwardchar,
/* i */ z_viinsert,
/* j */ z_downlineorhistory,
/* k */ z_uplineorhistory,
/* l */ z_forwardchar,
/* m */ z_undefinedkey,
/* n */ z_virepeatsearch,
/* o */ z_viopenlinebelow,
/* p */ z_viputafter,
/* q */ z_undefinedkey,
/* r */ z_vireplacechars,
/* s */ z_vichangewholeline,
/* t */ z_vifindnextcharskip,
/* u */ z_undo,
/* v */ z_undefinedkey,
/* w */ z_forwardword,
/* x */ z_deletechar,
/* y */ z_viyank,
/* z */ z_undefinedkey,
/* { */ z_undefinedkey,
/* | */ z_vigotocolumn,
/* } */ z_undefinedkey,
/* ~ */ z_viswapcase,
/* ^? */ z_backwarddeletechar,
};

