/*
 * T.C.F.S. v. 0.5alpha-linux
 *
 * tcfslogout    disable the user to use the tcfs-filesystem
 *
 * Authors:	Giuseppe Cattaneo, <cattaneo@udsab.dia.unisa.it>
 *		Giuseppe Persiano, <giuper@udsab.dia.unisa.it>
 *		Andrea Cozzolino, <andcoz@mikonos.dia.unisa.it>
 *		Angelo Celentano, <angcel@mikonos.dia.unisa.it>
 *		Aniello Del Sorbo, <anidel@mikonos.dia.unisa.it>
 *		Ermelindo Mauriello, <ermmau@mikonos.dia.unisa.it>
 *		Raffaele Pisapia, <rafpis@mikonos.dia.unisa.it>
 *
 * Permission to use, copy, and modify this software without fee
 * is hereby granted, provided that this entire notice is included in
 * all copies of any software which is or includes a copy or
 * modification of this software and in all copies of the supporting
 * documentation for such software.
 *
 * This software maybe be used for any purpose provided
 * the above copyright notice is retained.  It is supplied
 * as is, with no warranty expressed or implied.
 *
 */

#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <pwd.h>
#include <sys/socket.h>
#include <sys/types.h>
#include <netinet/in.h>
#include "defines.h"
#include "tcfscode.h"

#ifndef SECUDEDES
#include "d3des.h"
#endif

#define BINARY		0
#define OCTAL		1
#define DECIMAL		2
#define HEXADECIMAL	3

char *output_format[]=
{
	"%s\n",
	"0%o ",
	"%u ",
	"0x%x "
};

extern char *getsfskey (char *);

void main (int argc, char **argv)
{
	int len, i=0, fmt;
	char pass[128];
	char *exename=*argv, *sfskey;
	struct passwd *passentry;

	switch (getopt (argc, argv, "boxdh"))
	{
		case 'b':
			/* Binary output */
			fmt = BINARY;
			break;
		case 'o':
			/* Octal output */
			fmt = OCTAL;
			break;
		case 'h':
			/* Help required */
			printf ("\nDisplays user tcfs-key in various format.\n", *argv);
			printf ("Usage: %s [-oxdbh]\n", *argv);
			printf ("where:\n");
			printf ("       -o   for octal output\n");
			printf ("       -x   for hexadecimal output [default]\n");
			printf ("       -d   for decimal output\n");
			printf ("       -b   for binary output\n");
			printf ("       -h   for this help\n");
			exit (0);
		case 'd':
			/* Decimal output */
			fmt = DECIMAL;
			break;
		default:
		case 'x':
			/* Hexadecimal output */
			fmt = HEXADECIMAL;
			break;
	}

	strcpy (pass, getpass("Please enter your password:"));
	
	if ((passentry=getpwuid (getuid()))==NULL)
	{
		fprintf (stderr, "Who are you??\n");
		exit (1);
	}

	if (strcmp (crypt (pass, passentry->pw_passwd), passentry->pw_passwd)!=0)
	{
		fprintf (stderr, "Illegal password!\n");
		exit (1);
	}
	
	if ((sfskey=getsfskey (getlogin()))==NULL)
	{
		fprintf (stderr, "You have no tcfs-key.\n");
		exit (1);
	}

	sfskey=sfsdecode (sfskey, &len);
	
	if (strlen (pass)<8)
		strncat (pass, pass, strlen(pass));

#ifdef SECUDEDES
	desinit (DESMETHOD, D3DES);
	setkey_ (pass);
	dedes (sfskey);
#else
	deskey (pass, DE1);
	desd3 (sfskey, sfskey);
#endif

	fprintf (stderr, "Your tcfs-key is:\n");

	switch (fmt)
	{
		case BINARY:
			printf ("%s", sfskey);
			break;
		default:
			while (i<KEYSIZE)
				printf (output_format[fmt], (unsigned char)*(sfskey+(unsigned char)i++));
	}

	printf ("\n");
}
