/*
 * S.F.S. v. 0.5alpha-linux
 *
 * lsecure      displays the SFS-secure settings of a file   
 *
 * Authors:	Giuseppe Cattaneo, <cattaneo@udsab.dia.unisa.it>
 *		Giuseppe Persiano, <giuper@udsab.dia.unisa.it>
 *		Andrea Cozzolino, <andcoz@mikonos.dia.unisa.it>
 *		Angelo Celentano, <angcel@mikonos.dia.unisa.it>
 *		Aniello Del Sorbo, <anidel@mikonos.dia.unisa.it>
 *		Ermelindo Mauriello, <ermmau@mikonos.dia.unisa.it>
 *		Raffaele Pisapia, <rafpis@mikonos.dia.unisa.it>
 *
 * Permission to use, copy, and modify this software without fee
 * is hereby granted, provided that this entire notice is included in
 * all copies of any software which is or includes a copy or
 * modification of this software and in all copies of the supporting
 * documentation for such software.
 *
 * This software maybe be used for any purpose provided
 * the above copyright notice is retained.  It is supplied
 * as is, with no warranty expressed or implied.
 *
 */

/* Including standard library */
#include <stdio.h>
#include <rpc/rpc.h>

/* Including local library */
#include <tcfs_prot.h>
#include "lsecure.h"

/* Usage function */
void usage(char **argv, int err_code)
{
  switch (err_code)
    {
    case ERR_SFSREG:
      printf("\n%s ERROR: User not registered\n",argv[0]);
      exit(ERR_SFSREG);

    case ERR_USE:
      printf("%s usage: %s filename [filename]\n",argv[0],argv[0]);
      exit(ERR_USE);
    }
}

/* Function to build the absolute path of file */
char *makepath(char *fname)
{
  char *absfname;                                /* Absolute pathname        */

  if(*fname=='/') return(fname);

  absfname=malloc(MAX_PATHLEN);
  getcwd(absfname, MAX_PATHLEN);
  if (!strcmp(fname,"."))
    return(absfname);
  if(absfname[strlen(absfname)-1]!="/")
    strcat(absfname, "/");
  strcat(absfname, fname);
  return(absfname);
}

/* Main function to listing the secure attributes */
int lsecure(getextatargs *in)
{
  enum clnt_stat cs;                        /* RPC-Call return value        */
  unsigned int out;                         /* Result from the SFS-Server   */

  /* Makes the RPC-Call to the server and check it */
  switch(cs=callrpc("localhost",NFS_PROGRAM,NFS_VERSION,NFSPROC_GETEXTAT,(xdrproc_t)xdr_getextatargs,(char*)in,(xdrproc_t)xdr_int,(char*)&out))
    {
    case RPC_SUCCESS:                              /* Wrote the file status  */
      switch(out)
	{
	case UNSECURE:                             /* File in unsecure mode  */
	  printf("%s \t --- \t UNSECURE \n",in->file);
	  return (LSEC_OK);

	case SECURE:                               /* File in secure mode    */
	  printf("%s \t --- \t SECURE \n",in->file);
	  return(LSEC_OK);
	
	case ERR_FILE:                           /* File does not exists     */
	  fprintf (stderr,"%s \t --- \t File does not exists\n",in->file);
	  return(ERR_FILE);

	case ERR_ACCESS:                         /* File access denied       */
	  fprintf (stderr,"%s \t --- \t Access denied\n",in->file);
	  return(ERR_ACCESS);

	case ERR_IOCTL:                          /* IOCTL Error              */
	default:
	   fprintf (stderr,"%s \t --- \t Cannot list flag\n",in->file);
	   return(ERR_IOCTL);

	case ERR_STICK:                          /* Error in stick table     */
	  fprintf (stderr,"%s \t --- \t Entry not found in mountd-stick-table\n",in->file);
	   return(ERR_STICK);

	case ERR_SFSREG:
	  fprintf (stderr,"User not Registered \n");
	  exit(ERR_SFSREG);
 	}
    default:                               /* RPC-CALL failed             */
      clnt_perrno(cs);
      return(RPC_FAIL);
    }
}

/* lsecure main code */
int main(int argc,char **argv)
{
  getextatargs in;                          /* Structure to pass to the   *
                                             * SFS-server                 */
  unsigned int out;                         /* Result from the SFS-Server */
  int i;                                    

  if(argc<2) usage(argv,ERR_USE);           

  for (i=1;i<argc;i++)
    {
      in.uid=geteuid();
      in.file=makepath(argv[i]);            
      lsecure(&in); 
    }
  return(0);
}









