/*
 * S.F.S. v. 0.5alpha-linux
 *
 * cryptname    cypher the file name.
 *
 * Authors:	Giuseppe Cattaneo, <cattaneo@udsab.dia.unisa.it>
 *		Giuseppe Persiano, <giuper@udsab.dia.unisa.it>
 *		Andrea Cozzolino, <andcoz@mikonos.dia.unisa.it>
 *		Angelo Celentano, <angcel@mikonos.dia.unisa.it>
 *		Aniello Del Sorbo, <anidel@mikonos.dia.unisa.it>
 *		Ermelindo Mauriello, <ermmau@mikonos.dia.unisa.it>
 *		Raffaele Pisapia, <rafpis@mikonos.dia.unisa.it>
 *
 * Permission to use, copy, and modify this software without fee
 * is hereby granted, provided that this entire notice is included in
 * all copies of any software which is or includes a copy or
 * modification of this software and in all copies of the supporting
 * documentation for such software.
 *
 * This software maybe be used for any purpose provided
 * the above copyright notice is retained.  It is supplied
 * as is, with no warranty expressed or implied.
 *
 */
#include <unistd.h>
#include "defines.h"
#include "sfscode.h"
#include "uid.h"

#ifdef SECUDEDES
#include <af.h>
#else
#include "d3des.h"
#endif

char *encryptname (char *path, uid_t uid)
{
	int i=0;
	int len8=strlen(path)+8-strlen(path)%8;
	int len3;
	char *cryptpath, *tmp, *bufret;
	
	if ((strlen(path)%8)==8)
		len8+=8;

	len3=len8+3-len8%3;

	if (fskey(uid)==NULL)
		return NULL;	

	if ((cryptpath=(char*)calloc(len3,sizeof(char)))==NULL)
		return NULL;

	bzero (cryptpath, len3);
	strcpy (cryptpath, path);

#ifdef SECUDEDES
	desinit (DESMETHOD, D3DES);
	setkey_ (fskey(uid));
#else
	deskey (fskey(uid), EN0);
#endif

	while (i<len8)
	{

#ifdef SECUDEDES
		endes (cryptpath+i);
#else
		desd3 (cryptpath+i, cryptpath+i);
#endif
		i+=8;
	}
	
	tmp=cryptpath;
	cryptpath=sfsencode (cryptpath, len3);
	
	free (tmp);

	return cryptpath;
}

char *decryptname (char *cryptpath, uid_t uid)
{
	int i=0, len;
	char *path, *tmp;
	
	if (fskey(uid)==NULL)
		return NULL;

	path=sfsdecode (cryptpath, &len);

#ifdef SECUDEDES
	desinit (DESMETHOD, D3DES);
	setkey_ (fskey(uid));
#else
	deskey (fskey(uid), DE1);
#endif

	while (i<len)
	{

#ifdef SECUDEDES
		dedes (path+i);
#else
		desd3 (path+i, path+i);
#endif
	
		i+=8;
	}

	return path;
}
