/*
 * S.F.S. v. 0.5alpha-linux
 *
 * sfsd		This program handles RPC "NFS" data requests 
 *              adopting a secure transfer protocol.
 *
 * Usage:	[rpc.]sfsd [-dhnprv] [-f authfile]
 *
 * Authors:	Giuseppe Cattaneo, <cattaneo@udsab.dia.unisa.it>
 *		Giuseppe Persiano, <giuper@udsab.dia.unisa.it>
 *		Andrea Cozzolino, <andcoz@mikonos.dia.unisa.it>
 *		Angelo Celentano, <angcel@mikonos.dia.unisa.it>
 *		Aniello Del Sorbo, <anidel@mikonos.dia.unisa.it>
 *		Ermelindo Mauriello, <ermmau@mikonos.dia.unisa.it>
 *		Raffaele Pisapia, <rafpis@mikonos.dia.unisa.it>
 *
 * Permission to use, copy, and modify this software without fee
 * is hereby granted, provided that this entire notice is included in
 * all copies of any software which is or includes a copy or
 * modification of this software and in all copies of the supporting
 * documentation for such software.
 *
 * This software maybe be used for any purpose provided
 * the above copyright notice is retained.  It is supplied
 * as is, with no warranty expressed or implied.
 *
 * This code derives from: 
 *		 The LINUX User-Space NFS Server 1.5
 *	    by Mark Shand, Donald J. Becker, Rick Sladkey,
 *		 Orest Zborowski, Fred N. van Kempen 
 */

#include "nfsd.h"
#include "xattr.h"
#include "getopt.h"
#include "fsusage.h"

#include "tcfs.h" 
#include "mount.h"
#include "tcfscrypt.h"
#include "cryptname.h"
#include <syslog.h>
#include <errno.h> 
#include <stdlib.h>
#include <rpc/pmap_clnt.h> /* for pmap_unset */
#include <rpc/rpc.h>
#include <string.h> /* strcmp */ 
#include <memory.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <sys/stat.h>
#include <unistd.h>
#include <dirent.h>
#include <sys/types.h>
#include <fcntl.h>
#include <signal.h>
#include <stdio.h>
#define _RPCSVC_CLOSEDOWN 120

#ifdef __STDC__
#define SIG_PF void(*)(int)
#endif

#ifndef SFS_SOCKET 
#define SFS_SOCKET 9000
#endif

extern unsigned long sec,msec;
extern void receivekey (int);

#define desall(x)  ((unsigned long)(((unsigned long)x) & 0xfffffff8L))
mtable *first;
static char iobuf[NFS_MAXDATA];
static char pathbuf[NFS_MAXPATHLEN + 1];
static char pathbuf_1[NFS_MAXPATHLEN + 1];
int _rpcpmstart = 0;
int _rpcsvcdirty = 0;
int _rpcfdtype = 0;

FILE *log_fd;

static _PRO(void usage, (FILE *, int));

extern char version[];
static char *program_name;
static struct option longopts[] =
{
	{ "debug", 0, 0, 'd' },
	{ "exports-file", 1, 0, 'f' },
	{ "help", 0, 0, 'h' },
	{ "allow-non-root", 0, 0, 'n' },
	{ "promiscuous", 0, 0, 'p' },
	{ "re-export", 0, 0, 'r', },
	{ "version", 0, 0, 'v' },
	{ NULL, 0, 0, 0 }
};

extern clnt_param *cp;		/* only for the option list	*/

extern _PRO(void nfs_dispatch, (struct svc_req * rqstp, SVCXPRT * transp));
static _PRO(nfsstat build_path, (char *buf, diropargs * da));
static _PRO(int makesock, (int port, int proto, int socksz));
static _PRO(void closedown, (int sig));

extern void xdr_free();		/* fill this in later */
/*extern void pmap_unset();*/	/* why here??? */

/*
 * check_ro_attrib -- tig
 *
* This function will check to see if the nfs directory is mounted
 * read only.  If it is an error status is returned.
 *
 * Parameters:
 *    int auth - Where fs authentication is expected.
 *    struct svc_req *rqstp - The RPC service request.
 *    char *path - The file system path.
 *    clnt_param *cp - The Client fs parameters as supplied from the
 *       internal table of exported file systems.
 *
 * Returns:
 *    NFS_OK - If authenication isn't needed or if fs is read/write.
 *    NFSERR_ACCES - If the fs can't be found among the exported fs.
 *    NFSERR_ROFS - If the fs is a read-only fs.
 */
static inline int check_ro_attrib(auth, rqstp, path, cp)
int auth;
struct svc_req *rqstp;
char *path;
clnt_param *cp;
{
	/* Now we attempt to authenticate the clients credentials. */
	if (auth) 
	  {
	    /* Retrieve the client's parameters. */
	    if ((cp = auth_clnt(rqstp, path)) == NULL) 
	      return (NFSERR_ACCES); 
	    /* If this is a read only mount, then we'd better punt. */ 
	    if (cp->o.read_only)
	      return (NFSERR_ROFS);
	  }
	return (NFS_OK);
}

static inline nfsstat build_path(buf, da)
char *buf;
diropargs *da;
{
	nfsstat status;
	char *path, *fname;

	if ((path = fh_path(&(da->dir), &status)) == 0)
		return (NFSERR_STALE);

	while (*path)		/* strcpy(buf, path); */
		*buf++ = *path++;
	*buf++ = '/';		/* strcat(buf, "/");  */
	fname = da->name;
	while (*fname)		/* strcat(pathbuf, argp->where.name); */
		*buf++ = *fname++;
	*buf = '\0';
	return (NFS_OK);
}

/*
 * The "wrappers" of the following functions came from `rpcgen -l nfs_prot.x`.
 * This normally generates the client routines, but it provides nice
 * prototypes for the server routines also.
 */
#define CLIENT struct svc_req

int nfsd_nfsproc_null_2(argp)
void *argp;
{
#ifdef BOF
  syslog(LOG_DAEMON,"null_2");
#endif
	return (0);
}

int nfsd_nfsproc_getattr_2(argp)
nfs_fh *argp;
{
#ifdef BOF
  syslog(LOG_DAEMON,"getattr_2");
#endif
   	fprintf(log_fd, "nfsd_nfsproc_getattr_2 \n"); 
	return (getattr(argp, &result.attrstat.attrstat_u.attributes, NULL));
}

int nfsd_nfsproc_setattr_2(argp)
sattrargs *argp;
{
	nfsstat status;
	char *path;
	struct stat buf;
        fprintf(log_fd, "nfsd_nfsproc_setattr_2 ,%d ,%d ,%o \n",argp->attributes.uid, argp->attributes.gid ,argp->           	attributes.mode); 

#ifdef BOF
  syslog(LOG_DAEMON,"setattr_2");
#endif
	if ((path = fh_path(&(argp->file), &status)) == NULL) {
		/* That means we can't get a path to the file.  Give up. */
		return (NFSERR_STALE);
	}
	status = check_ro_attrib(client_authenticate, svc_rqstp, path, cp);
	if (status != NFS_OK)
		return(status);

	errno = 0;
	/* Stat the file first and only change fields that are different. */
	if (lstat(path, &buf) < 0)
		goto failure;
	if (((argp->attributes.uid != -1
	    && argp->attributes.uid != buf.st_uid)
	    || (argp->attributes.gid != -1
	    && argp->attributes.gid != buf.st_gid))
	    && lchown(path, argp->attributes.uid, argp->attributes.gid) < 0)
		goto failure;
	if (argp->attributes.mode != -1
	   && (argp->attributes.mode & 07777) != (buf.st_mode & 07777)
	   && chmod(path, argp->attributes.mode) < 0)
		goto failure;
	if (S_ISREG(buf.st_mode)
	    && argp->attributes.size != -1
	    && argp->attributes.size != buf.st_size
	    && truncate(path, argp->attributes.size) < 0)
		goto failure;
	if ((argp->attributes.atime.seconds != (unsigned) -1
	   && argp->attributes.atime.seconds != buf.st_atime)
	   || (argp->attributes.mtime.seconds != (unsigned) -1
	   && argp->attributes.mtime.seconds != buf.st_mtime)) {
		struct timeval tvp[2];
		tvp[0].tv_sec = argp->attributes.atime.seconds;
		tvp[0].tv_usec = argp->attributes.atime.useconds;
		tvp[1].tv_sec = argp->attributes.mtime.seconds;
		tvp[1].tv_usec = argp->attributes.mtime.useconds;
		if (utimes(path, tvp) < 0)
			goto failure;
	}
	return (getattr(&(argp->file),
		&(result.attrstat.attrstat_u.attributes), NULL));

failure:
	return (nfs_errno());
}

int nfsd_nfsproc_root_2(argp)
void *argp;
{
#ifdef BOF
  syslog(LOG_DAEMON,"root_2");
#endif
	return (0);
}

int nfsd_nfsproc_lookup_2(argp)
diropargs *argp;
{
  int status;
  struct stat sbuf;
  struct stat *sbp = &sbuf;
  diropokres *dp = &result.diropres.diropres_u.diropres;
  fhcache *fh;
  char *cname,*oname;
  uid_t uid;
  int kflag;
#ifdef BOF
  syslog(LOG_DAEMON,"lookup_2");
#endif
/* aggiunte */
  if ((fh=fh_find((svc_fh *)&(argp->dir),0)) == NULL)
    return (NFSERR_STALE);
  kflag=IS_CRYPTED(fh->extended);
  if (kflag && strcmp(argp->name,".")!=0 && strcmp(argp->name,"..")!=0){
    uid=geteuid();
    cname=encryptname(argp->name,uid);
    if (cname==NULL) {
#ifdef DEBUG
      syslog(LOG_DAEMON,"Failed in encryptname, maybe user have to sfslogin");
#endif
      return NFSERR_IO;
    }  
    free(argp->name);
    argp->name=cname;
  }
/* fine*/
  status = fh_compose(argp, &(dp->file), &sbp, -1, -1);
  if (status == NFS_OK) {
    status = getattr(&(dp->file), &(dp->attributes), sbp);
    if (status == NFS_OK)
      dprintf(1, "\tnew_fh = %s\n", fh_pr(&(dp->file)));
  }  
  return (status);
}

int nfsd_nfsproc_readlink_2(argp)
nfs_fh *argp;
{
	nfsstat status;
	char *path;
	int cc;
#ifdef BOF
  syslog(LOG_DAEMON,"readlink_2");
#endif
	if ((path = fh_path(argp, &status)) == 0)
		return (NFSERR_STALE);

	errno = 0;
	if ((cc = readlink(path, pathbuf, NFS_MAXPATHLEN)) < 0) {
		dprintf(1, " >>> %s\n", strerror(errno));
		return (nfs_errno());
	}
	status = NFS_OK;
	pathbuf[cc] = '\0';	/* readlink() doesn't null terminate!! */
	result.readlinkres.readlinkres_u.data = pathbuf;

	/* Now we attempt to authenticate the clients credentials. */
	if ((cp = auth_clnt(svc_rqstp, path)) == NULL)
		return (NFSERR_ACCES);

	if (cp->o.link_relative && pathbuf[0] == '/') {
		/*
		 * We've got an absolute (locally) pathname, and we should
		 * translate to a relative pathname for the client.  We do
		 * this by prepending the correct number of "../"es to the
		 * path. This cannot work if the client does not mount the
		 * specified subtree of the filesystem.
		 */
		int slash_cnt = 0;
		char *p, *q;

		/* Count how many directories down we are. */
		for (p = path + 1; *p != '\0'; p++)
			if (*p == '/')
				slash_cnt++;

		/*
		 * Ok, now we are finished with the orginal file `path'
		 * and will only deal with the link target.
		 */
		p = &pathbuf[cc];	/* Point to the end and calculate */
		if (slash_cnt == 0)
			q = p + 1;	/* the extra space take by a	*/
		else		/* prepended '.'  		*/
			q = p + 3 * slash_cnt - 1;	/* or '../.../..' */

		if (q >= pathbuf + NFS_MAXPATHLEN) {
			dprintf(1, " [[NAME TOO LONG!!]]\n");
			return (NFSERR_NAMETOOLONG);
		} else {
			/* Add some space at the beginning of the string. */
			while (p >= pathbuf)
				*q-- = *p--;

			if (slash_cnt == 0)
				pathbuf[0] = '.';
			else {
				/*
				 * This overwrites the leading '/' on the
				 * last iteration.
				 */
				for (p = pathbuf; slash_cnt > 0; slash_cnt--) {
					*p++ = '.';
					*p++ = '.';
					*p++ = '/';
				}
			}
		}
	}
	dprintf(1, " %s\n", result.readlinkres.readlinkres_u.data);
	return (NFS_OK);
}

int nfsd_nfsproc_read_2(argp)
readargs *argp;
{
  static sfs_lookupargs tmp;
  static sfs_lookupres ret;
  static char remote[NFS_MAXPATHLEN+1],work[NFS_MAXPATHLEN+1],dummy[NFS_MAXPATHLEN+1];
  static char host[NFS_MAXPATHLEN+1],*dir,call[NFS_MAXPATHLEN+1];
  char * path;
  getextatargs *ap;
  nfsstat status,st1;
  int fd,i;
  enum clnt_stat cs;
  fhcache *h; /* aggiunta per buffer */
  unsigned long j,count,k;
  unsigned long newof;
  char tmp1[1024],kflag;
  uid_t uid=geteuid();

  if ((h = fh_find((svc_fh *) &argp->file, 0)) == NULL) {
    return NFSERR_STALE;
  }
  if ((fd = fh_fd(&(argp->file), &status, O_RDONLY)) < 0) {
    return ((int) status);
  }
  errno=0;
/* This code handles buffer cache */
#ifdef BOF
  syslog(LOG_DAEMON,"read_2");
#endif
  kflag=(h->extended==7)?1:0;
  /* Test file owner */
  if (kflag && uid!=h->uid) {
    syslog(LOG_DAEMON,"Fuck off intruder !!!!");
    fd_inactive(fd);
    result.readres.readres_u.reply.data.data_len=-1;
    result.readres.status=NFSERR_ACCES;
    return (NFSERR_ACCES);
  }
  if (h->valid == -1) {
    syslog(LOG_DAEMON,"aiutoooooooooooooo");
    return NFSERR_IO;
  }
  if (h->valid == 0) { /* buffer doesn't contain any valid data */
    /* load a valid block that has intersection with the one requested */
    if (kflag)
      newof=desall(argp->offset);
    else
      newof=argp->offset;
    /* offset of the nearest DES block */
    errno = 0;
    (void) lseek(fd, (long) newof, L_SET);
    if (errno) {
      fd_inactive(fd);
      return (nfs_errno());
    }
    h->valid = read(fd, h->buffer, 8192);
    if (h->valid <0 ) {
      h->valid=0;
      fd_inactive(fd);
      return nfs_errno();
    }
    if (h->valid == 0 ) {
      result.readres.readres_u.reply.data.data_val = iobuf;
      result.readres.readres_u.reply.data.data_len=0;
      fd_inactive(fd);
      return (getattr(&(argp->file),&(result.readres.readres_u.reply.attributes), NULL));
    }
    h->offset= newof;
    /* we have a buffer with intersection */
    if (kflag) { /* Decrypt the buffer */
      if(sfs_decrypt(h->buffer,h->valid,h->offset,uid)){
	errno=22;
	result.readres.status=NFSERR_ACCES;
	return nfs_errno();
      }
    }
  } 
  if (!(h->offset<=argp->offset && argp->offset-h->offset<8192)) { 
    /* the block requested doesn't start in the buffer.
       This happens when i already have a buffer loaded and i have to
       handle a read for a block that is in another part of the file 
       I don't write the buffer on the disk cause i have done it in the write,
       if it has been modified */
    if (kflag)
      newof=desall(argp->offset);
    else
      newof=argp->offset;
    /* offset of nearest DES block */
    errno = 0;
    (void) lseek(fd, (long) newof, L_SET);
    if (errno) {
      fd_inactive(fd);
      return (nfs_errno());
    }
    h->valid = read(fd, h->buffer, 8192);
    if (h->valid <0 ) {
      h->valid=0;
      fd_inactive(fd);
      return nfs_errno();
    }
    if (h->valid == 0 ) {
      result.readres.readres_u.reply.data.data_val = iobuf;
      result.readres.readres_u.reply.data.data_len=0;
      fd_inactive(fd);
      return (getattr(&(argp->file),&(result.readres.readres_u.reply.attributes), NULL));
    }
    h->offset= newof;
    /* We have a buffer with intersaction with the block requested */
    if (kflag) { /* Decrypt the buffer */
      if(sfs_decrypt(h->buffer,h->valid,h->offset,uid)) {
	errno=22;
	result.readres.status=NFSERR_ACCES;
	return nfs_errno();
      }
    }
  }
  /* Now we have a clean (not crypted) buffer that contains the block to read*/
  if (8192-(argp->offset-h->offset)-argp->count>=0) { 
    /* The buffer totally contains the requested block */
    if (h->valid<(argp->offset-h->offset)) {
      /* trying to read at the end of the file */
      result.readres.readres_u.reply.data.data_val = iobuf;
      result.readres.readres_u.reply.data.data_len=0;
      fd_inactive(fd);
      return (getattr(&(argp->file),&(result.readres.readres_u.reply.attributes), NULL));
    } else {
      /* copy the block */
      for (j=0;j<argp->count && j<=h->offset+h->valid-argp->offset;j++) 
	iobuf[j]=h->buffer[j+argp->offset-h->offset];
      result.readres.readres_u.reply.data.data_val = iobuf;	
      result.readres.readres_u.reply.data.data_len=j;
      fd_inactive(fd);
      return (getattr(&(argp->file),&(result.readres.readres_u.reply.attributes), NULL));  
    } 
  } else { /* buffer doesn't contain all the block, copy the part i'm interested in */
    for (j=0;j<8192-argp->offset && j<=h->offset+h->valid-argp->offset;j++) 
      iobuf[j]=h->buffer[j+argp->offset-h->offset];
    if (j<8192-argp->offset) { /* Il file e' finito prima */
      sprintf(tmp1,"EOF valid %ld - letti %ld - richiesti %ld\n",h->valid,(long)j,(long)argp->count);
      result.readres.readres_u.reply.data.data_val = iobuf;	
      result.readres.readres_u.reply.data.data_len=j;
      fd_inactive(fd);
      return (getattr(&(argp->file),&(result.readres.readres_u.reply.attributes), NULL));
    } else {
      errno=0;
      (void) lseek(fd,(long)h->offset+8192,L_SET);
      if (errno) {/* seek error */
	result.readres.readres_u.reply.data.data_val = iobuf;	
	result.readres.readres_u.reply.data.data_len=j;
	fd_inactive(fd);
	return (getattr(&(argp->file),&(result.readres.readres_u.reply.attributes), NULL));
      }
      h->valid=read(fd,h->buffer,8192);
      h->offset+=8192;
      result.readres.readres_u.reply.data.data_len=j;
      if (h->valid <0) {
	h->valid=0;
	fd_inactive(fd);
      	return nfs_errno();
      }
      if (h->valid) { 
	k=argp->count-j; /* bytes to read  */
	for (j=0;j<k && j<=h->valid;j++)
	  iobuf[j+argp->count]=h->buffer[j];
      }
      if (kflag) { 
	if(sfs_decrypt(h->buffer,h->valid,h->offset,uid)){
	  errno=22;
	  result.readres.status=NFSERR_ACCES;
	  return nfs_errno();
	}
      }
      result.readres.readres_u.reply.data.data_val = iobuf;	
      result.readres.readres_u.reply.data.data_len+=j;
      fd_inactive(fd); 
      return (getattr(&(argp->file),&(result.readres.readres_u.reply.attributes), NULL));
    }
  }
  syslog (LOG_DAEMON,"qualcosa non e' andato bene nella read");
}

int nfsd_nfsproc_writecache_2(argp)
void *argp;
{
#ifdef BOF
  syslog(LOG_DAEMON,"writecache_2");
#endif
	return (0);
}

int nfsd_nfsproc_write_2(argp)
writeargs *argp;
{
  static sfs_lookupargs tmp;
  static sfs_lookupres ret;
  static char remote[NFS_MAXPATHLEN+1],work[NFS_MAXPATHLEN+1],dummy[NFS_MAXPATHLEN+1];
  static char host[NFS_MAXPATHLEN+1],*dir,call[NFS_MAXPATHLEN+1];
  char * path;
  getextatargs *ap;
  nfsstat status,st1;
  int fd,i;
  enum clnt_stat cs;
  fhcache *h;
  unsigned long j,k,tmpoff;
  struct stat bstat;
  char buff[1024],kflag;
  uid_t uid=geteuid();

#ifdef BOF
  syslog(LOG_DAEMON,"write_2");
#endif
  if ((fd = fh_fd(&(argp->file), &status, O_RDWR)) < 0) {
    /* was O_WRONLY */
    return ((int) status);
  }
  /* This code handles the buffer cache */
  if ((h=fh_find((svc_fh *)&argp->file,0))==NULL) {
    return NFSERR_STALE;
  }
  kflag=(h->extended==7)?1:0;
 if (h->valid == -1) {
    syslog(LOG_DAEMON,"aiutoooooooooooooo");
    return NFSERR_IO;
  }
  if (h->valid == 0) { /* buffer doesn't contain any valid data */
    fstat(fd,&bstat);
    if (argp->offset<bstat.st_size) {
      /* the block must be modified */
      errno=0;
      if (kflag)
	(void) lseek(fd, desall(argp->offset), L_SET);
      else
	(void) lseek(fd, argp->offset, L_SET);
      if (errno) {
	fd_inactive(fd);
	return (nfs_errno());
      }
      if (kflag)
	h->offset=desall(argp->offset);
      else
	h->offset=argp->offset;
      h->valid=read(fd,h->buffer,8192); /* load the buffer */
      if (kflag) { /* decrypt the buffer */
	if (sfs_decrypt(h->buffer,h->valid,h->offset,uid))
	  return NFSERR_PERM;
      }
    } else { /* i'm appending at the end of the file */
      memset(h->buffer,'\0',8192);
      /* qua bisogna aggiungere la gestione del vecchio fine file
	 perche' se il buffer contiene alcuni byte spuri crittografati in qualche
	 modo, dobbiamo fare in modo che tutto ritorni a posto... */
      if (kflag)
	h->offset=desall(argp->offset);
      else
	h->offset=argp->offset;
      h->valid=argp->data.data_len+(argp->offset - h->offset)-1;
    }
  } else {
    if (!(h->offset<=argp->offset && argp->offset-h->offset<h->valid)) {
      fstat(fd,&bstat);
      if (argp->offset<bstat.st_size) {
	/* block must me modified */
	errno=0;
	if (kflag) 
	  (void) lseek(fd, desall(argp->offset), L_SET);
	else 
	  (void) lseek(fd, argp->offset, L_SET);
	if (errno) {
	  fd_inactive(fd);
	  return (nfs_errno());
	}
	if (kflag)
	  h->offset=desall(argp->offset);
	else
	  h->offset=argp->offset;
	h->valid=read(fd,h->buffer,8192); /* load the buffer */
	if (kflag) { /* decrypt the block */
	  if (sfs_decrypt(h->buffer,h->valid,h->offset,uid))
	    return NFSERR_PERM;
	}
      } else { /* the block is at the end of the file */
	memset(h->buffer,'\0',8192);
	/* qua bisogna aggiungere la gestione del vecchio fine file
	   perche' se il buffer contiene alcuni byte spuri crittografati in qualche
	   modo, dobbiamo fare in modo che tutto ritorni a posto... */
	if (kflag)
	  h->offset=desall(argp->offset);
	else
	  h->offset=argp->offset;
	h->valid=argp->data.data_len+(argp->offset - h->offset)-1;
      } 
    }
  }
  /* now we have a buffer with intersection with the block i have to write */
  if ((long)h->valid-(long)(argp->offset-h->offset)-(long)argp->data.data_len>=0) {
    /* something in the buffer must be saved cause the part to write
       is shortest than the file */
    if (kflag)
      tmpoff=desall(argp->offset);
    else
      tmpoff=argp->offset;
    if (kflag && !(argp->offset % 8 == 0)) {
      bcopy(&h->buffer[tmpoff-h->offset],iobuf,8);
    }
    j=argp->offset-tmpoff; /* bytes copied into iobuf */
    bcopy(argp->data.data_val,iobuf+j,argp->data.data_len);
    j+=argp->data.data_len;
    if ( kflag && (j%8) != 0) {
      /* i have to align to des block */
      bcopy(&h->buffer[j+tmpoff-h->offset],iobuf+j,8-j%8);
      j+=8-j%8;
    }
    bcopy(iobuf,&h->buffer[tmpoff-h->offset],j); /* update cache */
    if (kflag) { 
	if (sfs_crypt(iobuf,j,tmpoff,uid))
	  return NFSERR_PERM;
      }
    errno=0;
    (void) lseek (fd,(long) tmpoff,L_SET);
    if (errno==0) {
      if (write(fd,iobuf,j)!= j) {
	dprintf(1,"Write failure, errno is %d.\n",errno);
      }
    }
    fd_inactive(fd);
    if (errno)
      return nfs_errno();
    return (getattr(&(argp->file),&(result.attrstat.attrstat_u.attributes),NULL));
  } else { 
    /* the buffer has intersection with the block, so i use the code 
       below to update the part with intersection then i load the rest */
    if (h->valid==8192) { /* tutto il blocco e' valido */
      /* align to des block */
      if (kflag)
	tmpoff=desall(argp->offset);
      else
	tmpoff=argp->offset;
      if (kflag && !(argp->offset % 8 == 0)) {
	bcopy(&h->buffer[tmpoff-h->offset],iobuf,8);
      }
      j=argp->offset-tmpoff; /* bytes copied in iobuf */
      bcopy(argp->data.data_val,&iobuf[argp->offset-tmpoff],8192-(argp->offset-h->offset));
      j+=8192-(argp->offset-h->offset);
      bcopy(iobuf,&h->buffer[tmpoff],j); /* update the cache */
      if (kflag) { 
	if (sfs_crypt(iobuf,j,tmpoff,uid))
	  return NFSERR_PERM;
      }
      errno=0;
      (void) lseek (fd,(long) tmpoff,L_SET);
      if (errno==0) {
	if (write(fd,iobuf,j)!= j) {
	  dprintf(1,"Write failure, errno is %d.\n",errno);
	}
      }
      (void) lseek (fd,(long)h->offset+8192,L_SET);
      if (errno){
	fd_inactive(fd);
	return nfs_errno(); /* i suppose this must not happen */
      }
      k=read(fd,iobuf,8192);
      if (kflag) { 
	if (sfs_decrypt(iobuf,k,h->offset+8192,uid))
	  return NFSERR_PERM;
      }
      switch (k) {
      case -1: /* read error */
	fd_inactive(fd);
	return nfs_errno(); 
	break;
      case 0: /* i have to append to the file */
	bcopy(argp->data.data_val+8192-(argp->offset-h->offset),iobuf,argp->data.data_len-(8192-(argp->offset-h->offset))); 
	if (kflag) { 
	  if (sfs_crypt(iobuf,argp->data.data_len-(8192-(argp->offset-h->offset)),h->offset+8192,uid))
	    return NFSERR_PERM;
	}
	write(fd,iobuf,argp->data.data_len-(8192-(argp->offset-h->offset)));
	fd_inactive(fd);
	if (errno)
	  return nfs_errno();
	return (getattr(&(argp->file),&(result.attrstat.attrstat_u.attributes),NULL));
	break;
      default: /* i have read something */
	bcopy(argp->data.data_val+8192-(argp->offset-h->offset),iobuf,argp->data.data_len-(8192-(argp->offset-h->offset)));
	j=argp->data.data_len-(8192-(argp->offset-h->offset)); /* copy remaining bytes */
	k=k>j?k:j; /* bytes to write */
	if (kflag) { 
	  if (sfs_crypt(iobuf,k,h->offset+8192,uid))
	    return NFSERR_PERM;
	}
	(void) lseek (fd,(long)h->offset+8192,L_SET);
	if (errno) {
	  fd_inactive(fd);
	  return nfs_errno(); /* i suppose this must not happen */
	}
	write(fd,iobuf,k);
	fd_inactive(fd);
	if (errno)
	  return nfs_errno();
	return (getattr(&(argp->file),&(result.attrstat.attrstat_u.attributes),NULL));
      }
    } else { /* The file ends in the buffer, a part must be rewritted and a 
		part must be added */
      if (kflag)
	tmpoff=desall(argp->offset);
      else
	tmpoff=argp->offset;
      if (kflag && !(argp->offset % 8 == 0)) {
	bcopy(&h->buffer[tmpoff-h->offset],iobuf,8);
      }
      j=argp->offset-tmpoff; /* bytes copied in iobuf */
      if (kflag && (h->valid % 8 !=0) )
	k=desall(h->valid)+8L;
      else
	k=h->valid;
      bcopy(argp->data.data_val,&iobuf[j],k-(argp->offset-h->offset));
      j+=(k-(argp->offset-h->offset))>0?(k-(argp->offset-h->offset)):0;
      h->valid=0; /* invalid the cache so the block will be reread */
      errno=0;
      if (kflag) { 
	if (sfs_crypt(iobuf,j,tmpoff,uid))
	  return NFSERR_PERM;
      }
      (void) lseek (fd,(long) tmpoff,L_SET);
      if (errno) {
	fd_inactive(fd);
	return nfs_errno(); /* i suppose must not happen */
      }
      if (write(fd,iobuf,j)!= j) {
	dprintf(1,"Write failure, errno is %d.\n",errno);
      }
      if (argp->data.data_len>j) {
	bcopy(argp->data.data_val+j,iobuf,argp->data.data_len-j);
	/* qui bisogna inserire le condizioni di fine file */
	if (kflag) { 
	  if (sfs_crypt(iobuf,argp->data.data_len-j,tmpoff+j,uid))
	    return NFSERR_PERM;
	}      
	write(fd,iobuf,argp->data.data_len-j);
      }
      fd_inactive(fd);
      if (errno)
	return nfs_errno();
      return (getattr(&(argp->file),&(result.attrstat.attrstat_u.attributes),NULL));
      }
  }
  syslog(LOG_DAEMON,"e' andato tutto a puttane");
}

#define CREATE_OMODE O_RDWR

int nfsd_nfsproc_create_2(argp)
createargs *argp;
{
	nfsstat status;
	int tmpfd, flags;
	struct stat sbuf;
	struct stat *sbp = &sbuf;
	uid_t target_uid;
	gid_t target_gid;
	int is_borc;
	int dev;
	int exists;
	fhcache *h;
	int kflag;
	char *cname;
	uid_t uid;
	setextatargs eattr;
	static sfs_lookupargs tmp;
	static sfs_lookupres res;
	static char remote[NFS_MAXPATHLEN+1],work[NFS_MAXPATHLEN+1],dummy[NFS_MAXPATHLEN+1],pathtmp[NFS_MAXPATHLEN+1];
	enum clnt_stat cs;
	char buf[1024];
nfsstat st;
#ifdef BOF
  syslog(LOG_DAEMON,"create_2");
#endif
	if ((h = fh_find((svc_fh *) &argp->where, 0)) == NULL) {
	  return NFSERR_STALE;
	}
	kflag=IS_CRYPTED(h->extended);
	if (kflag) { 
	  uid=geteuid();
	  cname=encryptname(argp->where.name,uid);
	  if (cname==NULL) {
#ifdef DEBUG
	    syslog(LOG_DAEMON,"Failed in encryptname, maybe user have to sfslogin");
#endif
	    return NFSERR_IO;
	  }  
	  free(argp->where.name);
	  argp->where.name=cname;
	}
	status = build_path(pathbuf, &argp->where);
	if (status != NFS_OK) 
	  return ((int) status);
	dprintf(1, "\tfullpath='%s'\n", pathbuf);
	errno = 0;
	
	exists =  lstat(pathbuf, &sbuf) == 0;

	/* Compensate for a really bizarre bug in SunOS derived clients. */
	if ((argp->attributes.mode & S_IFMT) == 0)
		argp->attributes.mode |= exists
			? (sbuf.st_mode & S_IFMT) : S_IFREG;

	/* First handle any unusual file-types. */
	if (!S_ISREG(argp->attributes.mode)) {
		if (S_ISBLK(argp->attributes.mode)
		    || S_ISCHR(argp->attributes.mode)) {
			is_borc = 1;
			/* This is probably better than just using
			   the size field by itself, but not by much. */
			dev = makedev(((argp->attributes.size >> 8) & 0xff),
			    (argp->attributes.size & 0xff));
		}
		else {
			is_borc = 0;
			dev = 0;
		}
		/* mknod will fail for EEXIST, we'll let it succeed. */
		if (exists) {
			/* But make sure it's the same kind of special file. */
			if ((argp->attributes.mode & S_IFMT)
			    != (sbuf.st_mode & S_IFMT)) 
			  return (NFSERR_EXIST);
			
			/* And that the major and minor numbers agree. */
			if (is_borc && dev != sbuf.st_rdev)
			  return (NFSERR_EXIST);
		}
		else {
			status = check_ro_attrib(client_authenticate,
			    svc_rqstp, pathbuf, cp);
			if (status != NFS_OK)  
			  return (status);
			
			if (mknod(pathbuf, argp->attributes.mode, dev) < 0) 
			  return (nfs_errno());
			
			if (stat(pathbuf, &sbuf) < 0) 
			  return (nfs_errno());
		}
		tmpfd = -1;
	}
	else {
		status = check_ro_attrib(client_authenticate,
		    svc_rqstp, pathbuf, cp);
		if (status != NFS_OK) 
		  return (status);
				
		flags = (argp->attributes.size == 0 ?
			CREATE_OMODE | O_CREAT | O_TRUNC :
			CREATE_OMODE | O_CREAT);
		tmpfd = path_open(pathbuf, flags, argp->attributes.mode);
		if (tmpfd < 0)
			goto failure;
		(void) fstat(tmpfd, &sbuf);
	}

	target_uid = argp->attributes.uid;
	target_gid = argp->attributes.gid;

	if ((target_uid != (uid_t) -1 && sbuf.st_uid != target_uid) ||
	    (target_gid != (gid_t) -1 && sbuf.st_gid != target_gid)) {
		if (lchown(pathbuf, target_uid, target_gid) < 0)

			goto failure;
		if (target_uid != (uid_t) -1)
			sbuf.st_uid = target_uid;
		if (target_gid != (gid_t) -1)
			sbuf.st_gid = target_gid;
	}

	if (S_ISREG(argp->attributes.mode)
	    && argp->attributes.size != -1
	    && argp->attributes.size != sbuf.st_size) {
		if (truncate(pathbuf, argp->attributes.size) < 0)
			goto failure;
		sbuf.st_size = argp->attributes.size;
	}
	if ((argp->attributes.atime.seconds != -1 &&
	     argp->attributes.atime.seconds != sbuf.st_atime) ||
	    (argp->attributes.mtime.seconds != -1 &&
	     argp->attributes.mtime.seconds != sbuf.st_mtime)) {
		struct timeval tvp[2];
		tvp[0].tv_sec = argp->attributes.atime.seconds;
		tvp[0].tv_usec = argp->attributes.atime.useconds;
		tvp[1].tv_sec = argp->attributes.mtime.seconds;
		tvp[1].tv_usec = argp->attributes.mtime.useconds;
		if (utimes(pathbuf, tvp) < 0)
			goto failure;
		if (argp->attributes.atime.seconds != -1)
			sbuf.st_atime = argp->attributes.atime.seconds;
		if (argp->attributes.mtime.seconds != -1)
			sbuf.st_mtime = argp->attributes.mtime.seconds;
	}
	if (argp->attributes.mode != -1
	   && (argp->attributes.mode & 07777) != (sbuf.st_mode & 07777)) {
		if (chmod(pathbuf, argp->attributes.mode) < 0)
			goto failure;
		sbuf.st_mode = (sbuf.st_mode & S_IFMT)
			| (argp->attributes.mode & 07777);
	}
	status = fh_compose(&(argp->where),
		&(result.diropres.diropres_u.diropres.file), &sbp,
		tmpfd, CREATE_OMODE);
	if (status != NFS_OK)
		goto failure;
	status = getattr(&(result.diropres.diropres_u.diropres.file),
		&(result.diropres.diropres_u.diropres.attributes),
		sbp);
	if (status != NFS_OK)
		goto failure;
	dprintf(1, "\tnew_fh = %s\n",
		fh_pr(&(result.diropres.diropres_u.diropres.file)));
	if (kflag){
	  tmp.name=h->path; tmp.mode=1;
	  res.remote=remote; res.work=work; res.dummy=dummy;
	  strcpy(remote,""); strcpy(work,"");
	  cs=callrpc("localhost",ADM_PROGRAM,ADM_VERSION,ADMPROC_LOOKUP,xdr_sfs_lookupargs,&tmp,xdr_sfs_lookupres,&res);
	  if (cs!=0) {
	    clnt_perrno(cs);
	    syslog(LOG_DAEMON,"fh_compose:unable to connect to mountd.");
	    /*fd_inactive(fdd);*/
	    return NFSERR_IO;
	  }
	  strcpy(pathtmp,res.work);
	  if (pathtmp[strlen(pathtmp)-1]!='/') strcat(pathtmp,"/");
	  if (*(strstr(tmp.name,res.dummy)+strlen(res.dummy))!='/') {
	    strcat(pathtmp,"/"); strcat(pathtmp,argp->where.name);
	  }
	  else
	    strcat(pathtmp,argp->where.name);
	  eattr.file=pathtmp;
	  eattr.mode=7;
	  setextat(&eattr);
	}
	return (status);

failure:
	dprintf(1, "\tcreate failed -- errno returned=%d.\n", errno);
	if (tmpfd != -1)
		close(tmpfd);
	return (nfs_errno());
}

#undef CREATE_OMODE

int nfsd_nfsproc_remove_2(argp)
diropargs *argp;
{
  nfsstat status;
  fhcache *h;
  uid_t uid;
  char *cname;
  int kflag;
#ifdef BOF
  syslog(LOG_DAEMON,"remove_2");
#endif
  if ((h=fh_find((svc_fh *)&argp->dir,0))==NULL)
    return NFSERR_STALE;
  kflag=IS_CRYPTED(h->extended);
  if (kflag) {
    uid=geteuid();
    cname=encryptname(argp->name,uid);
    if (cname==NULL) {
#ifdef DEBUG
      syslog(LOG_DAEMON,"Failed in encryptname, maybe user have to sfslogin");
#endif
      return NFSERR_IO;
    }
    free(argp->name);
    argp->name=cname;
  }
  status = build_path(pathbuf, argp);
  if (status != NFS_OK)
    return ((int) status);
  
  dprintf(1, "\tfullpath='%s'\n", pathbuf);
  
  status = check_ro_attrib(client_authenticate, svc_rqstp, pathbuf, cp);
  if (status != NFS_OK)
    return (status);
  
  /* Remove the file handle from our cache. */
  fh_remove(pathbuf);
  
  if (unlink(pathbuf) != 0)
    return (nfs_errno());
  else
    return (NFS_OK);
}

int nfsd_nfsproc_rename_2(argp)
renameargs *argp;
{
  nfsstat status;
  int kflag1,kflag2;
  char *cname;
  uid_t uid;
  fhcache *h1,*h2;
#ifdef BOF
  syslog(LOG_DAEMON,"rename_2");
#endif
  if ((h1=fh_find((svc_fh *)&argp->from.dir,0))==NULL)
    return NFSERR_STALE;
  kflag1=IS_CRYPTED(h1->extended);
  if (kflag1) {
    uid=geteuid();
    cname=encryptname(argp->from.name,uid);
    if (cname==NULL) {
#ifdef DEBUG
      syslog(LOG_DAEMON,"Failed in encryptname, maybe user have to sfslogin");
#endif
      return NFSERR_IO;
    }  
    free(argp->from.name);
    argp->from.name=cname;
  }    
  status = build_path(pathbuf, &argp->from);
  if (status != NFS_OK)
    return ((int) status);
  if ((h2=fh_find((svc_fh *)&argp->to.dir,0))==NULL)
    return NFSERR_STALE;
  kflag2=IS_CRYPTED(h2->extended);
  if (kflag2) {
    uid=geteuid();
    cname=encryptname(argp->to.name,uid);
    if (cname==NULL) {
#ifdef DEBUG
      syslog(LOG_DAEMON,"Failed in encryptname, maybe user have to sfslogin");
#endif
      return NFSERR_IO;
    }  
    free(argp->to.name);
    argp->to.name=cname;
  }    
  status = build_path(pathbuf_1, &argp->to);
  if (status != NFS_OK)
    return ((int) status);
  
  dprintf(1, "\tpathfrom='%s' pathto='%s'\n", pathbuf, pathbuf_1);
  
  status = check_ro_attrib(client_authenticate, svc_rqstp, pathbuf, cp);
  if (status != NFS_OK)
    return (status);
  
  /* Remove any file handle from our cache. */
  fh_remove(pathbuf);
  fh_remove(pathbuf_1);
  
  if (rename(pathbuf, pathbuf_1) != 0)
    return (nfs_errno());
  
  return (NFS_OK);
}

int nfsd_nfsproc_link_2(argp)
linkargs *argp;
{
	nfsstat status;
	char *path;
	int kflag;
	uid_t uid;
	char *cname;
	fhcache *h;
#ifdef BOF
  syslog(LOG_DAEMON,"link_2");
#endif
	if ((path = fh_path(&(argp->from), &status)) == 0)
		return (NFSERR_STALE);

	if ((h=fh_find((svc_fh *)&argp->to.dir,0))==NULL)
	  return NFSERR_STALE;
	kflag=IS_CRYPTED(h->extended);
	if (kflag) {
	  uid=geteuid();
	  cname=encryptname(argp->to.name,uid);
	  if (cname==NULL) {
#ifdef DEBUG
	    syslog(LOG_DAEMON,"Failed in encryptname, maybe user have to sfslogin");
#endif
	    return NFSERR_IO;
	  }  
	  free(argp->to.name);
	  argp->to.name=cname;
	}
	status = build_path(pathbuf_1, &argp->to);
	if (status != NFS_OK)
		return ((int) status);

	dprintf(1, "\tpathfrom='%s' pathto='%s'\n", path, pathbuf_1);

	status = check_ro_attrib(client_authenticate, svc_rqstp, pathbuf, cp);
	if (status != NFS_OK)
		return (status);

	if (link(path, pathbuf_1) != 0)
		return (nfs_errno());
	return (NFS_OK);
}

int nfsd_nfsproc_symlink_2(argp)
symlinkargs *argp;
{
  nfsstat status;
  fhcache *from,*to;
  uid_t uid;
  int kflag1;
  char *cname;
#ifdef BOF
  syslog(LOG_DAEMON,"symlink_2");
#endif
  if ((from=fh_find((svc_fh *)&argp->from,0))==NULL)
    return NFSERR_STALE;
  kflag1=IS_CRYPTED(from->extended);
  if (kflag1) {
    uid=geteuid();
    cname=encryptname(argp->from.name,uid);
    if (cname==NULL) {
#ifdef DEBUG
      syslog(LOG_DAEMON,"Failed in encryptname, maybe user have to sfslogin");
#endif
      return NFSERR_IO;
    }
    free(argp->from.name);
    argp->from.name=cname;
  }
  status = build_path(pathbuf, &argp->from);
  if (status != NFS_OK)
    return ((int) status);
  
  dprintf(1, "\tstring='%s' filename='%s'\n", argp->to, pathbuf);
  
  status = check_ro_attrib(client_authenticate, svc_rqstp, pathbuf, cp);
  if (status != NFS_OK)
    return (status);
 
  /*
   * Ignore the attributes, as the NFS version 2 documentation says
   * "On UNIX servers the attributes are never used...",
   */
  if (symlink(argp->to, pathbuf) != 0)
    return (nfs_errno());
  return (NFS_OK);
}

int nfsd_nfsproc_mkdir_2(argp)
createargs *argp;
{
  nfsstat status;
  struct stat sbuf;
  struct stat *sbp = &sbuf;
  nfsstat st;
  fhcache *h;
  int kflag;
  uid_t uid;
  char *cname;
#ifdef BOF
  syslog(LOG_DAEMON,"mkdir_2");
#endif
  if ((h=fh_find((svc_fh *)&argp->where,0)) == NULL)
    return NFSERR_STALE;
  kflag=IS_CRYPTED(h->extended);
  if (kflag) {
    uid=geteuid();
    cname=encryptname(argp->where.name,uid);
    if (cname==NULL) {
#ifdef DEBUG
      syslog(LOG_DAEMON,"Failed in encryptname, maybe user have to sfslogin");
#endif
      return NFSERR_IO;
    }
    free(argp->where.name);
    argp->where.name=cname;
  }
  status = build_path(pathbuf, &argp->where);
  if (status != NFS_OK)
    return ((int) status);
  
  dprintf(1, "\tfullpath='%s'\n", pathbuf);
  
  status = check_ro_attrib(client_authenticate, svc_rqstp, pathbuf, cp);
  if (status != NFS_OK)
    return (status);
  
  if (mkdir(pathbuf, argp->attributes.mode) != 0)
    return (nfs_errno());
  status = fh_compose(&(argp->where),
		      &(result.diropres.diropres_u.diropres.file), &sbp,
		      -1, -1);
  if (status != NFS_OK)
    return ((int) status);
  
  /*
   * Set up the correct ownership.  As with create, almost all mkdir
   * requests from the current Sun implementation fail to include
   * explicit uid/gid pairs for creates, so we have to use info
   * from the request authication (now done during dispatch).
   */
  {
    int target_uid = argp->attributes.uid;
    int target_gid = argp->attributes.gid;
    
    if ((target_uid != -1 && sbuf.st_uid != target_uid) ||
	(target_gid != -1 && sbuf.st_gid != target_gid))
      if (lchown(pathbuf, target_uid, target_gid) != 0)
	return (nfs_errno());
  }
  
  /* Note that the spb buffer is now invalid! */
  status = getattr(&(result.diropres.diropres_u.diropres.file),
		   &(result.diropres.diropres_u.diropres.attributes), NULL);
  if (status == NFS_OK)
    dprintf(1, "\tnew_fh = %s\n",
	    fh_pr(&(result.diropres.diropres_u.diropres.file)));
  return ((int) status);
}

int nfsd_nfsproc_rmdir_2(argp)
diropargs *argp;
{
  nfsstat status;
  fhcache *h;
  char *cname;
  int kflag;
  uid_t uid;
#ifdef BOF
  syslog(LOG_DAEMON,"rmdir_2");
#endif
  if ((h=fh_find((svc_fh *)&argp->dir,0)) == NULL)
    return NFSERR_STALE;
  kflag=IS_CRYPTED(h->extended);
  if (kflag) {
    uid=geteuid();
    cname=encryptname(argp->name,uid);
    if (cname==NULL) {
#ifdef DEBUG
      syslog(LOG_DAEMON,"Failed in encryptname, maybe user have to sfslogin");
#endif
      return NFSERR_IO;
    }
    free(argp->name);
    argp->name=cname;
  }
  status = build_path(pathbuf, argp);
  if (status != NFS_OK)
    return ((int) status);
  
  dprintf(1, "\tfullpath='%s'\n", pathbuf);
  
  status = check_ro_attrib(client_authenticate, svc_rqstp, pathbuf, cp);
  if (status != NFS_OK)
    return (status);
  
  /* Remove that file handle from our cache. */
  fh_remove(pathbuf);
  
  if (rmdir(pathbuf) != 0)
    return (nfs_errno());
  
  return (NFS_OK);
}

/* More Mark Shand code. */
static int dpsize(dp)
struct dirent *dp;
{
#define DP_SLOP	16
#define MAX_E_SIZE sizeof(entry) + NAME_MAX + DP_SLOP
	return (sizeof(entry) + NLENGTH(dp) + DP_SLOP);
}

int nfsd_nfsproc_readdir_2(argp)
readdirargs *argp;
{
	static readdirres oldres;
	entry **e;
	long dloc;
	DIR *dirp;
	struct dirent *dp;
	struct stat sbuf;
	int res_size;
	fhcache *h;
	int hideit;
	uid_t uid;
	int kflag;
	char *tmp;
#ifdef BOF
  syslog(LOG_DAEMON,"readdir_2");
#endif
	/* Free the previous result, since it has 'malloc'ed strings.  */
	xdr_free(xdr_readdirres, (caddr_t) & oldres);
	if ((h = fh_find((svc_fh *) &(argp->dir), 0)) == NULL)
		return (NFSERR_STALE);
	hideit = (!re_export && (h->flags & FHC_NFSMOUNTED));
	kflag=IS_CRYPTED(h->extended);
	uid=geteuid();
	/* This code is from Mark Shand's version */
	errno = 0;
	if (lstat(h->path, &sbuf) < 0 || !(S_ISDIR(sbuf.st_mode)))
		return (NFSERR_NOTDIR);
	if ((dirp = opendir(h->path)) == NULL)
		return ((errno ? nfs_errno() : NFSERR_NAMETOOLONG));

	res_size = 0;
	memcpy(&dloc, argp->cookie, sizeof(dloc));
	if (dloc != 0)
		seekdir(dirp, ntohl(dloc));
	e = &(result.readdirres.readdirres_u.reply.entries);
	while (((res_size + MAX_E_SIZE) < argp->count
		|| e == &(result.readdirres.readdirres_u.reply.entries))
	       && (dp = readdir(dirp)) != NULL) {
		if (hideit && strcmp(dp->d_name, ".") != 0
		    && strcmp(dp->d_name, "..") != 0) {
			dp = NULL;
			break;
		}
		if ((*e = (entry *) malloc(sizeof(entry))) == NULL)
			mallocfailed();
		(*e)->fileid = pseudo_inode(dp->d_ino, sbuf.st_dev);
		if (kflag && strcmp(dp->d_name,".")!=0 && strcmp(dp->d_name,"..")!=0) {
		  tmp=decryptname(dp->d_name,uid);
		  if (tmp==NULL) {
		    syslog(LOG_DAEMON,"e' colpa di anidello");
		    return NFSERR_IO;
		  }
		  dp->d_reclen=strlen(tmp);
		  strcpy(dp->d_name,tmp);
		  free(tmp);
#if defined(DIRENT) || defined(_POSIX_VERSION)
		  ;
#else
		  dp->d_namlen=strlen(dp->d_name);
#endif
		} 
		if (((*e)->name = malloc(NLENGTH(dp) + 1)) == NULL)
		  mallocfailed();
		strcpy((*e)->name, dp->d_name);
		dloc = htonl(telldir(dirp));
		memcpy(((*e)->cookie), &dloc, sizeof(nfscookie));
		e = &((*e)->nextentry);
		res_size += dpsize(dp);
	}
	*e = NULL;
	result.readdirres.readdirres_u.reply.eof = (dp == NULL);
	(void) closedir(dirp);
	oldres = result.readdirres;
	return (result.readdirres.status);
}

int nfsd_nfsproc_getextat_2(argp)
getextatargs * argp;
{
  static sfs_lookupargs tmp;
  static sfs_lookupres ret;
  static char remote[NFS_MAXPATHLEN+1],work[NFS_MAXPATHLEN+1],dummy[NFS_MAXPATHLEN+1];
  static char host[NFS_MAXPATHLEN+1],*dir,call[NFS_MAXPATHLEN+1];
  static geteattrargs in;
  static unsigned int out;
  static char tmpname[NFS_MAXPATHLEN+1],tmpbuff[NFS_MAXPATHLEN+1];
  int fd;
  enum clnt_stat cs;
  static res res;
  char * p, *t, *cname;
  int kflag=0,cont;
#ifdef BOF
  syslog(LOG_DAEMON,"getextat_2");
#endif  
  tmp.name=argp->file;
  tmp.mode=0;
  ret.remote=remote;
  ret.work=work;
  ret.dummy=dummy;
  strcpy(remote,"");
  strcpy(work,"");
  cs=callrpc("localhost",ADM_PROGRAM,ADM_VERSION,ADMPROC_LOOKUP,xdr_sfs_lookupargs,&tmp,xdr_sfs_lookupres,&ret);
  if (cs != 0)  {
    clnt_perrno(cs);
    syslog(LOG_DAEMON,"get_extattr: unable to connect to mountd.");
    return NFSERR_IO;
  }
  if (strcmp(remote,"")==0)
    return -4;
  strncpy(host,remote,strchr(ret.remote,':')-ret.remote);
  dir=strchr(ret.remote,':')+1;
  strcpy(call,dir);
  if (call[strlen(call)-1]!='/') strcat(call,"/");
  if (*(strstr(argp->file,ret.work)+strlen(ret.work))!='/')
    strcat(call,strstr(argp->file,ret.work)+strlen(ret.work));
  else
    strcat(call,strstr(argp->file,ret.work)+strlen(ret.work)+1);
  bzero(tmpbuff,NFS_MAXPATHLEN+1);
  strncpy(tmpbuff,call,strchr(call+1,'/')+1-call);
  p=call+strlen(tmpbuff);
  kflag=0;
  cont=1;
  do{
    t=strchr(p,'/');
    bzero(tmpname,NFS_MAXPATHLEN+1);
    if (t!= NULL)
      strncpy(tmpname,p,t-p);
    else {
      strcpy(tmpname,p);
      cont=0;
    }
    if (kflag) {
      cname=encryptname(tmpname,argp->uid);
      if (cname==NULL) {
#ifdef DEBUG
	syslog(LOG_DAEMON,"encryptname failed");
#endif
	return -5;
      }
      strcat(tmpbuff,cname);
      free(cname);
    } else {
      strcat(tmpbuff,tmpname);
    }
    in.filename=tmpbuff;
    cs=callrpc(host,XATTR_PROGRAM,XATTR_VERSION,XATTRPROC_GETEATTR,xdr_geteattrargs,&in,xdr_res,&res);
    if (cs != 0)  {
      clnt_perrno(cs);
      syslog(LOG_DAEMON,"get_extattr: unable to connect to remote host");
      return NFSERR_IO;
    }
    kflag=IS_CRYPTED(res.mode);
    strcat(tmpbuff,"/");
    p=call+strlen(tmpbuff);
  } while (cont);
  fd_inactive(0);
  return res.mode;
}
int nfsd_nfsproc_setextat_2(argp)
setextatargs * argp;
{
  static sfs_lookupargs tmp;
  static sfs_lookupres ret;
  static char remote[NFS_MAXPATHLEN+1],work[NFS_MAXPATHLEN+1],dummy[NFS_MAXPATHLEN+1];
  static char host[NFS_MAXPATHLEN+1],*dir,call[NFS_MAXPATHLEN+1];
  static geteattrargs eain;
  static unsigned int ea;
  static seteattrargs in;
  static unsigned int out;
  static char tmpnm[NFS_MAXPATHLEN+1],tmpbuff[NFS_MAXPATHLEN+1];
  static res res;
  struct stat st;
  int fdi,fdo,bytes;
  char tmpname[NFS_MAXPATHLEN+1],buffer[1024];
  unsigned long offset=0L;
  char input[NFS_MAXPATHLEN+1];
  enum clnt_stat cs;
  int kflag=0,cont;
  char * p, *t, *cname;
  uid_t uid=argp->uid;
#ifdef BOF
  syslog(LOG_DAEMON,"setextat_2");
#endif
  tmp.name=argp->file;
  tmp.mode=0;
  ret.remote=remote;
  ret.work=work;
  ret.dummy=dummy;
  strcpy(remote,"");
  strcpy(work,"");
  cs=callrpc("localhost",ADM_PROGRAM,ADM_VERSION,ADMPROC_LOOKUP,xdr_sfs_lookupargs,&tmp,xdr_sfs_lookupres,&ret);
  if (cs != 0)  {
    clnt_perrno(cs);
    syslog(LOG_DAEMON,"set_extattr: unable to connect to mountd");
    return NFSERR_IO;
  }
  if (strcmp(remote,"")==0)
    return -4;
  strncpy(host,remote,strchr(ret.remote,':')-ret.remote);
  dir=strchr(ret.remote,':')+1;
  strcpy(call,dir);
  if (call[strlen(call)-1]!='/') strcat(call,"/");
  if (*(strstr(argp->file,ret.work)+strlen(ret.work))!='/')
    strcat(call,strstr(argp->file,ret.work)+strlen(ret.work));
  else
    strcat(call,strstr(argp->file,ret.work)+strlen(ret.work)+1);
  bzero(tmpbuff,NFS_MAXPATHLEN+1);
  strncpy(tmpbuff,call,strchr(call+1,'/')+1-call);
  p=call+strlen(tmpbuff);
  kflag=0;
  cont=1;
  do{
    t=strchr(p,'/');
    bzero(tmpnm,NFS_MAXPATHLEN+1);
    if (t!= NULL)
      strncpy(tmpnm,p,t-p);
    else {
      strcpy(tmpnm,p);
      cont=0;
    }
    if (kflag) {
      cname=encryptname(tmpnm,argp->uid);
      if (cname==NULL) {
#ifdef DEBUG
	syslog(LOG_DAEMON,"encryptname failed");
#endif
	return -5;
      }
      strcat(tmpbuff,cname);
      free(cname);
    } else {
      strcat(tmpbuff,tmpnm);
    }
    in.filename=tmpbuff;
    cs=callrpc(host,XATTR_PROGRAM,XATTR_VERSION,XATTRPROC_GETEATTR,xdr_geteattrargs,&in,xdr_res,&res);
    if (cs != 0)  {
      clnt_perrno(cs);
      syslog(LOG_DAEMON,"get_extattr: unable to connect to remote host");
      return NFSERR_IO;
    }
    kflag=IS_CRYPTED(res.mode);
    if (cont)
      strcat(tmpbuff,"/");
    p=call+strlen(tmpbuff);
  } while (cont);
  ea=res.mode;
  if (ea==argp->mode)
    return 0;
  strcpy(input,dummy);
  if (input[strlen(input)-1]!='/') 
    strcat(input,"/");
  if (*(strstr(tmpbuff,remote+strlen(host)+1)+strlen(remote+strlen(host)+1))!='/')
    strcat(input,strstr(tmpbuff,remote+strlen(host)+1)+strlen(remote+strlen(host)+1));
  else
    strcat(input,strstr(tmpbuff,remote+strlen(host)+1)+strlen(remote+strlen(host)+1)+1);
  if (stat(input,&st)) {
    return NFSERR_NOENT;
  }
  if (S_ISDIR(st.st_mode)) { 
    struct dirent *dt;
    int nd=0;
    DIR *dir;
    /* Changing attributes to a directory */
    dir=opendir(input);
    while ((dt=readdir(dir))!=NULL)
      if (strcmp(dt->d_name,".")!=0 && strcmp(dt->d_name,"..")!=0)
	  nd++;
    rewinddir(dir);
    while (nd>0) {
      dt=readdir(dir);
      if (strcmp(dt->d_name,".")!=0 && strcmp(dt->d_name,"..")!=0) {
	if (IS_CRYPTED(argp->mode))
	  cname=encryptname(dt->d_name,uid);
	else
	  cname=decryptname(dt->d_name,uid);
	if (cname==NULL) {
#ifdef DEBUG
	  syslog(LOG_DAEMON,"encryptname failed");
#endif
	  return NFSERR_PERM;
	}
	strcpy(tmpnm,input);
	strcat(tmpnm,"/");
	strcat(tmpnm,dt->d_name);
	strcpy(call,input);
	strcat(call,"/");
	strcat(call,cname);
	free(cname);
	rename(tmpnm,call);
	nd--;
      }
    }
    closedir(dir);
  } else {
    /*  uid=st.st_uid; */
    strcpy(tmpname,input);
    strcat(tmpname,".$$$");
    if ((fdi=open(input,O_RDONLY))<0) {
      syslog(LOG_DAEMON,"set_extattr: unable to open file");
      return NFSERR_IO;
    }
    if ((fdo=open(tmpname,O_WRONLY|O_CREAT|O_TRUNC),st.st_mode)<0) {
      syslog(LOG_DAEMON,"set_extattr: unable to open file");
      return NFSERR_IO;
    }
    fchown(fdo,st.st_uid,st.st_gid);
    
    offset=0L;
    while((bytes=read(fdi,buffer,1024))){
      if (IS_CRYPTED(ea)) {/* Il file deve essere decrittografato */     
	if (sfs_decrypt(buffer,bytes,offset,uid)) {
	  syslog(LOG_DAEMON,"errore nella decrypt");
	  return NFSERR_IO;
	}
      } else { 
	if (sfs_crypt(buffer,bytes,offset,uid)) {
	  syslog(LOG_DAEMON,"errore nella crypt");
	  return NFSERR_IO;
	}
      }
      offset+=bytes;
      write(fdo,buffer,bytes);
    }
    fchmod(fdo,st.st_mode);
    close(fdo); close(fdi);
    unlink(input);
    rename(tmpname,input);
  }
  in.filename=tmpbuff;
  in.mode=argp->mode;
  cs=callrpc(host,XATTR_PROGRAM,XATTR_VERSION,XATTRPROC_SETEATTR,xdr_seteattrargs,&in,xdr_res,&res);
  if (cs != 0)  {
    clnt_perrno(cs);
    syslog(LOG_DAEMON,"set_extattr: unable to connect to remote host");
    return NFSERR_IO;
  }
  raise(SIGHUP);
  return res.mode;
}
/*
 * Only reports free space correctly for the filesystem that the
 * mount point is on.  Actually it will work fine for any file
 * handle (e.g. sub mounts) but the NFS spec calls for root_fh
 * to be used by the client when calling this.
 */
int nfsd_nfsproc_statfs_2(argp)
nfs_fh *argp;
{
	nfsstat status;
	char *path;
	struct fs_usage fs;
#ifdef BOF
  syslog(LOG_DAEMON,"statfs_2");
#endif
	if ((path = fh_path(argp, &status)) == NULL)
		return (NFSERR_STALE);

	if (get_fs_usage(path, NULL, &fs) < 0)
		return (nfs_errno());
	result.statfsres.status = NFS_OK;
	result.statfsres.statfsres_u.reply.tsize = 8*1024;
	result.statfsres.statfsres_u.reply.bsize = 512;
	result.statfsres.statfsres_u.reply.blocks = fs.fsu_blocks;
	result.statfsres.statfsres_u.reply.bfree = fs.fsu_bfree;
	result.statfsres.statfsres_u.reply.bavail = fs.fsu_bavail;

	return (NFS_OK);
}


static int makesock(port, proto, socksz)
int port;
int proto;
int socksz;
{
	struct sockaddr_in sin;
	int s;
	int sock_type;

	sock_type = (proto == IPPROTO_UDP) ? SOCK_DGRAM : SOCK_STREAM;
	s = socket(AF_INET, sock_type, proto);
	if (s < 0) {
		dprintf(0, "Could not make a socket: %s\n", strerror(errno));
		return (-1);
	}
	memset((char *) &sin, 0, sizeof(sin));
	sin.sin_family = AF_INET;
	sin.sin_addr.s_addr = INADDR_ANY;
	sin.sin_port = htons(port);

	{
		int val = 1;

		if (setsockopt(s, SOL_SOCKET, SO_REUSEADDR, &val, sizeof(val)) < 0)
			dprintf(0, "setsockopt failed: %s\n", strerror(errno));
	}

#ifdef SO_SNDBUF
	{
		int sblen, rblen;

		/* 1024 for rpc & transport overheads */
		sblen = rblen = socksz + 1024;
		if (setsockopt(s, SOL_SOCKET, SO_SNDBUF, &sblen, sizeof sblen) < 0 ||
		    setsockopt(s, SOL_SOCKET, SO_RCVBUF, &rblen, sizeof rblen) < 0)
			dprintf(0, "setsockopt failed: %s\n", strerror(errno));
	}
#endif				/* SO_SNDBUF */

	if (bind(s, (struct sockaddr *) &sin, sizeof(sin)) == -1) {
		dprintf(0, "Could not bind name to socket: %s\n", strerror(errno));
		return (-1);
	}
	return (s);
}

/* This is taken from an rpcgen generated service file. */
static void closedown(sig)
int sig;
{
	(void) signal(sig, closedown);
	if (_rpcsvcdirty == 0) {
		extern fd_set svc_fdset;
		static int size;
		int i, openfd;

		if (_rpcfdtype == SOCK_DGRAM)
			exit(0);
		if (size == 0) {
			size = getdtablesize();
		}
		for (i = 0, openfd = 0; i < size && openfd < 2; i++)
			if (FD_ISSET(i, &svc_fdset))
				openfd++;
		if (openfd <= 1)
			exit(0);
	}
	(void) alarm(_RPCSVC_CLOSEDOWN);
}

dump(int sign)
{
  char buff[1024];
  sec=msec/1000000L; msec=msec % 1000000L;
  sprintf(buff,"tempo utilizzato fino ad ora %lu:%lu\n",sec,msec);
  syslog(LOG_DAEMON,buff);
  sec=0;msec=0;
  signal(SIGUSR2,dump);
}

int main(argc, argv)
int argc;
char *argv[];
{
	int c,fd;
	struct sockaddr_in saddr;
	int addr_size;
	SVCXPRT *transp;
	int nfs_socket;
	char *auth_file = NULL;
	FILE *pidfile;

	re_export=1; /* for mount purpouse */
	if((log_fd=fopen("/tmp/log_nfs","w"))==NULL){
		perror("Errore in open log");
		exit(9);
	}
	/*
         * This code uses the RPC library functions in exactly the
         * same way a regular RPC application would.
         */
	nfs_socket = 0;
	_rpcfdtype = 0;
	if (getsockname(0, (struct sockaddr *) &saddr, &addr_size) == 0) {
		int ssize = sizeof(int);
		if (saddr.sin_family != AF_INET)
			exit(1);
		if (getsockopt(0, SOL_SOCKET, SO_TYPE,
			       (char *) &_rpcfdtype, &ssize) < 0)
			exit(1);
		_rpcpmstart = 1;
	} else
		pmap_unset(NFS_PROGRAM, NFS_VERSION);

		if (_rpcfdtype == 0 || _rpcfdtype == SOCK_DGRAM) {
		if (_rpcfdtype == 0 &&
		    (nfs_socket = makesock(NFS_PORT, IPPROTO_UDP, NFS_MAXDATA)) < 0) {
			fprintf(stderr, "nfsd: could not make a UDP socket.\n");
			exit(1);
		}
		transp = svcudp_create(nfs_socket);
		if (transp == NULL) {
			fprintf(stderr, "nfsd: cannot create UDP service.\n");
			exit(1);
		}
		if (!svc_register(transp, NFS_PROGRAM, NFS_VERSION, nfs_dispatch,
				  IPPROTO_UDP)) {
			fprintf(stderr,
				"unable to register(NFS_PROGRAM, NFS_VERSION, UDP).\n");
			exit(1);
		}
	}
	if (_rpcfdtype == 0 || _rpcfdtype == SOCK_STREAM) {
		if (_rpcfdtype == 0 &&
		    (nfs_socket = makesock(NFS_PORT, IPPROTO_TCP, NFS_MAXDATA)) < 0) {
			fprintf(stderr, "nfsd: could not make a TCP socket.\n");
			exit(1);
		}
		transp = svctcp_create(nfs_socket, 0, 0);
		if (transp == NULL) {
			fprintf(stderr, "nfsd: cannot create TCP service.\n");
			exit(1);
		}
		if (!svc_register(transp, NFS_PROGRAM, NFS_VERSION, nfs_dispatch,
				  IPPROTO_TCP)) {
			fprintf(stderr,
				"unable to register(NFS_PROGRAM, NFS_VERSION, TCP).\n");
			exit(1);
		}
	}

	program_name = argv[0];
	opterr = 0;
	while ((c = getopt_long(argc, argv, "df:hnprv", longopts, NULL)) != EOF)
		switch (c) {
		case 'h':
			usage(stdout, 0);
			break;
		case 'd':
			toggle_logging(0);
			break;
		case 'f':
			auth_file = optarg;
			break;
		case 'n':
			allow_non_root = 1;
			break;
		case 'p':
			promiscuous = 1;
			break;
		case 'r':
			re_export = 1;
			break;
		case 'v':
			printf("%s\n", version);
			exit(0);
		case 0:
			break;
		case '?':
		default:
			usage(stderr, 1);
		}

	/* No more arguments allowed. */
	if (optind != argc)
		usage(stderr, 1);

	/* We first fork off a child. */
	if ((c = fork()) > 0)
		exit(0);
	if (c < 0) {
		fprintf(stderr, "nfsd: cannot fork: %s\n", strerror(errno));
		exit(-1);
	}

	/* Saving pid file */
	if ((pidfile=fopen("/etc/tcfsd.pid", "w+")) == NULL)
	  {
	    fprintf (stderr, "Error creating pid file!\n");
	    exit (1);
	  }

	fprintf (pidfile, "%d\n", getpid());
	fclose (pidfile);

	/* Now we remove ourselves from the foreground. */
	(void) close(0);
	(void) close(1);
	(void) close(2);
#ifdef HAVE_SETSID
	setsid();
#else
	{
		int fd;

		if ((fd = open("/dev/tty", O_RDWR)) >= 0) {
			(void) ioctl(fd, TIOCNOTTY, (char *) NULL);
			(void) close(fd);
		}
	}
#endif
	/* Initialize logging. */
	log_open("nfsd");

	/* Initialize the FH module. */
	fh_init();

	/* Initialize the AUTH module. */
	auth_init(auth_file);

	/* Enable the LOG toggle with a signal. */
	signal(SIGUSR1, toggle_logging);
	signal(SIGUSR2, dump);

	if (_rpcpmstart) {
		signal(SIGALRM, closedown);
		alarm(_RPCSVC_CLOSEDOWN);
	}
	/* Run the SFS server. */
	signal(SIGIO,receivekey);
	if (initkeysock()) {
	  syslog(LOG_DAEMON,"Init error\n");
	  exit(1);
	}
	svc_run();

	dprintf(0, "Oh no Mr. Bill... nfs_server() returned!\n");
	exit(1);
}

static void usage(fp, n)
FILE *fp;
int n;
{
	fprintf(fp, "Usage: %s [-dhnpv] [-f exports-file]\n", program_name);
	fprintf(fp, "       [--debug] [--help] [--allow-non-root]\n");
	fprintf(fp, "       [--promiscuous] [--version]\n");
	fprintf(fp, "       [--exports-file=file]\n");
	exit(n);
}

int setextat(argp)
setextatargs * argp;
{
  static sfs_lookupargs tmp;
  static sfs_lookupres ret;
  static char remote[NFS_MAXPATHLEN+1],work[NFS_MAXPATHLEN+1],dummy[NFS_MAXPATHLEN+1];
  static char host[NFS_MAXPATHLEN+1],*dir,call[NFS_MAXPATHLEN+1];
  static seteattrargs in;
  static unsigned int out;
  enum clnt_stat cs;
  static res res;
#ifdef BOF
  syslog(LOG_DAEMON,"setextat");
#endif
  tmp.name=argp->file;
  tmp.mode=0;
  ret.remote=remote;
  ret.work=work;
  ret.dummy=dummy;
  strcpy(remote,"");
  strcpy(work,"");
  cs=callrpc("localhost",ADM_PROGRAM,ADM_VERSION,ADMPROC_LOOKUP,xdr_sfs_lookupargs,&tmp,xdr_sfs_lookupres,&ret);
  if (cs != 0)  {
    clnt_perrno(cs);
    syslog(LOG_DAEMON,"set_extattr: unable to connect to mountd");
    return NFSERR_IO;
  }
  strncpy(host,remote,strchr(ret.remote,':')-ret.remote);
  dir=strchr(ret.remote,':')+1;
  strcpy(call,dir);
  if (call[strlen(call)-1]!='/') strcat(call,"/");
  if (*(strstr(argp->file,ret.work)+strlen(ret.work))!='/')
    strcat(call,strstr(argp->file,ret.work)+strlen(ret.work));
  else
    strcat(call,strstr(argp->file,ret.work)+strlen(ret.work)+1);
  in.filename=call;
  in.mode=argp->mode;
  cs=callrpc(host,XATTR_PROGRAM,XATTR_VERSION,XATTRPROC_SETEATTR,xdr_seteattrargs,&in,xdr_res,&res);
  if (cs != 0)  {
    clnt_perrno(cs);
    syslog(LOG_DAEMON,"set_extattr: unable to connect to remote host");
    return NFSERR_IO;
  }
  return res.mode;
}


int getextat(argp)
getextatargs * argp;
{
  static sfs_lookupargs tmp;
  static sfs_lookupres ret;
  static char remote[NFS_MAXPATHLEN+1],work[NFS_MAXPATHLEN+1],dummy[NFS_MAXPATHLEN+1];
  static char host[NFS_MAXPATHLEN+1],*dir,call[NFS_MAXPATHLEN+1];
  static geteattrargs in;
  static unsigned int out;
  int fd;
  enum clnt_stat cs;
  static res res;
#ifdef BOF
  syslog(LOG_DAEMON,"getextat_2");
#endif  
  tmp.name=argp->file;
  tmp.mode=0;
  ret.remote=remote;
  ret.work=work;
  ret.dummy=dummy;
  strcpy(remote,"");
  strcpy(work,"");
  cs=callrpc("localhost",ADM_PROGRAM,ADM_VERSION,ADMPROC_LOOKUP,xdr_sfs_lookupargs,&tmp,xdr_sfs_lookupres,&ret);
  if (cs != 0)  {
    clnt_perrno(cs);
    syslog(LOG_DAEMON,"get_extattr: unable to connect to mountd.");
    return NFSERR_IO;
  }
  if (strcmp(remote,"")==0)
    return -4;
  strncpy(host,remote,strchr(ret.remote,':')-ret.remote);
  dir=strchr(ret.remote,':')+1;
  strcpy(call,dir);
  if (call[strlen(call)-1]!='/') strcat(call,"/");
  if (*(strstr(argp->file,ret.work)+strlen(ret.work))!='/')
    strcat(call,strstr(argp->file,ret.work)+strlen(ret.work));
  else
    strcat(call,strstr(argp->file,ret.work)+strlen(ret.work)+1);
  in.filename=call;
  cs=callrpc(host,XATTR_PROGRAM,XATTR_VERSION,XATTRPROC_GETEATTR,xdr_geteattrargs,&in,xdr_res,&res);
  if (cs != 0)  {
    clnt_perrno(cs);
    syslog(LOG_DAEMON,"get_extattr: unable to connect to remote host");
    return NFSERR_IO;
  }
  fd_inactive(0);
  return res.mode;
}





























