/*
 * S.F.S. v. 0.5alpha-linux
 *
 * sfscrypt.c:  Crypt and DeCrypt Functions...
 *
 * Authors:	Giuseppe Cattaneo, <cattaneo@udsab.dia.unisa.it>
 *		Giuseppe Persiano, <giuper@udsab.dia.unisa.it>
 *		Andrea Cozzolino, <andcoz@mikonos.dia.unisa.it>
 *		Angelo Celentano, <angcel@mikonos.dia.unisa.it>
 *		Aniello Del Sorbo, <anidel@mikonos.dia.unisa.it>
 *		Ermelindo Mauriello, <ermmau@mikonos.dia.unisa.it>
 *		Raffaele Pisapia, <rafpis@mikonos.dia.unisa.it>
 *
 * Permission to use, copy, and modify this software without fee
 * is hereby granted, provided that this entire notice is included in
 * all copies of any software which is or includes a copy or
 * modification of this software and in all copies of the supporting
 * documentation for such software.
 *
 * This software maybe be used for any purpose provided
 * the above copyright notice is retained.  It is supplied
 * as is, with no warranty expressed or implied.
 *
 */






#include <unistd.h>
#include <string.h>
#include "uid.h"
#include <syslog.h>

#ifndef SECUDEDES
#include "d3des.h"
#endif

#include "defines.h"

#define DESBLOCK	8
#define BLOCKSIZE	1024

void sfs_crypt_1k (char *block, int size, long offset, char *key)
{
	unsigned int i;
	unsigned miniblocks;
	unsigned int bn;
	static char kb[KEYSIZE];		/* block key */
	static char xorkey[KEYSIZE];		/* key XOR block number */
	static char xormblock[DESBLOCK];	/* miniblock XOR previous miniblock */
	static char prevmblock[DESBLOCK];	/* previous miniblock */
	
	bn=(int)(offset/(long)BLOCKSIZE)+1;

#ifdef SECUDEDES
	desinit (DESMETHOD, D3DES);
#endif

	memcpy (xorkey, key, KEYSIZE);

	for (i=0;i<KEYSIZE;i++)
		*(xorkey+i)=*(key+i)^(char)bn;

	memcpy (kb, block, KEYSIZE);

#ifdef SECUDEDES
	setkey_ (key);
	endes (kb);
	setkey_ (xorkey);
	endes (block);
	setkey_ (kb);
#else
	deskey (key, EN0);
	desd3 (kb,kb);
	deskey (xorkey, EN0);
	desd3 (block, block);
	deskey (kb, EN0);
#endif

	memcpy (prevmblock, block+DESBLOCK, DESBLOCK);

#ifdef SECUDEDES
	endes (block+DESBLOCK);
#else
	desd3 (block+DESBLOCK, block+DESBLOCK);
#endif
	i=2;
	miniblocks=size/DESBLOCK;

	while (i<miniblocks)
	{
		int j;

		for (j=0;j<DESBLOCK;j++)
		{
			*(xormblock+j)=*(block+DESBLOCK*i+j)^*(prevmblock+j);
			*(prevmblock+j)=*(block+DESBLOCK*i+j);
		}

#ifdef SECUDEDES
		endes (xormblock);
#else
		desd3 (xormblock, xormblock);
#endif

		for (j=0;j<DESBLOCK;j++)
			*(block+DESBLOCK*i+j)=*(xormblock+j);
		i++;
	}
	/* The last n = size%DESBLOCK (<8) bytes are left clear!! */
		
#ifdef SECUDEDES
	desdone ();
#endif
}

void sfs_decrypt_1k (char *block, int size, long offset, char *key)
{
	unsigned int i;
	unsigned int bn;
	unsigned int miniblocks;
	static char kb[KEYSIZE];		/* key block */
	static char xorkey[KEYSIZE];		/* key XOR block number */
	static char xormblock[DESBLOCK];	/* miniblock OR previous miniblock */
	static char prevmblock[DESBLOCK];	/* previous miniblock */

	bn=(int)(offset/(long)BLOCKSIZE)+1;

#ifdef SECUDEDES
	desinit (DESMETHOD, D3DES);
#endif

	memcpy (xorkey, key, KEYSIZE);
	
	for (i=0;i<KEYSIZE;i++)
		*(xorkey+i)=*(key+i)^(char)bn;

#ifdef SECUDEDES
	setkey_ (xorkey);
	dedes (block);
#else
	deskey (xorkey, DE1);
	desd3 (block, block);
#endif

	memcpy (kb, block, KEYSIZE);

#ifdef SECUDEDES
	setkey_ (key);
	endes (kb);
	setkey_ (kb);
	dedes (block+DESBLOCK);
#else
	deskey (key, EN0);
	desd3 (kb, kb);
	deskey (kb, DE1);
	desd3 (block+DESBLOCK, block+DESBLOCK);
#endif

	memcpy (prevmblock, block+DESBLOCK, DESBLOCK);
	
	i=2;
	miniblocks=size/DESBLOCK;

	while (i<miniblocks)
	{
		int j;

#ifdef SECUDEDES
		dedes (block+DESBLOCK*i);
#else
		desd3 (block+DESBLOCK*i, block+DESBLOCK*i);
#endif

		for (j=0;j<DESBLOCK;j++)
		{
			*(block+DESBLOCK*i+j)^=*(prevmblock+j);
			*(prevmblock+j)=*(block+DESBLOCK*i+j);
		}
		i++;
	}
	/* The last n = size % DESBLOCK (<8) bytes are untouched */

#ifdef SECUDEDES
	desdone ();
#endif
}

int sfs_crypt (char *block, int size, long offset, uid_t uid)
{
	int i=0;
	char *key;
	
	/*syslog (LOG_DAEMON, "sfs_crypt");*/

	if ((key=fskey(uid))==NULL)
		return -1;
	
	do
	{
		sfs_crypt_1k (block+i, BLOCKSIZE, i+offset, key);
		i+=BLOCKSIZE;
	}
	while ((i+BLOCKSIZE)<=size);

	if ((size-i)>0)
		sfs_crypt_1k (block+i, size-i, i+offset, key);

	return 0;
}

int sfs_decrypt (char *block, int size, long offset, uid_t uid)
{
	int i=0;
	char *key;

	/*syslog (LOG_DAEMON, "sfs_decrypt");*/

	if ((key=fskey(uid))==NULL)
		return -1;

	do
	{
		sfs_decrypt_1k (block+i, BLOCKSIZE, i+offset, key);
		i+=BLOCKSIZE;
	}
	while ((i+BLOCKSIZE)<=size);

	if ((size-i)>0)
		sfs_decrypt_1k (block+i, size-i, i+offset, key);

	return 0;
}
