use feature ':5.14';
use Moops;

our $VERSION = '0.1200'; # VERSION
# PODNAME: Dist::Iller::Types

library  Dist::Iller::Types

declares IllerConfigurationPlugin,
         IllerConfigurationPrereq,
         ArrayRefStr

{

    class_type IllerConfiguration       => { class => 'Dist::Iller::Configuration' };
    class_type IllerConfigurationPlugin => { class => 'Dist::Iller::Configuration::Plugin' };
    class_type IllerConfigurationPrereq => { class => 'Dist::Iller::Configuration::Prereq' };
    class_type IllerDoctype             => { class => 'Dist::Iller::Doctype' };

    coerce IllerConfigurationPlugin,
        from HashRef, via {
            my $hash = $_;

            "Dist::Iller::Configuration::Plugin"->new(%$hash);
        };

    declare ArrayRefStr,
    as ArrayRef[Str];

    coerce ArrayRefStr,
    from Str,
    via { [ $_ ] };

}

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Dist::Iller::Types

=head1 VERSION

Version 0.0001, released 2015-11-24.

=head1 SOURCE

L<https://github.com/Csson/p5-Dist-Iller>

=head1 HOMEPAGE

L<https://metacpan.org/release/Dist-Iller>

=head1 AUTHOR

Erik Carlsson <info@code301.com>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2015 by Erik Carlsson.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
