#! /usr/bin/perl
#---------------------------------------------------------------------
# $Id: 10.embellish.t 1835 2007-07-07 19:40:39Z cjm $
#---------------------------------------------------------------------

use Test::More tests => 9;

use HTML::Element;

BEGIN {
    use_ok('HTML::Embellish');
}

my $nb    = chr(0x00A0);
my $mdash = chr(0x2014);
my $lsquo = chr(0x2018);
my $rsquo = chr(0x2019);
my $ldquo = chr(0x201C);
my $rdquo = chr(0x201D);

#=====================================================================
sub fmt
{
  my ($html) = @_;

  $html->as_HTML("<>&", undef, {});
} # end fmt

#=====================================================================
my $source_list = [
  p => q{"Here we have--in this string--some 'characters' ... to process."}
];

#---------------------------------------------------------------------
my $html = HTML::Element->new_from_lol($source_list);

embellish($html);
is(fmt($html), <<"", 'default processing');
<p>${ldquo}Here we have${mdash}in this string${mdash}some ${lsquo}characters${rsquo} .$nb.$nb. to process.$rdquo</p>

#---------------------------------------------------------------------
$html = HTML::Element->new_from_lol($source_list);

embellish($html, default => 0);
is(fmt($html), <<"", 'all disabled');
<p>"Here we have--in this string--some 'characters' ... to process."</p>

#---------------------------------------------------------------------
$html = HTML::Element->new_from_lol($source_list);

embellish($html, dashes => 1, default => 0);
is(fmt($html), <<"", 'dashes only');
<p>"Here we have${mdash}in this string${mdash}some 'characters' ... to process."</p>

#---------------------------------------------------------------------
$html = HTML::Element->new_from_lol($source_list);

embellish($html, ellipses => 1, default => 0);
is(fmt($html), <<"", 'ellipses only');
<p>"Here we have--in this string--some 'characters' .$nb.$nb. to process."</p>

#---------------------------------------------------------------------
$html = HTML::Element->new_from_lol($source_list);

embellish($html, quotes => 1, default => 0);
is(fmt($html), <<"", 'quotes only');
<p>${ldquo}Here we have--in this string--some ${lsquo}characters${rsquo} ... to process.$rdquo</p>

#=====================================================================
# Argument checking:

eval { embellish() };
like($@, qr/^First parameter of embellish must be an HTML::Element at \Q$0\E line \d/, 'no parameters');

eval { embellish($html, 'whoops') };
like($@, qr/^Odd number of parameters passed to HTML::Embellish->new at \Q$0\E line \d/, 'odd parameter');

eval { HTML::Embellish->new()->process('whoops') };
like($@, qr/^HTML::Embellish->process must be passed an HTML::Element at \Q$0\E line \d/, 'bad parameter');
