## --Makefile.PL for Bioperl core module distribution--##
## ----------------------------------------------------##
## $Id: Makefile.PL,v 1.14 2006/12/05 20:11:32 sendu Exp $
##----------------------------------------------------

# This still works, but has been superceded by Build.PL
# Please use Build.PL in preference

warn <<'WARN';
!--
  Bioperl is transitioning from Makefile.PL-based installations to Build.PL

  This Makefile.PL should still work fine, but please try Build.PL instead,
  especially if you run into any non-test-related problems:

  perl Build.PL
  ./Build test
  ./Build install
  
  If you're seeing this message whilst installing with CPAN, consider
  stopping this installation and changing your CPAN configuration before
  trying to install again:
  
  cpan>install CPAN
  cpan>reload CPAN
  cpan>install Module::Build
  cpan>o conf prefer_installer MB
  cpan>o conf commit
  cpan>q
  
  Otherwise, if you would like to install the optional dependencies,
  install Bundle::BioPerl v2.1.8 or greater

--!

WARN

for (1..5) {
  local $| = 1;
  print ". ";
  sleep(1);
}
print "\n";


#
# Start with object preamble and setup of variables that might need changing
# in the future
#

require 5.006_001;
use strict;
use warnings;
use File::Spec::Functions;
use ExtUtils::MakeMaker;
use Cwd;

my $VERSION = 1.005002_100;
$VERSION = eval $VERSION;

# All Bioperl dependencies on external modules are defined here
# (these are mostly considered optional)
my %packages = (
 'DBI'								=> '0.0/Database Access/basic functionality/Everything',
 'Bio::Root::Version'	=> '1.005002/Bioperl/basic functionality/Everything',
);

# We don't want CPAN, Bundle::BioPerl et al. to know about these for various
# reasons (eg. because they would cause a circular dependency), so will exclude
# them from PREREQ_PM later on
my %exclude_from_prereqs = (
  
);

# These are really required and deserve a clearer warning
my %required = (
	'Bio::Root::Version' => 1,
	'DBI' => 1
);


#
# Main code
#

# generate string for makefile that allows show_tests and make test_<testname>
# to work
opendir(DIR,"t") || die "No test directory. Cannot continue.";
my @files = readdir(DIR);
shift @files;
shift @files;
my ($tline, $tset);
foreach my $file (@files) {
  $file =~ /(\w+)\.t/ || next;
  $file = $1;
  my $path = catfile('t', $file);
  my $line = "test_$file :: pure_all\n\tPERL_DL_NONLAZY=1 \$(FULLPERL) -I\$(INST_ARCHLIB) -I\$(INST_LIB) -I\$(PERL_ARCHLIB) -I\$(PERL_LIB) -e \'use Test::Harness qw(&runtests \$\$verbose); \$\$verbose=\$(TEST_VERBOSE); runtests \@ARGV;\' $path.t\n";
  $tline .= $line;
  $tset  .= " $file \\\n";
}
$tline = "show_tests :\n\t\@echo \'type make test_<subtest> to run\'\n\t\@echo '$tset'\n$tline\n";
print STDERR "Generated sub tests. go make show_tests to see available subtests\n";

# we may end up creating extra files we would want to clean later; note them here
my @should_be_cleaned;

# ask questions about optional stuff to install/test


# notify about optional modules that haven't been installed, and generate hash
# for prereqs needed later in WriteMakefile
my %prereq;
my $error = 0;
print "\n*** Optional dependencies section ***\n";
while (my ($name, $value) = each %packages) {
  my ($ver, $desc, $expl, $module) = split( /\// , $value);
	no strict 'refs';
  if (! eval "require $name;" || (${$name.'::VERSION'} || 0) < $ver) {
    my @modules = split(',', $module);
    my $modules = join("\n * ", @modules);
    print "External Module '$name' >= $ver ($desc) is not installed on this computer.\n The following Bioperl-run modules need it for $expl:\n * $modules\n";
    $error = 1;
    
    if (exists $exclude_from_prereqs{$name}) {
      print "Additionally, it will not be considered a pre-requisite\n(and therefore will not be automatically installed by CPAN) because:\n $exclude_from_prereqs{$name}.\n\n";
    }
		elsif (exists $required{$name}) {
			print "Additionally, it is absolutely required and therefore most if not all tests will fail!\n\n";
		}
    else {
      print "\n";
    }
  }
	
  unless (exists $exclude_from_prereqs{$name}) {
    $prereq{$name} = $ver;
  }
}
if ($error == 1) {
  print <<QQ_ERROR_QQ;
Information:

  Some perl modules are missing, listed above and below. The only
  functionality that will be affected is described above;
  the rest of bioperl will work fine without them.

  The installation of these external packages is very simple. You
  can read more about bioperl external dependencies in the INSTALL
  file or at:

  http://bioperl.org/wiki/Installing_BioPerl

  Enjoy the rest of bioperl, which you can use after going 'make install'

QQ_ERROR_QQ
}
else {
	print "All dependencies are installed\n\n";
}
print "NB: BioSQL also needs to be installed for this package to work; see the INSTALL file\n\n";

# write the makefile
WriteMakefile(
  NAME         => 'Bio',
  DISTNAME     => 'bioperl-db',
  VERSION      => $VERSION,
  dist         => { COMPRESS     => 'gzip -9f',
                    SUFFIX       => '.gz',
                    DIST_DEFAULT => 'all tardist'
                  },
  'AUTHOR'     => 'Bioperl Team (bioperl-l@bioperl.org)',
  'ABSTRACT'   => 'bioperl-db - package for biological databases',
  # clean() is overridden and also gets rid of @should_be_cleaned
  realclean    => { FILES => join(' ', @should_be_cleaned) },
  PREREQ_PM    => \%prereq,
  # Once 'nmake ppd' has been issued, the PPD needs to be modified for use with PPM4
  # In addition, non-critical prereq's should be moved to a Bundle::BioPerl PPD
  # A bit of a pain, but better to have all the prereq's in the same place initially
  # TODO I'll (Nathan Haigh) added updated details to the wiki for doing this
);

exit;


#
# subroutines
#


#
# override MakeMaker methods
#

sub MY::postamble {
  $tline;
}

package MY;

sub MY::clean {
  return shift->SUPER::clean(@_) . <<END;
\t-rm -rf @should_be_cleaned
END
}
