/*
 * Decompiled with CFR 0.152.
 */
package com.javonet.core.delegatecache;

import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class DelegatesCache {
    private static final ConcurrentMap<String, Object> DELEGATES_CACHE = new ConcurrentHashMap<String, Object>();
    private static DelegatesCache instance;

    private DelegatesCache() {
    }

    public static DelegatesCache getInstance() {
        if (instance == null) {
            instance = new DelegatesCache();
        }
        return instance;
    }

    public String cacheDelegate(Object delegate) {
        UUID uuid = UUID.randomUUID();
        String uuidString = uuid.toString();
        DELEGATES_CACHE.putIfAbsent(uuidString, delegate);
        return uuidString;
    }

    public boolean deleteDelegate(String uuidString) {
        Object result = DELEGATES_CACHE.remove(uuidString);
        return result == null;
    }

    public Object resolveDelegate(String uuidString) {
        return DELEGATES_CACHE.get(uuidString);
    }
}

