/*
 * Decompiled with CFR 0.152.
 */
package com.javonet.utils;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Objects;

public class TcpConnectionData {
    private String ipAddress = "";
    private final int port;

    public TcpConnectionData(String hostname, int port) throws UnknownHostException {
        this.port = port;
        InetAddress inetAddress = InetAddress.getByName(hostname);
        this.ipAddress = inetAddress.getHostAddress();
    }

    public byte[] getAddressBytes() {
        String[] ipAddress = this.ipAddress.split("\\.");
        byte[] ipBytes = new byte[ipAddress.length];
        for (int i = 0; i < ipAddress.length; ++i) {
            ipBytes[i] = (byte)Integer.parseInt(ipAddress[i]);
        }
        return ipBytes;
    }

    public byte[] getPortBytes() {
        return new byte[]{(byte)this.port, (byte)(this.port >>> 8 & 0xFF)};
    }

    public String toString() {
        return this.ipAddress + ":" + this.port;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TcpConnectionData that = (TcpConnectionData)o;
        return this.port == that.port && this.ipAddress.equals(that.ipAddress);
    }

    public int hashCode() {
        return Objects.hash(this.ipAddress, this.port);
    }
}

