#!/usr/bin/perl -w

# $Id: pod_merge.PL,v 1.1.2.2 2002/01/15 17:57:43 ilya Exp $

use 5.006;

use strict;

use File::Find;
use File::Spec;

require 't/utils.pl';

my ($sourcedir, $in_file, $out_file) = @ARGV;

my $plugin_dir = File::Spec->catdir($sourcedir, qw(HTTP WebTest Plugin));

# get list of plugins
my @plugins = (File::Spec->catfile($sourcedir, qw(HTTP WebTest ReportPlugin.pm)));
find({ no_chdir => 1,
       wanted   => sub {
	   return unless -f and /\.pm$/;
	   push @plugins, $_;
       } },
    $plugin_dir);

my $merged_data = <<WARNING;
# WARNING: This file is autogenerated from following files:
#
WARNING

for my $file (sort $in_file, @plugins) {
    $merged_data .= <<WARNING;
#            $file
WARNING
}

$merged_data .= <<WARNING;
#
# Do not modify this file but edit those files. All changes in this
# file will be lost.


WARNING

$merged_data .= read_file($in_file);

# strip CVS ID mark - it caused some minor pain for me
$merged_data =~ s/\n# \$Id.*//;

# regexp to find TEST PARAMETERS section
my $sectionRe = qr/=head1\ TEST\ PARAMETERS # find the beging of section
                   (.*?) # content of the section
                   =cut # find the end of section
                  /sx;

# find all TEST PARAMETERS sections
my $sections = '';
for my $plugin (@plugins) {
    my $plugin_data = read_file($plugin);

    my($section) = $plugin_data =~ $sectionRe;

    next unless defined $section;

    $sections .= $section;
}

# sort content of sections
my @sections = map "=head2$_", grep /\S/, split '=head2', $sections;
@sections = map $_->[1],
            sort { $a->[0] cmp $b->[0] }
            map { my($name) = $_ =~ /=head2\s+([a-z_]+)/; [ $name => $_ ] }
            @sections;
$sections = join '', @sections;

# insert TEST PARAMETERS section
$merged_data =~ s/(=for\ pod_merge\ TEST\ PARAMETERS) # point for insertion
                /$sections$1/x;

write_file($out_file, $merged_data);
