use Dios { acc => 'uni' };
use Test::More;

plan tests => 8;

my $NAME = 'Damian';

class Base1 {
    method basic { return 'basic' }
}

class Base2 {
    method more_basic { return 'more basic' }
}

class Demo is Base1 is Base2 {
    has Str $.name is rw is req;

    method foo ($this: Str $newname, Int|Undef :$other) {
        ::is $name, $NAME => 'Name correct';

        $name = 'Other';
        ::is $this->name, 'Other' => 'Assignment to name correct';

        return 1;
    }
}

my $obj = Demo->new({ name => $NAME });

::is $obj->basic, 'basic' => 'Inherited Base1 correctly';
::is $obj->more_basic, 'more basic' => 'Inherited Base2 correctly';

::is $obj->foo('me'), 1      => 'Called foo() correctly';
::is $obj->name, 'Other' => 'Retained updated name correctly';

::is $obj->name('etc'), 'etc' => 'Called setter correctly';
::is $obj->name, 'etc'        => 'Retained updated name correctly';

done_testing;

