/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.client.cache;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Priority;
import javax.cache.Cache;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.ReaderInterceptor;
import javax.ws.rs.ext.ReaderInterceptorContext;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.jaxrs.client.cache.BytesEntity;
import org.apache.cxf.jaxrs.client.cache.Entry;
import org.apache.cxf.jaxrs.client.cache.Key;
import org.apache.cxf.transport.http.Headers;

@Priority(value=4999)
public class CacheControlClientReaderInterceptor
implements ReaderInterceptor {
    private Cache<Key, Entry> cache;
    @Context
    private UriInfo uriInfo;
    private boolean cacheResponseInputStream;

    public CacheControlClientReaderInterceptor(Cache<Key, Entry> cache) {
        this.cache = cache;
    }

    public CacheControlClientReaderInterceptor() {
    }

    public CacheControlClientReaderInterceptor setCache(Cache<Key, Entry> c) {
        this.cache = c;
        return this;
    }

    @Override
    public Object aroundReadFrom(ReaderInterceptorContext context) throws IOException, WebApplicationException {
        Object cachedEntity = context.getProperty("client_cached_entity");
        if (cachedEntity != null) {
            if (cachedEntity instanceof BytesEntity) {
                Object object;
                BytesEntity bytesEntity = (BytesEntity)cachedEntity;
                byte[] bytes = bytesEntity.getEntity();
                if (bytesEntity.isFromStream()) {
                    ByteArrayInputStream byteArrayInputStream;
                    object = byteArrayInputStream;
                    byteArrayInputStream = new ByteArrayInputStream(bytes);
                } else {
                    object = bytes;
                }
                cachedEntity = object;
                if (this.cacheResponseInputStream) {
                    InputStream is = bytesEntity.isFromStream() ? (InputStream)cachedEntity : new ByteArrayInputStream((byte[])cachedEntity);
                    context.setInputStream(is);
                    return context.proceed();
                }
            }
            return cachedEntity;
        }
        if (Boolean.parseBoolean((String)context.getProperty("no_client_cache"))) {
            return context.proceed();
        }
        MultivaluedMap<String, String> responseHeaders = context.getHeaders();
        String cacheControlHeader = responseHeaders.getFirst("Cache-Control");
        CacheControl cacheControl = CacheControl.valueOf(cacheControlHeader.toString());
        byte[] cachedBytes = null;
        boolean validCacheControl = this.isCacheControlValid(context, cacheControl);
        if (validCacheControl && this.cacheResponseInputStream) {
            cachedBytes = IOUtils.readBytesFromStream(context.getInputStream());
            context.setInputStream(new ByteArrayInputStream(cachedBytes));
        }
        Object responseEntity = context.proceed();
        if (!validCacheControl) {
            return responseEntity;
        }
        long expiry = cacheControl.getMaxAge();
        if (expiry == -1L) {
            String expiresHeader = responseHeaders.getFirst("Expires");
            if (expiresHeader.startsWith("'") && expiresHeader.endsWith("'")) {
                expiresHeader = expiresHeader.substring(1, expiresHeader.length() - 1);
            }
            try {
                expiry = (Headers.getHttpDateFormat().parse(expiresHeader).getTime() - System.currentTimeMillis()) / 1000L;
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        Serializable ser = null;
        if (cachedBytes != null) {
            ser = new BytesEntity(cachedBytes, responseEntity instanceof InputStream);
        } else if (responseEntity instanceof Serializable) {
            ser = (Serializable)responseEntity;
        } else if (responseEntity instanceof InputStream) {
            byte[] bytes = IOUtils.readBytesFromStream((InputStream)responseEntity);
            ser = new BytesEntity(bytes, true);
            responseEntity = new ByteArrayInputStream(bytes);
        } else if (responseEntity instanceof byte[]) {
            ser = new BytesEntity((byte[])responseEntity, false);
        }
        if (ser != null) {
            Entry entry = new Entry(ser, responseHeaders, this.computeCacheHeaders(responseHeaders), expiry);
            URI uri = this.uriInfo.getRequestUri();
            String accepts = (String)context.getProperty("client_accepts");
            this.cache.put((Object)new Key(uri, accepts), (Object)entry);
        }
        return responseEntity;
    }

    private Map<String, String> computeCacheHeaders(MultivaluedMap<String, String> responseHeaders) {
        String lastModifiedHeader;
        HashMap<String, String> cacheHeaders = new HashMap<String, String>(2);
        String etagHeader = responseHeaders.getFirst("ETag");
        if (etagHeader != null) {
            cacheHeaders.put("If-None-Match", etagHeader);
        }
        if ((lastModifiedHeader = responseHeaders.getFirst("Last-Modified")) != null) {
            cacheHeaders.put("If-Modified-Since", lastModifiedHeader);
        }
        return cacheHeaders;
    }

    public boolean isCacheInputStream() {
        return this.cacheResponseInputStream;
    }

    public void setCacheResponseInputStream(boolean cacheInputStream) {
        this.cacheResponseInputStream = cacheInputStream;
    }

    protected boolean isCacheControlValid(ReaderInterceptorContext context, CacheControl responseControl) {
        boolean valid;
        boolean bl = valid = responseControl != null && !responseControl.isNoCache() && !responseControl.isNoStore();
        if (valid) {
            CacheControl clientControl;
            String clientHeader = (String)context.getProperty("client_cache_control");
            CacheControl cacheControl = clientControl = clientHeader == null ? null : CacheControl.valueOf(clientHeader);
            if (clientControl != null && clientControl.isPrivate() != responseControl.isPrivate()) {
                valid = false;
            }
        }
        return valid;
    }
}

