//	Copyright (c) 1993, University of Kansas, All Rights Reserved
//
//	Class:		TDosLynx : public TApplication
//	Include File:	TDosLynx.h
//	Purpose:	Implement our application object.
//	Remarks/Portability/Dependencies/Restrictions:
//	Revision History:
//		12-09-93	created
//		02-09-94	Split all members into seperate files to
//				enhance overlay support.
#define Uses_TDeskTop
#define Uses_TVMemMgr
#define Uses_MsgBox
#include"tdoslynx.h"
#include"globals.h"
#include<stdlib.h>

extern "C"	{
#include"..\wattcp\include\tcp.h"
#include"image.h"
};

void TDosLynx::handleEvent(TEvent& TE_Event)	{
//	Purpose:	Determine the implications of an event
//	Arguments:	TE_Event	What happened for call to function
//	Return Value:   void
//	Remarks/Portability/Dependencies/Restrictions:
//	Revision History:
//		12-13-93	created
//		03-31-94	Modified to better handle an ownerClose
//				request.  Didn't work.
//		04-05-94	Video switching mode code added.  Moved into
//				a separate function.

	//	If the following is not null, a window is requesting that
	//	it be close.  Will do so now to avoid a particular problem
	//	of returning to an object that no longer exists.
	if(TVp_ToBeRemoved != NULL)	{
		deskTop->remove(TVp_ToBeRemoved);
		destroy(TVp_ToBeRemoved);
		TVp_ToBeRemoved = NULL;
	}

	//	If the following is not null, then there is an image that
	//	we must view.  Will do so now.  This is a staggered event.
	if(cp_ToBeViewed != NULL)	{
		if(usi_graphicsmode != (image_modes)image_modes_total)	{
			//	Suspend DosLynx and view the image.
			suspend();
			::image_viewer(cp_ToBeViewed, (image_modes)
				usi_graphicsmode);
			resume();
			redraw();
		}
		delete(cp_ToBeViewed);
		cp_ToBeViewed = NULL;
	}

	if(TE_Event.what & evMessage)	{
		switch(TE_Event.message.command)	{
		case cmOpenURL:
			//	Open a URL
			OpenURL();
			clearEvent(TE_Event);
			break;
		case cmUnHideMessage:
			//	Show the message window.
			::TC->show();
			::TC->makeFirst();
			clearEvent(TE_Event);
			break;
		case cmTile:
			//	Tile all windows on desktop.
			::TC->hide();
			deskTop->tile(deskTop->getExtent());
			clearEvent(TE_Event);
			break;
		case cmCascade:
			//	Cascade all windows on desktop.
			::TC->hide();
			deskTop->cascade(deskTop->getExtent());
			clearEvent(TE_Event);
			break;
		case cmDosShell:
			//	Provide a dos shell.
			suspend();
			system("cls");
			system("echo Type EXIT to return to DOSLYNX.");
			system(getenv("COMSPEC") == NULL ? "command.com" :
				getenv("COMSPEC"));
			resume();
			clearEvent(TE_Event);
			redraw();
			break;
#ifndef RELEASE
		case cmTraceWWW:	{
			//	Turn on WWW tracing.
			extern int WWW_TraceFlag;
			WWW_TraceFlag++;
			WWW_TraceFlag %= 2;
			clearEvent(TE_Event);
			doslynxmessage("WWW tracing turned " << (WWW_TraceFlag
				== 1 ? "on" : "off") << '.');
			break;
		}
		case cmTraceWATTCP:	{
			//	Turn on Wattcp debugging.
			static int i_twattcp = 0;
			i_twattcp++;
			i_twattcp %= 2;
			tcp_set_debug_state(i_twattcp);
			clearEvent(TE_Event);
			doslynxmessage("WATTCP tracing turned " << (i_twattcp
				== 1 ? "on" : "off") << '.');
			break;
		}
		case cmTraceDOSLYNX:	{
			//	Turn on doslynx debugging.
			c_trace++;
			c_trace %= 2;
			clearEvent(TE_Event);
			doslynxmessage("DOSLYNX tracing turned " << (c_trace
				== 1 ? "on" : "off") << '.');
			break;
		}
#endif // RELEASE
		case cmOpenLocal:
			//	Open a local file
			OpenLocal();
			clearEvent(TE_Event);
			break;
		case cmOwnerClose:
			//	Destroy the requesting view.
			//	Assume deskTop owns the view.
			//	Here's the kludge, set a variable that will
			//	close this for us the next time the function
			//	is called so that we will avoid returning to
			//	an object that no longer exists.
			TVp_ToBeRemoved = (TView *)(TE_Event.message.infoPtr);
			clearEvent(TE_Event);
			break;
		case cmQuit:	{
			//	The application is about to exit.
			//	Broadcast to all open views in the desktop
			//	to close.
			//	Don't clear this event.  The base class will
			//	have to do its wrap up also.
			TEvent TE_close;
			TE_close.what = evBroadcast;
			TE_close.message.command = cmClose;
			deskTop->handleEvent(TE_close);
			break;
		}
		case cmVideoMode:	{
			//	Change the video mode from what we are to
			//	the other....
			switchVideo();
			clearEvent(TE_Event);
			break;
		}
		case cmMailDeveloper:	{
			mailDeveloper();
			clearEvent(TE_Event);
			break;
		}
		case cmImage:	{
			//	There is an image that we will view.
			cp_ToBeViewed = (char *)TE_Event.message.infoPtr;
			clearEvent(TE_Event);
			break;
		}
		case cmHomePage:	{
			//	Load up the home page.
			if(cp_Home != NULL)	{
				OpenURL(cp_Home);
			}
			else	{
				doslynxmessage("home not specified in the"
					"configuration file.");
			}
			clearEvent(TE_Event);
			break;
		}
		case cmHotList:	{
			//	Load up the HotList.
			if(cp_HotList != NULL)	{
				OpenLocal(cp_HotList);
			}
			else	{
				doslynxmessage("hotlistfile not specified in "
					"the configuration file.");
			}
			clearEvent(TE_Event);
			break;
		}
		case cmAboutDosLynx:	{
			auto TRect TR_about = deskTop->getExtent();
			TR_about.grow(-3, -1 * TR_about.b.y / 2);
			TR_about.grow(0, 6);

			messageBoxRect(TR_about, "\nDosLynx\nVersion 0.71 "
				"Alpha\nCopyright (c) 1994 by The "
				"University of Kansas, All Rights Reserved\n"
				"Developer:  Garrett Arch Blythe",
				mfInformation | mfOKButton);
			break;
		}
		default:
			//	Event not handled here.
			break;
		}
	}

	//	Have our base handle the event also.
	TApplication::handleEvent(TE_Event);
}