/*---------------------------------------------------------------------------
Query.h - Header file for Query.m class.
-----------------------------------------------------------------------------*/
#define EMAILSIZE 252		/* Max email reformat len; good malloc size */

#define WRAPWIDTH 40		/* Hyphens/Equals line width when wrapping */
#define NWRAPWIDTH 128		/* Hyphens/Equals line width when wrapping */

#define COMSIZE 4088		/* 4088 is a good malloc size; see the NeXT */
				/* "So You Want Your Applications to Fly" notes*/
				/* COMSIZE is shared with other .m files */

#import <objc/Object.h>
#import <streams/streams.h>

@interface Query:Object
{				/* IDs assigned by Interface Builder */
   id   boxView;		/* Box view in main query window  */
   id   boxViewWindow;		/* Window containing "fields" box view  */
   id   fieldSearchingWord;	/* Searching textfield in "fields" box */
   id   fieldSearchButton;	/* Search button in "fields" box */
   id   fieldScrollView;	/* Scroll view in "fields" box */
   id   nameForm;		/* Form field in the "name" box */
   id   nameSearchButton;	/* Search button in the "name" box*/
   id   phoneView;		/* Scroll view for the output */
   id   queryWindow;		/* Query window  */
   id   nameSearchingWord;	/* Searching textfield in "name" box */
   id   returnFieldsBox;	/* Radio button matrix of field types */
   id   searchTypeButton;	/* Button which ultimately holds popup list */
   id   splitView;		/* View encompassing box & phoneView */

   char alias[EMAILSIZE];	/* Holds alias field for email reformatting */
   BOOL copiedEmail;            /* Was the previous line the Email line? */
   char *domain;		/* Need the domain for rewriting address */
   char email[EMAILSIZE];	/* Holds email field for email reformatting */
   BOOL reformatEmail;		/* Only reformat if valid domain & default return*/

   int  curPerson;		/* Current # of person being processed */
   char errMsg[256];		/* Alert panel error message string */
   BOOL isQueryReady;		/* Is the Query object fully initialized? */
   int  returnedFields;		/* Current setting of field type radio matrix */
   char selFields[COMSIZE];	/* Fields the user wants returned */

   char hyphens[NWRAPWIDTH];	/* Separator line between entries */
   char equals[NWRAPWIDTH];	/* Separator line between searches */
   
   id   myBVS;                  /* The BoxViewSwitcher object for my boxes */
   id   myFieldForm;		/* "fields" form matrix in myQueryFieldView */
   id   myIconMatrix;		/* "icon" matrix in myQueryFieldView */
   id   myQueryFieldView;	/* View holding "icon" & "fields" matrixes */
   id   mySpecify;		/* ID of object handling "Specific" window */
   id   qiObject;		/* The Qi object handling my I/O  */
   id   queryAnimator;		/* Animator object (timer)  */
   id   theQiManager;		/* Manager who knows all the Qi server IDs */

   NXStream *queryStream;	/* Query memory stream */
}

- init;
- createBoxViewSwitcher:sender;
- createFonts:sender;
- initLineWrap:sender;

- setQueryVars:aQiManager domain:(const char *)aDomain;
- setQueryWindow:(const char *)aTitle offset:(float)anOffset;
- (BOOL) openSession:(const char *)aServer;

- queryTimeCheck;
- stopTimer:sender;

- createQueryFieldView:sender;
- fillFieldMatrix:sender;

- setReturnedFields:sender;
- createSpecify:sender;
- specOrigin:(float *)xLoc :(float *)yLoc;
- showSpecify:sender;
- hideSpecify:sender;

- speakerSearch:(const char *)aCommand;
- search:sender;
- (BOOL)catData:(char *)aSource data:(const char *)aData;
- (BOOL)getFieldForms:(char *)aCommand;

- newPerson:(const int)aPerson;

- qiOutput:(char *)aBuf;
- processLine:(char *)aBuf;

- clearQueryFields;
- clearQueryView;
- displaySearchingWord:(BOOL)searching;
- outputString:(char *)aString;
- outputStream:sender;

- displayEmail:sender;
- emailLine:sender;
- notRegisteredLine:sender;

- boxViewDidSwitch:sender;
- selCell:sender;

- splitView:sender getMinY:(NXCoord *)minY maxY:(NXCoord *)maxY ofSubviewAt:(int)offset;
- splitView:sender resizeSubviews:(const NXSize *)oldSize;

- shiftWindow:(float)anOffset;
- showWindow:sender;

- windowDidMiniaturize:sender;
- windowWillClose:sender;
- windowWillResize:sender toSize:(NXSize *)frameSize;

- (const char *)getServerName;
- (BOOL)isQueryReady;
- qiObject;

@end
