/*---------------------------------------------------------------------------
InfoView.h - Header file for InfoView.m class.
-----------------------------------------------------------------------------*/
#define BOXSIZE 52.

#define BOTBORDER 6.
#define TOPBORDER 8.

#import <appkit/View.h>
#import <dpsclient/wraps.h>

@interface InfoView:View
{
   id infoAnimator;		/* Animator object */

   id imageNE;			/* Image which is moving northeast */
   id imageNW;			/* Image which is moving nortwest */
   id imageSE;			/* Image which is moving southeast */
   id imageSW;			/* Image which is moving southwest */

   int nDrawPasses;		/* Number of drawing passes */
   
   BOOL drawnOnce;		/* Has the image been drawn once */
   BOOL drawing;		/* Are we currently drawing? */

   NXPoint imagePt;		/* Current location of imageNE */
}

- initFrame:(const NXRect *)frm;

- drawImages;
- drawFinalScene:sender;
- drawInit:sender;

- mouseDown:(NXEvent *)theEvent;

- startInfoViewTimer:(float)seconds;
- stopInfoViewTimer:sender;

- windowDidBecomeKey:sender;
- windowWillClose:sender;

@end
