/*
 * wserv.c - little program to be a pipe between a screen or
 * xterm window to the calling ircII process.
 *
 * Written by Troy Rollo, Copyright 1992 Troy Rollo
 * Finished by Matthew Green, Copyright 1993 Matthew Green
 * Original support for 4.4BSD by Jeremy Nelson
 * Almost total rewrite to use INET sockets instead by Jeremy Nelson
 *
 * Copyright 1997 EPIC Software Labs
 * See the COPYRIGHT file or do /help ircii copyright.
 */

#define WSERV_C

#include "defs.h"
#include "config.h"
#include "irc.h"
#include "term.h"
#include "ircaux.h"
#include <errno.h>
#include <sys/uio.h>

static 	int 	s;
static	char	buffer[256];

void 	my_exit(int);
void 	ignore (int value);

int	main (int argc, char **argv)
{
	fd_set		reads;
	int		nread;
	unsigned short 	port;
	char 		*host;
	char		*tmp;
	int		t;
	char		stuff[100];

	my_signal(SIGWINCH, SIG_IGN);
	my_signal(SIGHUP, SIG_IGN);
	my_signal(SIGQUIT, SIG_IGN);
	my_signal(SIGINT, ignore);

	if (argc != 3)    /* no socket is passed */
		my_exit(1);

	host = argv[1];
	port = (unsigned short)atoi(argv[2]);
	if (!port)
		my_exit(2);		/* what the hey */

	s = connect_by_number(host, &port, SERVICE_CLIENT, PROTOCOL_TCP);
	if (s < 0)
		my_exit(23);

	/*
	 * first line from a wserv program is the tty.  ircii doesnt
	 * actually do anything with it, but perhaps its useful just
	 * to confirm we're not out of our minds.
	 *
	 * Note that im using sprintf() now because writev() was proving
	 * to not be reliable enough.  Stupid linux. :p  All this stuff
	 * must be sent with one write() because the client is expecting
	 * it to get a full line, with a newline, in one segment.  To do
	 * otherwise will lead to failure.
	 */
	tmp = ttyname(0);
	sprintf(stuff, "%s\n", tmp);
	t = write(s, stuff, strlen(stuff));
	term_init();
	printf("t is %d", t);

	/*
	 * The select call..  reads from the socket, and from the window..
	 * and pipes the output from out to the other..  nice and simple
	 */
	for (;;)
	{
		FD_ZERO(&reads);
		FD_SET(0, &reads);
		FD_SET(s, &reads);
		if (select(s + 1, &reads, NULL, NULL, NULL) <= 0)
			if (errno == EINTR)
				continue;

		if (FD_ISSET(0, &reads))
		{
			if ((nread = read(0, buffer, sizeof(buffer))))
				write(s, buffer, nread);
			else
				my_exit(3);
		}
		if (FD_ISSET(s, &reads))
		{
			if ((nread = read(s, buffer, sizeof(buffer))))
				write(1, buffer, nread);
			else
				my_exit(4);
		}
	}

	my_exit(8);
}

void ignore (int value)
{
	/* send a ^C */
	char foo = 3;
	write(s, &foo, 1);
}

void my_exit(int value)
{
	printf("exiting with %d!\n", value);
	printf("errno is %d (%s)\n", errno, strerror(errno));
	exit(value);
}

/* These are here so we can link with network.o */
char *LocalHostName = NULL;
struct in_addr LocalHostAddr;
char empty_string[] = "";
enum VAR_TYPES { unused };
int get_int_var (enum VAR_TYPES unused) { return 5; }
void set_socket_options (int des) { }

/* End of file */
