/*
 * server.h: header for server.c 
 *
 * Copyright 1990 Michael Sandrof
 * Copyright 1997 EPIC Software Labs
 * See the COPYRIGHT file, or do a HELP IRCII COPYRIGHT 
 */

#ifndef __server_h__
#define __server_h__
  
/* To get definition of Who, Ison, and Userhost queues. */
#include "who.h"

/* To get definition of Notify */
#include "notify.h"

/* XXXX Ick.  Gross.  Bad. XXX */
struct notify_stru;

/*
 * type definition to distinguish different
 * server versions
 */
#define Server2_8	1
#define Server2_9	2
#define Server2_10	3
#define Server_u2_8	4
#define Server_u2_9	5
#define Server_u2_10	6
#define Server_u3_0	7

/* Server: a structure for the server_list */
typedef	struct
{
	char	*name;			/* the name of the server */
	char	*itsname;		/* the server's idea of its name */
	char	*password;		/* password for that server */
	int	port;			/* port number on that server */
	char	*nickname;		/* Authoritative nickname for us */
	char	*s_nickname;		/* last NICK command sent */
	char	*d_nickname;		/* Default nickname to use */
	int	fudge_factor;		/* How much s_nickname's fudged */
	int	nickname_pending;	/* Is a NICK command pending? */
	char	*userhost;		/* my userhost on this server */
	char	*away;			/* away message for this server */
	int	oper;			/* true if operator */
	int	version;		/* the version of the server -
					 * defined above */
	int	server2_8;		/* defined if we get an 001 numeric */
	char	*version_string;	/* what is says */
	long	flags;			/* Various flags */
	long	flags2;			/* More Various flags */
	char	*umodes;		/* Possible user modes */
	char	umode[54];		/* Currently set user modes */
	int	s_takes_arg;		/* Set to 1 if s user mode has arg */
	int	connected;		/* true if connection is assured */
	int	write;			/* write descriptor */
	int	read;			/* read descriptior */
	pid_t	pid;			/* process id of server */
	int	eof;			/* eof flag for server */
	int	motd;			/* motd flag (used in notice.c) */
	int	sent;			/* set if something has been sent,
					 * used for redirect */
	char	*redirect;		/* Who we're redirecting to here */
	WhoEntry *	who_queue;	/* Who queue */
	IsonEntry *	ison_queue;	/* Ison queue */
	UserhostEntry *	userhost_queue;	/* Userhost queue */

	struct in_addr local_addr;      /* ip address of this connection */
	struct sockaddr_in local_sockname; /* sockname of this connection */
	NotifyList	notify_list;	/* Notify list for this server */
}	Server;

extern	int	attempting_to_connect;
extern	int	number_of_servers;
extern	int	connected_to_server;
extern	int	never_connected;
extern	int	using_server_process;
extern	int	primary_server;
extern	int	from_server;
extern	int	last_server;
extern	char	*connect_next_nick;
extern	int	parsing_server_index;
extern 	int 	user_changing_nickname;
extern	Server	*server_list;


	void	add_to_server_list 	(char *, int, char *, char *, int);
	void	build_server_list 		(char *);
	int	connect_to_server 		(char *, int, int);
	int	connect_to_server_by_refnum 	(int, int);
	void	get_connected 			(int, int);
	int	read_server_file 		(void);
	void	display_server_list 		(void);
	int	server_list_size 		(void);
	void	send_to_server 			(const char *, ...) __A(1);
	void	send_to_aserver			(int, const char *, ...) __A(2);
	void	servercmd			(char *, char *, char *);
	char	*get_server_nickname 		(int);
	char	*get_server_userhost		(int);
	char	*get_server_name 		(int);
	char	*get_server_itsname 		(int);
	void	set_server_flag 		(int, int, int);
	int	find_in_server_list		(char *, int);
	char	*create_server_list 		(void);
	void	set_server_motd 		(int, int);
	int	get_server_motd 		(int);
	int	get_server_operator 		(int);
	int	get_server_version 		(int);
	void	close_server 			(int, char *);
	void	MarkAllAway 			(char *, char *, char *);
	int	is_server_connected 		(int);
	void	flush_server 			(void);
	int	get_server_flag 		(int, int);
	void	set_server_operator 		(int, int);
	void	set_server_away			(int, char *);
	char *	get_server_away			(int);
	void	server_is_connected 		(int, int);
	int	parse_server_index 		(char *);
	void	parse_server_info 	(char *, char **, char **, char **);
	void	set_server_bits 		(fd_set *);
	void	set_server_itsname 		(int, char *);
	void	set_server_version 		(int, int);
	int	is_server_open 			(int);
	int	get_server_port 		(int);
	int	get_server_local_port 		(int);
	char	*set_server_password 		(int, char *);
	void	set_server_nickname 		(int, char *);
	void	close_all_server 		(void);
	void	disconnectcmd 			(char *, char *, char *);
	char 	*get_umode 			(int);
	int	find_server_refnum 		(char *, char **);
	void	change_server_nickname		(int, char *);
	void	register_server			(int, char *);
	void	fudge_nickname			(int);
	char 	*get_pending_nickname		(int);
	void	accept_server_nickname		(int, char *);
	void	reset_nickname			(void);
	char *	get_possible_umodes		(int);
	void	clear_user_modes		(int);
	int	auto_reconnect_callback		(void *);
	int	is_me				(int, const char *);
	void 	got_my_userhost (UserhostItem *item, char *nick, char *stuff);
	void 	password_sendline 		(char *data, char *line);
	void	do_server			(fd_set *);
	void	change_window_server		(int, int);
	void	server_redirect			(int, char *);
	int	check_server_redirect		(char *);

#endif /* _SERVER_H_ */
