create sequence papernr start with 1;

create table papordner (
		     o_kurz char(10) primary key,
		     o_lang char(30),
		     o_typ char(10),                            /* ein- oder ausgangsordner */
		     abt_nummer number(5),             /* o_kurz u.u. nur pro abt eindeutig */
		     ben_nummer number(5)              /* nummer des erfassers */
		     ) pctfree 20
       ;

create table paper (
		       d_nummer number(6) not null primary key,
		       o_kurz char(10) not null references papordner(o_kurz),
		       erf_datum date not null,
		       titel char(255),                       
		       bemerkung char(255),                       
		       publin char(100),
		       verlag char(50),
		       ort char(50),
		       jahr char(20),
		       vol char(20),
		       seite char(20),
		       abt_nummer number(5),             /* ben_nummer u.u. nur pro abt eindeutig */
		       ben_nummer number(5)              /* nummer des erfassers */
		       ) pctfree 20
       ;

create table autor  (
		     autor char(50),
		     d_nummer number(6) references paper(d_nummer),
		     pos number(3)
		     ) pctfree 20
       ;
create table keyword (
		     keyword char(50),
		     d_nummer number(6) references paper(d_nummer),
		     pos number(3)
		     ) pctfree 20
       ;
create table editor (
		     editor char(50),
		     d_nummer number(6) references paper(d_nummer),
		     pos number(3)
		     ) pctfree 20
       ;

create unique index i_papordner on papordner (o_kurz);
create unique index i_paper on paper (d_nummer);

grant select on papernr to neumann;
grant select on papordner to neumann;
grant select on paper to neumann;
grant select on autor to neumann;
grant select on keyword to neumann;
grant select on editor to neumann;

insert into papordner values ( 'Meta', 'Metaprogrammierung', '', 1000, 1);
insert into papordner values ( 'DDB', 'Deduktive Datenbanksysteme', '', 1000, 1);
insert into papordner values ( 'LP', 'Logic Programming', '', 1000, 1);
insert into papordner values ( 'MOD', 'Medellierung', '', 1000, 1);
insert into papordner values ( 'DB', 'Datenbanken', '', 1000, 1);
insert into papordner values ( 'OODB', 'Object orientierte Datenbanken', '', 1000, 1);
insert into papordner values ( 'Normal', 'Normalisierung', '', 1000, 1);
insert into papordner values ( 'AI', 'guess what', '', 1000, 1);
insert into papordner values ( 'Prolog', 'Prolog', '', 1000, 1);
insert into papordner values ( 'ISM', 'Information System Modelling', '', 1000, 1);
insert into papordner values ( 'Gustaf', 'Gustaf''s Goodies', '', 1000, 1);
insert into papordner values ( 'Norbert', 'Norbert''s Goodies', '', 1000, 1);
insert into papordner values ( 'Christoph', 'Christoph''s Goodies', '', 1000, 1);

insert into paper values ( 
			     papernr.nextval, 'DDB', 
			     to_date('1-APR-92'), 
			     'Treating Enhanced Entity Relationship Models in a Declarative Way',
			     'noch nicht erschienen', 
		 	     'Proceedings of the 2nd Russian Conference on Logic Programming', 
			      '', '', '1991', 1000,1205);
 
insert into autor values ('Kehrer N.',papernr.currval);
insert into autor values ('Neumann G.',papernr.currval);
insert into keyword values ('EER',papernr.currval);
insert into keyword values ('Prolog',papernr.currval);







