# Oraperl Emulation Interface for Perl 5 DBD::Oracle DBI
#
# $Id: Oraperl.pm,v 1.21 1995/08/26 17:39:01 timbo Rel $
#
#   Copyright (c) 1994,1995 Tim Bunce
#
#   You may distribute under the terms of either the GNU General Public
#   License or the Artistic License, as specified in the Perl README file.
#
# To use this interface use one of the following invocations:
#
#       use Oraperl;
# or
#       eval 'use Oraperl; 1' || die $@ if $] >= 5;
#
# The second form allows oraperl scripts to be used with
# both oraperl and perl 5.

package Oraperl;

require DBI;
# use Carp;
require Exporter;

$VERSION = substr(q$Revision: 1.21 $, 10);

@ISA = qw(Exporter);

@EXPORT = qw(&ora_login &ora_open &ora_bind &ora_fetch &ora_close
    &ora_logoff &ora_do &ora_titles &ora_lengths &ora_types
    &ora_commit &ora_rollback &ora_autocommit &ora_version
    &ora_readblob
    $ora_cache $ora_long $ora_trunc $ora_errno $ora_errstr
    $ora_verno $ora_debug
);


$debug    = 0 unless defined $debug;
$debugdbi = 0;
$switch   = DBI->internal;
# $safe		# set true before 'use Oraperl' if needed.

if ($debugdbi){
    my($sw) = $switch;
    $sw->debug($debugdbi);
    print "Switch: $sw->{Attribution}, $sw->{Version}\n";
    $sw->{DebugDispatch} = $debugdbi;
}

# Install Driver
$drh = DBI->install_driver('Oracle');
print "DBD::Oracle driver installed as $drh\n" if $debug;
$drh->debug($debug);
$drh->{CompatMode} = 1;
$drh->{Warn}       = 0;


use strict;

sub _func_ref {
    my $name = shift;
	my $pkg = ($Oraperl::safe) ? "DBI" : "DBD::Oracle";
    \&{"${pkg}::$name"};
}


#	-----------------------------------------------------------------
#
#	$lda = &ora_login($system_id, $name, $password)
#	&ora_logoff($lda)

sub ora_login {
    my($system_id, $name, $password) = @_;
    $Oraperl::drh->connect($system_id, $name, $password);
}
*ora_logoff  = _func_ref('db::disconnect');


# -----------------------------------------------------------------
#
#   $csr = &ora_open($lda, $stmt [, $cache])
#   &ora_bind($csr, $var, ...)
#   &ora_fetch($csr [, $trunc])
#   &ora_do($lda, $stmt)
#   &ora_close($csr)

sub ora_open {
    my($lda, $stmt, $cache) = @_;

    my $csr = $lda->prepare($stmt) or return undef;

    # only execute here if no bind vars specified
    $csr->execute or return undef unless $csr->{NUM_OF_PARAMS};

    $csr;
}

*ora_bind  = _func_ref('st::execute');
*ora_fetch = _func_ref('st::fetchrow');
*ora_fetch = _func_ref('st::fetchrow');
*ora_close = _func_ref('st::finish');

sub ora_do {
    # error => undef
    # 0     => "OK"	(0 but true)
    # >0    => >0
    my($lda, $stmt) = @_;

    return $lda->do($stmt);	# SEE DEFAULT METHOD IN DBI.pm

    # OLD CODE:
    # $csr is local, cursor will be closed on exit
    my $csr = $lda->prepare($stmt) or return undef;
    # Oracle OCI will automatically execute DDL statements in prepare()!
    # We must be carefull not to execute them again! This needs careful
    # examination and thought.
    # Perhaps oracle is smart enough not to execute them again?
    my $ret = $csr->execute;
    my $rows = $csr->rows;
    ($rows == 0) ? "OK" : $rows;
}


# -----------------------------------------------------------------
#
#   &ora_titles($csr [, $truncate])
#   &ora_lengths($csr)
#   &ora_types($csr)

sub ora_titles{
    my($csr, $trunc) = @_;
    warn "ora_titles: truncate option not implemented" if $trunc;
    @{$csr->{'NAME'}};
}
sub ora_lengths{
    @{shift->{'ora_lengths'}}		# oracle specific
}
sub ora_types{
    @{shift->{'ora_types'}}		# oracle specific
}


# -----------------------------------------------------------------
#
#   &ora_commit($lda)
#   &ora_rollback($lda)
#   &ora_autocommit($lda, $on_off)
#   &ora_version

*ora_commit   = _func_ref('db::commit');
*ora_rollback = _func_ref('db::rollback');

sub ora_autocommit {
    my($lda, $mode) = @_;
    $lda->{AutoCommit} = $mode;
    "OK";
}
sub ora_version {
    my($sw)  = DBI->internal;
    print "\n";
    print "Oraperl Emulation Interface version $Oraperl::VERSION\n";
    print "Oracle Driver $Oraperl::drh->{Version}\n";
    print "$sw->{Attribution}, version $sw->{Version}\n\n";
}


# -----------------------------------------------------------------
#
#   $ora_errno
#   $ora_errstr

# This is really internal knowledge but it saves using tie and
# performance for ora_errno is very important.
*Oraperl::ora_errno  = \$DBD::Oracle::err;
*Oraperl::ora_errstr = \$DBD::Oracle::errstr;


# -----------------------------------------------------------------
#
#   $ora_verno
#   $ora_debug    not supported, use $h->debug(2) where $h is $lda or $csr
#   $ora_cache    not supported
#   $ora_long     used at ora_open()
#   $ora_trunc    used at ora_open()

$Oraperl::ora_verno = '3.000';	# to distinguish it from oraperl 2.4

$Oraperl::ora_long  = 80;	# 80, oraperl default
$Oraperl::ora_trunc = 0; 	# long trunc is error, oraperl default


# -----------------------------------------------------------------
#
# Non-oraperl extensions added here to make it easy to still run
# script using oraperl (by avoiding $csr->readblob(...))

*ora_readblob = _func_ref('st::readblob');

1;
# end.
