/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.utils;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.logging.Logger;
import javax.annotation.Priority;
import javax.ws.rs.BeanParam;
import javax.ws.rs.Consumes;
import javax.ws.rs.CookieParam;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.FormParam;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.HttpMethod;
import javax.ws.rs.MatrixParam;
import javax.ws.rs.NameBinding;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import org.apache.cxf.common.logging.LogUtils;

public final class AnnotationUtils {
    private static final Logger LOG = LogUtils.getL7dLogger(AnnotationUtils.class);
    private static final Set<Class<?>> PARAM_ANNOTATION_CLASSES = AnnotationUtils.initParamAnnotationClasses();
    private static final Set<Class<?>> METHOD_ANNOTATION_CLASSES = AnnotationUtils.initMethodAnnotationClasses();

    private AnnotationUtils() {
    }

    private static Set<Class<?>> initParamAnnotationClasses() {
        HashSet classes = new HashSet();
        classes.add(PathParam.class);
        classes.add(QueryParam.class);
        classes.add(MatrixParam.class);
        classes.add(HeaderParam.class);
        classes.add(CookieParam.class);
        classes.add(FormParam.class);
        classes.add(BeanParam.class);
        return classes;
    }

    private static Set<Class<?>> initMethodAnnotationClasses() {
        HashSet classes = new HashSet();
        classes.add(HttpMethod.class);
        classes.add(Path.class);
        classes.add(Produces.class);
        classes.add(Consumes.class);
        return classes;
    }

    public static int getBindingPriority(Class<?> providerCls) {
        Priority b = AnnotationUtils.getClassAnnotation(providerCls, Priority.class);
        return b == null ? 5000 : b.value();
    }

    public static Set<String> getNameBindings(Annotation[] targetAnns) {
        if (targetAnns.length == 0) {
            return Collections.emptySet();
        }
        LinkedHashSet<String> names = new LinkedHashSet<String>();
        for (Annotation a : targetAnns) {
            NameBinding nb = a.annotationType().getAnnotation(NameBinding.class);
            if (nb == null) continue;
            names.add(a.annotationType().getName());
        }
        return names;
    }

    public static boolean isParamAnnotationClass(Class<?> annotationClass) {
        return PARAM_ANNOTATION_CLASSES.contains(annotationClass);
    }

    public static boolean isValidParamAnnotationClass(Class<?> annotationClass) {
        return PARAM_ANNOTATION_CLASSES.contains(annotationClass) || Context.class == annotationClass;
    }

    public static boolean isValidParamAnnotations(Annotation[] paramAnnotations) {
        for (Annotation a : paramAnnotations) {
            if (!AnnotationUtils.isValidParamAnnotationClass(a.annotationType())) continue;
            return true;
        }
        return false;
    }

    public static boolean isMethodAnnotation(Annotation a) {
        return METHOD_ANNOTATION_CLASSES.contains(a.annotationType()) || a.annotationType().getAnnotation(HttpMethod.class) != null;
    }

    public static String getAnnotationValue(Annotation a) {
        String value = null;
        if (a.annotationType() == PathParam.class) {
            value = ((PathParam)a).value();
        } else if (a.annotationType() == QueryParam.class) {
            value = ((QueryParam)a).value();
        } else if (a.annotationType() == MatrixParam.class) {
            value = ((MatrixParam)a).value();
        } else if (a.annotationType() == HeaderParam.class) {
            value = ((HeaderParam)a).value();
        } else if (a.annotationType() == CookieParam.class) {
            value = ((CookieParam)a).value();
        } else if (a.annotationType() == FormParam.class) {
            value = ((FormParam)a).value();
        }
        return value;
    }

    public static <T> T getAnnotation(Annotation[] anns, Class<T> type) {
        if (anns == null) {
            return null;
        }
        for (Annotation a : anns) {
            if (a.annotationType() != type) continue;
            return type.cast(a);
        }
        return null;
    }

    public static Method getAnnotatedMethod(Class<?> serviceClass, Method m) {
        Method annotatedMethod = AnnotationUtils.doGetAnnotatedMethod(serviceClass, m);
        return annotatedMethod == null ? m : annotatedMethod;
    }

    private static Method doGetAnnotatedMethod(Class<?> serviceClass, Method m) {
        if (m != null) {
            for (Annotation annotation : m.getAnnotations()) {
                if (!AnnotationUtils.isMethodAnnotation(annotation)) continue;
                return m;
            }
            for (Annotation annotation : m.getParameterAnnotations()) {
                if (!AnnotationUtils.isValidParamAnnotations((Annotation[])annotation)) continue;
                LOG.warning("Method " + m.getName() + " in " + m.getDeclaringClass().getName() + " has no JAX-RS Path or HTTP Method annotations");
                return m;
            }
            Class<?> declaringClass = m.getDeclaringClass();
            Class<?> superC = declaringClass.getSuperclass();
            if (superC != null && Object.class != superC) {
                try {
                    Method method2 = AnnotationUtils.doGetAnnotatedMethod(serviceClass, superC.getMethod(m.getName(), m.getParameterTypes()));
                    if (method2 != null) {
                        return method2;
                    }
                }
                catch (NoSuchMethodException method2) {
                    // empty catch block
                }
            }
            for (Class<?> i : declaringClass.getInterfaces()) {
                try {
                    Method method3 = AnnotationUtils.doGetAnnotatedMethod(serviceClass, i.getMethod(m.getName(), m.getParameterTypes()));
                    if (method3 == null) continue;
                    return method3;
                }
                catch (NoSuchMethodException method3) {
                    // empty catch block
                }
            }
            if (declaringClass != serviceClass && !declaringClass.isInterface()) {
                for (Class<?> i : serviceClass.getInterfaces()) {
                    try {
                        Method method = AnnotationUtils.doGetAnnotatedMethod(serviceClass, i.getMethod(m.getName(), m.getParameterTypes()));
                        if (method != null) {
                            return method;
                        }
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        // empty catch block
                    }
                }
            }
        }
        return null;
    }

    public static String getHttpMethodValue(Method m) {
        for (Annotation a : m.getAnnotations()) {
            HttpMethod httpM = a.annotationType().getAnnotation(HttpMethod.class);
            if (httpM == null) continue;
            return httpM.value();
        }
        return null;
    }

    public static <A extends Annotation> A getMethodAnnotation(Method m, Class<A> aClass) {
        return m == null ? null : (A)m.getAnnotation(aClass);
    }

    public static <A extends Annotation> A getClassAnnotation(Class<?> c, Class<A> aClass) {
        if (c == null) {
            return null;
        }
        A p = c.getAnnotation(aClass);
        if (p != null) {
            return p;
        }
        p = AnnotationUtils.getClassAnnotation(c.getSuperclass(), aClass);
        if (p != null) {
            return p;
        }
        for (Class<?> i : c.getInterfaces()) {
            p = AnnotationUtils.getClassAnnotation(i, aClass);
            if (p == null) continue;
            return p;
        }
        return null;
    }

    public static String getDefaultParameterValue(Annotation[] anns) {
        DefaultValue dv = AnnotationUtils.getAnnotation(anns, DefaultValue.class);
        return dv != null ? dv.value() : null;
    }
}

