package WWW::Yahoo::Groups::Utils;
our $VERSION = '1.88';
use strict;
use warnings FATAL => 'all';
use base qw( Exporter );
our @EXPORT = qw( get_unmangling_table );

# Unmangling code by Zainul M Charbiwala. Subsequently modified first by
# Vadim Zeitlin and then Iain Truskett.

{
    my @unmangling_table;
    my $loaded = 0;

    sub load_unmangle_data
    {
        my $unmangle_data = <<'EOF';
000:O:q:?::::::s::::n::::b::::$::::Y:::::t::::f:::X::::z::}:7:::c::::X::|:,::{::Q:-:::::::::b:#:y:::.::^::::a:=::{:::m:X:2:!:F:s:::::M:8:5:::6::6:::e:::m:6:::j:h:::B::::B:::::_:T::::::::::|:::::::~:0::z:::::b::t:::::::#::::::2::S:w::R:1:::::::-::::f:::::::y:p::C:::::X::W:::2:g::c:P::b::L:::::::::::Z::y::::t::+:::::::::::::::::::::::v:::::::t
001:::::::X::l:j:::::H:9:::U:X:N::::4:H:x:::f::::l::::::::3::::Y:::O::::6::`:::::m::y::$:::::N:|:l::::::*::t:t:5:::W:r:P:::?::::X:::N:p:+:}:::::::#:l::n:::R:::X:^::$:::Q:::J::::::D:n:6::c::::::::s:G::::H::E:E:::f:::::::t:::V:L::::::::q:::::::Y::G::::F:::::::::::I:_:J:::r:-:::::::y:::N:::c:::::::r:::::::::7:t::::::n::j:::::::::::::x
002::::::::::::w::::::::P:1:r:::=:::::::::b:o:+:::::~:::::y::}::::R::::x:::::h:::::::{:{:u::::::`:::g:N:V::~::R:::::l:::::k:::~::C:,:::=::m:::Z:A::t:M:L::::.::7::x::!:::p:::d:T:X:X:::::G:::::::::w::V::K::v::?:::l:n:K:Y::::::::l::~:n:=:5:::t::3:1:Y::9::.:::.:K:T::::R:::::::Z:y::::u::::::::6::z:::::::j::::l
003::O::@::::::L::::!:::3:::::4:::::::::6::l:Z::1:::::b:4:X:D::::::y:N::::1:::::::t::::8:::::::::::.:j:f::m:::::}:l:E::::5:::u:2:::::::@:6:::::d:::H:2::,:::t:b:::::_:8::::::::::::{:::4:5:::::::_:8:@:w:::6:j:n:b:6:::%::::q::!:::V:::z:g::::::S:,:N:N::8::*::::::Z:L::::f::}:B:::::::n:::::::::::::::::::::::::::::::r::::::::::::::n:s::::z
004:{::::Q::::d:h::V::$:W::`:R:::?::t:::y::::j::::::::::U:G::::C:::|:!::I::.::A:::+::::~:::::::::t::L::::::::::::3:::::x::::_::c:::::=:T:::#:+::::::@:::Q::V:::}::N:1:e:j:2:::::::::f::3:.::9:-:l::C::::::::J:::::::5::}::_::::a::::W:e::::a:::O::?::k:::::r:u:::X::::::6:::::::m::::::::6:::i:::::::::::q::::0:::::7
005:::B::O:7:W:M::::::v:::7:A:A:0:T::::::z::V::::7::S:::z::b::P:::::j::8::::::::7::w:::@::`::::,::9:::::6::X:::U::6::::$::z:::`:::::::U:j::l:q:::::D:R::::::::5:::::::::::e:|:}:X::.:B:::x:o:::l::::g::f::::A::H:::q:B:::#::::::::i:::::::e:::::::`:L:::Q::n:C:Z:::::+::.:?::i:^:3::::::9:::P::::::0:::::::::::1::::::8::::n:8::n::::::::z::::x
006::::::*:::::n::g:L:6:::P:H:c:b:::::a:::t:::::v::C::_:W:0:::::r:::::^:h::::::::0::::y:2:::::::,:c:::::B:W:::::n:8::3:::::a::::::::::b::J::::::::::::A::-:::::#::::::h:::y:::1:::::::K:S:Y:::U::::W:::c::::E:e:c:7::::::::::::m:y:::L:::W:d::::::x:1:Q:?:::S::::::::N::::S::::U:9::::P:::::::::::::::::::v::::::::::::r::::r
007:8:W::o:}:~:::::%::{::::::::::M::h:::5::N::S::$::%::p:Z::E:::L:j::::::::!::t::::r::::=::::::A::::I:U:v::::::h:t::5::@:Q::9::L::::::::J:::~::::6::{:E:G:P::n::^::::m::::::::::::::::_:2::`:::::d:`:E::?::1:7::::l:::F::j::::::::::::::J:::K::}:I:::::::::=:s:::@::o:::2::::i:::::::::::::j::w:::::::::h:o::d::::::z
008::::::::::::J::::x:0::2::::z:7::X:::::K:I:%::::::s:G:::::::::::A::::9:::$:u::::Y::::::::j:::Z:g:::H::::::w::O::+::=:::::::c:::::::::q::::$:q::::::::::*::::::::-:i:l::::n:::3::::::::::::d:::@:::::Q::::::A::Z:y:::Z:6:v::~::=:::::::D::x:I:,:p:::::::::::r:::::::r:::::::::::::::l:d:::::::::::::::::::v:::x
009::!::i::|::::::::::a:::d::+:::?:%:8::V:.::^::e:y:f::::::H:::K:Y:i:::::::::q::^::Q:Y:::::::Z:y:::::,:6:::Q:3:::::v:{::N:::::@:F:::::::g:s::j::?::E::y::::::::::::::P:::o::d:N:2:Y:f::{::%:d:+::{::H:#:E::L:::Z::+:@:4:::::::^:{::::~:X::::::::::::::::V:M:::X::7:::::::::::::::m::3:i:X:b:::::::::::8::::t:::::::2:::::::::::::m:::::::::::q
010:::::8:?::::8:::V:::G:O:::w:f::?:r:::t::::::::!:::=::f:6:k:::#:::::C::D::*:::::X::::::::v:k::::V:::W::::::::::::g:4::Y::}:a:y:^::X:L:::::::i:j:n:::r::d:|::::::::::l:::::V::e:#::T:::::::T:::0:-:N::q::%::}:A::::::::::b:q:::9:T::::::::M:::::::}:0:Q:::j::U:G::::::9:::f::::::::::3:::::::::::i:::::::::m:7:::::::::::::::::m:::::::::::::v
011:::::::::::::::::B:::::::::::::::_:::::^:::::m::O:%:::::::::::M:+:::a::Q::y:::M:::g::`:::9:U::::::E::Y:::W:::*:::`:.:::::::::::::::::=:::+:.::^:k:::w:::D:t::::a::w:w:Y:f::A:H:::::::.:::t::e:y:i::w:::C::::@:::::::::V::m:_:t::d:::::o:{:y:::?::::w:-:L:::::L:~:::-:::K::h::::::::::y::4:::::4:::2::::::::::w::::y:::::s::o::v:::z
012::::_:w:::::,::r:::::::::::::::q::Y:::e:::,:::::::::A:}:e::x::I:::::::6::::::6:E::b::0:::::h::i:%:r::::::::9:h:n:T:::::::A:b::h:.:p:S::v:^:^:5::$::::1::::::s::::m::m:I:::::::::::n:N:::O:::b::*:::^::::R:9:::5:::::::c::::6:::::0:n::a::$::::::H::3:t::::F::k:::.:o::~::::z:::y::::::f::::::h:x:7::f::::::z:::::::::w
013:::::-:::::1:::::::@:K:u:?:::k:N:::::H:r::K:::::::7:,:l::::::H:::::::::::V::V::9:}::::s::b:,:::m:@:::::H:9:I:::::::H:::q:::d:c:::::::::X:::`:::::::::::5:J:a::V:Q::::::::::::|::::`:::::2:::::Q:t:A::b:A::o:H:::::::::::E:y:::::::::A::+:::::T::$:::R::h:::4:::Q:::H::::S:U:d:::d::a:R:::f::X::s::-::::::5:::::l
014:b:Q:m:=:::Z:::9::::q:A::$:#:::::::::::::1:A:::c:::o:D:4:r:5:::::::3:::B:::::a:::4:::::::j:::@:H:G:::::::::M::::?:9:b::Y:n::::F:f::=::W:K:::n:8:::::::H::::$::::+::P:::Y:::::v::::::::=:::y:7:A:::|:::::Y:D:K::=::::Z:::s:*::g::::{:::::q:::?:1:6::Z:W:c::::::::1:u::_:::::::s:::M::5:R::::::X:3:s:::::::::e:::::::::::::::l:::::::k::::j
015::h:::::@:::::g:K::d::::::::c::::0::2::::K::::L::T:::::|:+:::V::::::o:::s::Z:9::::p:k:::H::R::::::T::7::S:r::Q:::::::::::#::::_::e::U:L::_:::::::::::E::q:::O:?::*::y::M:Q::H::r:::::-:::#:E::$::::::::T:F::s:g:::::::::::::::::G:t::::::::::::f::#:::::y:::::::::u:.:Z:X::6:::::p:::::n:::9:::::::::::::v:h:i::::::::x::::::::::::::::::x
016:`:#::::I:2:D::::f:::::1:::::l::::::D::::@:k:::::@:Q:T:8:::::::::::::}::$::::!:::::~::6:::}:^:::A:::::::::@::x::::l::*:::M:::6:a::5::::y::e::X:::_:::::?:::%:n::h::::,::D:::2::::::::$:A::n:x::u:m::::::::!:::|::B::g::::.:%::a:::3:g:7:v:::Q::::s::4:|::::f::E::2::::1::::.:::v:V:N::Y::::::5:Y:m:Z:::::6::2:r:d:::::::::s:::::g::t:u::::::::::v
017::A::H:v:5:Q::1:::j:::::u:::J:::::e:}:::::::@:|::r::::7::::::::s::::v::::!::d:E::H:::o:O::p:::::R:::::x::::::::$:::w::::U:::_:::`::N::M:::S::::f:::!:X:::::::*::d:::::t:@:::b::^:::::::=:.:::::C:::::I::_:%::9:::::k:::N::Y::D:::@:*:#:::::::J:8::::::::G:^:::@:F::!:::@::J:::5:::::::-:d::::::::l:3:c:::e
018:x::v:%:l:::::+:::t:S::A:d:::::::::::h:v:::::::::|::::::P:h:{::::8::=:::::9::v::i:O:::|::::::::::::M:g:::::z::J::::|::n:E:g:S::::Z:q::::::Q:::q:^:s::::h::::::@:::Z:::i::::u:::::=::::::s:R:=:::::g:g:::::::::::::X:x::::j::::U::*:-:x:::0:R::F:g::::::::x:f:1::::::R:O:R::::-::o:::::4:::::::::::::::k::::::::::::::r:::::::::::::::::::::::::z
019:Z::$:::::::::8::P::::g:_:::t:C:p:::::M:::w::o:K::B:::u:q::::::o:::::y:::::::::::1::!:3::::$:::::=:::U:2:T:::q:k::::X:::::V:::W::0::T:H:::::T:::::::::y:}:Q:+:?:P:::j::-::::::::::::I:Q:-:E:::!:{::I::::::::}:^:d::*::+::d:S:T:0:l::::::G:+:=:::::::%:|:G::::h::::d::::::H::::::::::::n:::::::.:::::::::a::::::::::::v::::::::::::r:::::x
020:U:^:i:::j::W:?::8:K:::9:~::X:::R::::a:o:::::::y:_:::,::=:::L::::::v::::b:::v::2:::::Z::l::V:::::::::*:::::y:{::D:::W::l:R:0:::G::Y:S:::::::U:::::::::::Z:::b:::::5::~::S:::I:::+:::v:y:y::::P::D:K:::::3:::!::::::::::::_:::::::9::{:::T::{:S::::@:::::,:O:l:::}:W:::::W::l::y::W:H::::::::p:T:::::::::::b:::::v::::::::::r::::::::::k
021:9::::f::=:6:::p:::::::::~:i:3::::::::::::::z::::::r::::z:::|::::::Q:::::::::::F:::v:r::t:::::::%:p::@::::::::::::::3:::d:0::L:::::::+:O::::::::::|:k:::::::S::f:::h:::F:c:::::::J:H::z::U:::::$:::::::::::::|:::::::::::::::m::N:::::::1:::h::::s::C:::4:J:::::x::::t::f:::.::8:::::::::::::7::::g::::::g:::::y::::::o
022::::4:::::{:::::`:::8:::::::::::::i::::3::::::e::_:g:::::5::v:::M::::::::::#:::A:::::E:::::::l:9:::::X::::~:z:+:j:r:::::j:N:::::::::B:A::::::-:G:b:::::S:_:::O::::::j:P:::::d::1:::Q::V::K::::N:::::::::::I::::f:::M::::7:|:o::::::W::F:::::::::R::::::.:::::0:l::::::i::::l::::::::::::::::::::::::::::::::::v:::r
023:B:::,:::!:::::::::::::f::::8:z::U:1::G:Q::P::::A:::::::-::::h:?:U:c:::Q:i:::::^::::::,:::w:!:::::::::::b::.::::::n:::::::_:::::?:y:::::#::J::e::r:k:::E::a:::::X::=:::#::!:::Y:::E:::::|::R::::~:::::K::~::::::::::-:P:$:::::::d::b:U::::~::I::D:::::h:+:::Y:{:E::$:::::::::K::::::p:R:::w::h:::::::::::::::::::::::::::::::::::::::t
024::::G:~::1::,:o:5::::::-::K:8:::0::::|:::::::^::p:::b::::3:l::_::::R::!::::::::C:J:c:L:_::B:::F::r:::Q::::O:::::?:?:::%:%:::}::::,::_:::::X::::I:::S:!:Q:::6:::F::::.:B:v:L:::s:::::::4:::,:::::t:::::S:=:::::^::u:-:::p:n::::::::::z:::@:b:^::D::::::8::::f:::s:::::x::::::::::::::Y:k:+:::U:::::::::Z::::::::::::::s:::::::::h::::::::::v
025::::`::B:c::Z:`:::q:#:x::::4::t::u:i::v::u:::*:::O:t::::::^::::u::::M:7::::0:m:::l::::::J::L:2::R:M::::::C::w::B:4:b::::g::::~:::!::m:::::3:*::::b:2:::::$:::*::-::M:9::::::E:w:=:X::A:1:?:::::%::#::::6:::::::::w::3:::C::o:::4:::::r::C:::::C:::O:::~::$:::::::::h::::Z::%::u::::::::::S::o::::::::::::::::::::i::::::::::::::::::::n
026:7:9::!::::7:z:i:::y:n::k::S:::I::::::y::U::m:::::G:|:4::::R:N:i:::?::::q:::e:J::::H::Q:x:::W::::z::::q::j:s:::6:d:::Y:u:D:::L::W:::|:::@:s::::}:K::::y:::D:%:@:::~:::::::::h:H::V:$:::+:Q::::d::::::o:::s:2::::f:U:::::::,::6::::}:s:E:?::.::b::F::}:v::j:|::T:a:A:+::::`::$::::::W::9:::::g:::::::w::.::c::r:::::Y:Y::o:::v::8::::::::::::::l::::::::::::::::::u:::x
027:::|:::::::::::::::s:::j::f:L:::::,:::Q:F:V::D::C:9::,:::::T::::::s:*::|::L:w::.:::::::*:::::::#::::|:::^:::o::L::::m::Z:Z:r::y::I:k::{::::w:::N::+:3:u:*:::r::::#:e::o:K:V:::::1:4::Q:::t:t::|::::W:+:+:8:}::::a:::::::::::::o:G:::m::2:X:::B::c:::U::::E::::D:::=::J:::%:::::Z:::::::::::::::e::6:w:1::::::::m::w:::o::::8::::w::::e
028::y:^:::y:w::}:6::::Q::V:q::::M:::::::::d:d:,:::::::O:::@::$:::y::X:::N:::-::J::::::::::T:V::::s::e::i::4:::8::::k:{::f:::::C::::::M:::::d:I:o:,:::#:2:::::L::::::H:^::::::l:::W::n:5::R:::p:::B::::b::{:::::g::1::::-::::::N::::f::W::s::0::9:5:::x:::q:M::z:4::E:::::::9:::::B::::h:::+::u:::X::7::::p::::::.::::p:::::::::::::j
029:m:::L::::w:v::::::*::A:::::::b:F::W::::a:::::::F:S:::9:E:::::::::1:::::T::Y:I::6::|:::_::::e:7::::+::h:::l:e::::::}:m:h:::::o:::::::::::::^:4::t:-::::i::::::.::S:::A::::a::p::-:::::!:x::::::::::t::`::J:::o::a:::::j::b:::O::l:a::6:::::::::_:::{::`::::::u:N::o:::b:::O:L:W::G::::::::::::::h:::::k:k:::y::::::::::::::::::::::t:::z
030:*:::::::::W:::::j::!:::::P:K::u:f::::W:F::::::_:::::::p:::::0::R::::,::f::::B:8::F:%::::::::4:::k::::J:1::::::$::=:H::::o:::::::::+::C:t::F:9::::9:j:::T:c::::::::A:::::=:#::q:R::_:::c::h:::B:r::E::::::::V::::::::::f:::9::h::::::::0::::::::4::t:::6:::::$:e::x:::::::::::::T:::::n:::::::::7::::::::::::n::n::v
031:::::A:a::}:t::::::s:Y::H:l::::::$::::::::::::}:E::::::x:0::1::::::f:::::e:K:::::::::_:::c:::c::h:5::::Y:::y:G::::T::::@:7:::o:::.:r:a:f::::::::y::::::r:::::F::l::Q::::y::::::8:::::::::3:o:::::::s:p:z:=:::Q:::::R:::*:z:::c::::S::::*::::r:,:}::.::E:_:::V::::Z:::::::::f:j:e::::::n:::r::S:6::::::::::::::r:x:h:::::y::::::::p::::::::r
032:::::::H::::::k:k::::$:W:!::::::::::R:::::::M:::::8:::_:::::F::::d:k::A:t:::::_:::Q:~:Y:`::::::%::::::6:p::::B:::::5::::1::::f:::=:::~:::::*:::y::0:=:::T:::r:3:I:::-:Z::o:::*:O:::#:|::::::::::s::::::::l:=:A::::P:::2:p:B::::b:::::::::b:::*:::::0:a::@:,::5:::g::v:::::::-::W::::t:::u:::::::::::q:::::::2:::::::::o:::::::::t
033::D:T::::.:%:4:#:::::::::::w::::|:%:::::::::::b::P:6::::::::3:7::::::g::@::::::!:m:R:::::m::8::::-:8::::U:V:+:::=:?::::::::::::::R::::p:4:s:::x::^:::::P:::~:::g:::$:T:::R:::::::n:::::::::D:::-::::*:::::::::8::::::L:f:::S:::,:w:::1:z:*::{:::Z:w::=:J::::::H:::o:,::4:N:::::::::::8::::7:0:::::::-::::::y:::::::::::h:::::l:::::p
034:l::::::F:::::::::m:p::~:::b::::_::q:^:1:n:::R::}:K:::w::Y:I:z::3::::::::::t:8:::`:c:^::3::::|::::9:::L:}:::1:z::z::::::::i:::A:l:::E::::::::d:=:+::P::::i::8::::::::::u:::::::n:Z::x::P::N:_:4::7:::M:::::::M::::7::8:G:K:::::.::::::s:,::*::N:::f:::::+:::A:-:v::::::h::::::t:b:::::Z::::::4::::::n:::z::::a::::::::::::::o:::::::::::::::::::::z
035:::::.::::C::^::::E:z:K:::::::::::|:S::o::::G:s::9::d:::::2:C:::::H:8::V::R:Q:Z::::::::u:$::%:d:`:+::i::::::::::::::Y::R:c:::{::0:*:M::::::J::u:4:::j:::::z:a:::i:-::::::I:L:e::::l:::4:*:::::::1::J::j:9::::@::t::q::M::::::K::::+::W::j::h:::::::::O::::::,:L:n:::P::`::*:~::::O::M:1::N:::::w:d:h::::::a::X:::3:::p:e::::::::::u:::::l
036::::::U:i::x:.::L:::::::j:::::::::::::::C:L:d:::_:::t:Y::=::::#:G:::U:::B:::F::::v::V::I:e:::4:B:a::Y::::q:::::::::::::`::U::F::z:B::M::::9:::z::_:::::r::::M:::D:-::9:::::O::S:~::E::D:::::::::::|:::F:::7:M:::~:2::T:::1:!::R:g:B::::Z:i:::@:D::0::*::::::::::::|:8:*:4:::Y:::::::::N::3::::::::::::i:::0:::t::x::i:::::q::::::::::s
037::::B:,:::v::::::::::?:::y:Q:B:::U:C:::::f::::~:`:L:`:q:::n:U::V:::::::::F:,:::::A::w::n:::::D::::::::::::::::q:::Q:::::N::p::::W:j::=::R::::::0::P:O:v:k::T:::::|:::::::2:k:::R::::7:d:g::y::T:y::::::S::::c:r::x:%:R::%:::9:7:::Y::N::::V:::::q:j:6::B::::::w::C::c:c::::::::-:p::::z:V:::w::::::R:::g::::::::::::::::::z
038:::O::m:::e:H:Q::::x:g:::::d::::::::t:::N::::g::.::::N::::::::f::*::b::::::s::::::::::e::::::2:::::::::a::::D::::::J:::#:7:::::::::::A:V::+:t:::q::J::q::4:C:E::c:I::::::::#:i:::::::A:b:?:::D:::_::Q::Y:G:::::o:::::J:v:::X:::g:::::d:::::::u:E::::::0:::::::::::::::::::::::::o:::::::::::::u:e:q:::::::::::m
039::::::::::R:::r::~::n::7:%:::b:::::a:T::::A:u::7::3:::_::w:::::=::::::G::::::::::I::I:::h:p::::E:::p::::::::::B:::$:R::::{::::`::::M:*:::::::b:8:?:::::Z:::U::::R:F:::::::+:::::K::a::::l:A:::o::M::9::h:::O:}:d:e:J:l:::?:::K:#::::::::::::q::S::w:y:r:K:::::::A::f::L:6:X::G:K:::t:::::3:::::U:::::::s:p::::::::::::::::::::::t
040::5:::E::::::,:b:*:O:::::::4::::::D:::::4::~::::::c:::::z:E:$:!:::l::0::::::U::w::K:::::::S::E::::^:}::P::J:8:|:::c:::_:{:S:X::q::::::::::2:::z::K::::::::::::::f:9:::S:::::::*::X:::k::d:o::%::::::Z:::::::_:::f::::::#:`:::::::::::x:::+::q::::!:i:Y:::::::::2:K:::3::::::::::::::k:::::::::::::::::::::h:::::::::::::::::::r
041:::::::::Q:::{:p:B::O::m::z:::N::::::e:{:::z:6::F:t::::m:::::g::::=::S::I:Y:L:::::::::I:W:g:%:a::::R::::::::=:::::f::::D:::::::y:::::::::::::::,:~::*:::|::,::::O:{::::^::5::::::::::::U::F:::H:::::::=::B:^:b:}::::!::::H:G::$:{:N:::}:x::#::::J:~::L::n:::I:T:::::l:::::6:::g:::::::::::x::::h:::::::::x::::::r:i:::::::c
042:::::h::j::::G::::r::::v::W::::::j:::x:4:g::::::::P:n:h::V:::::::::::::::e:2::B:::K:::J:::::6:::.:2::+:::j:4:::Z:::1:,:::4:::s:g::n:::::9:5:~:::::7::::a:v::u::C:::::s::::H:::$:::8::i:::0::x::u:b::::s:G::l::M:G::X:U::$::q::::::f:P:::~::z:w:::Y:::::P::U::L:O::b:k:e::s:::::l::G::P::T::3:::::::::m::::2::::f::::::::::::q:::a::::::e:::::::q
043:+::%:::z::::c:::J:::#:t:x:::::::::s::8:`::::::!:h:::::::m:Z::E::`::=:J:X:#:Z:Y:X:::e:::::D:U:a:l:::::s:.:O:O::G::a:::::g::::::6::::=:k:T::~::m:P:3:::}:::e:w:::D:::::L::y::::::::_::C:u::z:::j:C:8::::V::::::::::::::7::{:::::::u::G::,::::S::::,:f:::_:U:::|:::9::::::::-::::t::5::::::::::::c:::-:d::::::::::::z:::::::e::::s::::::::::::::::::z
044::f:u:::X:P:::::::N:@::N::X::Q::::::::Z:+:H:k::j::::a:::::F::3:w::::::I:::::G::V::::::::=:z:^::::N:q:::q:::H::5::::U:H:::3::::m::::#::::::::::::::$::::Z:::::::::::0:}:1:j::k:5:::::::::O::::4::::g:O::T:O::::::H:::::,::n:::C::::!::::I:::::d::::Q:l::K:::r:v::::::::::::::a:X::J::S:9:4::::X::r:::W:::::::::::::t:::::::::g:u::::::::::::::w
045:j:%::::W::::::$::::::::@:::$:::9:Z:W::5:::+:q::_::::W:k:c:::::%::::::A:F::::::E::::%:::D:::c:V:M:F::z:::::Z:2:::9:::::X:q:l::^::J:::R::::::f::::::::::::::a:::V::::z::::T::::::Z:::S::::::L::S::a:::{:::^::::9::::c::C::::V:::::::::::::::A:R::::::3:::::::::J::.::::::.:::::::::l:x::::::::::::::::f::::i:::::::::::::::y:::::v
046::::::::x:h::::::`:.:::::J::e::::::r:8:B:::::H:::::::::5::::::U::::E:::7:6:~:|:::d:F:?:F::f:U::::l:::f:8:::u::::-:,::::r::M:r:::-::k:!::s::~:A:N:::U::^::::::@:::^::::4::l:%::::::_::F::?:w:::H:::t:::::2:K:::0:::T::-:::j:q::w::::::u::8:::::::C:.:::::e:=:~:T:B:::::::v:t:::I::::S::+::::::v:Q::::::::::::::::::v:::k::z::::s:::::::::::v:::u:z
047::`:f::::::L::T::::::::R::G:::::V::::::T::::::::C:::::::.:::m::9::::h:q::j:o::+:::d::::g::d:e:U::q::G::O:E:F::::::::V::::{::*::2:6:::::::::K::::6:::::m::j:::::::h:::::-::::::::g:4:r:b:::U::l:s:::::|::::::d:::X:::I:_:::::::M::::::K:^::L::i::2:m::::8:8::2:m:N:R::::c:A::::::l:b:::z::::::::::::::j::::::m::::n:::e:::x:::h::::::::p
048::::::3:g::::W::v:.:::v::::o::::W:+:::O:4::::1:Q::::a::::::::n:U:F::n:{::::Z::j::,:::?::P:::i:L:O:::::::3::R:::^:`::j:::p:::::W::::::::::::::::::::::::::#::L:g:T:::e::+::t:A:h:E:r::::e:6::::::M:E::::::::::::`:x::C:::::=:::*:t:::U:9:::3:g:::H:,::::::v:h::::5:e::@:::::N::8::R:h::::::::::Y:2:::::1::::Z::::::r::n:a::::::b::::::o
049:::::::::W::`:::::*::v::p:l::::::f::{:O:3:u:::::::4:A::$:H:^:::P:::4:::F::::::9:::n::N:::::$::::%:::8::::q:v::b::::#::u:U:!::::$:!:N:::4:f:*:::::j:::-:::::::,:0:g::g:G:%::::F::h:c:V:-::j::=:.::c:::::::::::-:W:k::d::Z::::::::::S::::::$::q:::{:::2::::::0::e:::y:::::::::::::h:E:l::9::::g::::::v:::x:::::::::::w
050:::::0::t:4:::::::T:::::{:D:e:}::S::2:Y:f::L::::.::::k:::::~:p:::^:l::::::6::::::Z::::::::::::::!:Q:::::::::::s::::::::q::A::5::::q:::3:R:i::::::4:f:::i:::::#:::::i::#::8::::::::::Z::5::::j::::::n:S:::0:3:9::j:?:h::::s::D::i::::!::W:::B:::s:::::::=:?:::::M::-::::::9::::::t::::k::::6::s::::::::::::::::9::8
051:K::L:::::`:w:::::::o:::::::g::::K:J:L::::::`:|:::::t::W::::::C:::::::%:#:x::7::::v::j:f::::G:h::::e::::`:::::::E:`:g:::$::8::{::D::L::l::::::b:::Y:Z::::::O:6:L:W::m:8:%:?::::::U:=:::::::1::::P::|::::f::::::::::k:::z:x:Y::z:::::::::::::?:7:w::::*::g::::$:x::::#:p:4:::::::::O::::U::b:::::::::::::::::w:c
052:~::::::::%::7:::*:=::::::v:::M:C::w:P:::|::::?::H:0::.:X:!:::V::::::7::c:b:::r::{:K:::E:::J::::1:::::::::::::::#:::::!::::p:W::b:u:A:::_::7:::|:::q::_:G:y:::m:}::::~:Y:2:~::+:3:d::G::U::0::l::::9::::::T:r:u::6:S:H::::::V:::|:::J:5::::::w::::::::y:n:::}:M:::8::9:5:d:?::e:Z:F:::::::H:::::m::b:::::::::::::::6:::::z:::::::::h:e::::::i:k
053:q::::::::::b::L::::i::*:-:::::s:::%:6:::*:::O::::::a:::4:|:4:u:B:::::1:::m:::y:::#::::e:::x:::!:::::::::::::T:::|:p::_::S::h:::::::::::::::::#:::Z::_::P:::::::b::::::::k:::j::::C:::::X::::5::W:::V:b:::::@::::::::::f:::?:P:::o::.:J:~::::::q::::8::C::::G::::::w:::p::l:.::h::::::p::f:::::X::p::a:g:::::::::::::::s
054::B::^::::::K:::::::::::g::G:::::::~::::S::::::E:::::::::D:K::~:::U:::::::,:T:e:::::U::N::X::E::,::::i:::Z:V::::7:#:::F::t:::w::::3:z::::N::}:::o::E:::::}:A::::::::::6:::f::::G:,:::|::::::::::::k::::m:::::::::::I::d::!:6::~::m:::c:-::6::::9::H:r:j:{::N:|::y:E:::P:7:::e:::h:::::e::s:::::-:c:::::f::::::8:::b::::::::::::::::::::s:::::z
055::::*:::::p:::,::{:O:::z::o:::::::4:S::::O:d:{::S::::::A:m::`:::::L:::E::::::::E::k:T:::::W:H::::::::F:::K:H:G::U:::9:::o::::::::::G::D:z:::::z::::I:A:::v::Y:G::@:q:3:::::::D:::T:::`::g:|:::+::::::z:X:::::U::k::::::k::@::1:_:4:n:k:::::::::E:::^::::b:::2::=::::::{:::::::::::::::.:::::::j:::d:::::g::::i:::::b:::o:::::n:r
056::e::e:e:::i::t::::|::::*::::i:::::#:2:F::X::::H::::v:$:=:j::::k::::T::::-::::*:G::::::z:X:R:::G:::::X::::::::::::::::y:::::::|:::Y:::.:::%:::6:::::::::::::::H:Y::Y:::::::::::o::::l::7::J:::0:9:X:m:J::::O:K:::u:~::::m:}:::Q:T::A:::::::::s:::p::%::%::::}::::::::::m:::::e:L:V:::o:::::::::::m::o::::b::::p::::l::::j:::::::::::q:q:t
057:::P:::2::t:::L:D:::e:C::C:::x:::n:::6::::::U::::n:*:::*::k:::::?:::O::5:::6:e::::!:*:::$:::=:l::-:@:::K:::::v::::::R:::K:::H:9::::::-:i::::::C::Q:::::A:@:::::::::N::4:::a::::%:q::Q::z:F::::c::::d::i:i:|:y::::.:e:4:g::%:::$::{:z:V:::L::::U::r::::::::=:p:::~:::B::-::q:x::::*::::::::::S:::::o::.::::::::::::f:::::j::9:::::::e
058::+::j::::::::::h::::I:::::3:X:::e:=:d:0:::::C:::::::D::H::::::::@::H:j:::b:A::U::::q::::::::::::::::o:7:6:::::5::::::z:::::a::x::9:b:::8::R:::B:O::::O:::::!:::c::::::{:m:V:::0:::::%::::W::+:::j::::*:%:_::=::::::::::::E:::::::::::::o:7::^:::r:::::-:C:}::^:!:::::j:::::-:h:::::::::::::::::::o:::x:::4::::::::s::g
059::s:::T::::::O:#:~:::::::::h::E::::?:::$:P:::::::::::0::s::::::d:U:::T::::b::z::C::::::o:::x:::::::::::::::::E::~:::::::9:::h::N:u:::H:_:::::!::::::r:::::f:J::::,::p::?::g:W:::::8:M:2:::::::$::::#:4::u:L::::::B:::p:::i:::o:.::::E:,::g:::w:R:::@::5::::::C:D::z:@::Q:::::::::M:::::a:::::::::u:::::::s:::h:s
060:P::-::::::-::::::?:::f::::::|::K::::J:b::5::::T:::I::e::?:R::::v:A:::::::::O:L:::::::d:8:::?::::::4:::n::=::K:::S::i::::::::e:X:::::::::a::::::J::::x:::::p:::::B::::F:T:x:::p::m::::::e::!:2:::4:q:B::L:::::::::L:b:::^:::!:y:::::9::::::-:B:-::s:#:1:::::L:^:y::^:::|::::8::::Q::::K:::d:::::::::::::::::::d
061:s:}::::::r:f:S:::::::e::|::::m:::.:::l:::0::::::::M:::s:::P:G::+:::::J:?:2:::+:::E::::::::::::y::m::S:v::::::+::::-:::l:::8:::C::=:::X::h:S::::C:K::::%::::::::s:::X:::O:::::::w:::!::::::!:u:::*:J::L:::::j:::0:5:s:9::s:|:::::::x::::::A:h::::Z::::?::a::::S::::P:w:::::::::0:::g:::::T:::g::::::::d::::::6::::::::::::h:::::::n::::::r
062:::`::+::x::::c::::::::::6::::::n:::::::::b:::::::^::*::b:,:::::H::::::R::*:}::R:^:f:::,:N:i::::::Y::|:::-:V:B:=::::::7::::T:::::t:@:::1:::k:::k:`::::}::f:`:::s:::::^:::::v::J:::::n::::w:::::Y:::::::::v::::q::^::::::u:M:e:::::::::::::::i:1::::::g:P:::::::4:D:R::2::x::.:T:::::::::::q::::e::::::r:::n::::::::::::i::::::::::::q
063::j::M:{::::F:::o::::::::^::B::C::::::C:::=:}::::v:::@:o:::c::::E::::::z:q::H:::::::::::::W:m::+:::v::y:I:::::c::A:u:::C::I::::::::J:r::o:r:::2:x:::.:=::7:::::_::::::j:f::f:::b:N:::,::v::$::::E::q:3::c::+:::::::_:::::m:::::p:K::d::I::m:::y:_:j::j:_:::`::X::::::::::::z:::::::J::::a::::::t:i:::::g:X:::::::h:::::::::a::::q:u:q
064:^:d:::::::B:l:v:G::G::::::E::::::j:::?:::::,:T:U::::*:U:::::1:::::9::d::d:::N::::::::::::::::}::::I:::::::::d::8:::::::=:S::+:::::::w:E:::::L::::C:::w:::::::::::w:c:::g::::j::::::t:::::::::L:1:-::f:?:Y:::W::::::^::B:::::::::a:::::o:::::::7::::w:T:::c:o:n::::D:::::::b:-::::::::::::r:::::::::5::::::e:::::::k
065::C:::::K::o::!::::N:::7::Z::+::::::::::::::4:::h::::l:::::T::g:Z:,::L::7::c::::::::T::`::::::N:::L:_:o:W:::::::::::::5::::7:E::::::F::F::!::W::::::.:::_:O:::::S:M::::.:::_:+::::c:e::N:2::::L:::B::,:::?:I::s:::::t::*::::::$::::Q:U:n:w::x::::!::::~::@:::V::l:::::Q:`:p:::N::::::::::::::::::::v::::::::::::::::::::g
066:::s::U:::I:n::S::::o::::::k::1:::|::::n::2:~::7::c::B:::::X:k:::::::`:::::I::::::::::::::::}::::::x:::::#::::8::::::X::w::::c::@::Q:::::::F::%:V::W:::::+::::q:G:#::::?:i:::{:::N:Y:^:::K:Q:::::::|::g::::I::::::::8::::::::E::9:::-:::::j:D:H:,::j:::T:::::::::i:::::::O:::6::::0::7:::p::y:+::::::q:::::z:::::::::::::k
067:::::1:::k::k:Y::x:::y:=:j::::m:~:::::::::::T::=::%:w::0:Z:::::X:::::::X:::::::=:::::p:::9:Z:K:::8:-::F:::::::::::::-:::x::N::H:S::::`:l::::p:e:M:c::::::~:~:::U:n:::$::t:c:::::0:::Y:::+::U:T::^::::`:p:2::::J::6:::::::::::d::::::::::,:c:3::::::*::J:::::t:W:::::q:::::s::E::m::::::::::::::::.::::::::::::a:::::::::::::::o
068::X:Z::R:::F:::::3:::::::3:::::::::::::T:::X:::::c::::::::::y::P:q:::i::::7:::::.:S:::+::*:B::::::V::e:J::h::v:::G:T:,::e:P:z::k:d::::::t:y:b:::::::::B::N:::::::::D:::~:::::7:L::::H::::::x:i::y:?:::::::|::::::o:=:::::::M:.:H:H::+::4:Q::K::::::d:::::w::w:V:3:::::::q::::::::Y::r:a::::s::.::W::p:::::f::::::o::u:::::::::::n::::::::u
069:::+::C:::^:T::::::::U::::z:L:T:::E::::E:::#::-:::N:3:::::::::9:1:::z:C:S:8:::::::::5:::::::o:::::J:C:D:::G:q:::::a:Z:::Q:f:::::P:,:::::::::g::L:E:::b:::d:::::q:::::s:}::C:::o::9::e:0:w::d:^::::::I::::V::::e:::E:v::::::3:::$::Y:::::o:h:_:::3:0::K::9:3:::J:::i:c::U:B::U::::H:::::o:::Z:::M:w:W:h:::::::::l::::::t:::::::::g
070:e::::P:=:::::::::B:::::H:::::::Q:4::::?:::W:::c:::7:::Z::G:::::::B:B::z:k:^:_:t:::::::x::4:e:::D:H::::s::::.::6:::M:::K::2::::::::o:~:E::v::::::::::e::x::?:::::::::::u::::`::A::b::v:s::::d:::%:1::::z:::::::N:?:m::r::::::::::::I::::e::S:::::::::::::z::r::c::D:M::::::8::::c:M:m:::::::b:::::5:::::::::::::::::::::::::::u
071::n:A:::4:::::::.::::::p::H:O::9::`:X::::~::C:::::Q:2:@:::::::3:::+:W:W:l::::::::::::M::::::::::{:_:::,::!:::~::::6::g::::H::l::::}:+::-::L::5::::u::1:$:4:::::m:::::g:N:z:v:+:B:o:u:y:h:+:q:::T::2::v:i:::::::::S::C::::W:l:::::I:::::::::M:::::w::::L::W::G::%::::::#::::7:::::::0:w:::g:X:0:::::a::::::::::::::::::::::::::::::z:::::::::::::::x
072::::::g:m:Y:m:::::::H:G:`:%:::j::W:::::`:v::::Y:e::::::i:::}:::::::::::r::D::::n::q::l:4::X:5::Q::::}:::::}:::H:$::::^:U:::::::::::::Q:.::F:::::m::::g:M:::S::::,:::::,:-::U:0::::r::::::::::::@::::G::?:S:::1::::::::V::::::::::::|::::::::::::::::3::^::6:::P::V:s:::::::::::::::W:::T:::::::o::x:8::::::::::w::::::::l::m
073:%:H:{::::E::::::4:E:z:%:::::e::9::::o::::::::8::-::::::::o::#:0:H::E::::::h::l:::J::!:::::::6:$:i:X:m:::N:::q::9::::7::::^::~::v:::::::::W:::::T::::o:::::::::8:d::|::::::::::::f:::::::::F::::::::::`::S:::6:m:::H:::::::f:8:::k:n:::::::b::v:::::::::D::d:::a:::::::::6::N:::::::::3::x:w:c:::::::::::::::::::n:::::p:::::::v
074:::::z::0:::::+:W:Y:::z:O:t:|::%:::::::::::}::::J:f:e::v:*::=::A::o::x::A::v:::H:::::!:z:::::::::::::B:D:^:4:::x:O:U::::::b::::n::::::::7:p:B:l:9::3:m::L::B::::::::::::::o:0:!:x:::::::::::X:0::::::::::s::w:::::::a:-:g::::::3::-:%:P::::8:@::::::C::=:i:J::!:::::B::,:::::::::v::::J:y:::::::4::W::::::::::::::::::m:::::::::::::::w::::::x
075::u::E:::D::O::z::S::w:::::+:::::::::::+::::::#:n::=:::::f:::::::::::k:4:::::r:n:U::::x:::::::::z:::::M:::::::::B::2:::::::::F:}:#:::::@::::::::p:::i:::::::H::::,:::I::::C::::::X::::::a:R::::l:X:::::::::U:u:Z:::::L:::%:p::G:i:::O::::a:2::::$:f:::!::::::s::::::4:::::::::::::Z:t:::i
076:::::::::+:E:Q:U::::N:J:::B:::J:.:::~::::c:^:b::3:u::::_:::::::A::-:::f::::::n:}:B::::=:::B::::::::::P:::M:w:::::::::::::::::::::9::::::::U:?:w::I:`:::P::D:::G:::::!::::::::}::::n:?:::::W::::::::a:_:::-:::::0::::2:q:::r::::W:W::::::::1:::::::3::::::::::::c::::::K:::::V::R:::::::::::::::::::::z:t::q::::::::::o
077:F:?:::::#:::e:+:u:1::::s::::a:R:P::@:::::a:_::N::k:::::z::::h:::Z::~:::::::y:o:k:t::S::::::e:9:::8:::::y:a:::::P:%::~::1:::f:8::f::5:Y::::::::::g::u:7:::::::::::F:::::::W::y:n::|::::m:::z::::::::l:C:Y:::c:::3:a::@::::I:::%::::::::::O::::::R::::@::::0:|:::q:::O:::R:j:::::::::::::j:::o:::::::t:::5::::::::q:::::::::::::::::::::::w
078::::l:n:M:::::::o::::::+::::::3:,:^::p:::N::w::::M::::#:B:t:::|:#:}:::7:::::R:::::I:j:8:e:h::::::g::::::x::::::t:K::y:F:::::::::::m:::{::Z:m::M:B:O:8:^::::::B::::::::::X::G:::::P:::F::::@:u:@:4::k::::::O::j:::::G:::.:N:r:::::S:::::T::::m::::f::::::::::G::::4::a::w:::+:::::::M::8::-::::u::::::Y:::i:::8:::::::::::g
079::::::::{:X::q:::::::a:h::::::X:x:::D::x:::B::::,:::+:::S:::l:::5:w::::*:e::::k:~::G:r::+:::::q::::S::::k:L:D:::::::x:::r:::6::T::*:o:r:a:.::::::::d::f::::K::::::::::#:i:L::Z::,:::D::U::I::::::::P::q::::::+::M:#::F:::F:::v:e::I::D::::E::2:::::u:::m::V:::::::::U::::::::::::m::v:::V:::::::7:::::::c::::::p::::::::::::::::::::::::::u
080:::d::J:::::::v:z:^:::::::0::V::::::::::::s:y::+:*::y::::::::::2::m::2::z::P::o::::::4:5:::0:X::V:c:c::A::::a:3:n::.:::y::::::::::::::7:::::%:::x:z::3:::t::8::c::=:::::::m::::$::C:::::::::::#:S:::::::::::::V:U:J::5::+:-:t:|::::::::::t::+::5:K:P:p:4:k::%:::::::1::b:I:::::3:Q:::::::::::::e::::::::x:e::::y:e:::::c:::::::::::k::::::::::::y
081:v:::2:F::8::::d::::M:::::::::{::::b::::-::::Y::q:m:h::::::::g::::::::*::::::::9::::::::::z::F:::::%:::=:M::::2:::Y::?:2::::::::::%:s:q::*::N::^::::.::,:Z:::{:::0:@::t:::::z:p:::::Q::::::::::::$:::::T:q:::::4:,:A::l::F::`::1:7:::::::h:I:::::::o:::::=:`:F:r:Z:+::::::x:::::o:::::::::::v:b::-::::::::::::::::::w::::::::::::w
082::x:N::i::q:.:8:::W:::::::::::::::::q:u::H::::q:::::j::::::::V:::::::::f:B:j:_:X:::u:%:::*:::::::::u::C::::::::::::::v::::e:::::6:C:::::::m:g:3:::9::g:$::E:9::.::7:v::j:::C::l:P::::::::-:::v:::a:::::u:::A:2:::e:r:::::5::::5::5:::::M:::u:H::g::%:::~::::$::+:+::::K:::::::::::::::::b:a
083::P::J:::I:::::::2:b:::J::::*:L::.:B:+::=:::z:::::::^:5::F::y:::::q:o:$:::k:::::o:c:3::::j:::T::::#:V::::W::@:?::::z:X:4::::`:D:::::::o:::y:%::U:::w::::::::w::@::1::a::::::::::s::::::::7:::::::0:g::P:::::5::{:::::::::=::::::T::::::::::::-:::::::U::L:T:0::::u:::::F::::0:4:+::j::f::::::d:::::::::::9::3::::::::::f::f::::o
084::7::v::,::::3:::R::::::::|:=::::W:M::::::::X:::::::::::I:::_:@:::K::=:::::=:s:S:m:::::::::4:r:s:G::::C::::::@:::::w::::^:y:::H::::2::K:W:::w::7::K::::::R:::::n::F:r:%:U:p:::*:8:::Q:!::s:::::=:#:::::.:v::P:m::,:::I:::::::::::9:::::::W:::::::::S::t:::::I:9:?:::v::#::::6:o:::::W:::::::W::::q:9:::Y:p::.:+::::::f:t:::q
085:R:::W::9:::_:b:M:::3::::9:::::::::::W::::r:::::Z:o:::?:A::::::::C::::::K:E:=::::::9:::::q::J:::::::8:u::c::::6::::::::::::::M::::+::::::4::n::::::6::::::k:f:::c:g:::::::P::D:::::q:::9:*:h::::f::::2:::::#::::4:::::::5:::Q:::R:g::::::::%::::::B::::::::c::::::::::i:5::::::r:c::m:0:::::::d:::z:::::::::::::v
086::::::w:*::::A::::::::E::::::c::k:::::7:o::::+:^::B:::::~::F:::::6:::::C::::::*::r::::~::::b:::::::::::d::::b:::K:8:::::,::c::::Q:::{:X::v:S:::a:::::::$::S::g::z:::Y:@:6::O:::::Y::*:a:::H::::::::D::::::J:::::::::k:i:z:+:s:=:::::::::U:::u:::::::M:::U::3:T:j:::::w:y:::::::::::::::::2:::::h::6:::::::7::::9:::::::::i
087:4:::::::::::::7:J:::::::::_:::::::v:~:Q:7:::P::l:::::f::::O:::t:::+:_:::}:3:w::s::1::::4:s:t::::3:::J::X:::::::::M::::::::O::Y:::::h::::::::*:=:q:::6:`:W:::::::::::::I:::::R:::W:f::::8:9:-:p:X:::::::::a:j:J::R:::^::~:::::::~::.:o:r::::.:::::::::::b::x:M::::::::g:I::::g::::::::::g:2
088:.:::::::::::s::z::::::::U::::$::::y:p:::@::::l:::::=:::U::Z::#:::::+:::::_:5:::::::::Q:2:=::::x::m:::7:::0::D:w::::O:v::+::B:O::::::,::{::::::::::::w::::`:::::::I::3:::::X:~:|:::::7:::::::v::d::!:::F:::::p:9::::L::::s::Z:-:::G:V:q:J::::::::s:::::::::W:::::5::d:d::n:::::::o:::U::s:::::::::::7:::::::::y
089::_:M:5:6:L::::::i:::::%:=::W:::::U:1:v::::9::9:::::{:Y::::::::W::U::`::^:::i::::::::Z::i::::K::::::::=::::::3::::::1:::::::L:F::::k:::::::Q:g::::#:::+:C:d:c:|:::::9::7::h::r::::::z:::::::e:g:1:::c:3:::C:w::z:::p:8:z::p::F:8:b:::::e:I:::::X:u::%:M:::h::::::+:i:::::m:*:~:::::r::5:::::::::g::S:::u::a:::x::::m:9::::::7:::::::::::::z:::::::::::::::y
090:::~:::Y:s:::::n::-::$:4:::K::::`::::::X:::::::Z::U:g::`::::+::1:::J:M:W:8:h::::W::::::H:@::::::::n:::H:::-:s::::::6:::y:::::::!::I::w::I::$:!:::::::::N::7::{:u:0:::5::a:_:u::E:::e:G::::::8:::f::::v:::::6:-::Z::v::t:::::t:r:::j::^:::!:::::::B::#::t:G::E:::::v:::::v:4::::::q:7:::r:z:::::::::::::::::s::l:::g:::::::::::::d
091:n::r::Y:.:$:::D:::::l::}::::C:o::d::#::::K:g:::::::::8:P::b:::|::::::::6::1:::::r:::::::n::f:=::e:W:::n::A:::::F:8:M::::::::E:P::::::K::E::::::::8:::::F:W:,::::::6:::::.:::::8:::Q:*:::::::::n:::?:*::::k::::::::y:w::E:Q:*:R::*:o:::::::::::::::6::W::m:M:D:8:T:v:A:b:::z:::G::N:::L::::u:M:::p:::c:::::::::3::::::::::::::::::s
092:::::K::M:::G::!::R::L:::::::y::E::!:8::}:5::::::*::F:X:V::M::w:b:::,::j:*::::~::::::::::::I::::::::::::::::::::::::N:::::::Q:::::::::J:k:J::4::K::::::K::::d::1::::::::-:?:::9:5:P::?:r::::-::::::::D:::p:@:S:::::p:$:,::::::::?:::s:::::l:::::::::::::M::n:::::::::::::::Q:::5:::x::::::i::::::q::::::::::::::::::::::::::t
093:W:::$:b::::::::::C:6:::::S::::::::::::i::a::@::::D:d:|:`:::m::::P:::.::::::-::$::P::D:U:::^::::::::::5::i::::%:::::e:I::G:V:::4::%:::s:|:::V::::o:e:T:::::::::::U:::U:b:::::}:2:}::X::%:::_::3::+:::::`:a:y:::::::W:::::::d::::!:2::::::P:o::::z:::::Z::::n:~:::::::r::x::9:G::f::U:::c::::::::::::::::::::::::::::f::::::::::::::::p:y
094:::::::::::::h:::{::B:L:::::::-:5:~:_:l:::*:::::::::W:::!:~:::k:H:a::N:1:X:::::f:::e::A::::j::::2:P:F:::C::::::c:::::::Y:::::q:::::n:::w::_:::::i:::7:{:2:L::D::::~::::::s:{:::::J:3::U::3::::::R::G:::::::r:x:::i:.:n:y:Z::K::A:::::r:::G:::l:E:!:C::::::::::P:::4:k:V:::::k:::R::::v::::::::::::a:+::::::::::::::::::::::::::y
095::::Z::8:L::::::I:::4:::::::::`:::::::o:::::v::u:::2:::6::x:A:w:a:@:E:::::}::::::::::8::::::T::::::::t:::+:N::::::i:::::?::::u:N:::::Y::::::N:::::i::I:=:l::::C:::::::::S:::::::::.:::::P:::::8::::`:K:f:6:::v:-:z::M::::O::B:::u:::}:::{::::::::::::::l::::::L:X:::::w:::::::7:+:::k:y:::::::::y:::::6::::::v::::::::::j:o
096::::X::v:::9::::::::::$:,::@:::::R::w:.:::R::l::=:~:::u:+:5::::::::::::a:::::::::::::L:8::_:::k:~::E::::::::E::::P:}:::l:=::::::9:1:+:^:::n::::::i:0::::::::u:7::::::::r:::::::2:I:~:m::*::::::::3:!::::O::W::::+:{:3::::L::r:}::u:_::::9::!::T:K::A::::`:::Q::W::::u::Y:::2::u::::d:.:::6:::::::::::n::::::::r::4::::p::h:::::::y::m::w
097:::::G:::y:7::6:1::::::::A::9:::v::::u::j:::::E:::::::::l:@::l::N::::::}:!:0:::::a::::::::::1:=::d:`::::::::.::z:S::::p:::::$::z:7:::::::::::::4:F::::::5::::::_::::::R:::S::::a::::::5:::::,::::N::8::::::::5:x::I:::I:::::5:{:::::::::g:5:::5::X:5::O:$::B::6:::::::::::::y::W:::::::::+:::::::n
098::::c::::a:::9::c:@::::y::::v:::9:::.::q:i:}::::,:::::::6:::`:v:::::::?:::5:::S:::::::7:::::p::::A:+:::4::::!::t::.::d:z:c:_:*::#:::C:a::A:::}:d:::=:::V::::::b:-::::w:a::m:~::K::S::::W:^:::::::u:n::::n:::::::,::n:::::_::f::::::7:::::k:j::::e::.:n::c::::::V:E:K::P::::E:::l::P:::r:o:::::O::R:6::::::::::::p:::::::::::::p:::t
099:::::s:J::::::*::::::i:::}::::o::S:::9::::::0:::#::T::d::D:::{:::::-::H:::=::::::0::R:::::::::::i::::::::::T:::::::Y::`:::::::S:V:::m::::p::N::::%:Q:p::I:::q:::g::::::C::::W::::V::i:}:U:n::B:::?:Y::::::::o:P:+:O:::::::c:::::Y::p:V:::$::::::::::::,::::W:%::::Z:f:i:.:::S:::::::3:::j::4:::::z:::::::::::::::::::::w::::::::y
100:A:T:::X::`:::O:y:p::d:y:::::1:::*::*::?:Z::s:::{:::a::::R::f::.::::-:j::5:O:::x::Z:L:n::::|::::z::7:::3:t::::::L:::::p::::::::s::::}::%::|:::F::G:N:::l::v::::F:%::::::X:X:-:::D:T:::-::7:::::::::::::::x::::::4::::::::v:::C:Q::k:p:::::,:`:::v:C:::T:::6::l::+:+:g:::#:Y::P:0:::::::U:.::::::-:::x:::5:y:U:::::::::::::::::k::e
101:T::@::#:N::?::n::::::::+::::C:=:u:0::F::::D:i:u:H:::i:X:0::::8:::p:::z::::::N:s:::::::::::G:2::*:%::d::I:::!::::N:,:::::c:e::::%:k:::x:::::f::::V:*:::::U:::::h:::v::=:W:%:::8:::`::::::::::::U:*:::::#:::J:U::::4:::k:x:^:::l:::::::+::W::4:z:T:2::4::::::z::I:y:g::::a::::::I::::::::::::::::::::::e:::::::::::d
102::::::::c:R:w:::0:i::g:Y::}:::$::T::m::Q::7:l::::::W:.:g:::::I:::!:::6:V:3:G::e:::|::Z:,::$::::::E:::::::::::::n:A:j:::::h:::::::J:::x:y:B::::::1:+:u::::7::::::::::I:::k:::::::m:::v::::.:::::::^:e:::%::.:.:::::::i:x:b:::A:w::::n:`:j::q::::::D:3::::::::::::3::u:O::::F::6::n:::::::T::::::::::3:::::y:::p:::::9:::f::z:::::j
103:H:::::::G::::::T::::}:::`:::R:^:P:::!:h:,::O::::::::::f:::.::i:::::::::::::x:::::::P:Z:::::::::::k:T:$:::::Z:C:Z:::O::::::::::z:::::::-:::v:::x:::::::::Q:::?:::::z::::+:::G::::::::::x:::::|:::h:B::r:~:O:::F:::::l::::|:::::9::::::f::::q::::::9:::,::::::::E:::::::::S:::::::::::+::::::::::v:l:::::c:::::::::::::::x
104:::p::::U::::::Q::Y::{::::B::::::_::N::q::::x:i::::y::{::e:::::::::?:n:f::B:K:::?:N:::b::::::::`:_:::N:f::x:n:::::::::A:::0:A:p::::v::P:B::P::L:::o:::{::d:::K::4::=:*:L:::K::C::k:::::::}:::::I::@::B:m::::::5:::::::4:.:::::V:::::a:::_:3:^:::::y:::W:::g::M:N:,:::j::::L:^::::::::::::S::v:::::V:V:+:::::::::::::::::::o::h:x:::z:t:::::::::::::::v
105::::w::O:f::::::=:l:f:8::V:::u::h:::i:g:::::::::v:~::::::::::z::A::r::s:_:::x:m::P::b:g::::::::::::U:::q:::.::N:-:i::.:?::B::j:P::i:::.:::_:::::B::::::m:::::::@:::f::::::::K:e::R:::::::::::A:::d:}:k:I:::::b:}:*:::=:t:::3::::@:U:r:|::?::!:E::::s::::::::::I:-::v::f:P::::!:a:::4::::::0:::L:v::::::::s::::::y::::::::::w:::::::::::::::::::::v
106:_:::A::::::::::::::!::::!:w::#:d:P:::::L:Y::::4::::-:::::h::J:::1::u::O::::::f:H:::S:}:N::::::::.::::::H:::b:!:::::::::Q:D:::::::::k::::I::F:::#:C:-:!::::S:G:3:::::::|:::::::::1:::k::::i::C:::k::::::S:~:::::3::::::v::g::::1::::z:::M:::::::::,:::l:::::F:::::::::m:2:s:X::::::::k::::::+:7:::::5::::k
107::S:8:::::0::::::::::::::::f:K:b:::P::T::::=:5::::`:B::`::::C::::::y::w::::::::U::::::S::$:::^::::::$:::L:::^:::::::::::C:=::::::$::`:t::I::r::::~:::::::^::j:::Q:::S:::|::T:I:::S::::::_:Z:8::S::::::L:::v:X:::?:%:E::::9:::::::::F::V:::::p::::::::::::::::::e::::::::1::Y:::2::::::::::::::::::::o::::::::::::::::::::p
108:::7:g:::::Y:g:::j:+:Q:::Y:y::P:::::::f::::::g:D::N::::::::M:::::t::::::g::@:q:::4:R:::::::x:~:}::R::::1::::D:{:_::K::::|:::::::::::::P:-:V::@::::::Q:::::B:::::::::::::N::::::::.:q:::3::`:}::::::r::V:W::::::::::::::m:%:z:::m:=::A::b:D::::::D:::D:::l:*::h:::|::X:8::D:::::::T:O:::q:1::+::::7:2:1::::::::::::::::::::::x::::k::::::t
109:!:U:::::::r:::::0::B::e:5:::F:a::::::5:D::1:2::::::x::::::4:::@::u::::C::9:::::::,:7::::-:p:::::w::p:::::::}:@:::::::Z:x:::.:9::i::::::::::::::::::,:::::N::B:u::g::::::^::=::s::::}::e:?::::o:Y::B:e:::::::::C:::B::W:::P:s:h:0::i:::3::::7::::::::3:l::D:s::%:::::::q::::::::r:U:p:::::p::::::::::::0:i::::::::::::::::m::::::l
110:Y:::6:q:^:::|::H::::8::~:b::k:::::,:::o:::::G:s:::S:R:R:::::s:::Q:::,::::::::::::T:::::::n:::::~::::k::V:::x:::y:!:R:b:::K:Y::R::0:n::::,:!:::7:::|:v:z:::::::::::o:::^:::f:::8:f:F:Z:::::::::::V:::q:J:m:j:::::.::y::::::|:::::::_::::2:l:.:::N::::{:::y:{::::y::6::8::M::::D::.:V:::J::r::::::9:9:::::::::u:4:::o::::::6::::::::::s
111::N:::::::::::E::7:b::1::Y:::::1:::K::H:G::B::::R:s:::::::T:O:::::#:-::::O::::5::w:F:V:::::t:=::::::2::+:.:::r:f::::::a::::::::9:::8:::1::+::J::~:2:::F::D::6:y:::h::.:::::::::B:::c:L:~::r::::S:::::l::::Q::D:::::.::::^:::::%::?:v:::::Z:::::p:::3:::8:T:::.::::1::::m::Q::::::L::M::7:9::::::::::::b::::::::b::::::::s::q:::::::::q
112:X:8::s::C:o:H:6:::::::::3::::::w::6:::::8::-:`:1:::::::p:+::9::i::Z:::::^::H::M:::::::0::u:::::T:::C::{:::G:0:::,:{:::3:@::x:::::::s::::D:C::::::p::B:::::t::::z:J::*:7:::x:9::4::::0:::B:::::v:::1:@::@::::y:{:::y:p::Z::::1:::y:::c::?::::::::::c:D:h::::::::s::+:::7::S::$::w::::::::::+:::l::k::Z::::::::::::5::::6
113:E::a:Q:::R:::J:I:::j:$::g:t::h:9:::*::::w:::::h:::I:::j:::~::b::q::::f:::::W:::::::::g:i:Z:q::::S:C::b::K:s::::::::H:::I::::::j:::::6::t:-:j:{:::^:Y::::q:c::V:8::::Q::{:}::D:::.::b::g::a:::::::::::4:{:h::::M:::,:a::L::L:::5:Q:::C:?:Q:::#:K:::::::::::::::W::::}::::::e::s:g::::::::3:::::::::::::e:::::i:::::::::::::::::w:w:f:::::::::r
114:d::t::::C:V:#::@:}:::::C:L:a::::::p::::::7:X::8:}:T::D::}::q::T:L::I:::::::::::i::h::l::::!::N::::0::x:::$:v:::3::::::::3::V:::5::D::::A:!::t::x:|::::::::::::U:::~::O:::::::G:::4:w::M::h:::v:::::::w::F::::P::::::8:j::p:J:::=::a:::::::::::::::8::::::::3:A:::::::V:::::O:::p::b:::::::::b:o::g::a:::::::c::::::o
115::::p::::::0:?:d:Y::::::::::v::M:::::^::::A::V:::q::::::^::^:::X:%::::::l::I::-:_:::::m:*:::y:z:::::t::0:6::::::::0:N:::::::1:Z:::::::q:c:f::W::::::::z::E:N::::M::Z:n::::::d::::-:K::0:M::C:j::::{::5::::3::v:::::::::v:D::S:~::::x::::::::p:9:::y::k:e:::m:::R:::::::9:::Q:+:::::::::y::::::::z:::::::9::::g::::k::z:t::::::t:::::::::::::::::v
116:5:::::n:::::::8:5::::2:::@::::::::::!:n:::J:J:g::r::L:X::F:$::::5:.::::p:::O:o::::.:2:G::::::T:1:Y::-:::::u:::::::::::::n:::b:V:8::::::::B:::::::::::P::r::0:R:W::s::3:::::::L:!:::::::F::|::k:::::::t:Z:::::a::~:G:N::Q::c::6::::::::.:::p:C:::2:4:::d:::{:c:::p::::::Q::::::::::::::::::::::::::::::::::t::::::::::::::::x:::::::::::u
117:::Y:V::+::::::P::::::T::b::::}:V::@::A:|:::::R:f::S::::a::Y:::::::::::D:G:::::L::::::-::::D::::5::::d:::4::M:0::}::J::F:q:::::::K:::::4:P::I::2:Y::::::O:9:f:::::::::::::%:::.:@:g:r::::::F:Y:g:O:K::::::W:::P:8::h:::}::::::::3::::::::::::Q:t:::::P:::{:}::::::_:::::::::::::Y::b:t::X::1::g:::::8:::v::::::::::::::::o:::p:n:::::::o
118:::4:8:$:::-:::::::Z::*:::I:::::::::::u:::n:::::}::::9:::m:M:::e::::E::0:_::::b:M::s:Z:5::::::v:::e:::::::::::2:::j:::-:::3::::::E:::::::S::{:::Y:`:!::::C:4::::Z:::::c::::s:::7:A:::h::$:::h:::::::::{::M::::g::M:8::h::::::::::N:m:0::::::3:::::U:x:::::I:~::E:::1::::Y::s::5:Q:p:::::::y::::U:::::7:6::::1::::::c::::::::::::::::::::z
119:::E::W:`:::U:u::::F:::::::::`:Y::F::::::::N:::y::6:-:::u::8::::c:S:::i:::C:=::2:1::::::{:|::::::::,:=::n:::j::a:::::::::::::U::::S:::x::::.:x:::::::O::::~:::::z:::Z:::|:::l::::h::R::::::.:::::H:-::p:::::!:m::w:a::Y:::::6::E::f:::::::::t:::::::::::b:b:::::8:::W::::::::::.::h:::::::::::::::::::m:::::::::i
120::K::U::::::::::::_:::b:u::T:p::::::|:::::::::::+:e::::7::::::x::p:Z:::-:::::::::g:3:R::::::::::::e:f::::::::::b:|::::r::::z:::::D::_::!::S::`:{:1:j::A::t::::y:::::::::::::Y:::::F::::6::$::::^:Y:::T:::::::G::l::U::::::p::::a:::`:}::u:::::::`:::::0:2:5::B::E::t:o:::s:c:::::r::V:::::d::q::::::-:::j:::::::::::::k
121::::f:2::::::x::?:::::o:9:::d::5:t:L::0:::::::d:L::b:p:::y:::::9::4:Z::::::j:E:y:::::::p:y::+::3:::J:|:B:,:::::::i:::::7::C:::k:@:::G::::::::::::0:N:::::::::h::F::::w:6::::^:::::s::::=::::w::::::::::::::G:G:::M:::n::::::a:H:::f:::::4:::B::6:::::3:::%:0:H:::::h:u:m:::::+::::y:::z::::::::V:::::::b:::::::::::::::r::::::::::::::u
122::R::h:::::*:$:::::1::Z:::U::E::::A::T:1:*::::a::::::::^::::::::3:u:p:::@:::::r::::Y::0:?::3:::::::::B::2::::::E:::x::9::m::::::::::::::i:::::b:x::::X:::h:::::::O:P:4::h:::U::::2::V::::S::y:::h:P:::D:b::::::::::W::::R::::::::J::::L::::L:::::7:::::::::`:::::m:0:::a::::8:W:::::::::h::c:.::::1:::::::v::::::q
123:g:E:::::::::::2:::::n:0::Z::E::f:::::::E::::::::v::::::::.:::4:e::::=::g::u::::q:::::::::P::::::::::::::*::::T:::::u:K:p:L::|:#:::4::::::::::::S::o::::V::::3::::::$::O:r:9::::::M:p:::::F::::2:::::|:::{::h::+:h:-::j:::a:v:R:::X::`:::::q::g::::d:::4::::::::::::H::x::::m::::U::::Y::4:m:h:::d::::::::::::::::::::f::::::::u
124::::C::E:::::m::::S::::::::-:z:6::}:::::s:::b:-:::K:::::R::::::::w::::::F:::e:U:P::o::::@::Z::::::::_::::g:1::8:u:B:t::m:::I:::::9:U::::::::::o::O::t:::y:8:B::::::L::u::z::::::::?:::~:e::_:D:::$::N:::::~:::::1::::C::::::::^:::%::::::::2:x:Y:::}:::*::::q::::::::9::::::K:q:::::::3::::::::5:::Z:r::::6:::::::::::l::::::w
125:w:Z::}::h:::K:::x::::::::::::::D::::::D:::::%:::1:::::,::D::9:!::::|:::.:T::Q::::a:c:H::::l::,:Y::D::1:p:c::z::::`:::::::*:b:L::E:t::0::A:::::%::::R:U:::m:::c::::::R:`::p::2::I:::::K:::b::::-:h::::::t:b::7::::~:#:X:O::::R:{:P:::1::u::b::4:n:X::::::?:p::j:::::::::::6::8:y::::J:::::::7:::::b:::q:::d::k::::8::::::t:::::x
126::::7:*::^:::_::5:::U:3:#::P:y::f::e::::m:@:3::|:V::{::a:::::::G::::::1:~:::s:::::::k:0::C:::y:::::::::::::f::::::::::j:A::::::::t:^:I:::5:Y::G:::l:h:::q:i:::::::I:y::::::M::m:j::H:::::w::::s:z:::::::::l:K::::R::w:A:=::4:m:::?::v::?:3:::::*::A::h::G:::q::.::F:z:d:K:::C:q:::6:O::::O::::::R::l:P::::::b:i::q:::::::::::l::w::::::::y
127:::::r:q::::::::::::E:f::V:k::6::O:::o:::J::::::::#:}::a:::::R::B:+:::R:::p::g:D:$:::::~:#:::i:::u:::4::?::K::h:::O:::::9:::::::::$::.:J::M:::~:::::3::::R::::::::::::::H:R:::::::::R:q::::Y::k:::9::x::::::::!::::::`:::Z:::::u:L:v::::::::n::::::V:::::::1::$:h:::Z::q::::::T:::::::::::::t::::::::::::::::::z::::::::::::::w
128::l:::::::::::D:::D:h:~::6::::F:P::::::#:::G::::J::::1:Z::q:::G:::::,:::3:::::::::::}:::-:O:::::3:T::::::::::F::::=:A:*:e::Z:::,::::R:N:::?:n::z::X:_:_::V:e::!::::H::v::{::Z:v::::y::O:V:d::D:D::::c::f:J:::r:2:z::::Q::}:::::::,:~::::t:8:D:::6:y::::6:::l:V:N:::8:#:z::t:::J:!:::::::r:u::::g:Q:::::::::::::4::::::::::::::::f:c
129:::::::::D:H:.::`::k::::::*::::::O:@:E::::x:::::6::::B:::t::::o:::::t:::P::%::2:::::::::::::,:k:G:::5:*::_:::::G:_::::w:O::::n:!:::F::|::::F:a:y:~::::z::::{:::9:::::+:Y:d:0::K::-::G:::::{:::::6:$:r::7:::=::c::::::`::::G:t::::::V:3::p:|:q::N:::::::~:::R:R:::::::e::=:T::::::::::::::q:S::::0::::v:::::9::::6:::::::j:::::::::q
130::v::::A:u:#:::e:l::::::.::}:h:q:q::?::N:n::::::P:i:K:d:2:G:V:Q:::o:::r:w::::::::::::p:%::::a:G:::_::I:.:Q:::V::e:::::::::::d:M:u:L:::`::::@:g:::::!::T:c:a::f:?::8:c::::u::::::::::::g:::,::::T:V:::::I::Y:::}::::n::::::w:,:h:f::+::@::::Q:::^::::::::::}::::::::?:K:j:::::!:::::::a:::::::::3::::::::::::::::q::::::::::::::::::::::::::::::::::y
131:::x:::f::::::4:%::p::::::5:y:S:::J::::::+::::w::!:::d:::::-:::u::D:l::::n:::4:U:0::::::9:B:O:?:::v:::::y:^::#:v:F:C::7:::::::R::a:::f:E:O:Q::::2::::1:::E::::f::N::W:^:2:::::::N::::::::5::@:L::1:::X:::d:r::Q::=::8:p:::::::::#:I::x::::::::R:i:U:t:M:2::::::::::*:::::::::::::C::G::::::::::r:q::::::::g::::::::::e:::s::::d::::::::q:u::y
132:D::K:.::i::q:P::k::d::#::Q::::::d:::::`::::::=:::6::$:::::9::::::::::U:G::{:::6:y::f:::Y::6:::@:^::::::R::o:?:U::::::::J:::::|::::::::::::u:.:#::%:::::N::::9:A::::::::::.:::M::E:p:::::8::::_::3:::L::0:T:::x:C::J:::::v:::::{:Y::`::::~:F:::5:i:::C::::f:::::::::::::r:::f:Y::::::::::::m::::::::::::::::::::r:::::q:::z:::q
133::::::::E:::::::}:::p::::::H:B::::+::::::::0:5::L:R::Q:::?::::::+::::::::y:::~::::::::3:::::f:::::A:::Q::r:`:::%:::u::K::l:m:::::4::M::::::::::P::1:%::::$:::::C::r:s::::V:H::::C:i::::::%::t:::5:::`:::D:::::V::::G:{:N:h:::::Z:::::B:I:::::::::P::i::::::::j::f:::::::::::::::::t::::::::::::6::::::::::k
134::::~::t::B:::::a::2::k::::::::::::J:::::L:::D:::::M:*:u:B::h::.:Y:8:::m:P:D:::J:::|:3::=::::::::7::::::::Q::::::8::::::U:D::5::::m::::::::t::::y::N:T::::::-:j:0::::::::::::u:::::::,:::Q::c:,:::T:::::0:i:::::J:::::9::::q:A:::F::7:`:::X:z::::::!:B::l::z:::~:::::v:::::::::::::::W:::R:::::1::::::::::::::::::::::u::::::s:::z
135::::::@:::::::$::L::::V::::U:::::U:$::::!:::::::%::::::::D::n:::::::$:::::A:@:::2::::::d::::7::::h::F::::::d::::k::!:+::::S::::::q::::B::D:2::::::::::0:::5:!:k:::::{:A:W::T::::::r:a:::x:M::d::::j:::m:l:.:$:I:O:::::::8::::+::l::::$::::4:.::*::::i:Z::::::::::M:::::::-::t:::::::::::::::w::w::::d::::::o::::::::::::::l
136::::::::U:::::@:::r::::::_::s:::::X::::t:k::6:::::4::::::{:::::#::::::O::z::o:::::k:::7::::7::j:S:::3:x:::::Y:N::v:4:X::::::z::::X:::r::8:6:::::::::::::::Q:::N::*:k:R:N::J:9::I:::::::::::::::::::v:::+:::Z::::d:1:0:::x::i::::}:Q:M::N::::Q:V:!:Q::::S:0:::::::Y:M::::::::1:::::::::::l:::::f:4:6::x:::4:l::w:::::::y::t:y
137:C:::S:::::G:M::I::::::8::5:::+:I::^:::9:e:?:::::::H:-::::::::::::::::::n::p:3:G::W:::#::a:r:::6:::::::i:,:::u:7::::::::J:E::::::::Z:::::,:::8:I:::l:%::h::H::r:::::::9::::P:::::Z:a::::{:L::w::3:G::::::::::::!::::A:::::B:::::L::::::::l::::h:?:Y::C::::::b:p:Q::::T:i::::::::::4::2::::::::::::::::::::::::::t:::::::::::s:::::::::w
138::$::K::!:l:8:::|::,:,:::::x:::{:x::::E:6:::I::::N:::::F:::::O::::P::::::4:`::G:@:G::-:9:H::::::Y::::*::::T::Q:::::::::H:::V:t:t:::::::v:O:::`:h::5::::::::J:::::::::::n:{:::9:::5::::E::C:::::G::7::::g:::E::O:^:::::::::::#::::4:c:V:T::e:::::=::z::|::::6::::t::,:::::::V:7:::::d::q:::::s::h:::::::.:j:::s::::x::::x:::::p::::::::::::p
139:::w:0:^::::3:q:::::.:::::::::::::::Y:::H:::`::u::~:I::::::::r:::m::::#::::N:9:z:0:#:_:::U:::7:I:w:::~:::::::::::_:::Q::1:n:::::::h:O::%::::::s::|:T:::K:T:D::::K:::::::G:7::::a:}:h:z::u:::m:::::::::::::W:|:s:e::::`::U::::::7::::::::#:B::P::Z:::a::J::^:?:::h:::z:-::?:::::l::::::::::e::::::::o:::::::l::::::::::::::::::::::v
140::::I:::::^:a::6:::::::::::::::9:r::::::::::A::r:::::::V:*:s:::::y::S:j::::::::,:q::r:::F:n:9:4:Z:::%:::::::::::`:::%:::r::1:c::::4:$:::::l::@:T:0::b::p:::c:::Y:::::q:::8::::d:::$:Z::::d::::::.::::::::D:::q::H::+::}:::0:::1::::X:4:::z:::::i:7::a::::e:::B:p::S:::::::::::::w:k::::::i::::::::::::-::::::8
141::1:::::::c:::-:Z::::::::n:G:::{::`:G:::0:::M:B:n::::::C::2:Q::::::::g:::::6:?::g:5:d:::N:::X:::q::::::::#::::::F:x::::::::X:+:::::::::8:D::::Q::::5::u::::E::t:::$::N::::::::::::::g:::::A:::#:::}::::::::M:L:1:-:`::D::::A::|::^:::+:7::r:::::o::::::q:Y:o:.::::::::::::b:::R:5:::Z:::::9:::::::::::0:::u
142:?::::::::::::::::|:0::l:::.:m:y:::#:::J::::%::p::|::::::::5::G:c::H::M:p::::::8::::+::::q:a:::::::b::p::~:::::::G:^::J::T::!:o:I:G:::::::1:v::T:F::::::::$::=::M:w:r:p:}::::k::+:F:1:::5::::,::::::::::e:::::B:U:c::7:c:f::e:::6:%::k:y::::::#::::::::::9::H:::::::H:::O::G::::::::M::q:x::::::::::k::::::::::::::::::::::::w::::::p
143::w:::Z:S:T:S::B:F:B:A:r:P:!:::q:e:::o:o:::::::{:C::::M:U:O:::::::::4::::::t:::::_:`:::F:A:::::~::F::::B:s::::D:^::C:S::::C:i:::::q:::::::j:::::::r::$::}:P::::$::z::::R::::L::y::::::L:w::::::1::{::-:J::?:G:::::r:::::s:::,:::::::::::O::::::::=:::9:`:::d::A::::,:t:_::::::::::::X::t:::::::f::s::::::::::::::h::::y::::::::::r::::::::::::y
144:0:|:Q:::::T::::k::a:::j::z:::::::::::,::::i:::::{:|:::::e:::::9::::j:s:::::|::`:4:::::p:k:C:n:::`:::::U:::::^:::k::%::P:::::P::::::5::::::s:{:u::l:::#:X:U::::::@:::P::::Q::e:::^:l::X::o::9:::::::::f:::::::::::Y::6::::::::::::::::R::::::::o:::::::::::#:5:::U:::w:::o:::::::::y:W:::y:::k::f:::i::::::::::l::::::::::::::::::::::::::z
145:::::?:::::Y::=::o:::f:|::::::::::7:::::g::P::s::n:::::::Q::_:::::::::::f:::::::::^:6:.::A::T:::::n:::Z:C:J:*:k::::O::b:D:::::::::::::G:d::::+:::::::h:x:::::r:1:::n:P:~::p::Q::N:::::+::::$:::F:,:i:::::::::0:::C::::U:h::?::Z::::K:::~::G::::r:::::Q:4:::::::K:B:`::w:G:::v:k::::::::::::::p:5:8:::w:::a:b
146:::::@:-::::::::u::5::::#:::::::*:I:h:Z::=:f::::::!:::::::r:::B::::::::,::$:::::::S:J::::::=:v::::P::::}:7:4:::c:m::::::::6:`:1:::::::::::h::::W:::::::o::C:::r:::::::::?:o::::M:%:f::::S::::T:n:=::::::::a::?:D::P:::::::o:::::::8:m:}::::::!::::::::A:r:::k:5:B:O::::0::::::::::::z::::::::3::3:::::j:::::::::::::::::x
147::z::+:::?:p:::a:X:O::::6:::L:::5:%::Q:$::m::::0::p:::1::n:::::::T::::::_:3:::g:::::V::::E:::?:E::|:*::::?::B:::::::o:I:g:B:::P:+:b:H::::::V::::::::::::@:::::l:::::S:::::::5:::k:::::s:::w:Y:n::::::::::N:::k::c::::E:::w::::1:::V:2::J::-:::F:::::::::2::J:!::::=:m:::f:::::Q::2::::h::::N:::::::f:W::::0::::::::::::::z
148:::::::6::g:r::::::::::::::Q::::j::::::::*:f:U:::S:::n::::8:t:::K::::::::::v:::::^::::R:::G:::::::R::::::5:e:::::::::::N:::::E::::::::::::::p:.:::::::q:::E:::E::::k::V:::=:::::::::::::::::%:~:b:E::::::x:::H:=::Q:::::S::Q:::g:::+:::F::O:F:::Q::|:h::_:::::::X:::::::f:::g:o::::X::::y
149::::::V::o::::3:::t:f::M::T:K:~:::m::::::::::::x::%::::::v:X::::::::9::::!:::^:::::::Q::h:::::::Z:.::::L:$::F::::::::::O::::h:E::p:::::::q:::7::Y::::::::::::W:::F:::c:::7:::::::k:::j:::W:b:::V:6:q::::::::::7::4:_:X:$:5:::::y::::::r::::N::::::::X::j::::::::::w:a::::::::x:w::T::::i:::::::::::::g::::::::::::::::::::::::::::w
150::::d:::::::::f:w::}::::.:=:::P::p:3:::L::G:?:::::::::l::6:U:::e:^::}:n:v::$:-::9::::::n:::n:::%:::{::b:::::w:::s:::H::,::6:::3:W:Q:::^:::p:G::::::@:`:t:::::d:g:::7:p:::A:|:p::::::::::y::::P:::`::^::::::s:::B:::L::+::i::0:::::H:::m::::c:D::::K::i:a::::::::::::u:O::::V:S:::::::I::::::::n::::a::::::c::::::::::::::::i:k
151::L:#:::::*:I:::N:::::P:,:C::L:#::::!:c:::::{::::::W::::::::::P:::::D::0:::C:8:::::::::O:V:::::::?:w:K:::::k::::::4:::a:::S:L:4::R::::V:::::::::F::::+::::::+::w::f::p:D:V::::::::6::W:::p:::b:::::::::::5:H:::B::::B:{::`:`:*::t::::_:I::Z:::5::.::o::::::t:G:D:X:i::y:3::S:n::M:d:Q::::z::x::::::::z::::::c:::r:a:::::::::b
152:::U::p::::0:::C:u:m:::::.:::2:::G:t:.:::b::V:`::0::::::p:::::H:S:::::d::::::::X:W::::::{:::::::?:r::c::3:!::*:^:P::Q::::^::::::C::l:::0:W:::::f::::::::::::K:::::::::6:::|:G:t:{:::s:a:*:K:W:i:::::::::::::A:K:::::1:::%::::::::::L:-::`:O::::Y::::::m::::::::::::::::W:::::W::0::::q:::::::w:m:::::::::::::::::::::::::::::z
153:,:::1::l:::::X:::::j:::^::::::J::::::::::Y:m::$::::::::%::H:N:b:_::7:z:::c:8:5:$:}::7:::::?:Q::::::w::u::w::S:::v:5:A:3:::::h:::0::F:J::::::~::::::::x:::L:::::`:::D::x:B:5:,:m:*:::::k::::::c::::::|:%::::::+::J:y::*:y:::T:}:::@:::=::::$:::::::b:::M:I::B:::.:S:::Q:::*:x:x::::::b::::k::::::z:t::::::::p:+:::::::::::::::::n:::::::t
154::p::x::d::m:::*:M:::::X::::::j::b:q::g::::%:a::::::~::s:}::r:::::::::::::1:~::::::::::K:1::::C::::::I:::y:Z::Q::::#:N::::f::|:u:g:::8:v::S::::d:::l:::::4:::E:x:!::::::::_::::::::::K:F:::::,:s::M:::::$:::::7::D:::::::::X:#:::::p::R:::$:f:W:::O:{::::::|::::::g:::::::t::::::::::t::::::.:U:::::::::::::::::::::::::::z::::::::::w::y
155:::::::::::j:R:7:::::{:8::!:0:^::::%:z:s:::a:::::?:::3:::V:%::u::L::w:::r:!:::3::::::::L:::C::8:f:::::o:g:,::::m::.:::::::#::8::::R:::::I::l::::::f::5:::::::::_::::G:d:4:?:B::::o:D::G:7:t:::::X::::5:f::R:m:*::::%::P::::::::+:F::::::%:::::k::::::j:::::A::::::d:::::=::::Q::::Y:::::::Z::::m::::r::0::::::::::::8:::::::::::t
156:::::::N:::C::::::::::::::::::s:K:::::::::::::O:#:g:X:*::::M:e:::::o:::T:x:::B:L:::::!::s:5:::1::::::B:Y:::p:n::::I:::,:4:B::v:t:r:l:::e:::W:!:::n:5:::,:Y:Q:{::`::1:::4::::::::}:u::::4:H:m:X:::::::::::c:o::y:{:::::::::::::::N:::::::q:5:::::Z::k:::E:V::W:::!:::::::9:::::F:::::::d:::8:::::::::::::::::::::::::c::::o
157::F:::::::::::^::::::::#::X:^:g:::^:::h::::::::d:::g:C::::a:r::p:::%::M::::i::::X:u:f:::g:::z::::::::::C::J::2:_:f:k:::::::9::::Y:::u::::r::k::::*:v::q:::*::::::::U:a:^::g::9:::::::::z::::8:::6:::::::::o::::::u::7:::::U::::N:B:::::::!:`:::2:|:::f:::H:_::d::z::U:::o:::I::::::::::::3:e::::::::::::::::::::w
158:3:c:V::a:::n:::3:T::y:^:::::::1:s::R::::-:::c:n:4:::O:::::::+:::::a::::L::3:a::%:::d:j:::::l:W:d:W::j::::::::b::::::::::::::1:G:::::k:::?:::::::::::M:::::3:::6:6:::::$:::::w::U:::::Z:Y:::::h:,::::7:::9:5:u:::::x::M:::*::t:}::x:Q:r:::I:::::::5:::_:_::::::O:y::G:z::::y:8:1::::::1:::::::V:8:::::::::::::::::::p:::::::k
159:::::_::::k:::|::U::S:::S:R::::G:_::B:c::_:::M:J:::7::N:J:$::T:0:::`:t:::^:Z:::::::#:{:::::?::b::M:j:::o:2:::0:d:::W:::*:::::::::?::U:K:h:T::::::}:6:::8:::::::::::n:d::e::::::o:::::::::::t:7::::::::::V::~::f:::0:::*:::::*:H::::::::::|:::::::::::::::r:::r:::::::o:::v:::::::::7::g:::U::::::l::::::::::::::::x:::::::::::::::y
160:y:=:::9::::S:P::9::I::::q:Y:Q::::::::O::%:::::::!:::::::C:g::::@::,:u:e::::::::O:=:O::5:^:::::}:H:G:5:::::::d::K:x::::::v:N:!::h:::::::4:i:::g:A::::e:g::::+:`:*::H:1:::::::|:::?::2::B:::::l:u:t:{:I::::::::::R:i:g:t::n:,:::g::X:::f::-::::::C:::4::::d::::@::::Y:6:U::$::::I:,:::a::L::7:::::::::::0:::::::0::8
161::I:I:3:D:::z:::1::::::V::@:=:-:::::::::V:t:::9:r:::::O:O:u::::::::::::h:7::::::::-::h:k:E::D::::::8:X::~:M:::::::p::A::::::::::::x:::i::7:*:::::::C:.::_:}::::::`:c::v:::::E::.:`:b:::::::g:::::::n:::P::::::r:::::::y:b::o::1:C:::0:::::u::::::Z::O:+:::::::m:::5:t:+:::::::::::K::::+::3::l:1::::::::::::::::y
162::::::u:A:::::::::U:::::,:::::G:A::0::y:Z:::m::::A::::S:3::5:R:Q:{:::T::N:V:^:*:J:|:W::::::M::f:-:::K:-::::9:::O:-::-:::::Q:::::::d:%:::2::3:::::::E:::s:::0::U:::::Z::::k:::%:::d:::i:q::::j:+:::4:::w::::S::N::::::b:{:N:::::::::e:::X::P::::::#:4:::::V::*:::o::::::::::::r:x::y:F::::::::i::P::::::x::::::::::::::::::k
163:=:::k:::O::e:m:V::s::u:::::::::U:Q:::::?::::.::::B:::A::$:::J:::e:$::C:::L:::::R:a:::t:w::::::T:D:M::Q::l:::c:a:d:!::^::-::::::::::m:::::::::?:::i:::::::::F:|:R:::J:P:K:|::::a::K:::::e::E:::::::V::::8::.:::::Y::::::a::e::::+::4::A:::::b:D:::::f:::::::::s::::3::::::::z:::::-:::8::::::::::y::::::::::::t::::::a
164:::::::::y:::y:::F:`:::I::q::::2:n:L:::::::::{:::::::L:::L::::k::r::P:::::D::::^:::m:.::::P::8:::a:::T::::X:l:_::::c::w:9:B:::::-:y:::::j:::::::d::R::::::::::::.:::::%:Z:::::::@:2::::z::::::::x:j::::R::s::T::::::-::::::::#::t::X::5::::x:::::1::::.:::::D:F:::I::D:::u::P::::::::j:::::::::::::::::::::::::::::::::::::::s::w
165:o:::t::::::2:C:@:M::::^:%::::?:::::::Q:g:::::::C::::::::::p::n:_:::J:%::f::`:::T:g:s:A::::::P:5:::::P::::m:p::d::::r::::%::#::::q::l:Z:o:d:::O:P:::::::g:1:p::Y:=:k:^:::F::T:Z::m:S:::::::D:k::p::S::J:k::::c:::p::U:U:::!:3:S::N:h:|:::s:0::J:w::^::r:H::::::::::L::::::a::=:::y::::n:::::2::W::::r:V:::j::R:::::::::4:::::2:::7
166::a:!:::T:::::w:O:::n::::::c:K::::::A::::::::::::::::::::N::z:g:::::::::#:::J:::::}::::U:Z:C:a::~:$:Z::::2:O::::::::7:::::i:::::::`::-::::5:::}:::G:8::f::::5::Y:x:h::::z::::m::::y::l:::::::0:|:h:.:::2::3:::H::c::2:z:Z:K::::o:I:c::::5:l::L:::::2::6:C:h:{::::!:`::n:G:t:d:v::k:::::::a::::::0:q:Z:T::::j:-:::9:e:4::1:o::o::::::::::::::::::::o
167::::O:j:F::,::::::::2:c:F:O:::::::::B::::::::t:{::y::::::?:N:7::::m:i::::::::F:::::-::::T:::::{:p::R:::::?::::i:O:::E:::::w::::s::z:::::x:Y:::L:A::::::::2:w:x:b:::@:::*::::::x:::::9::}:~:::{:N:::+::H:::::+:N:F::B:::#:U::::7::8::@:d:::g:::::::::d:q:::::::{:::?:h:::?:::L:::2:z:::::j:::::::::j:Y:::b:::::::::i::::::i:::p
168::::::::u::f::::4:::::J:::::::z:::::::::Z:::w::m::i:::P::2:::P:::Z:::c:m:,::8:::::::C:::4:*:P::::r:e::::::=:A:::L::s:::g:::::::::W:b::!:::::::::e:::A:l::v:8::`:::::K::::7::@::1::::O::Q::::::::::::::::::r::::`:::1:::::::::::s::::v::::::=:::t::4:p::::+:::::::::t::::s:::+::p::::3:::::::::z::::::::::o
169:#:6:::::a::::}::::q::y::T:::::$:::::::::6:::::::::6:z::::::::::::::::::::::::i::m:5::::0:R:l:j:::::::::V::::?::6:::::::7:,:::::f:::H:U::::::::::Q:::::::o::::::::::%::x:::O::k:7:s:::::::::::j:::T:2::::@:c:::,::x::::::-:Y::~::^::c:::::::::x:::=::s::::W::::k:::::N::z:::::m::::::::::b:::::::::::v::::::::::::t:w
170:::::::h::A::$::G:C:::::=::::::w::r:::=:::|:r::9:::::!:::::l:U:::E::_:O:w::U::::O:::::::+:m:::m:::::q::::::S:::::::,::::Q:::H::B:3:::::x:T::::b::{:::Q:::::::5:U::F:?:::E:::::!:#::b:::U:x:::::Z:::::6:Y::::::::::u::o:::X:::H::::h::_:V::^:::::,:X::::::c::~::::::::::::::::::9::::::S:c::::::8:::::::::d:::d:d:::k::::::::::::::::::s
171:::X::N::p:b::%:::5:6:D::2:c::::x:%::H:C::::::$:s:::::::::b::d::::E:::::::5::y::^:::K::::_:::::.::3::::::m:D::::::a:::$:::::::a:3:::~:::c::3:1::::p:::::3:::7:e:{:::P:::::1::$::`::::`::W:D:@:::::D:*:R:::D::e:4:R::::5::v:::,:S::::::k::R:::::Z::6::A:P::P:::A:::n:::a::l::N:K:p:7:::::8:::l:::::::::::n:::a:::::w:::f:::::::::p
172:::=::%::n::::r:::V:I::::i:V:.:::::3:7::::S::::::::@:H::::J::$::::::g:::I:A::p::::::::-:r::G::U:N:::H::d:::::!:::d:S:{:W:!:::::B:::::#:f:$:h:m:::K:U:=::::::^::n:::::3:::x:::::L:::::v:::::F:::::::::A::::C:,:z:::::z:_::::::T::::::D::H:::g::::Q::::_:G::::::::::::::q:::::::::7:i:2:l::::::::::V::6:Z::::::::::::::d:b
173:J::::::::E::::::5::+::e::::::x:::::::B::I::Z::8::::J::a:::O::::o:::::::-:::1:::::::::::Q:+:::::::g:*::::::::5::$::z:9:::::Z:V::e:_:::::M:::::{:c:n:::1:::::::#::::w:::L::::::y::?::::a:w::::`:`::I::0:::::9:z::Z:::g:O:::::u::::$:+::p:F::::F:::::u::z:_::U:g::5::l::E::S:::::::::e::::::::+::::::::::::u::::::a::m
174:M:::::R::!::?:::b::|::?:::::::3::::::::l:::I:O::::o:#::i::::*::d::F:::{:S:.::::::D:r:4:::::::::::_::=:o:=:::::::::j::::0:=:x::Q:-:2:P::^:|::c:a::}::::J::::I:{:::X:2:z:::::::Q::::N:::*::::?::::P:::H:X::L:u:::::`:z:::::::{::Q:::G::::E:::::::H:::_:::r:X::c::::::::::-:G::::p:F::::::::::::::::::::::::::::::::g:::::::::::::::::::::::::z
175:::::t::|:2:a:::::K:0:-::k:::O:V::::5::_:::`::::::F::,:::U:::::::::::T:i::E:`::k:%:::i:::::h::w:w:?::Y:::K::!::O:G:::4:w::2:W::U:::C:::w:}::X::::::^::Z::`::s:j:R::::3:::::::!::6:::::A:0:@:::::h::::m::::::^:::F:o::1:f::1::::::=::i::O:::w:-::j::::,::v:::::::t:::X:::::::::::::q::c:j:7:::::P::N::n::::::::::::u::::::8::::::::h::::m
176::i::::::::p:o::F:}::::l:::^:::x::e:::::z::I:::o::::k:3:::::::p:I:::::A::::#:L:@::::j::t::::z:#:::::::r:F:r::o:P:::C::::::3:i:c:::::|:@::o:::::::::::::::::::6:-::@::::::,:::::::g::::::C:*:r:5:Q:m::_:C::::d:::::::H::m:|:!::5::::U:::{::::::::::y:::F:::v:::::#:::_:::::::Z:n::::W:i:::Y:::::::::::::::::::::::::::::::n
177:::j:::#:~::::::e::::::::::@::::::C:m::::?::e:::::?::::::}:z:::M::2::o:::A::l:l:::h::v:::K:::::f::Y:y:5:z::@:T::`:P:::r:L:::Q:::4::}::::::::k:c::~::i::::=:::C::::b:z:E::P:~::::::a::::J::::::::::G:::4:*:::|::::::::z::::::::@::F:::::O:::::::::::X:6::$:Y:::::k:{:C:::::::J::::H::::x::-:P:::z:::::3:::::::::c:::::::::::::::::::::::::::::::x
178::{:g::4:H:::J::::N::%:0:L:::M::D::y:N:::::2::::D::::I:::::::::q::m:l::P::::::D:N::::::m:::G:u:I:B:~:^::::!::-:+::%:U:::::::@::e:J::::{::::%::K:a::::4:w::G:h::i::::v::::O:8::A::::::::D::z::M::n::E:X:::::W:R::w:::::f:W:U::::l::::~:n:::|:::C::::1:::Q:k::@::::4::M::::P:::::X:::::F::::::H:::::::::::::::::::::k:h:::::y:::p
179::::::::Z::N:_:Z::c::l:::6::~::Z:::4:H::::@::::w::::X::::::S::w:::`::.:a:T:::S::S::#:::?:C::@:::::L:@::N:S:::Y:::2:h:R::::J::o:f:::::g::::!::::::k:::::a::m::k:7:n:::I:B::::W:::::::::s:::8:::::=::o:O:,::K:Z:=:8::::$:?::::::#::::j::y:::%::::1:F:B:::H:@:l::#::T:5:k::P:::::o::V::::L::W::::Z:::e::7:::a::::r:u::::Z:::n::8::::s::::::::u::::q
180:h:-:y:r::G:b:::}::::::R:::Q::::,:,:::u:k:i::C:d::#:z:j:::::::::::B:`:::i:2::l:::::C:::R:5:}::::::::::j::b:o:Q:`:::f:8::::p:::V:t:::::7::::::::::::-:?:P:M:}::::::x:R::H:T::T:2::w::6:::y::~::::l:,:::5::c:t::::::^:::_:m:#:::g::F:@:j:::8::4::j:::9::0:N::::::::::r:::N::b::n:::::::::Y::::::::::v:g::.::::::::Y:::::::::::::l::a:::::u
181::b::?::::l:::-:H::::::6:m:9::w::::h:l::*:::m:J:K::::::N::G::::::::W::::::::::::1:M:Q:::,::::::x::$:!::z:::::R:i::::::a:H:m:w:::d:V::?:::::::::::::::::::::g::::M::::j:::^::b:::6:::::::8:::c:E::::::u::::::::::!::n::K:Y::::::::::::::::K:::I:2:::9:::::::::::h::T:::::::::::::e::::w:::::::i:u::k::::::::::::::::g
182:::q:u::k::|:::E:::::::U:r::::#::::{:e::::::E::B::7:::f::!::::N:Y::}:::n:Y::::h:c:::u:p:::::::#::::t:::::r:~:,:~:E:T:::e::}:::::::::::1:6:}::::0:::V::j:C::l:j:w:#:m::N:m:1::::5:::x:::s:::M:1:::::y:::x:m:t:0:::::Z:~::#:w:2:T::::T:H::::::::::T::7:P:f::::::::-:j:0:::B::I:::g:0:::::::::6::::::::4:::::Z:8::::9::::::::::5:::::::::::::v:::::y
183::2:::H:x:::q:::::=:+::o::::U:::::Z::C:R:::::::^:u::5::::?::::=:::::h:{::l:_:U:{::::?:::T::5:3::J:b::y::M:0::}:J::P:::e:::m:s:::::::}:*:::X::::`:i:::::::::z:|::M::9:S:b:,:::0:::::::::::~::::::6:B::::::::::,:x:F:y:I:::-::::W:Z:k::::::::l:x:e:C:::{::::W::::H:::::.:8:7:@::i::X:::::U:::::::::::::V::4:::::::::::::e::::::::::::::x::::::::::y
184:::::::e:3:V::::::::E:::::J::1::::::::::z:#:@::::::::j:::+:4::?:::::::::m:*::d::W:2:s:w:::::1::::@:7:::s:::#:::s:R:-:.:t::R::::~:::4:n:U::G:e:::h::::~::::|::::A::4::?:::`::::::M:::::J::::::H:N:a::D:k::Q:::::::%:::|::w:::::::d:P:g:z::::s:*:r:T:|:::T:J:{:n:o:::::B:F::5::n:r:2:m:t::T::::::::::::::Y:::::::::::s::::::::f:::::::t
185:$:g::n:c:::j::::::::::5::q:::_:q:}:N:::x::%::_:::::#:::::::n::L:::-::::::::::M:::l::7:::S:c::p:::u::g::::::::::::::::::::::::::::R::::h::D:::L::C:::n::::::W::*:::J::M:V:::::@:::#:`::::::~:N:=:!:$:1:::F:*:P::::::::::Y::o:::::::f:z::P::t::::$:::::}::p:e:::^::7:b:3::f:E::3::::::::::::l:c::::::::::e::y:::3:::::::::::y::::::::::t:w
186:::,:N:::::i:::::H:4::x::N::2:5::g::::::::::x::::::::::::::::2::c::::W::::::::::*::v::::::::::9:?:%:L::::n:1:j::::v:::::G:@::{:{:::::::::%:b:c::V:n:::j::::::a::::::::*:t:d::,:#:L:O:::::::P:1:a::o:{:#:u:::P::::R::v:2::#::::::::::::::.::::::$:t::-::_:M::9::::X::::::::::V:::::R:::k:::::i:T::7::::a:::::::::::::::j::::::::::::::r
187:|::::::y:+::::h::::T::::v:::::::::y:::3:::::::::K::,:::R::+::::::`::::4::q::::::::::::2::::::::8:::l:2::::::5:-:.::$::v:Q:::H::V:*:O::::p::3:::::?:c:o:::.::A:::::::q:::::t::Y:::q:::^:L:::e:::$::E:p:::::J:N::d::::q:::D::_::::::::::::1::7::,:A:::::x:::E:F:::i:::::::::::::::1::::::o:::::u::g:::::::::j:::d
188:::::::::::::m::v::::o:F:::F:::w::*::-::::::Q::::::x:1:::o:::::3:::::r::?:::j:::::::::B::::J:::::::E:::V::::::::::::::::v:-:::::::1::|:#::d:G::::#:y::?:::1:6:::K::T::!:::::::::U::::C::::j:}:::r:::::::O:::*:j::::d:~:::p:b::r:`::::g::s::::w:::}::::::::b:::::::::P:U::::::::::::::::V::::5:::l:::::u::::::l
189:t::::::B::M:V::::::e:T:::::8::0::::!:::::::4::3:::?::w::B:G:::::d:::9::::::::+::{:::c::t::X::i:::::|::::::I::b:~:o::0::?:::R:::::::::::-:::::::::T::D:::::::c::::y::::B::v:e:::::::::::0::N::p:T::v::Q:9::@::U::::X:8:::E:::J:::R:n:::::::m:E:a::P::v:::::Q::i::::@:9::d::::::::4:c::m::u::Q:::j:::::8
190::::::o:Y::.::::::_:::::g:X:}:R:::u:::::::::::::i:::s:.:5:::::R::{:::5::::::H::::B::::s:.::v:%:n::::::s:::w::::e:~:::::::::::5::::::::::::::::f::::::%::%:k:t::::#:::t::,:::U::0:f:-::}::::::::#::3::X:K::q:I:::::::::::::::::Z:x:^:w:y:::::::Y:M:::q:4:::X:R:::::T:e:o::::6::j::::::::2::::S:::::::::::::e::::::j::::::p
191::::R::D:::::=:z:::R:+:9::k:::X::::2:p:::U:::::_::$::::x::%::x::_::*::Y:::::::::i:::::v:::#:::::5:M:f:::-:::::::f::::::I::::E::^:::::::::::0::M:9::::::::F:::c:K:?::.:R::*:::::m:j:::::e::::h:::e::X:~:::+::::S::+:::::::_:::0:::::::::+:::::::z::R:::::::w::::3::::K::::::::l:::::::::::::q::::::::::::k:::h:::::::::::::x
192:::e:#::m:::::g:_::9::t::::4:::{::::1::z::2::4:X:::::1:9::::::^:::::.:::f::::v:::u:2:::X:$::::s:::::x:9:k::h::N:::::d:::f::::.::L:::::::?::::U:A:G::::r:-:H:@:::V:::::7::::::`:7::~:H:::B::f:::j::o::^::::::::d:::i:::C::::P::::::^::{:h:::A:e:5:t:$::::::::::e::N:::Z::::::%:::::P:::::::::::u:::q:::::7:::r:h::t::7:b:::::b::::::l::::::::::::::y
193::,::D:o::::::::|:::::u:#:s::M::::::i:::::::::::8:j::H:::::::%::K::z:~:#::::::q:{::x:G::::Y:::::::::Y:::g:::::::o:::::N::-:::{:V:::H:2:3:::::H::1::K:u:::Z:I::::::{:::::::::::::::+:G:0:a:::R:::::p::::e:::::F:A::B:::::c:::S:::s:E:@:::T:M::::::0::::6:D:~::::s:{:o::}::@:p::::d::::::::::::::.::n:::::+::n
194:r::5::u:c:,::::{:7:P:::w::Z:::s:c:4::::J:}:::M::::n:$:::L:::-::E::::::h:T:::$:::::d::::x:O::|:%::B:::::o::1:::N::k:::::0::V:::g:C::}:#::f:Q::::::::$::P::a::~:::::H::*::::!:h:::2:::::::::H::::::::!::::::::G::::::::::k::::::c:q::::m::t:::Z:::k:7::::$::::j::::::::::::::::::s:8:::::y:::::t::9:::9::::n:::::::q::r
195::::::::X::::::::::w:?:G::::S::M:,::G:I::t::::3::::::.:::d:!::::q::::::|:w:::::::^:@::::|::::#:::Z::::::3::::::::p:3:W:H:::I::::P::8::L::Q:O::3:::::::::::j:::::a::M:::::::::::r::::::::T::::::+:::::d:w::s:S:::::}::T::~:::::::L::k::o:::::H::S:n::::Y::-:::.::J::E:::::::::u:::z:::::::::b:::::m::::::::b::::::y::::::::::::::::x
196:2::6::y::::::::::a:@:,::G:O::::Z:7:::::o::Y:::::k:x::Q::E::!:::::2:::0::W::T:t:U:::m:p::::=:::::k:a:_::|:I::E:::|:K:M::C:::::::::::::::q:C::H:H:::e:,:X:h:n:|::::H::::::a::::l::::0:::M:A::::R:::i:p:9:::p:::9:%::d:::i::R:::3::A::::::C:::::M::::::G:{:::#:`:::+::z:::::::Q:U::::::5::::V:t::x:w:::::v::::m:::::::2:::3::::w:::u:::::::::::::::w::::x::s
197:p:::T::1::L:::::B:_::v:m:D:::::H:::{:::k:::F:::A:::::K:2::::::8:~::::x::::u::P:::::Q:::x::::::-:::7::m::::y:l::m::x:::::|:::::.::::::::g:::::::::::::0::O:Y:T:::::H::t::::=::::::J::S:::R:::=:::~:L:::::::}:u:::W:::::t:::!:::#::::S::J:r:x:O:0::::K::^:c::::::i:::N::::C:k::F:M:c:k:J::Z::::::::::X::u:::::::::n::::::7:::m
198:::W:::e::::::::::u::::*::^:i::::::::::Z:W:5::j::z::::::1:v::K:p:::::::::u:::F::::4::c:::::_::K::E:%::G::::::1::D:a:{:::{::-:C::.:::::::G:H:O::?:r::::S:::|:A:2:l:M:::::::::o:::::::h:::::h:::::Q:::::::::::::A::::I:::w::r:.:R::6::::::::U:|::C::::::m::A:A:u::::::n::4:::::::::2:::h:::::::::5::::::::c:s:f::p::::i::::::n
199::::::::h::x:::::::::!:m:{:a:O:::::d::::v::%:|::1:K:::::v::::::b:r:::::B:d:::::::::::L:::k::f::r::::::::9::::::::8:k::c:%::::$:b::T:::::::o::::c:::o:::::::s:::,::^::{::x::::a:::P:X:::::,::?:::_:z:::O::N::$:V::Q::S::k:::u:l:::B:::::$:o::::::~:k:::::b:::::f::::::L:U:J:u:e:::q:::::::::y::::::::::::::::h::::::::::::::::::::::::::u
200:k:3::y::6:S:9:2::P:::::E::-:::::::A::d:L:::::::v:N:2:e::i::::*:::~:W:::p:}:::b:::B::::3:::B::`:::::W:c::3::::::+::::t::::~:c:{:+:L:::::?:::5:n:::::::,::::w:2:e:l:::t::::::::r:r:3::}:1::N:::::::_:::::::8:l:r::n::G:7:!:::y:P:::::::::::::C:@:::}:a::a:::V:h:::z:G::::c:::6::c::::R:::t:p:::::::::m:::::::::s:::::::::::4:g:::::d
201::::::::5:::N::::::R:::::g:::k::=:{:c::::::::::::::::H:8:e:::s:G::$::::v:r:::P::::t:w:::::::j::t:n::i:::::o:H:h::V:{:k::2::$:::j::::#:::::?::::::k:::::I::X:::%::,::::::5:M::::p::9::::::@:::::!:::x:::h:::h::::5:4:::M::::::_::}:k:O::d::?::*:::::::u::T:7:!::::::w:::::::::q::::::::r::::::w::W:::::::9::d::::::::::::::::x:::u
202::k::::b:+::`::::::::::::8:::!::T:V::::R::8:+::.:e::::::p:::::7::*:::q::~:@:::::::::}:::::::Z::::t::::::::q:|::t::w:::::::z:::::7:N:::.:::f:Y::::,:::*:g:::V:::::0:h:::b::::::::q::}:::K:::n::B::::k:8::Z::::z:::|:::::^::::F:L::::::::?:::V::::::W:S:::7:`::7::8:::{:-:N::::T:::::::::::1
203:I::H:::::$:@:::F::D::::::::::::::3::!::::d:~::w:::D::::q:i:::d::%:S:j:::::::::::::x::::C:v:!::~:L:::::}:j:::::::9:::e::,:j:::::x:%:w::::%:E:::::1::I:::E::::::X:i::#:::`::V::::::::x:::j::::::::Q:::::::::::::=:::$::g:s:w::::::::::::O::::::-:3::::::::::x::=:::::::::f::n::S::::::z:::0:::::::::::::::5::::::g:::::::::::::x::::::::y
204:6:::::::::Z::::~:h:Z::::::6::::::::c::::-::::::::::::c::u:S:::|::r::::::b:M::o::y::::::u:::%::#::::7:::::L:::P::::::V:g:::::d::C:#::::x:D::::Y:::::J:e:::{:::::::::z:J::g:::::::::::F::::::q:::::::::e:::::D::a:::v::S:::::::!:::::::::::v::::^::K::::a:::::::::y::::::::::::::::::::::s::::::x:::::::z::::::y
205::::::::::::%:::::_:::::.:::::::}:::::::g:::::::q:::x::S:Y:V:v:::::::::J::C:::Y::::P::|:::::::::::::::::::z:W::::::+::::c::::::::::4:::W:::::5::::::X::::::X::3::::::::A::#::=:::T::::g:1:I:@::?:::::i:::::::::l::::::P::=:_:x::R::::::d:@:G::g:k:,::::N:::P::::::::::::X:::::::::7:::t::::::k
206::::P::::P::A:::::X:?:D::::::::O::-::::w:::m::::-::::T:D::y:::$:::::#::::::::::b::::O:::::r::::H:_:::X::O:y::S:l::::::#:::::Y::*::::Z::::::::::u::6:::G::::::B:B:::z:::::::B::v::::::e::%:::5:::::::::::`::Q::d::`:x:::=:p:j:::::::::n:::::^:i::::::*:::G:s::?:P:O:::9::I::::::Q:Z:::::5::::n:::h:::::::::::c::::i::::::r
207:::*::M:::::7::::::=::::::::::::X::Q::#:X::F:h:G:P:E::1:7:r::::d:f:::::::::::7::.:7::@:3::::y:6:L::::o:::a:E:::::L:::::::::1::::::8:$::^::,:::Q::::::::b::I::::o:::=::E::::::::::c::B:::::::~:::u:m:::E:::::::::::f:a:a::::::::$::::::::::::::::j:::::::$:@::::::::-::::u:a::::::::2::t:::5::::::c:::::::::::::::::::::::::::::::x
208::::::%:}::N:d:4:.:T:b:::5::-::7::D:::*::::::W:w::::::+::::K:W::::::::::::J::::::Y::~:6:6::w:0::::g:::{:::7:::::D:B::,:::::::~:n:n::::2:::::Z::::c::::5::2:::::3:Y:L:::::l:::l:3::::::1:::I:R:f:%:::j:6::y::B:::::::h:E:::~::::M:#:::4::::F::::::^:::::::::!:0:::M::::0::::j:::::::u::::::::-::Q:v:::::2:::::::::::::q:::::::v::i:::m
209::::z:3:r::::~:R::::::.:::2:d:|::l:!:I:::::A::p:::::::::::::}:::::::R:::b::::+:6:W::::::d:+::::k:::5:::::Z:::I:Y:::::X::::::M:|::_:D:q::Y:T:::::::::H:w::::::::::,:::G:8::W:::c::::*::^::r:m::::::`::::b:::}:H:::::$::t::::o::g:0::9::Y::2::%:%::K::X:::::::::Z:6:::Y:j:::::M::f::z:::c::s::i:g:::::::-::l:::m:::::::a:::a
210:i:::q:::{:::=:B:::g:3:::4:Z::m::r::::::~:::q:S::y::::::::7:::9:t:n::::?:::.:?:b:a:,::X:::::::Z:::C:y:z::d:D::::{::::E:}::::::p::p::::::O:::x:d::::::t:::S::P:=::4:::H:7:K:_:^:i:::4:=:p::::::::~:::!:+::1:T:::O:::~::a:::::::Y::::::::::6::::W:f:::H:j:::`:|:E:::::9:u:2::::::L:::::U::::::1:5:f::::::j::e::::::::::::::m::::n:::::::i::::l
211:::k::L:::::::Y::1:m:::::n::u::h::::+:::.:U:::::8::::C:::::::b:::::k::::::z::K::t:+::`::E:::g:b::::6:::::}:Q:T:::5:J:N:::d:?::::::V:F:F::Y:k::n:.::L:5:::::9:9::?:~:j:::::::8::::!::3:G:::::::6::::Z:::x:{:H:::::::::i:::,:::y:$::W:::::Y::S:c::k::c:::::::b:F:w::::::*::::::2:::Y:1::::::::f::::4:::::::::-::-::::::g:::e::::::::::::::y:::r
212::r:_:9::Q::_::|::q::::I::::$:::A:::s:::#:p:::W:2::::j:::%:v::::::::::Q:o:a::l::::::G:::1:::o:::::A:$::::::::1::|:A:::::::::Z:::::::::g::,:::9::::9:::R:e::::::::N:3:O:m:H::::::::::i::::%::B:::i:+:::::I:::::::::::V:::}:!::-:::Y::u:*::i::m::::::8::V:*::::::::Y::::7:T:a:::::::O::::::::::::k:0:::::::::::::::::::r::u::::h
213:}:~::m::0:k::b::K:::W::7::::D:::Q:-:8::::I::}:M::::::?::2::0:::b::J:2:L:0:::I:::::::::q::{:::A:::_:::E:::::*:l:P::::g::j::#:::h::::::d:::::Z::D:::0:O:::::$:::3::::::M:::::::W:::::::@::p:3:5::::O::::z::::q:}::R:::8:4::y:K:K:::R:g::i:::::::::u:n:%:z::b:+::C:::p::H:r:7:::c::::e:h::h:k:Z:::P::::1::::::::::::::::::::::v
214:::h:::::::U:::::!:s:::D:::`::#:::::b::::1::@::V:::^::S:U:k::#::c::::t:`::%:N:::::::I:K::::7:::M::::::A:::::::::+:::::M::::Z::::=::g::::::b:`::X::G::x:U::3::::::9::Q:::::=::::::::::::N:O::::V:::::::s:x:$:::::7:L::H:::t:A:::A:::+:j::v:::::C::m::::a::i:#::::V:q:J::H::::::4::T:::::::Q::::6:::1:::::::j::0::::::::::::::::::::p
215::0:::::v::::::-:::d:::::::::-::::::::q:c::::m:::J:V:::W::::g::::Y:::::::::::b::z:::::::f:S:::^:2:::::::::::+:G::u::T::::r::?:::O::v::::g:0:::::s:y::::::::}::::5:::::#::::::::I:::_:::4:::2::?::k:::g:::m::n::::::::::::::Y::::::^:::A:::::::j::?:J::::1:::.::a::::::m:::9:::b:::::::::f:::::::::f::::::p:::o
216:::z:::::O:::D::#::::::`:::s:::~::::4::O::j::j::::c:::::,::2:::::|:::::::I:::::::{:r:P:::::u:::+:W:V:::l:::::%:::v::.:::-:::$::::G::w:u:::p::|::.:O::Z:::::o:::t:::::}::::::::::u:::::3::y:~:::::M:v:2::::t::6:m::::::::::2:::::F:J::::::l::::a:::U::::::::::::::::3:n::::::::::::::Y:9:::::::::::::l
217::*::{:::-::::::U::K::S::F:::7:2:::0::::::p:$:::::h::::::::D:::y:Q:z::@:c:::|:::}:4:::c::::F:}:::o:::4::O:X:::X::t:r::T:::::0:::::f:::^:`:::::u:i::*::H:w::::l::u:4::::E:::::::::@::P:3::::::N:::::q::::w:::h:::X::::l::-::Y::::J:e:n::::::::::7::Z:::c::W::::p::o:::S:::::k:::::::S:::::::::::::::::j:s::::4:::::::::::::::::::::::::n
218:::::::r:@::::::::c:::::A::::i:::y:7:::8::5:::9::::::::::::W:::G:::::::::::::::X::::::::::h::$:::+:B:::I:::::::6:::^::8:w::d:::::::::::a::::::::!::::::::s::P::@:W::F::::x::M:J::::::-:6:::-::::::::::::e:L::7::2::p:::::8:u::+::::%::Y::::::::::::::::1:::::::::::::::c:::-::::::t:r::::::2:j:m::::::m:::::::j:w:i:::::::::v
219:c::c:::p:%:::s::::f:{:h::::C:::::n::::::::m:*::::::::::c::t:k:::J:::V:K:::::::::h:::::q::{:::?::::I::j:.:::5::l:u::O:M:::z:::x:t::::I:::0:::R:y:V::::::o:g::s:::::J:::=:4:::X::_::::C::-::i::p:W:::::::D::::::2:::$:D::::s:::::::K:::u:`:::G:L::,::e::F:::k:::::_::@::w:::::V:X::::::+::8:::::::::::::::::::h::a::::::::::::::::::u:::t
220::::::::::!:::H:::q:::::::n:::S:b::B::::,::::::::::-:::::::i:::::n::::::{:P::::d:1:D::::::::L::{::::I:::e:G:0:::u::T::,::::::Y:e::::::$::::Z:::r:::M::0:J:::i:::u:.::::::i:::::A:::J:::::::::::::::::::::::c:N:r:P:::::,:::#:::::::o:y:!:5::::::U::::::::::::H::::g:-:::5::n::::S::f::::::1:::3:1:::::::::::::s::::::u::::::::::::y
221::V:G::k:{::::T:::::::I:^:B:a::::J::@::::B:Y::^::2:::::a:|::::-:n::::::::::P:M:::::k:u:z:::W:::::::F::::Z::::::::J:P:y:::s:::::,::K:::::::::-:::=:X:::::::::k:d::U:C::::::::I:::::m:=::::D:Q:j::.::::O::`::B:::::::!:::F:::::::G:k:::b:U:d::::::m::e::N:::::R::::::w::::::b:::::::U:::::d::::::::z::::::2:n::::5::::v:9:::f:::::q::s::::::q
222:::C::=:::A::^::t:!:s::::::::::4::k::p:%:A:W:::t:h::z:G::::::::::X::~::::::::S:::N:L::::::!::V:::::J:::M::|::s:W::o:?:::::1:::i:I::?:q::_::m::m::::v::::6::S::::-:::@::::::::$:::::6:`::::L:B::z::y:::y::::Z:_::::::::::::::k:::L:G:7:::a::i:::|:i::::::::::o:::S:::::A::::::::S::::I:::::::::::o:::::::::j::::::::::::::::::::::o:::::::::::z
223::4::Y:::_:d::::m:::::H:::::N::@:::::::r::c:::#::k::p::n:y:::=::q:Q::f::8:::::Y:::::::N:::.::n:::::#:v:::::c:::::::::::::::R:::::u:R:8:::::::::D:p:::::::f:::t::::::8:J::::::::5:u::::5::l::.:::::%::Y:*::{::M::::::S::3::O:::::3::y:J:::Y::::::::::::N:::z::::g:0:2:::::::T::::::::O:v:::::::::::::::::::r::::::b
224:u:G:S::7:::::::`:::G:::::::Z:W:D:I::m:9::::::e:::m:i:f:t:W::{:::f:::K:::::::::::::::w:#:C:::::::p::A::::*:::::G:I::4::::+::K::::a::::::::::::C::::::::G::::::b::7:-:V::i:::::::{::_:::Z::::v::::W::n::C:o:::::::::::6:::J:A:::::::::_::w:I:::::c:P::::|:::d::::d:.:::::::::6::::::::e:::::::3
225:::::::z:f:::2::+::::M:d::::Y:|::::T:R::6::h::::::V:::`:N:~:::::C::{::5::::X:::::`:i:`:k:J:::::A:Y::K::u:z::V::::u:::v:::@:I:::@:::::U:O:D::::::K:::r::}::::?:::z:::::l::::::w:::::::3:::q:::n:::::P:::::::q::Q::r:::::::O::e::::::B:4:K:::::h::::::v:B:@:}:#:W::D:::_:j:::::::::Y:K::V:::::::::d:::0::::o:::g:+::::::::z::::::::::::::::l
226:L::D:::$:J:::::2::%:::l:::::,::O::=:::j:$:-:j:::u:::::Y:F::::a:M:::::B::+:::::z:h::v::V::::::::{:l::D:::::::$:W:::::::o::4::d:`:%:X::::Q::!:b:::X:7::G:K::::p::s:2:D:::p:::V:::7:l::::::%:i::::::::N::::Z::O:::m:X:::::k:::::E:::o:::W:::::::@:::2::P::::::::::K:u::::::+:q:p:Y:::::::i:I:u:::N:a::1:::u:::::m:4::::5
227:::::V::d:::::::::::::r::::::r:i:::P:f:5::::::::::K:@:M::B::F::::a:::y:::::T:V::::::Q::::J::::l::::::::j::s::+:::::4:::l:::b:::::y:p:::C:#::Z:::k::h:Y:::G::::2::M::E:::}::Q::C:::::8:2:::c:r:::::::::i:-::::f:?::::l::::.::::2:::::H:E::q:::J::v:%:U::::::::T:::R::::::e::s:::::j::::::::::::::::::c:q:::1
228:::}::`::::u::::::V::W:W:::E:I:::r:~::$::k::::::A:::::::h:N::::k:J::L:q:j:u:R:5::2:::@::c::.:K:::::+::$:::::@:::`:B:p::::K::r:7:G:::|::::::J:::::::P:::::`:::W::a:^:::}::+:R::::::::H::::::::::::M:::F::::X:::::::::::`:D::::::E:T:}:d:0::i:A:%::::::$::#:::L:::::Q:::b:::::C:A::s::8:::Z:::::Z::::::r::l::n:x::u
229::@:.::g:::R:::s::_::-:F::@:::::8:::c::-::z:U::::+:c::y::S:w:,::{::7:g:m:::s:::=:c:Q:::1:::::::9:h:::~:::0::::-:::R::::}:w:*:h:::k:::::6::::H::#:::@:::::::::f::::::::8::u:::::::::5::_::f:::Z::G:H::::::*::l:N::%::::K::P:::6::i:i:3:::N::P::::8:%:h:::::9:::l:::::::-:1::::::|::x:::::4::::::O::T:v:::::::::x::::::::::x
230:f::::|:::N:::::w:t:::::3:j:r::::j:::N::::!:::::5::J:x::Q:::::f:a:$:j::o:::::::::D::%:f::1:o:::::::a::R:6:::::R::S:::::::::v:s::::::-::1:a:I:::::::E:::!:J::::::i::::::1:::::v::J:2:::$::::::::::I:::h:::::c::,::U:::::::::8:q:::::::C:::-:N:v::::::b::k::`::J:::::::g:::::J:+:::V:::0::6:::::V:::::::j:::::p:::s:::::::v::p:::::n
231::J::::::J:::i:::::M:::w:S::::A:::h:::::::::W::`:::::::F:S::j::::X:::}:+::3:a:::::::::::0:x::S:::::b:W:Y::::%:::::::::}::?::::e::::B::s:::::::Q:8:::S:q:::::::::@::::::::o::::::t:$:q:V::::A:7:::1:#:::!:6::4:::::::::N::::,:J:X:X:s:D:::s::e:8::U:::^:::::w:k::E:g:a:::::::::9::x:::l:L::5:::::::::::y::::z:::::c::::u::::::::::j:::r
232:z:m:F:::::s::I:J::X:A::P:::::::Y::d:::::F:=:`:L:::::T:::::::::::::::::K:::1:M:::::::::j::::::d:y:|:::::::e:N:::U:::S::::3::::::B::0::h:::=::::R:p:6:D::0:::s::::::`:::q::_::::::4:::_:::T::q:::U:::::i:::::t::::_:7:n::R::X:::::I:w:::~::1:8:::::@:s:u::Y::Q::::::|::V:D::::j:::e:k::::::k:O:::X::::::.:k::z::w:::::::::f:::::::i
233::o::::s::::::Q::::::::::::2:::::::::::::::::o::::m:W:::i:::Y::::4:%:R:::::+::E::::::A:::9::u::::1:::::y:#:X::A:2::i::K:::::::::::::S:7:::V:::::::::6:f:Z:z:v:d::J:A:U::~::n::.:::::Y:*::g:|:f::::::4::::::::|:h:r:!:::::::5::::::::K:::::k:1:::}::::::H::::::H:::::z::::::j::P:q::::::::X::z::::l:h
234:1::n:::Z:3::~:F:::::c:n:a::n:::::::?::::::::::k::::l::z:t::::::::?::x::::0::::I:e::S::7:!:u::::F:::::::#::9::r:::::::::::::h:::::::o::X::v:C:::::E:B::::d:::::::::::::U:::::!:^:k:::u::$:::#:::.::::::::9:::::$:6:0:^::::{::::}:*::7:::::E:::::.:?:::~::q:::a::::e:d::::::::::::e:::5:::::::p::::1::::::a:q
235:::l::5:::::*:::::::::,::F::::L::::::Z:::0:E:::::::%:2:::F::::O:::3::::Y:::?::::.:*::::::::::@:::::@::g:1:::-::*::::G::2::::y:G:::c::n::z:Z::::-:%::v:::=::::C::p:b::::=::::::^::::o::::b:::z:::::C:::::o:^:Z:W::X:*:::u::::::::::::::::::r::O:::c:D::::::::::::::::::::I:::::s:::::::v::::::.
236:::::::::::::C::,:::::7::p::K::::::::::U:9:R::t:t:::I:c::::::::::4::::V::.:d::h:S:::::c::2::::I:`:M::::::::::::::::^:s::s::D::u::D::::t:H:{::::::::::::::::$::e:C:!:x::::::b:t::T:?::b::::::2::v:!::::7::p:E:w:::::::?:T::C:Z::.::::G::::::8::p::::::N:X:::::G::::::y:::i:X:::::f::1:::::::::::::::::::::4:::::::::f:::z:::::::::m
237:::R:a:S:_::::-::A::p::1::::::::~:D:::l:::::::*::::::::G:::d:0:6:::::::::F:::::::::::::o::{:O:::::::::X:::q:::K::::t::g:::r:::R:::::::2::::::::5:::::?:#:::+:y:::~:A:L::::E::::L::::::::::!::K:::E::::3::=:E:U:G:::O:B:::Q:::::::::n:::::Y::::::::::N::}:::::::1:0::::::::::::Q::::::::::::::g::::::::6:::::::::::::::r
238::::F:::::$::#::::i:::::t::H:l:+:::G::::e:x::F:::l::::M:::Q:@:K::M::D::F:=:::K:::::::::::::I::::::?:N::::::::f::|:q::*:F::_::w:F:::::::::::::::B::::::::::s:r:::::J::R:::O::::l:::%:B:::::?:::L:::::::::::::::R:::::::::::V::::::v:6::::::F:::::^:::{::::::l:::C:z::::8:v:3:::U:::::::k::::::::::::9::y::::g::::::::::::n:::::::::::::w
239::::|::::::X::e:i:::::r::N::n:6::::a:::@:s:.::::::r::{::|:_::A:::I::::%::x::v::W::::::::O::A::`::O:|:1:n:::::0::::::::t:O::::::::::::k:g:{::U:::j:.:y:::+::::|:::::v:e::::j:g:%:::O::|:$:::::::P::W:}:~::b:::u:::::Q:::::::::::q:n::::::::::::::R:::::::I:C::::::K:p::0:8::::::i::L:::::::::u:::::::::2::2:::f::u
240:::::!:P:9:=::5:f:::::X:::{::3:::::::E:::E::::q::::C::::o:v::,:::x:::::::::::::%:N::g::t::2::::::P:::J:::::_:::::::::::::m:M:W:U:::s:W::z:::::?::M:::::::::y:y::::::::F:C::::N:::::::::#:::::::U::::::::_::3:Q:7::o:::3::::P:::::S:::=:::?:?:4:::_::::#:f:1::a:`::C::K::::::M::h::::::::::::::::::::6:k:::::::::::d:e:::::w::::::::::::s
241:N::::B::V:C::4:Z:c::M::i::h:g:::S:I:j:q:::::M:::.::6::o::::::e:#:E::::T:::::O:u:8::s:x::Y:::*::a:::::a:S:::T::::~::::::7:z::U:D:::~:M:::A::3:::::::::::::I:::J:::!:::+::u:::n::b:::::D:2:::::::w:::::o::O:V::::::8:::.::::::::::::::e::::l::?:j::::n::H:::::::::::::::Z::::::::::::::X:::::::::::g::::::::::9:::d::::::::::::::::z
242::.:1::::5:g:5:::::::J::Q::i:p::7:v::R::H:::::v:::2:::V::::O::I::::::k:4:::^:::::0:R:m:::Q::V:::::w:H:::::#::_::`::::::n:q::E:B:o:::4::P:::9::::*:Z::::::::a:t:::_:::::::*:::O:::::j:u::K:S:^::::j:::I:7:9::C::o::::H:@:::::::::d:W::h:T::::::::H:h:::!:::I::#:Z:s:g:::a:|:2:::k:::::B:7::::::::9:::1:O::::::8::::o::t:::::::b:::::::::::::h::::::::::::t
243:a:t:::x:::~:::u:::::Q::_::::::B:Z:7::::S:k:R::::x:E::?:::::w:.::K::::0:k::::w:~::::t::8::8::K::::::W:::w:@::S::_::w:s:u:::q:::.:::a:::J::::`::r::o::::W::W::U:X:m:::K:z:e:v:::n::::J::9:`:Z:::!:S:::J:k:::T:6:p::u::::0:::::::::V:2:F::::::::::.::{:::::::::e::S:::x:::`::::I:::W:k:H:0::x::::i:R::::n::::::f::x:::::q::::::::::m:c:::x:::::::::::::::v
244:G::J:::K:G::::h:^::::|:F:::_:::::5:g:::a:::6:E:::::::!:.::4:::::::::L:}:D::p:N:::::::::l::$:::::::0:::0::A:::::,:m::::L::o:::e::B:A:T::2::5:_:A::9:g:::!:A:::::::::$:::i:::::::$::%:::::#::J:::Z::::=::::::::::::::Z:p::::::W::@:::K::z:::c:::3:::S:n:7::$:::::9:::D:7:::::c:n:::g:H:q::R::s::::::-::::::::n:::v:w::::::m:j:::::::::l
245::Y:2:::::::y:U:~:::::::::Y:W::=:::8:::#:::D::U:::}:::{:::8:{::s::=::::::!:::q:::::Z:,::P:0:::::::!::::L:::::*:::::1::_::=:h:::::j::::S::::J:o:::::::s:H:#:k:!::T::n::A:::::@:::4::::.:::::,:::f:d::::A:::M:V::n:::::1:d:e:@:.::::::::::y:h::b::l::w::::E:::-:|::::::::::S:::v:::::v::0:::::::::b:::::::::s::::::r:::::::::::m
246:S::3:::}:::!:v::::?::::::::-::a::l:Y:M::::::::8:q:Y::s:::J::N:a:,::::::S::::?::*::::H:D:s::::::X::::::U:::::0:m::6::::::::::7:::::b::::0::@:::::.:k:.:::::Y:::D:|::G:+:{:::9:::::K::o:::::B:!:::K::::::z::#:::::t:::b::::b:::|::`::::6:R:B::::::b:U:::::7:::C:::::S::#:A::u:::::L:::p::d:::P:9:::::5:::::n:::7:::::9:::::::::::::::::::::::u
247:-::::::4:::{:l::6:::W::G::::::::::v:3:::y::p::l:::::Z::P:::::::::::::::::n:::D:i:U::::::h:::h::$::`::::#:0::Z:`:Y:::Z::::0::x:W::1::::T::J:l:L:::::::}::::::::k:x::::::::q:q:::e::u:!::v::::v::::4:0:^:::e::E:N::D::u:::5:::::F::::::w:::::d:X::::::O::::::m::n:n::::U:::::::p:G::O:::2:::::::::::6:::::::::::::::::::::::p:::s
248:Q::9::d:::1::@:~:0:l:e::K:::::::::::I:F::::::Q:M::Y:g:H::h::j::K::::::::h:g:{:V:W:X::::::6:::::=:::::m:h:*::6:{:F::::::!:@:h::::y:7:O:::::i::L:$:::0::::::::::::::L::j::::U:::B::::::::a::4::::3:}:G:@::::::P::::::::u:^::::::m:::D:::::2::::::::::d:B:R:K:::e:::J::::::{:::j:R::K::e::2::6::Y:.:::::::::::::::j::::::::m::::::::::::v::::s
249::M::-:::7::j::t::}:8:::w:N::`:%:A:!:t:l:::::T::::::::d:M::Y::x:1::::::::^:~::C::::::p:a:::::Y::J:::::O::::::i::A:::::::C:::S::::::@:::::A::::::j::::s::_::5:@:U::::::::::?::Y::I::V:_:::b::L:G::::^:::::l::A::::V::::::.::::O::b:,:::::::!:e:@:@::q:w:^:1::S:y:L::Z:::M::%:=:::A:::::::y:::::o:2::::::5:::::::::::::::::j::k::::::::::::m::m
250:::b:::::Q:::0:S::X::^:::s:::::V:T:::x:n::P::3:!:::I:::::::::j:6:::|:!:::::F::::A:C:::X::n:H::H:L:::!:p:::#::Q:::,:::W::::6:::::::::::*::::s:j:a::::9::J::::1:::V:::q::o:m::::::r:7::::V:::::::`::::::@::::::0:::Y::::::::::=::::::k::::::9::::%:J:e::|:::::E:~:*:f::T:::::::::R:::K:n::W:i::::::::::::::::::5::l
251:V:::::::::::::::,:r::1::_:::::::::::::h::P:::::5:=:R::J:0:Y::6::b:V::2::::::::::-::::1:::9:::::::t:b::::c::::=:=:S:::D:::@:e:::::i:::Y::::::,:::::::::q:::::::::F:n:::x:6::6:$:O::Q:z::.:,:::::U:::s:{:::::::::D:::9::::::::y:.:::::=:f::d::::b:l::5::O:::%:::A:::::::::::::::::::8::Q:+:w:::6:::v:::::::::::::9
252::::::::::z::?::Z:::::c:::::::::,:g:w:V:r:::V:?:::.:::::::Z::::::$:w:@::I:::~:v::::::o::@::::k:::::::K:::|:::z::|:::::d:::j::~:v:p:+:::::::W:K:N:T:,::::u:::::l::::::::W:::i::K::9:::}::::::::`::::o::::x::Y::::::::2:::::%::K:N:::::=:::::G:v::::m:::H::O:m::L::I:::F:+:+:I::l::N::::::::::::T::::::::v::::3:::::::::::j::::::x
253:::o::I:::K::::a::::::::::z::k:+:::::::b:::::::::g:::::::y:::-:::7::::5::::f:::`::::::::l:g::::c:e:::k:::::^:$:::::y:u:::%:::::t:w::|:M:3:6:_:::::::::w:W:::}:::::::::L:::::::M::`::6::m:::_:L:I:::5:::h:::::L:0::i::M:::::::::8::M::::V::S:::::x:::::^::::m::::::d::::::7::::k::+:::::U::::v:d:9:e::::b::::3::::c:::::d
254:::0:b:::::=:::E:9:J::p:::M:::::c:::::::::::$::r:::::::@::s:@:%:::6:::4:::d:.:!:g:::.::::::i::::::::::::::::a::i:::P::::::i:::::::::=::::::C:::U:S::R::Z:X:2::::b:R:P::e:q:::::::6:::::::::a:::::::G:H::::::::::::q:4::::M:O::D:g:::::::1:=:0:::::::::#::::}:}::::::c:1:::::::::7:::::::Z:u::::Y:::::4
255::::::::::::::::::::x::::::Y::::::9:::^::Q::I:Z:9:::_::6:-::h::Q::Q::::u:::s::::M::::M::b:::::V:::::::::::b:v::::::::~::::::::::@::c:}::::W::::o:d:::::::::::`:::W:Y:S:X:::Z:{:A::~:4::9:::::R:1::::@::A:::::9:::::::U:::J::::::6:#:::#:X::T:::::::::::2::t::%:::b:::j:5::::4::::::::::::::::::::::::u:::::u:::::::j::::::::::::::::::z
EOF

        for ( split /\n/, $unmangle_data ) {
            my ($num, $rest) = split /:/, $_, 2;
            $unmangling_table[$num] = [ split /:/, $rest ];
        }

        $loaded = 1;
    }

    sub get_unmangling_table
    {
        load_unmangle_data() unless $loaded;
        return \@unmangling_table;
    }
}

1;
