use v6.d;
use Test;

use FindBin::Dirs;

my $verbose 
= %*ENV< VERBOSE > 
?? True 
!! False
;

sub pick_all
(
    IO $path --> Bool
)
{
    $path ~~ :d
}

my $subdir  = 'lib';

my $pass0  = Dirs :$verbose, :$subdir, wanted => &pick_all;
ok $pass0,  'Dirs with want dir';

my $pass1  = Dirs :$verbose  :$subdir, wanted => &pick_all, :start( $*PROGRAM-NAME );
ok $pass1,  'Dirs with want dir and start';

my @want0   = $pass0.eager;
my @want1   = $pass1.eager;

put "# Pass0:\t", @want0;
put "# Pass1:\t", @want1;

ok $pass0 ~~ $pass1, 'Bin and $*Program-Name return same list.';

done-testing;
