/*
 * Decompiled with CFR 0.152.
 */
package com.javonet.core.transmitter;

import com.javonet.core.transmitter.TransmitterWrapper;
import com.javonet.utils.RuntimeName;

public class Transmitter {
    public static synchronized byte[] sendCommand(byte[] messageByteArray) {
        int responseByteArrayLen = TransmitterWrapper.sendCommand(messageByteArray);
        if (responseByteArrayLen > 0) {
            byte[] responseByteArray = new byte[responseByteArrayLen];
            TransmitterWrapper.readResponse(responseByteArray);
            return responseByteArray;
        }
        if (responseByteArrayLen == 0) {
            String errorMessage = "Response is empty";
            throw new RuntimeException(errorMessage);
        }
        String errorMessage = TransmitterWrapper.getNativeError();
        throw new RuntimeException("Javonet native error code: " + responseByteArrayLen + ". " + errorMessage);
    }

    public static boolean deployRuntime(byte[] byteArray, String path, byte channel) {
        return TransmitterWrapper.deployRuntime(byteArray, path, channel);
    }

    public static boolean setEmbeddedRuntime(byte calledRuntimeNumber, byte calledRuntimeVersion, String path) {
        return TransmitterWrapper.setEmbeddedRuntime((byte)RuntimeName.Jvm.ordinal(), calledRuntimeNumber, calledRuntimeVersion, path);
    }

    public static int activateWithLicenceFile() {
        return Transmitter.activate("", "", "", "", "");
    }

    public static int activateWithCredentials(String email, String licenceKey) {
        return Transmitter.activate(email, licenceKey, "", "", "");
    }

    public static int activateWithCredentialsAndProxy(String email, String licenceKey, String proxyHost, String proxyUserName, String proxyPassword) {
        return Transmitter.activate(email, licenceKey, proxyHost, proxyUserName, proxyPassword);
    }

    private static int activate(String email, String licenceKey, String proxyHost, String proxyUserName, String proxyPassword) {
        int activationResult = TransmitterWrapper.activate(email, licenceKey, proxyHost, proxyUserName, proxyPassword);
        if (activationResult < 0) {
            String errorMessage = TransmitterWrapper.getNativeError();
            throw new RuntimeException("Javonet activation result: " + activationResult + ". " + errorMessage);
        }
        return activationResult;
    }
}

