/*
 * Decompiled with CFR 0.152.
 */
package com.javonet.core.generator;

import com.javonet.core.generator.IOptimizedTransmitter;
import com.javonet.core.generator.handler.GeneratorHandler;
import com.javonet.core.handler.Handler;
import com.javonet.core.interpreter.Interpreter;
import com.javonet.utils.Command;
import com.javonet.utils.CommandType;
import com.javonet.utils.ConnectionType;
import com.javonet.utils.RuntimeName;
import com.javonet.utils.TcpConnectionData;
import java.io.File;
import java.util.Locale;
import java.util.Optional;

public class TransmitterOptimizer {
    public static void optimize(Command command, Handler handler, Interpreter interpreter, ConnectionType connectionType, Optional<TcpConnectionData> tcpAddress) {
        Command optimizedCommand = new Command(command.getRuntimeName(), CommandType.OPTIMIZE, new Object[]{command});
        Command optimizedResponse = RuntimeName.Jvm == command.getRuntimeName() ? handler.handleCommand(optimizedCommand) : interpreter.execute(optimizedCommand, connectionType, tcpAddress);
        String dir = System.getProperty("user.dir");
        String classPath = System.getProperty("os.name").toLowerCase(Locale.ROOT).contains("win") ? dir + "\\Binaries\\Native\\Windows\\X64" : (System.getProperty("os.name").toLowerCase(Locale.ROOT).contains("mac") ? dir + "/Binaries/Native/MacOs/X64" : dir + "/Binaries/Native/Linux/X64");
        GeneratorHandler generatorHandler = new GeneratorHandler();
        File generatedClassFile = generatorHandler.generateOptimizedTransmitter(optimizedResponse, classPath);
        generatorHandler.compileClass(generatedClassFile);
        Class<?> clazz = generatorHandler.getClassFromUrl("JvmOptimizedTransmitter", new File(classPath));
        IOptimizedTransmitter.optimizedClasses.put(command.hashCode(), generatorHandler.getClassObject(clazz, new Object[0]));
    }
}

