#######################################################################
# $Id: Ti.t,v 1.1 2005/02/27 02:16:41 dpchrist Exp $
#
# Test script for Math::TriangularNumbers::Ti.
#
# Copyright 2005 by David Christensen <dpchrist@holgerdanske.com>
#######################################################################
# uses:
#----------------------------------------------------------------------

use Test::More tests => 30;

use Math::TriangularNumbers qw(Ti);

#######################################################################
# debugging:
#----------------------------------------------------------------------

# $Math::TriangularNumbers::debug = 1;

#######################################################################
# script:
#----------------------------------------------------------------------

ok(!defined(eval{ Ti('foo') }));				#  1
ok($@ =~ 'is not an integer');					#  2
ok(Ti(  0)  ==   0);						#  3
ok(Ti(  1)  ==   1);						#  4
ok(Ti(  2)  ==   1);						#  5
ok(Ti(  3)  ==   2);						#  6
ok(Ti(  4)  ==   2);						#  7
ok(Ti(  5)  ==   2);						#  8
ok(Ti(  6)  ==   3);						#  9
ok(Ti(  7)  ==   3);						# 10
ok(Ti(  8)  ==   3);						# 11
ok(Ti(  9)  ==   3);						# 12
ok(Ti( 10)  ==   4);						# 13
ok(Ti( 14)  ==   4);						# 14
ok(Ti( 15)  ==   5);						# 15
ok(Ti( 16)  ==   5);						# 16
ok(Ti( 21)  ==   6);						# 17
ok(Ti( 28)  ==   7);						# 18
ok(Ti( 36)  ==   8);						# 19
ok(Ti( 45)  ==   9);						# 20
ok(Ti( 55)  ==  10);						# 21
ok(Ti(210)  ==  20);						# 22
ok(Ti(465)  ==  30);						# 23
ok(Ti(820)  ==  40);						# 24
ok(Ti(5049) ==  99);						# 25
ok(Ti(5050) == 100);						# 26
ok(Ti(5051) == 100);						# 27
ok(Ti( -1)  ==  -1);						# 28
ok(Ti( -2)  ==  -1);						# 29
ok(Ti( -3)  ==  -2);						# 30

#######################################################################
