package NGS::Tools::BAMSurgeon::Trinucleotides;

use warnings;
use strict;
use Carp;
use Moose::Role;
use FindBin qw($Bin);
use Params::Validate qw(:all);
use Data::Dumper;
use File::Path qw(make_path);
use YAML qw(LoadFile);
use HPCI;
use Cwd qw(abs_path);

has 'seed' => (
	is => 'ro',
	writer => '_set_seed'
	);

has 'minvaf' => (
	is => 'ro',
	writer => '_set_minvaf'
	);

has 'maxvaf' => (
	is => 'ro',
	writer => '_set_maxvaf'
	);

has 'vafbeta1' => (
	is => 'ro',
	writer => '_set_vafbeta1'
	);

has 'vafbeta2' => (
	is => 'ro',
	writer => '_set_vafbeta2'
	);

sub trinucleotide_genome {
	my $self = shift;

	$self->log->info("trinucleotide_genome\n");
	$self->log->info("reference: " . $self->config->{reference} . "\n");
	$self->log->info("sex: " . $self->sex);
	
	my $stages = [];

	foreach my $chr (@{$self->chromosomes}) {
		my $gen_index_stage = $self->HPCI_group->stage(
			name => 'bs_trinuc_genome_' . $chr,
			command => "perl " . $self->bin . "/trinucleotide_genome.pl --genome " . $self->config->{reference} . " --trinucleotide_directory " . $self->wd . "/ref/trinucleotides --chromosome $chr",
			resources_required => {
				h_vmem => '90G'
				},
			modules_to_load => [ 'Perl-BL', 'Schedule-DRMAAc' ]
			);
		push(@{$stages}, $gen_index_stage);
		}
	return $stages;
	}

1;
