
use Getopt::Advance;

my %src2 =
       help => {
           opts => [
               "compact=b" => "compact help",
           ],
           pos => {
               topic => [
                   1,
                   sub ( $os, $help-topic ) {
                       note "Need help for topic $help-topic";
                   }
               ],
           },
       },
       cmd1 => {
           opts => [
               "op1=s" => "option 1",
               "op2=b" => "option 2",
           ],
       },
       cmd2 => {
       },
       cmd3 => {
       },
   ;

   sub try-opts ( %src, @args ) {
       my OptionSet @os;
       my OptionSet $os;

       for %src.keys -> $cmd {
           $os .= new;
           my @c = $cmd;
           @c.push: $_ with %src{$cmd}<annotation>;
           $os.insert-cmd( |@c );

           $os.append: |$_ with %src{$cmd}<opts>;
           with %src{$cmd}<pos> {
               for .keys -> $pos-name {
                   $os.insert-pos(
                       $pos-name,
                       |$_{$pos-name}
                   );
               }
           }

           @os.push: $os;
       }

       note " >> getopt({@args})";
       my $rv = getopt( @args, |@os, :compact-help );
   }

   note "--- No command, no annotations";
   try-opts( %src2, @() );
