# WebApiActiveQueryBuilder::ActiveQueryBuilderApi

## Load the API package
```perl
use WebApiActiveQueryBuilder::Object::ActiveQueryBuilderApi;
```

All URIs are relative to *https://webapi.activequerybuilder.com*

Method | HTTP request | Description
------------- | ------------- | -------------
[**get_fields_post**](ActiveQueryBuilderApi.md#get_fields_post) | **POST** /getFields | 
[**transform_post**](ActiveQueryBuilderApi.md#transform_post) | **POST** /transform | 


# **get_fields_post**
> ARRAY[Field] get_fields_post(query => $query)



### Example 
```perl
use Data::Dumper;

my $api_instance = WebApiActiveQueryBuilder::ActiveQueryBuilderApi->new();
my $query = WebApiActiveQueryBuilder::Object::SqlQuery->new(); # SqlQuery | todo

eval { 
    my $result = $api_instance->get_fields_post(query => $query);
    print Dumper($result);
};
if ($@) {
    warn "Exception when calling ActiveQueryBuilderApi->get_fields_post: $@\n";
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **query** | [**SqlQuery**](SqlQuery.md)| todo | 

### Return type

[**ARRAY[Field]**](Field.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json, text/xml
 - **Accept**: application/json, text/html

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **transform_post**
> Result transform_post(transform => $transform)



### Example 
```perl
use Data::Dumper;

my $api_instance = WebApiActiveQueryBuilder::ActiveQueryBuilderApi->new();
my $transform = WebApiActiveQueryBuilder::Object::Transform->new(); # Transform | Transforms the given SQL query according to the commands provided in this request. You can add constraints, hide some of the resultset columns, chang sorting or limit rows of resultset. All transformations are performed according to the SQL syntax and database schema provided through the registered account at https://webapi.activequerybuilder.com/ identified by the given unique identifier. All transformations can only lead to reorganization or limitation of the resultset data. This means that it's impossible to get transformed SQL that reveals any other data than the data retutned by original query.

eval { 
    my $result = $api_instance->transform_post(transform => $transform);
    print Dumper($result);
};
if ($@) {
    warn "Exception when calling ActiveQueryBuilderApi->transform_post: $@\n";
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **transform** | [**Transform**](Transform.md)| Transforms the given SQL query according to the commands provided in this request. You can add constraints, hide some of the resultset columns, chang sorting or limit rows of resultset. All transformations are performed according to the SQL syntax and database schema provided through the registered account at https://webapi.activequerybuilder.com/ identified by the given unique identifier. All transformations can only lead to reorganization or limitation of the resultset data. This means that it&#39;s impossible to get transformed SQL that reveals any other data than the data retutned by original query. | 

### Return type

[**Result**](Result.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json, text/xml
 - **Accept**: application/json, text/html

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

