# NAME

WebApiActiveQueryBuilder::Role - a Moose role for the QueryBuilderApi

Active Query Builder Web API lets create, analyze and modify SQL queries for different database servers using RESTful HTTP requests. Transforms the given SQL query according to the commands provided in this request. You can add constraints, hide some of the resultset columns, chang sorting or limit rows of resultset. All transformations are performed according to the SQL syntax and database schema provided through the registered account at https://webapi.activequerybuilder.com/ identified by the given unique identifier. All transformations can only lead to reorganization or limitation of the resultset data. This means that it's impossible to get transformed SQL that reveals any other data than the data retutned by original query.

# VERSION

Automatically generated by the [Swagger Codegen](https://github.com/swagger-api/swagger-codegen) project:

- API version: 1.1.0
- Package version: 1.1.0
- Build date: 2016-07-31T11:32:28.521+06:00
- Build package: class io.swagger.codegen.languages.PerlClientCodegen
For more information, please visit [https://webapi.activequerybuilder.com/](https://webapi.activequerybuilder.com/)

## A note on Moose

This role is the only component of the library that uses Moose. See 
WebApiActiveQueryBuilder::ApiFactory for non-Moosey usage. 

# SYNOPSIS

The Perl Swagger Codegen project builds a library of Perl modules to interact with 
a web service defined by a OpenAPI Specification. See below for how to build the 
library.

This module provides an interface to the generated library. All the classes, 
objects, and methods (well, not quite \*all\*, see below) are flattened into this 
role. 

        package MyApp;
        use Moose;
        with 'WebApiActiveQueryBuilder::Role';
        
        package main;
        
        my $api = MyApp->new({ tokens => $tokens });
        
        my $pet = $api->get_pet_by_id(pet_id => $pet_id);
        

## Structure of the library

The library consists of a set of API classes, one for each endpoint. These APIs
implement the method calls available on each endpoint. 

Additionally, there is a set of "object" classes, which represent the objects 
returned by and sent to the methods on the endpoints. 

An API factory class is provided, which builds instances of each endpoint API. 

This Moose role flattens all the methods from the endpoint APIs onto the consuming 
class. It also provides methods to retrieve the endpoint API objects, and the API 
factory object, should you need it. 

For documentation of all these methods, see AUTOMATIC DOCUMENTATION below.

## Configuring authentication

In the normal case, the OpenAPI Spec will describe what parameters are
required and where to put them. You just need to supply the tokens.

    my $tokens = {
        # basic
        username => $username,
        password => $password,
        
        # oauth
        access_token => $oauth_token,
        
        # keys
        $some_key => { token => $token,
                       prefix => $prefix, 
                       in => $in,             # 'head||query',     
                       },
                       
        $another => { token => $token,
                      prefix => $prefix, 
                      in => $in,              # 'head||query',      
                      },                   
        ...,
        
        };
        
        my $api = MyApp->new({ tokens => $tokens });

Note these are all optional, as are `prefix` and `in`, and depend on the API
you are accessing. Usually `prefix` and `in` will be determined by the code generator from
the spec and you will not need to set them at run time. If not, `in` will
default to 'head' and `prefix` to the empty string. 

The tokens will be placed in the `WebApiActiveQueryBuilder::Configuration` namespace
as follows, but you don't need to know about this. 

- `$WebApiActiveQueryBuilder::Configuration::username`

    String. The username for basic auth.

- `$WebApiActiveQueryBuilder::Configuration::password`

    String. The password for basic auth.

- `$WebApiActiveQueryBuilder::Configuration::api_key`

    Hashref. Keyed on the name of each key (there can be multiple tokens).

            $WebApiActiveQueryBuilder::Configuration::api_key = {
                    secretKey => 'aaaabbbbccccdddd',
                    anotherKey => '1111222233334444',
                    };

- `$WebApiActiveQueryBuilder::Configuration::api_key_prefix`

    Hashref. Keyed on the name of each key (there can be multiple tokens). Note not
    all api keys require a prefix.

            $WebApiActiveQueryBuilder::Configuration::api_key_prefix = {
                    secretKey => 'string',
                    anotherKey => 'same or some other string',
                    };

- `$WebApiActiveQueryBuilder::Configuration::access_token`

    String. The OAuth access token. 

# METHODS

## `base_url`

The generated code has the `base_url` already set as a default value. This method 
returns (and optionally sets, but only if the API client has not been 
created yet) the current value of `base_url`.

## `api_factory`

Returns an API factory object. You probably won't need to call this directly. 

        $self->api_factory('Pet'); # returns a WebApiActiveQueryBuilder::PetApi instance
        
        $self->pet_api;            # the same

# MISSING METHODS

Most of the methods on the API are delegated to individual endpoint API objects
(e.g. Pet API, Store API, User API etc). Where different endpoint APIs use the
same method name (e.g. `new()`), these methods can't be delegated. So you need
to call `$api->pet_api->new()`.

In principle, every API is susceptible to the presence of a few, random, undelegatable 
method names. In practice, because of the way method names are constructed, it's 
unlikely in general that any methods will be undelegatable, except for: 

        new()
        class_documentation()
        method_documentation()

To call these methods, you need to get a handle on the relevant object, either
by calling `$api->foo_api` or by retrieving an object, e.g.
`$api->get_pet_by_id(pet_id => $pet_id)`. They are class methods, so
you could also call them on class names.

# BUILDING YOUR LIBRARY

See the homepage `https://github.com/swagger-api/swagger-codegen` for full details. 
But briefly, clone the git repository, build the codegen codebase, set up your build 
config file, then run the API build script. You will need git, Java 7 or 8 and Apache
maven 3.0.3 or better already installed.

The config file should specify the project name for the generated library: 

        {"moduleName":"WWW::MyProjectName"}

Your library files will be built under `WWW::MyProjectName`.

          $ git clone https://github.com/swagger-api/swagger-codegen.git
          $ cd swagger-codegen
          $ mvn package
          $ java -jar modules/swagger-codegen-cli/target/swagger-codegen-cli.jar generate \
    -i [URL or file path to JSON swagger API spec] \
    -l perl \
    -c /path/to/config/file.json \
    -o /path/to/output/folder

Bang, all done. Run the `autodoc` script in the `bin` directory to see the API 
you just built. 

# AUTOMATIC DOCUMENTATION

You can print out a summary of the generated API by running the included
`autodoc` script in the `bin` directory of your generated library. A few
output formats are supported:

          Usage: autodoc [OPTION]

    -w           wide format (default)
    -n           narrow format
    -p           POD format 
    -H           HTML format 
    -m           Markdown format
    -h           print this help message
    -c           your application class
    

The `-c` option allows you to load and inspect your own application. A dummy
namespace is used if you don't supply your own class.

# DOCUMENTATION FROM THE OpenAPI Spec

Additional documentation for each class and method may be provided by the Swagger 
spec. If so, this is available via the `class_documentation()` and 
`method_documentation()` methods on each generated object class, and the 
`method_documentation()` method on the endpoint API classes: 

        my $cmdoc = $api->pet_api->method_documentation->{$method_name}; 
        
        my $odoc = $api->get_pet_by_id->(pet_id => $pet_id)->class_documentation;                                  
        my $omdoc = $api->get_pet_by_id->(pet_id => $pet_id)->method_documentation->{method_name}; 
        

Each of these calls returns a hashref with various useful pieces of information.

# LOAD THE MODULES

To load the API packages:
```perl
use WebApiActiveQueryBuilder::ActiveQueryBuilderApi;

```

To load the models:
```perl
use WebApiActiveQueryBuilder::Object::Condition;
use WebApiActiveQueryBuilder::Object::ConditionGroup;
use WebApiActiveQueryBuilder::Object::Field;
use WebApiActiveQueryBuilder::Object::HiddenColumn;
use WebApiActiveQueryBuilder::Object::Pagination;
use WebApiActiveQueryBuilder::Object::Result;
use WebApiActiveQueryBuilder::Object::Sorting;
use WebApiActiveQueryBuilder::Object::SqlQuery;
use WebApiActiveQueryBuilder::Object::Total;
use WebApiActiveQueryBuilder::Object::Transform;

````

# GETTING STARTED
Put the Perl SDK under the 'lib' folder in your project directory, then run the following
```perl
#!/usr/bin/perl
use lib 'lib';
use strict;
use warnings;
# load the API package
use WebApiActiveQueryBuilder::ActiveQueryBuilderApi;

# load the models
use WebApiActiveQueryBuilder::Object::Condition;
use WebApiActiveQueryBuilder::Object::ConditionGroup;
use WebApiActiveQueryBuilder::Object::Field;
use WebApiActiveQueryBuilder::Object::HiddenColumn;
use WebApiActiveQueryBuilder::Object::Pagination;
use WebApiActiveQueryBuilder::Object::Result;
use WebApiActiveQueryBuilder::Object::Sorting;
use WebApiActiveQueryBuilder::Object::SqlQuery;
use WebApiActiveQueryBuilder::Object::Total;
use WebApiActiveQueryBuilder::Object::Transform;

# for displaying the API response data
use Data::Dumper;

my $api_instance = WebApiActiveQueryBuilder::ActiveQueryBuilderApi->new();
my $query = WebApiActiveQueryBuilder::Object::SqlQuery->new(); # SqlQuery | todo

eval {
    my $result = $api_instance->get_fields_post(query => $query);
    print Dumper($result);
};
if ($@) {
    warn "Exception when calling ActiveQueryBuilderApi->get_fields_post: $@\n";
}

```

# DOCUMENTATION FOR API ENDPOINTS

All URIs are relative to *https://webapi.activequerybuilder.com*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*ActiveQueryBuilderApi* | [**get_fields_post**](docs/ActiveQueryBuilderApi.md#get_fields_post) | **POST** /getFields | 
*ActiveQueryBuilderApi* | [**transform_post**](docs/ActiveQueryBuilderApi.md#transform_post) | **POST** /transform | 


# DOCUMENTATION FOR MODELS
 - [WebApiActiveQueryBuilder::Object::Condition](docs/Condition.md)
 - [WebApiActiveQueryBuilder::Object::ConditionGroup](docs/ConditionGroup.md)
 - [WebApiActiveQueryBuilder::Object::Field](docs/Field.md)
 - [WebApiActiveQueryBuilder::Object::HiddenColumn](docs/HiddenColumn.md)
 - [WebApiActiveQueryBuilder::Object::Pagination](docs/Pagination.md)
 - [WebApiActiveQueryBuilder::Object::Result](docs/Result.md)
 - [WebApiActiveQueryBuilder::Object::Sorting](docs/Sorting.md)
 - [WebApiActiveQueryBuilder::Object::SqlQuery](docs/SqlQuery.md)
 - [WebApiActiveQueryBuilder::Object::Total](docs/Total.md)
 - [WebApiActiveQueryBuilder::Object::Transform](docs/Transform.md)


# DOCUMENTATION FOR AUTHORIATION
 All endpoints do not require authorization.



