# Generated by default/object.tt
package Paws::StorageGateway::FileSystemAssociationSummary;
  use Moose;
  has FileSystemAssociationARN => (is => 'ro', isa => 'Str');
  has FileSystemAssociationId => (is => 'ro', isa => 'Str');
  has FileSystemAssociationStatus => (is => 'ro', isa => 'Str');
  has GatewayARN => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::StorageGateway::FileSystemAssociationSummary

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::StorageGateway::FileSystemAssociationSummary object:

  $service_obj->Method(Att1 => { FileSystemAssociationARN => $value, ..., GatewayARN => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::StorageGateway::FileSystemAssociationSummary object:

  $result = $service_obj->Method(...);
  $result->Att1->FileSystemAssociationARN

=head1 DESCRIPTION

Gets the summary returned by C<ListFileSystemAssociation>, which is a
summary of a created file system association.

=head1 ATTRIBUTES


=head2 FileSystemAssociationARN => Str

The Amazon Resource Name (ARN) of the file system association.


=head2 FileSystemAssociationId => Str

The ID of the file system association.


=head2 FileSystemAssociationStatus => Str

The status of the file share. Valid Values: C<AVAILABLE> | C<CREATING>
| C<DELETING> | C<FORCE_DELETING> | C<MISCONFIGURED> | C<UPDATING> |
C<UNAVAILABLE>


=head2 GatewayARN => Str





=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::StorageGateway>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

