/*
 * Decompiled with CFR 0.152.
 */
package thredds.cataloggen;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.catalog.InvCatalogFactory;
import thredds.catalog.InvCatalogImpl;
import thredds.catalog.InvDatasetImpl;
import thredds.catalog.InvService;
import thredds.cataloggen.CatalogBuilder;
import thredds.cataloggen.StandardCatalogBuilder;
import thredds.crawlabledataset.CrawlableDataset;
import thredds.crawlabledataset.CrawlableDatasetFile;
import thredds.crawlabledataset.CrawlableDatasetFilter;

public class CatGenAndWrite {
    private static Logger log = LoggerFactory.getLogger(CatGenAndWrite.class);
    private CatalogBuilder catBuilder;
    private CrawlableDataset collectionCrDs;
    private CrawlableDataset topCatCrDs;
    private File topCatWriteDir;
    private CrawlableDatasetFilter collectionOnlyFilter;
    private InvCatalogFactory factory;

    public CatGenAndWrite(String collectionId, String collectionTitle, String collectionUrlId, InvService service, CrawlableDataset collectionCrDs, CrawlableDataset topCatCrDs, CrawlableDatasetFilter filter, InvDatasetImpl topLevelMetadataContainer, File catWriteDir) {
        String topCatWritePath = topCatCrDs.getPath().substring(collectionCrDs.getPath().length());
        File topCatWriteDir = new File(catWriteDir, topCatWritePath);
        if (!topCatWriteDir.exists() && !topCatWriteDir.mkdirs()) {
            log.error("CatGenAndWrite(): could not create directory(s) for " + topCatWriteDir.getPath());
            throw new IllegalArgumentException("Could not create directory(s) for " + topCatWriteDir.getPath());
        }
        this.topCatWriteDir = topCatWriteDir;
        this.catBuilder = new StandardCatalogBuilder(collectionUrlId, collectionTitle, collectionCrDs, filter, service, collectionId, null, null, true, null, null, null, topLevelMetadataContainer, null);
        this.collectionCrDs = collectionCrDs;
        this.topCatCrDs = topCatCrDs;
        this.collectionOnlyFilter = new CollectionOnlyCrDsFilter(filter);
        this.factory = InvCatalogFactory.getDefaultFactory(false);
    }

    public static void main1(String[] args) {
        String collectionPath = "C:/Ethan/data/mlode";
        String startPath = "grid/NCEP";
        String catWriteDirPath = "C:/Ethan/data/tmpTest";
        if (args.length == 3) {
            collectionPath = args[0];
            startPath = args[1];
            catWriteDirPath = args[2];
        }
        File catWriteDir = new File(catWriteDirPath);
        File collectionFile = new File(collectionPath);
        CrawlableDatasetFile collectionCrDs = new CrawlableDatasetFile(collectionFile);
        InvService service = new InvService("myServer", "File", collectionCrDs.getPath() + "/", null, null);
        CrawlableDatasetFilter filter = null;
        CrawlableDataset topCatCrDs = collectionCrDs.getDescendant(startPath);
        CatGenAndWrite cgaw = new CatGenAndWrite("DATA", "My data", "", service, collectionCrDs, topCatCrDs, filter, null, catWriteDir);
        try {
            cgaw.genCatAndSubCats(topCatCrDs);
        }
        catch (IOException e) {
            log.error("I/O error generating and writing catalogs at and under \"" + topCatCrDs.getPath() + "\": " + e.getMessage());
            return;
        }
    }

    public static void main(String[] args) {
        String collectionPath = "C:/Ethan/data/mlode";
        String startPath = "grid/NCEP";
        String catWriteDirPath = "C:/Ethan/code/svnThredds/tds/content/thredds/catGenAndWrite";
        if (args.length == 3) {
            collectionPath = args[0];
            startPath = args[1];
            catWriteDirPath = args[2];
        }
        File catWriteDir = new File(catWriteDirPath);
        File collectionFile = new File(collectionPath);
        CrawlableDatasetFile collectionCrDs = new CrawlableDatasetFile(collectionFile);
        InvService service = new InvService("myServer", "OPENDAP", "/thredds/dodsC/", null, null);
        CrawlableDatasetFilter filter = null;
        CrawlableDataset topCatCrDs = collectionCrDs.getDescendant(startPath);
        CatGenAndWrite cgaw = new CatGenAndWrite("DATA", "My data", "mlode", service, collectionCrDs, topCatCrDs, filter, null, catWriteDir);
        try {
            cgaw.genCatAndSubCats(topCatCrDs);
        }
        catch (IOException e) {
            log.error("I/O error generating and writing catalogs at and under \"" + topCatCrDs.getPath() + "\": " + e.getMessage());
            return;
        }
    }

    public void genAndWriteCatalogTree() throws IOException {
        this.genCatAndSubCats(this.topCatCrDs);
    }

    private void genCatAndSubCats(CrawlableDataset catCrDs) throws IOException {
        String catWritePath = catCrDs.getPath().substring(this.topCatCrDs.getPath().length());
        File catWriteDir = new File(this.topCatWriteDir, catWritePath);
        if (!catWriteDir.exists() && !catWriteDir.mkdirs()) {
            log.error("genCatAndSubCats(): could not create directory(s) for " + catWriteDir.getPath());
            throw new IOException("Could not create directory(s) for " + catWriteDir.getPath());
        }
        File catFile = new File(catWriteDir, "catalog.xml");
        InvCatalogImpl cat = this.catBuilder.generateCatalog(catCrDs);
        this.factory.writeXML(cat, catFile.getAbsolutePath());
        List<CrawlableDataset> collectionChildren = catCrDs.listDatasets(this.collectionOnlyFilter);
        for (CrawlableDataset curCrDs : collectionChildren) {
            this.genCatAndSubCats(curCrDs);
        }
    }

    static class CollectionOnlyCrDsFilter
    implements CrawlableDatasetFilter {
        private CrawlableDatasetFilter filter;

        CollectionOnlyCrDsFilter(CrawlableDatasetFilter filter) {
            this.filter = filter;
        }

        public boolean accept(CrawlableDataset dataset) {
            if (dataset.isCollection()) {
                if (this.filter == null) {
                    return true;
                }
                return this.filter.accept(dataset);
            }
            return false;
        }

        public Object getConfigObject() {
            return null;
        }
    }
}

