use Test::More qw(no_plan);
use App::RecordStream::Test::OperationHelper;

use strict;
use warnings;

BEGIN { use_ok( 'App::RecordStream::Operation::toptable' ) };

my $stream1 = <<STREAM;
{"c":"0","a":"2","b":"2","d":"2","ct":2}
{"c":"0","a":"0","b":"2","d":"0","ct":3}
{"c":"0","a":"1","b":"1","d":"0","ct":7}
{"c":"1","a":"2","b":"2","d":"1","ct":8}
{"c":"0","a":"2","b":"0","d":"2","ct":1}
{"c":"2","a":"0","b":"0","d":"1","ct":1}
{"c":"2","a":"2","b":"1","d":"2","ct":3}
{"c":"2","a":"0","b":"0","d":"0","ct":22}
{"c":"2","a":"0","b":"0","d":"2","ct":6}
{"c":"2","a":"1","b":"1","d":"1","ct":4}
{"c":"2","a":"0","b":"2","d":"2","ct":27}
{"c":"1","a":"1","b":"0","d":"0","ct":17}
{"c":"2","a":"0","b":"2","d":"1","ct":4}
{"c":"1","a":"1","b":"0","d":"1","ct":2}
{"c":"1","a":"0","b":"0","d":"0","ct":4}
{"c":"0","a":"0","b":"0","d":"2","ct":23}
{"c":"0","a":"0","b":"1","d":"0","ct":24}
{"c":"1","a":"2","b":"2","d":"2","ct":26}
{"c":"1","a":"1","b":"1","d":"1","ct":8}
{"c":"0","a":"2","b":"0","d":"1","ct":1}
{"c":"2","a":"2","b":"1","d":"1","ct":21}
{"c":"1","a":"1","b":"1","d":"0","ct":7}
{"c":"0","a":"1","b":"0","d":"2","ct":8}
{"c":"2","a":"0","b":"2","d":"0","ct":2}
{"c":"2","a":"2","b":"2","d":"2","ct":26}
{"c":"1","a":"1","b":"2","d":"1","ct":24}
{"c":"1","a":"0","b":"2","d":"1","ct":1}
{"c":"0","a":"1","b":"1","d":"1","ct":5}
{"c":"0","a":"0","b":"0","d":"0","ct":27}
{"c":"2","a":"2","b":"0","d":"2","ct":25}
{"c":"2","a":"1","b":"2","d":"1","ct":1}
{"c":"1","a":"2","b":"1","d":"1","ct":21}
{"c":"0","a":"0","b":"2","d":"2","ct":20}
{"c":"2","a":"2","b":"2","d":"1","ct":22}
{"c":"1","a":"2","b":"1","d":"0","ct":9}
{"c":"0","a":"1","b":"0","d":"0","ct":28}
STREAM

my $table1a = <<TABLE;
+-+-+-+--+--+--+--+--+--+-+--+--+
| | |a|2 |  |  |0 |  |  |1|  |  |
+-+-+-+--+--+--+--+--+--+-+--+--+
| | |b|2 |0 |1 |2 |0 |1 |1|0 |2 |
+-+-+-+--+--+--+--+--+--+-+--+--+
|c|d| |  |  |  |  |  |  | |  |  |
+-+-+-+--+--+--+--+--+--+-+--+--+
|0|2| |2 |1 |  |20|23|  | |8 |  |
+-+-+-+--+--+--+--+--+--+-+--+--+
| |0| |  |  |  |3 |27|24|7|28|  |
+-+-+-+--+--+--+--+--+--+-+--+--+
| |1| |  |1 |  |  |  |  |5|  |  |
+-+-+-+--+--+--+--+--+--+-+--+--+
|1|1| |8 |  |21|1 |  |  |8|2 |24|
+-+-+-+--+--+--+--+--+--+-+--+--+
| |0| |  |  |9 |  |4 |  |7|17|  |
+-+-+-+--+--+--+--+--+--+-+--+--+
| |2| |26|  |  |  |  |  | |  |  |
+-+-+-+--+--+--+--+--+--+-+--+--+
|2|1| |22|  |21|4 |1 |  |4|  |1 |
+-+-+-+--+--+--+--+--+--+-+--+--+
| |2| |26|25|3 |27|6 |  | |  |  |
+-+-+-+--+--+--+--+--+--+-+--+--+
| |0| |  |  |  |2 |22|  | |  |  |
+-+-+-+--+--+--+--+--+--+-+--+--+
TABLE

App::RecordStream::Test::OperationHelper->test_output(
  'toptable',
  ['--x', 'a,b', '--y', 'c,d'],
  $stream1,
  $table1a,
);

my $table1a_records = <<RECORDS;
{"c":"0","a":{"1":{"b":{"1":"","0":8,"2":""}},"0":{"b":{"1":"","0":23,"2":20}},"2":{"b":{"1":"","0":1,"2":2}}},"d":"2"}
{"c":"0","a":{"1":{"b":{"1":7,"0":28,"2":""}},"0":{"b":{"1":24,"0":27,"2":3}},"2":{"b":{"1":"","0":"","2":""}}},"d":"0"}
{"c":"0","a":{"1":{"b":{"1":5,"0":"","2":""}},"0":{"b":{"1":"","0":"","2":""}},"2":{"b":{"1":"","0":1,"2":""}}},"d":"1"}
{"c":"1","a":{"1":{"b":{"1":8,"0":2,"2":24}},"0":{"b":{"1":"","0":"","2":1}},"2":{"b":{"1":21,"0":"","2":8}}},"d":"1"}
{"c":"1","a":{"1":{"b":{"1":7,"0":17,"2":""}},"0":{"b":{"1":"","0":4,"2":""}},"2":{"b":{"1":9,"0":"","2":""}}},"d":"0"}
{"c":"1","a":{"1":{"b":{"1":"","0":"","2":""}},"0":{"b":{"1":"","0":"","2":""}},"2":{"b":{"1":"","0":"","2":26}}},"d":"2"}
{"c":"2","a":{"1":{"b":{"1":4,"0":"","2":1}},"0":{"b":{"1":"","0":1,"2":4}},"2":{"b":{"1":21,"0":"","2":22}}},"d":"1"}
{"c":"2","a":{"1":{"b":{"1":"","0":"","2":""}},"0":{"b":{"1":"","0":6,"2":27}},"2":{"b":{"1":3,"0":25,"2":26}}},"d":"2"}
{"c":"2","a":{"1":{"b":{"1":"","0":"","2":""}},"0":{"b":{"1":"","0":22,"2":2}},"2":{"b":{"1":"","0":"","2":""}}},"d":"0"}
RECORDS

App::RecordStream::Test::OperationHelper->do_match(
  'toptable',
  ['--x', 'a,b', '--y', 'c,d', '--records'],
  $stream1,
  $table1a_records,
);

my $table1b = <<TABLE;
+-+-+--+-+--+-+-+-+-+--+
| |a|2 | |  |0| |1| |  |
+-+-+--+-+--+-+-+-+-+--+
| |b|2 |0|1 |0|2|1|0|2 |
+-+-+--+-+--+-+-+-+-+--+
|c| |  | |  | | | | |  |
+-+-+--+-+--+-+-+-+-+--+
|1| |8 | |21| |1|8|2|24|
+-+-+--+-+--+-+-+-+-+--+
|2| |22| |21|1|4|4| |1 |
+-+-+--+-+--+-+-+-+-+--+
|0| |  |1|  | | |5| |  |
+-+-+--+-+--+-+-+-+-+--+
TABLE

App::RecordStream::Test::OperationHelper->test_output(
  'toptable',
  ['--x', 'a,b', '--y', 'c', '--p', 'd=1'],
  $stream1,
  $table1b,
);

my $table1c = <<TABLE;
+-+-+-+--+--+--+
| | |a|0 |  |  |
+-+-+-+--+--+--+
| | |b|2 |0 |1 |
+-+-+-+--+--+--+
|c|d| |  |  |  |
+-+-+-+--+--+--+
|0|0| |3 |27|24|
+-+-+-+--+--+--+
| |2| |20|23|  |
+-+-+-+--+--+--+
|2|1| |4 |1 |  |
+-+-+-+--+--+--+
| |0| |2 |22|  |
+-+-+-+--+--+--+
| |2| |27|6 |  |
+-+-+-+--+--+--+
|1|0| |  |4 |  |
+-+-+-+--+--+--+
| |1| |1 |  |  |
+-+-+-+--+--+--+
TABLE

App::RecordStream::Test::OperationHelper->test_output(
  'toptable',
  ['--x', 'a,b', '--y', 'c,d', '--pin', 'a=0'],
  $stream1,
  $table1c,
);

my $stream2 = <<STREAM;
{"avg_d":2,"c":"0","a":"2","b":"2","ct":2}
{"avg_d":0.448275862068966,"c":"2","a":"0","b":"0","ct":29}
{"avg_d":1,"c":"2","a":"1","b":"1","ct":4}
{"avg_d":0.105263157894737,"c":"1","a":"1","b":"0","ct":19}
{"avg_d":0,"c":"1","a":"0","b":"0","ct":4}
{"avg_d":0,"c":"0","a":"0","b":"1","ct":24}
{"avg_d":1.76470588235294,"c":"1","a":"2","b":"2","ct":34}
{"avg_d":1.5,"c":"0","a":"2","b":"0","ct":2}
{"avg_d":1.125,"c":"2","a":"2","b":"1","ct":24}
{"avg_d":0.509090909090909,"c":"1","a":"1","b":"1","ct":55}
{"avg_d":1.75757575757576,"c":"2","a":"0","b":"2","ct":33}
{"avg_d":1,"c":"1","a":"1","b":"2","ct":24}
{"avg_d":1,"c":"1","a":"0","b":"2","ct":1}
{"avg_d":0.78125,"c":"0","a":"1","b":"1","ct":32}
{"avg_d":0.92,"c":"0","a":"0","b":"0","ct":50}
{"avg_d":2,"c":"2","a":"2","b":"0","ct":25}
{"avg_d":1,"c":"2","a":"1","b":"2","ct":1}
{"avg_d":1.73913043478261,"c":"0","a":"0","b":"2","ct":23}
{"avg_d":1.54166666666667,"c":"2","a":"2","b":"2","ct":48}
{"avg_d":0.7,"c":"1","a":"2","b":"1","ct":30}
{"avg_d":0.444444444444444,"c":"0","a":"1","b":"0","ct":36}
STREAM

my $table2 = <<TABLE;
+-+-+-----+----------------+--+-----------------+--+-----------------+--+
| | |b    |2               |  |0                |  |1                |  |
+-+-+-----+----------------+--+-----------------+--+-----------------+--+
| | |FIELD|avg_d           |ct|avg_d            |ct|avg_d            |ct|
+-+-+-----+----------------+--+-----------------+--+-----------------+--+
|c|a|     |                |  |                 |  |                 |  |
+-+-+-----+----------------+--+-----------------+--+-----------------+--+
|0|2|     |2               |2 |1.5              |2 |                 |  |
+-+-+-----+----------------+--+-----------------+--+-----------------+--+
| |0|     |1.73913043478261|23|0.92             |50|0                |24|
+-+-+-----+----------------+--+-----------------+--+-----------------+--+
| |1|     |                |  |0.444444444444444|36|0.78125          |32|
+-+-+-----+----------------+--+-----------------+--+-----------------+--+
|2|0|     |1.75757575757576|33|0.448275862068966|29|                 |  |
+-+-+-----+----------------+--+-----------------+--+-----------------+--+
| |1|     |1               |1 |                 |  |1                |4 |
+-+-+-----+----------------+--+-----------------+--+-----------------+--+
| |2|     |1.54166666666667|48|2                |25|1.125            |24|
+-+-+-----+----------------+--+-----------------+--+-----------------+--+
|1|1|     |1               |24|0.105263157894737|19|0.509090909090909|55|
+-+-+-----+----------------+--+-----------------+--+-----------------+--+
| |0|     |1               |1 |0                |4 |                 |  |
+-+-+-----+----------------+--+-----------------+--+-----------------+--+
| |2|     |1.76470588235294|34|                 |  |0.7              |30|
+-+-+-----+----------------+--+-----------------+--+-----------------+--+
TABLE

App::RecordStream::Test::OperationHelper->test_output(
  'toptable',
  ['--x', 'b,FIELD', '--y', 'c,a'],
  $stream2,
  $table2,
);

my $table3 = <<TABLE;
+-+-+-----+----------------+--+-----------------+--+-----------------+--+
| | |b    |2               |  |0                |  |1                |  |
+-+-+-----+----------------+--+-----------------+--+-----------------+--+
| | |FIELD|avg_d           |ct|avg_d            |ct|avg_d            |ct|
+-+-+-----+----------------+--+-----------------+--+-----------------+--+
|a|c|     |                |  |                 |  |                 |  |
+-+-+-----+----------------+--+-----------------+--+-----------------+--+
|2|0|     |2               |2 |1.5              |2 |                 |  |
+-+-+-----+----------------+--+-----------------+--+-----------------+--+
| |1|     |1.76470588235294|34|                 |  |0.7              |30|
+-+-+-----+----------------+--+-----------------+--+-----------------+--+
| |2|     |1.54166666666667|48|2                |25|1.125            |24|
+-+-+-----+----------------+--+-----------------+--+-----------------+--+
|0|2|     |1.75757575757576|33|0.448275862068966|29|                 |  |
+-+-+-----+----------------+--+-----------------+--+-----------------+--+
| |1|     |1               |1 |0                |4 |                 |  |
+-+-+-----+----------------+--+-----------------+--+-----------------+--+
| |0|     |1.73913043478261|23|0.92             |50|0                |24|
+-+-+-----+----------------+--+-----------------+--+-----------------+--+
|1|2|     |1               |1 |                 |  |1                |4 |
+-+-+-----+----------------+--+-----------------+--+-----------------+--+
| |1|     |1               |24|0.105263157894737|19|0.509090909090909|55|
+-+-+-----+----------------+--+-----------------+--+-----------------+--+
| |0|     |                |  |0.444444444444444|36|0.78125          |32|
+-+-+-----+----------------+--+-----------------+--+-----------------+--+
TABLE

# Test Keygroups
App::RecordStream::Test::OperationHelper->test_output(
  'toptable',
  ['--x', '!b!,FIELD', '--y', '!^(a|c)$!sort', '--v', '!avg_d|ct!sort'],
  $stream2,
  $table3,
);

my $table4 = <<TABLE;
+-+-+-----+--+----------------+--+-----------------+--+-----------------+
| | |b    |2 |                |0 |                 |1 |                 |
+-+-+-----+--+----------------+--+-----------------+--+-----------------+
| | |FIELD|ct|avg_d           |ct|avg_d            |ct|avg_d            |
+-+-+-----+--+----------------+--+-----------------+--+-----------------+
|a|c|     |  |                |  |                 |  |                 |
+-+-+-----+--+----------------+--+-----------------+--+-----------------+
|2|0|     |2 |2               |2 |1.5              |  |                 |
+-+-+-----+--+----------------+--+-----------------+--+-----------------+
| |1|     |34|1.76470588235294|  |                 |30|0.7              |
+-+-+-----+--+----------------+--+-----------------+--+-----------------+
| |2|     |48|1.54166666666667|25|2                |24|1.125            |
+-+-+-----+--+----------------+--+-----------------+--+-----------------+
|0|2|     |33|1.75757575757576|29|0.448275862068966|  |                 |
+-+-+-----+--+----------------+--+-----------------+--+-----------------+
| |1|     |1 |1               |4 |0                |  |                 |
+-+-+-----+--+----------------+--+-----------------+--+-----------------+
| |0|     |23|1.73913043478261|50|0.92             |24|0                |
+-+-+-----+--+----------------+--+-----------------+--+-----------------+
|1|2|     |1 |1               |  |                 |4 |1                |
+-+-+-----+--+----------------+--+-----------------+--+-----------------+
| |1|     |24|1               |19|0.105263157894737|55|0.509090909090909|
+-+-+-----+--+----------------+--+-----------------+--+-----------------+
| |0|     |  |                |36|0.444444444444444|32|0.78125          |
+-+-+-----+--+----------------+--+-----------------+--+-----------------+
TABLE

# --v field order is respected on output
App::RecordStream::Test::OperationHelper->test_output(
  'toptable',
  ['--x', '!b!,FIELD', '--y', '!^(a|c)$!sort', '--v', 'ct,avg_d'],
  $stream2,
  $table4,
);


my $pin_records = <<RECORDS;
{"c":"2","a":{"1":{"b":{"1":4,"2":1}},"0":{"b":{"0":1,"2":4}},"2":{"b":{"1":21,"0":"","2":22}}},"d":"1"}
{"c":"2","a":{"1":{"b":{"1":"","2":""}},"0":{"b":{"0":6,"2":27}},"2":{"b":{"1":3,"0":25,"2":26}}},"d":"2"}
{"c":"2","a":{"1":{"b":{"1":"","2":""}},"0":{"b":{"0":22,"2":2}},"2":{"b":{"1":"","0":"","2":""}}},"d":"0"}
RECORDS

App::RecordStream::Test::OperationHelper->do_match(
  'toptable',
  ['--x', 'a,b', '--y', 'c,d', '--pin', 'c=2', '--records'],
  $stream1,
  $pin_records,
);

my $sort_stream = <<RECORDS;
{"priority":"20","uid":"root","ct":47}
{"priority":"20","uid":"ALL","ct":120}
{"priority":"20","uid":"messagebus","ct":1}
{"priority":"20","uid":"syslog","ct":1}
{"priority":"20","uid":"avahi","ct":2}
{"priority":"20","uid":"daemon","ct":1}
{"priority":"20","uid":"colord","ct":1}
{"priority":"20","uid":"bernard","ct":67}
{"priority":"ALL","uid":"root","ct":63}
{"priority":"ALL","uid":"ALL","ct":140}
{"priority":"ALL","uid":"messagebus","ct":1}
{"priority":"ALL","uid":"syslog","ct":1}
{"priority":"ALL","uid":"avahi","ct":2}
{"priority":"ALL","uid":"daemon","ct":1}
{"priority":"ALL","uid":"colord","ct":1}
{"priority":"ALL","uid":"rtkit","ct":1}
{"priority":"ALL","uid":"bernard","ct":70}
{"priority":"-100","uid":"root","ct":1}
{"priority":"-100","uid":"ALL","ct":1}
{"priority":"0","uid":"root","ct":12}
{"priority":"0","uid":"ALL","ct":12}
{"priority":"25","uid":"root","ct":1}
{"priority":"25","uid":"ALL","ct":1}
{"priority":"39","uid":"root","ct":1}
{"priority":"39","uid":"ALL","ct":1}
{"priority":"10","uid":"root","ct":1}
{"priority":"10","uid":"ALL","ct":1}
{"priority":"21","uid":"rtkit","ct":1}
{"priority":"21","uid":"ALL","ct":1}
{"priority":"9","uid":"bernard","ct":1}
{"priority":"9","uid":"ALL","ct":1}
{"priority":"30","uid":"bernard","ct":2}
{"priority":"30","uid":"ALL","ct":2}
RECORDS

my $unsorted_output = <<OUTPUT;
+--------+---+----+---+----------+------+-----+------+------+-------+-----+
|        |uid|root|ALL|messagebus|syslog|avahi|daemon|colord|bernard|rtkit|
+--------+---+----+---+----------+------+-----+------+------+-------+-----+
|priority|   |    |   |          |      |     |      |      |       |     |
+--------+---+----+---+----------+------+-----+------+------+-------+-----+
|20      |   |47  |120|1         |1     |2    |1     |1     |67     |     |
+--------+---+----+---+----------+------+-----+------+------+-------+-----+
|ALL     |   |63  |140|1         |1     |2    |1     |1     |70     |1    |
+--------+---+----+---+----------+------+-----+------+------+-------+-----+
|-100    |   |1   |1  |          |      |     |      |      |       |     |
+--------+---+----+---+----------+------+-----+------+------+-------+-----+
|0       |   |12  |12 |          |      |     |      |      |       |     |
+--------+---+----+---+----------+------+-----+------+------+-------+-----+
|25      |   |1   |1  |          |      |     |      |      |       |     |
+--------+---+----+---+----------+------+-----+------+------+-------+-----+
|39      |   |1   |1  |          |      |     |      |      |       |     |
+--------+---+----+---+----------+------+-----+------+------+-------+-----+
|10      |   |1   |1  |          |      |     |      |      |       |     |
+--------+---+----+---+----------+------+-----+------+------+-------+-----+
|21      |   |    |1  |          |      |     |      |      |       |1    |
+--------+---+----+---+----------+------+-----+------+------+-------+-----+
|9       |   |    |1  |          |      |     |      |      |1      |     |
+--------+---+----+---+----------+------+-----+------+------+-------+-----+
|30      |   |    |2  |          |      |     |      |      |2      |     |
+--------+---+----+---+----------+------+-----+------+------+-------+-----+
OUTPUT

# Test input order
App::RecordStream::Test::OperationHelper->test_output(
  'toptable',
  ['--x', 'uid', '--y', 'priority'],
  $sort_stream,
  $unsorted_output,
);

my $sorted_output = <<OUTPUT;
+--------+---+-----+-------+------+------+----------+----+-----+------+---+
|        |uid|avahi|bernard|colord|daemon|messagebus|root|rtkit|syslog|ALL|
+--------+---+-----+-------+------+------+----------+----+-----+------+---+
|priority|   |     |       |      |      |          |    |     |      |   |
+--------+---+-----+-------+------+------+----------+----+-----+------+---+
|-100    |   |     |       |      |      |          |1   |     |      |1  |
+--------+---+-----+-------+------+------+----------+----+-----+------+---+
|0       |   |     |       |      |      |          |12  |     |      |12 |
+--------+---+-----+-------+------+------+----------+----+-----+------+---+
|10      |   |     |       |      |      |          |1   |     |      |1  |
+--------+---+-----+-------+------+------+----------+----+-----+------+---+
|20      |   |2    |67     |1     |1     |1         |47  |     |1     |120|
+--------+---+-----+-------+------+------+----------+----+-----+------+---+
|21      |   |     |       |      |      |          |    |1    |      |1  |
+--------+---+-----+-------+------+------+----------+----+-----+------+---+
|25      |   |     |       |      |      |          |1   |     |      |1  |
+--------+---+-----+-------+------+------+----------+----+-----+------+---+
|30      |   |     |2      |      |      |          |    |     |      |2  |
+--------+---+-----+-------+------+------+----------+----+-----+------+---+
|39      |   |     |       |      |      |          |1   |     |      |1  |
+--------+---+-----+-------+------+------+----------+----+-----+------+---+
|9       |   |     |1      |      |      |          |    |     |      |1  |
+--------+---+-----+-------+------+------+----------+----+-----+------+---+
|ALL     |   |2    |70     |1     |1     |1         |63  |1    |1     |140|
+--------+---+-----+-------+------+------+----------+----+-----+------+---+
OUTPUT

# Test sort-to-end
App::RecordStream::Test::OperationHelper->test_output(
  'toptable',
  ['--x', 'uid', '--y', 'priority', '--sa'],
  $sort_stream,
  $sorted_output,
);

